/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.webapp;

import com.bigdata.journal.IIndexManager;
import com.bigdata.journal.IJournal;
import com.bigdata.rdf.properties.PropertiesFormat;
import com.bigdata.rdf.properties.PropertiesParser;
import com.bigdata.rdf.properties.PropertiesParserFactory;
import com.bigdata.rdf.properties.PropertiesParserRegistry;
import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.sail.webapp.AbstractRestApiTask;
import com.bigdata.rdf.sail.webapp.BigdataRDFContext;
import com.bigdata.rdf.sail.webapp.BigdataRDFServlet;
import com.bigdata.rdf.sail.webapp.HttpOperationException;
import com.bigdata.rdf.sail.webapp.RESTServlet;
import com.bigdata.rdf.sail.webapp.RestApiCreateKBTask;
import com.bigdata.rdf.sail.webapp.RestApiDestroyKBTask;
import com.bigdata.rdf.sail.webapp.VoID;
import com.bigdata.rdf.sail.webapp.client.ConnectOptions;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.task.AbstractApiTask;
import com.bigdata.service.jini.JiniClient;
import com.bigdata.service.jini.JiniFederation;
import com.bigdata.util.PropertyUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.openrdf.model.BNode;
import org.openrdf.model.Graph;
import org.openrdf.model.Resource;
import org.openrdf.model.impl.GraphImpl;

public class MultiTenancyServlet
extends BigdataRDFServlet {
    private static final long serialVersionUID = 1L;
    private static final transient Logger log = Logger.getLogger(MultiTenancyServlet.class);
    protected static final String DESCRIBE_EACH_NAMED_GRAPH = "describe-each-named-graph";
    protected static final String DESCRIBE_DEFAULT_NAMESPACE = "describe-default-namespace";
    private RESTServlet m_restServlet;

    public void init() throws ServletException {
        super.init();
        this.m_restServlet = new RESTServlet();
        this.m_restServlet.init(this.getServletConfig());
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (req.getRequestURI().endsWith("/namespace")) {
            this.doCreateNamespace(req, resp);
            return;
        }
        this.m_restServlet.doPost(req, resp);
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (!MultiTenancyServlet.isWritable(this.getServletContext(), req, resp)) {
            return;
        }
        String namespace = this.getNamespace(req);
        if (req.getRequestURI().endsWith("/namespace/" + ConnectOptions.urlEncode(namespace))) {
            this.doDeleteNamespace(req, resp);
            return;
        }
        this.m_restServlet.doDelete(req, resp);
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (!MultiTenancyServlet.isWritable(this.getServletContext(), req, resp)) {
            return;
        }
        this.m_restServlet.doPut(req, resp);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (req.getRequestURI().endsWith("/namespace")) {
            this.doDescribeNamespaces(req, resp);
            return;
        }
        if (req.getRequestURI().endsWith("/properties")) {
            this.doShowProperties(req, resp);
            return;
        }
        this.m_restServlet.doGet(req, resp);
    }

    private void doCreateNamespace(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Properties defaults;
        PropertiesParserFactory parserFactory;
        PropertiesFormat format;
        if (!MultiTenancyServlet.isWritable(this.getServletContext(), req, resp)) {
            return;
        }
        BigdataRDFContext context = this.getBigdataRDFContext();
        IIndexManager indexManager = context.getIndexManager();
        String contentType = req.getContentType();
        if (log.isInfoEnabled()) {
            log.info((Object)("Request body: " + contentType));
        }
        if ((format = PropertiesFormat.forMIMEType(contentType)) == null) {
            MultiTenancyServlet.buildAndCommitResponse(resp, 400, "text/plain", "Content-Type not recognized as Properties: " + contentType);
            return;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Format=" + format));
        }
        if ((parserFactory = (PropertiesParserFactory)PropertiesParserRegistry.getInstance().get(format)) == null) {
            MultiTenancyServlet.buildAndCommitResponse(resp, 500, "text/plain", "Parser factory not found: Content-Type=" + contentType + ", format=" + format);
            return;
        }
        PropertiesParser parser = parserFactory.getParser();
        Properties given = parser.parse((InputStream)req.getInputStream());
        if (indexManager instanceof IJournal) {
            IJournal jnl = (IJournal)indexManager;
            defaults = new Properties(jnl.getProperties());
        } else {
            JiniFederation fed = (JiniFederation)indexManager;
            defaults = ((JiniClient)fed.getClient()).getProperties();
        }
        Properties effectiveProperties = PropertyUtil.flatCopy(defaults);
        for (Map.Entry<Object, Object> e : given.entrySet()) {
            String name = (String)e.getKey();
            Object val = e.getValue();
            if (val == null) continue;
            effectiveProperties.put(name, val);
        }
        String namespace = effectiveProperties.getProperty(BigdataSail.Options.NAMESPACE, "kb");
        try {
            AbstractApiTask.submitApiTask(indexManager, new RestApiCreateKBTask(req, resp, namespace, effectiveProperties)).get();
        }
        catch (Throwable e) {
            MultiTenancyServlet.launderThrowable(e, resp, "namespace=" + namespace);
        }
    }

    private void doDeleteNamespace(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String namespace = this.getNamespace(req);
        try {
            AbstractApiTask.submitApiTask(this.getIndexManager(), new RestApiDestroyKBTask(req, resp, namespace)).get();
        }
        catch (Throwable e) {
            MultiTenancyServlet.launderThrowable(e, resp, "DELETE NAMESPACE: namespace=" + namespace);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doShowProperties(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String namespace = this.getNamespace(req);
        long timestamp = this.getTimestamp(req);
        final long tx = this.getBigdataRDFContext().newTx(timestamp);
        try {
            AbstractApiTask.submitApiTask(this.getIndexManager(), new AbstractRestApiTask<Void>(req, resp, namespace, timestamp){

                @Override
                public boolean isReadOnly() {
                    return true;
                }

                @Override
                public Void call() throws Exception {
                    AbstractTripleStore tripleStore = this.getTripleStore(this.namespace, tx);
                    if (tripleStore == null) {
                        throw new HttpOperationException(404, "text/plain", "Not found: namespace=" + this.namespace);
                    }
                    Properties properties = PropertyUtil.flatCopy(tripleStore.getProperties());
                    BigdataRDFServlet.sendProperties(this.req, this.resp, properties);
                    return null;
                }
            }).get();
        }
        catch (Throwable t) {
            MultiTenancyServlet.launderThrowable(t, resp, "namespace=" + namespace);
        }
        finally {
            this.getBigdataRDFContext().abortTx(tx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDescribeNamespaces(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        long timestamp = this.getTimestamp(req);
        String s = req.getParameter(DESCRIBE_EACH_NAMED_GRAPH);
        boolean describeEachNamedGraph = s != null ? Boolean.valueOf(s) : this.getBigdataRDFContext().getConfig().describeEachNamedGraph;
        String s2 = req.getParameter(DESCRIBE_DEFAULT_NAMESPACE);
        boolean describeDefaultNamespace = s2 != null ? Boolean.valueOf(s2) : false;
        long tx = this.getBigdataRDFContext().newTx(timestamp);
        try {
            GraphImpl g = new GraphImpl();
            if (describeDefaultNamespace) {
                String namespace = this.getBigdataRDFContext().getConfig().namespace;
                this.describeNamespaceTx(req, (Graph)g, namespace, describeEachNamedGraph, tx);
            } else {
                List<String> namespaces = this.getBigdataRDFContext().getNamespacesTx(tx);
                for (String namespace : namespaces) {
                    this.describeNamespaceTx(req, (Graph)g, namespace, describeEachNamedGraph, tx);
                }
            }
            MultiTenancyServlet.sendGraph(req, resp, (Graph)g);
        }
        catch (Throwable t) {
            MultiTenancyServlet.launderThrowable(t, resp, "describeEachNamedGraph=" + describeEachNamedGraph + ", describeDefaultNamespace=" + describeDefaultNamespace);
        }
        finally {
            this.getBigdataRDFContext().abortTx(tx);
        }
    }

    private void describeNamespaceTx(HttpServletRequest req, Graph g, String namespace, boolean describeEachNamedGraph, long tx) throws IOException {
        AbstractTripleStore tripleStore = this.getBigdataRDFContext().getTripleStore(namespace, tx);
        if (tripleStore == null) {
            return;
        }
        BNode aDataSet = g.getValueFactory().createBNode();
        String[] serviceURI = MultiTenancyServlet.getServiceURIs(this.getServletContext(), req);
        VoID v = new VoID(g, tripleStore, serviceURI, (Resource)aDataSet);
        v.describeDataSet(false, describeEachNamedGraph);
    }
}

