/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.webapp;

import com.bigdata.bop.BOpUtility;
import com.bigdata.bop.PipelineOp;
import com.bigdata.bop.engine.AbstractRunningQuery;
import com.bigdata.bop.engine.BOpStats;
import com.bigdata.bop.engine.IRunningQuery;
import com.bigdata.bop.engine.QueryEngine;
import com.bigdata.bop.engine.QueryLog;
import com.bigdata.bop.fed.QueryEngineFactory;
import com.bigdata.journal.IIndexManager;
import com.bigdata.journal.TimestampUtility;
import com.bigdata.mdi.PartitionLocator;
import com.bigdata.rdf.sail.BigdataSailRepositoryConnection;
import com.bigdata.rdf.sail.sparql.Bigdata2ASTSPARQLParser;
import com.bigdata.rdf.sail.sparql.ast.SimpleNode;
import com.bigdata.rdf.sail.webapp.AbstractRestApiTask;
import com.bigdata.rdf.sail.webapp.BigdataRDFContext;
import com.bigdata.rdf.sail.webapp.BigdataRDFServlet;
import com.bigdata.rdf.sail.webapp.BigdataServlet;
import com.bigdata.rdf.sail.webapp.HTMLBuilder;
import com.bigdata.rdf.sail.webapp.RESTServlet;
import com.bigdata.rdf.sail.webapp.RestApiGetContextsTask;
import com.bigdata.rdf.sail.webapp.SD;
import com.bigdata.rdf.sail.webapp.SparqlEndpointConfig;
import com.bigdata.rdf.sail.webapp.XMLBuilder;
import com.bigdata.rdf.sail.webapp.client.EncodeDecodeValue;
import com.bigdata.rdf.sparql.ast.ASTContainer;
import com.bigdata.rdf.sparql.ast.QueryRoot;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.relation.accesspath.AccessPath;
import com.bigdata.service.IBigdataFederation;
import com.bigdata.service.IDataService;
import com.bigdata.service.ndx.ClientIndexView;
import com.bigdata.util.InnerCause;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.openrdf.model.Graph;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.GraphImpl;

public class QueryServlet
extends BigdataRDFServlet {
    private static final long serialVersionUID = 1L;
    private static final transient Logger log = Logger.getLogger(QueryServlet.class);
    static final transient String ATTR_QUERY = "query";
    static final transient String ATTR_UPDATE = "update";
    static final transient String ATTR_ESTCARD = "ESTCARD";
    static final transient String ATTR_CONTEXTS = "CONTEXTS";
    static final transient String ATTR_SHARDS = "SHARDS";
    static final transient String ATTR_UUID = "uuid";
    static final transient String ATTR_TIMESTAMP = "timestamp";

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (req.getParameter(ATTR_UPDATE) != null) {
            this.doSparqlUpdate(req, resp);
        } else if (RESTServlet.hasMimeType(req, "application/sparql-update")) {
            this.doSparqlUpdate(req, resp);
        } else if (req.getParameter(ATTR_UUID) != null) {
            this.doUUID(req, resp);
        } else if (req.getParameter(ATTR_ESTCARD) != null) {
            this.doEstCard(req, resp);
        } else if (req.getParameter(ATTR_CONTEXTS) != null) {
            this.doContexts(req, resp);
        } else {
            this.doSparqlQuery(req, resp);
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (req.getParameter(ATTR_QUERY) != null) {
            this.doSparqlQuery(req, resp);
        } else if (req.getParameter(ATTR_UUID) != null) {
            this.doUUID(req, resp);
        } else if (req.getParameter(ATTR_ESTCARD) != null) {
            this.doEstCard(req, resp);
        } else if (req.getParameter(ATTR_CONTEXTS) != null) {
            this.doContexts(req, resp);
        } else if (req.getParameter(ATTR_SHARDS) != null) {
            this.doShardReport(req, resp);
        } else {
            this.doServiceDescription(req, resp);
            return;
        }
    }

    private void doUUID(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        QueryServlet.buildAndCommitResponse(resp, 200, "text/plain", UUID.randomUUID().toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doServiceDescription(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        long tx = this.getBigdataRDFContext().newTx(this.getTimestamp(req));
        try {
            AbstractTripleStore tripleStore = this.getBigdataRDFContext().getTripleStore(this.getNamespace(req), tx);
            if (tripleStore == null) {
                this.buildAndCommitNamespaceNotFoundResponse(req, resp);
                return;
            }
            String[] serviceURI = BigdataServlet.getServiceURIs(this.getServletContext(), req);
            GraphImpl g = new GraphImpl();
            SD sd = new SD((Graph)g, tripleStore, serviceURI);
            SparqlEndpointConfig config = this.getBigdataRDFContext().getConfig();
            sd.describeService(true, config.describeEachNamedGraph);
            QueryServlet.sendGraph(req, resp, (Graph)g);
        }
        catch (Throwable t) {
            QueryServlet.launderThrowable(t, resp, "");
        }
        finally {
            this.getBigdataRDFContext().abortTx(tx);
        }
    }

    private void doSparqlUpdate(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (!QueryServlet.isWritable(this.getServletContext(), req, resp)) {
            return;
        }
        String updateStr = QueryServlet.getUpdateString(req);
        if (updateStr == null) {
            QueryServlet.buildAndCommitResponse(resp, 400, "text/plain", "Required parameter not found: update");
            return;
        }
        try {
            String namespace = this.getNamespace(req);
            long timestamp = 0L;
            this.submitApiTask(new SparqlUpdateTask(req, resp, namespace, 0L, updateStr, this.getBigdataRDFContext())).get();
        }
        catch (Throwable t) {
            QueryServlet.launderThrowable(t, resp, "SPARQL-UPDATE: updateStr=" + updateStr);
        }
    }

    void doSparqlQuery(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (!QueryServlet.isReadable(this.getServletContext(), req, resp)) {
            return;
        }
        String queryStr = QueryServlet.getQueryString(req);
        if (queryStr == null) {
            QueryServlet.buildAndCommitResponse(resp, 400, "text/plain", "Not found: query");
            return;
        }
        try {
            String namespace = this.getNamespace(req);
            long timestamp = this.getTimestamp(req);
            this.submitApiTask(new SparqlQueryTask(req, resp, namespace, timestamp, queryStr, this.getBigdataRDFContext())).get();
        }
        catch (Throwable t) {
            QueryServlet.launderThrowable(t, resp, "SPARQL-QUERY: queryStr=" + queryStr);
        }
    }

    private static String getQueryString(HttpServletRequest req) throws IOException {
        if (RESTServlet.hasMimeType(req, "application/sparql-query")) {
            return QueryServlet.readFully(req.getReader());
        }
        return req.getParameter(ATTR_QUERY) != null ? req.getParameter(ATTR_QUERY) : (String)req.getAttribute(ATTR_QUERY);
    }

    private static String getUpdateString(HttpServletRequest req) throws IOException {
        if (RESTServlet.hasMimeType(req, "application/sparql-update")) {
            return QueryServlet.readFully(req.getReader());
        }
        return req.getParameter(ATTR_UPDATE);
    }

    static String readFully(Reader reader) throws IOException {
        int numChars;
        char[] arr = new char[8192];
        StringBuffer buf = new StringBuffer();
        while ((numChars = reader.read(arr, 0, arr.length)) > 0) {
            buf.append(arr, 0, numChars);
        }
        return buf.toString();
    }

    private static void explainQuery(String queryStr, BigdataRDFContext.AbstractQueryTask queryTask, FutureTask<Void> ft, Writer w) throws Exception {
        QueryRoot originalAST;
        SimpleNode parseTree;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Will build explanation");
        }
        UUID queryId2 = null;
        IRunningQuery q = null;
        while (!ft.isDone() && queryId2 == null) {
            try {
                ft.get(1L, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException ex) {
                // empty catch block
            }
            if (queryTask.queryId2 == null) continue;
            queryId2 = queryTask.queryId2;
            break;
        }
        if (ft.isDone()) {
            ft.get();
            if (queryTask.queryId2 != null && (queryId2 = queryTask.queryId2) == null) {
                throw new AssertionError();
            }
        }
        assert (queryId2 != null);
        HTMLBuilder doc = new HTMLBuilder(queryTask.charset.name(), w);
        XMLBuilder.Node current = doc.root("html");
        current = current.node("head");
        current.node("meta").attr("http-equiv", "Content-Type").attr("content", "text/html;charset=" + queryTask.charset.name()).close();
        current.node("title").textNoEncode("bigdata&#174;").close();
        current = current.close();
        current = current.node("body");
        current.node("h1", "Query");
        ASTContainer astContainer = queryTask.astContainer;
        String queryString = astContainer.getQueryString();
        if (queryString != null) {
            current.node("h2", "SPARQL");
            current.node("pre", queryString);
        }
        if ((parseTree = (SimpleNode)astContainer.getParseTree()) != null) {
            current.node("h2", "Parse Tree");
            current.node("pre", parseTree.dump(""));
        }
        if ((originalAST = astContainer.getOriginalAST()) != null) {
            current.node("h2", "Original AST");
            current.node("pre", originalAST.toString());
        }
        if (queryId2 != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Resolving IRunningQuery: queryId2=" + queryId2));
            }
            IIndexManager indexManager = BigdataServlet.getIndexManager(queryTask.req.getServletContext());
            QueryEngine queryEngine = QueryEngineFactory.getQueryController(indexManager);
            while (!ft.isDone() && q == null) {
                try {
                    ft.get(1L, TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException ex) {
                    // empty catch block
                }
                try {
                    q = queryEngine.getRunningQuery(queryId2);
                }
                catch (RuntimeException ex) {
                    if (!InnerCause.isInnerCause(ex, InterruptedException.class)) continue;
                }
            }
            if (q != null && log.isDebugEnabled()) {
                log.debug((Object)("Resolved IRunningQuery: query=" + q));
            }
        }
        if (q != null) {
            PipelineOp queryPlan;
            QueryRoot optimizedAST = astContainer.getOptimizedAST();
            if (optimizedAST != null) {
                current.node("h2", "Optimized AST");
                current.node("pre", optimizedAST.toString());
            }
            if ((queryPlan = astContainer.getQueryPlan()) != null) {
                current.node("h2", "Query Plan");
                current.node("pre", BOpUtility.toString(queryPlan));
            }
        }
        try {
            ft.get();
        }
        catch (ExecutionException ex) {
            Throwable cause = ex.getCause();
            StringWriter sw = new StringWriter();
            cause.printStackTrace(new PrintWriter(sw));
            String s = sw.getBuffer().toString();
            current.node("pre").text(s).close();
        }
        current.node("h2", "Query Evaluation Statistics");
        if (q == null) {
            current.node("p", "Statistics are not available (query already terminated).");
        } else {
            IRunningQuery[] children = ((AbstractRunningQuery)q).getChildren();
            long elapsedMillis = q.getElapsed();
            BOpStats stats = q.getStats().get(q.getQuery().getId());
            String solutionsOut = stats == null ? "N/A" : Long.toString(stats.unitsOut.get());
            String chunksOut = stats == null ? "N/A" : Long.toString(stats.chunksOut.get());
            current.node("p").text("solutions=" + solutionsOut).text(", chunks=" + chunksOut).text(", subqueries=" + children.length).text(", elapsed=" + elapsedMillis + "ms").text(q.isCancelled() ? ", CANCELLED." : ".").close();
            boolean clusterStats = q.getFederation() != null;
            boolean mutationStats = false;
            QueryLog.getTableXHTML(queryStr, q, children, w, false, 0, clusterStats, queryTask.explainDetails, false);
        }
        doc.closeAll(current);
    }

    private void doEstCard(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Resource[] c;
        Value o;
        URI p;
        Resource s;
        if (!QueryServlet.isReadable(this.getServletContext(), req, resp)) {
            return;
        }
        try {
            s = EncodeDecodeValue.decodeResource(req.getParameter("s"));
            p = EncodeDecodeValue.decodeURI(req.getParameter("p"));
            o = EncodeDecodeValue.decodeValue(req.getParameter("o"));
            c = EncodeDecodeValue.decodeResources(req.getParameterValues("c"));
        }
        catch (IllegalArgumentException ex) {
            QueryServlet.buildAndCommitResponse(resp, 400, "text/plain", ex.getLocalizedMessage());
            return;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("ESTCARD: access path: (s=" + s + ", p=" + p + ", o=" + o + ", c=" + c + ")"));
        }
        try {
            this.submitApiTask(new EstCardTask(req, resp, this.getNamespace(req), this.getTimestamp(req), s, p, o, c)).get();
        }
        catch (Throwable t) {
            QueryServlet.launderThrowable(t, resp, "ESTCARD: access path: (s=" + s + ", p=" + p + ", o=" + o + ", c=" + c + ")");
        }
    }

    private void doContexts(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (!QueryServlet.isReadable(this.getServletContext(), req, resp)) {
            return;
        }
        try {
            this.submitApiTask(new RestApiGetContextsTask(req, resp, this.getNamespace(req), this.getTimestamp(req))).get();
        }
        catch (Throwable t) {
            QueryServlet.launderThrowable(t, resp, "GET-CONTEXTS");
        }
    }

    private void doShardReport(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Resource c;
        Value o;
        URI p;
        Resource s;
        if (!QueryServlet.isReadable(this.getServletContext(), req, resp)) {
            return;
        }
        if (!this.getBigdataRDFContext().isScaleOut()) {
            QueryServlet.buildAndCommitResponse(resp, 400, "text/plain", "Not scale-out");
            return;
        }
        boolean doRangeCount = true;
        try {
            s = EncodeDecodeValue.decodeResource(req.getParameter("s"));
            p = EncodeDecodeValue.decodeURI(req.getParameter("p"));
            o = EncodeDecodeValue.decodeValue(req.getParameter("o"));
            c = EncodeDecodeValue.decodeResource(req.getParameter("c"));
        }
        catch (IllegalArgumentException ex) {
            QueryServlet.buildAndCommitResponse(resp, 400, "text/plain", ex.getLocalizedMessage());
            return;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("SHARDS: access path: (s=" + s + ", p=" + p + ", o=" + o + ", c=" + c + ")"));
        }
        try {
            this.submitApiTask(new ShardsTask(req, resp, this.getNamespace(req), this.getTimestamp(req), s, p, o, c, true)).get();
        }
        catch (Throwable t) {
            QueryServlet.launderThrowable(t, resp, "SHARDS: access path: (s=" + s + ", p=" + p + ", o=" + o + ", c=" + c + ")");
        }
    }

    private static class ShardsTask
    extends AbstractRestApiTask<Void> {
        private final Resource s;
        private final URI p;
        private final Value o;
        private final Resource c;
        private final boolean doRangeCount;

        public ShardsTask(HttpServletRequest req, HttpServletResponse resp, String namespace, long timestamp, Resource s, URI p, Value o, Resource c, boolean doRangeCount) {
            super(req, resp, namespace, timestamp);
            this.s = s;
            this.p = p;
            this.o = o;
            this.c = c;
            this.doRangeCount = doRangeCount;
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            long begin = System.currentTimeMillis();
            try (BigdataSailRepositoryConnection conn = null;){
                conn = this.getQueryConnection();
                AccessPath accessPath = (AccessPath)conn.getSailConnection().getBigdataSail().getDatabase().getAccessPath(this.s, this.p, this.o, this.c);
                ClientIndexView ndx = (ClientIndexView)accessPath.getIndex();
                String charset = "utf-8";
                this.resp.setContentType("text/html");
                this.resp.setCharacterEncoding("utf-8");
                PrintWriter w = this.resp.getWriter();
                try {
                    HTMLBuilder doc = new HTMLBuilder("utf-8", w);
                    XMLBuilder.Node current = doc.root("html");
                    current = current.node("head");
                    current.node("meta").attr("http-equiv", "Content-Type").attr("content", "text/html;charset=utf-8").close();
                    current.node("title").textNoEncode("bigdata&#174;").close();
                    current = current.close();
                    current = current.node("body");
                    IBigdataFederation fed = (IBigdataFederation)this.getIndexManager();
                    Iterator<PartitionLocator> itr = ndx.locatorScan(this.timestamp, accessPath.getFromKey(), accessPath.getToKey(), false);
                    int nlocators = 0;
                    TreeMap<String, AtomicInteger> hosts = new TreeMap<String, AtomicInteger>();
                    StringBuilder sb = new StringBuilder();
                    while (itr.hasNext()) {
                        PartitionLocator loc = itr.next();
                        IDataService ds = fed.getDataService(loc.getDataServiceUUID());
                        String hostname = ds == null ? "N/A" : ds.getHostname();
                        AtomicInteger nshards = (AtomicInteger)hosts.get(hostname);
                        if (nshards == null) {
                            nshards = new AtomicInteger();
                            hosts.put(hostname, nshards);
                        }
                        nshards.incrementAndGet();
                        sb.append("\nhost=" + hostname);
                        sb.append(", locator=" + loc);
                        ++nlocators;
                    }
                    long begin2 = System.currentTimeMillis();
                    long elapsed = begin2 - begin;
                    long rangeCount = this.doRangeCount ? accessPath.rangeCount(false) : -1L;
                    long elapsed2 = System.currentTimeMillis() - begin2;
                    current = current.node("H2", "summary");
                    current.node("p", "index=" + ndx.getIndexMetadata().getName() + ", locators=" + nlocators + ", hosts=" + hosts.size() + ", elapsed=" + elapsed + "ms");
                    if (this.doRangeCount) {
                        current.node("p", "rangeCount=" + rangeCount + ", elapsed=" + elapsed2 + "ms");
                    }
                    current.node("H2", "shards").node("pre", sb.toString());
                    sb.setLength(0);
                    for (Map.Entry e : hosts.entrySet()) {
                        sb.append("\nhost=" + (String)e.getKey());
                        sb.append(", #shards=" + e.getValue());
                    }
                    current.node("H2", "hosts").node("pre", sb.toString());
                    doc.closeAll(current);
                }
                finally {
                    ((Writer)w).flush();
                    ((Writer)w).close();
                }
                Void void_ = null;
                return void_;
            }
        }
    }

    private static class EstCardTask
    extends AbstractRestApiTask<Void> {
        private final Resource s;
        private final URI p;
        private final Value o;
        private final Resource[] c;

        public EstCardTask(HttpServletRequest req, HttpServletResponse resp, String namespace, long timestamp, Resource s, URI p, Value o, Resource[] c) {
            super(req, resp, namespace, timestamp);
            this.s = s;
            this.p = p;
            this.o = o;
            this.c = c;
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            long begin = System.currentTimeMillis();
            try (BigdataSailRepositoryConnection conn = null;){
                conn = this.getQueryConnection();
                long rangeCount = 0L;
                if (this.c != null && this.c.length > 0) {
                    for (Resource r : this.c) {
                        rangeCount += conn.getSailConnection().getBigdataSail().getDatabase().getAccessPath(this.s, this.p, this.o, r).rangeCount(false);
                    }
                } else {
                    rangeCount += conn.getSailConnection().getBigdataSail().getDatabase().getAccessPath(this.s, this.p, this.o, (Resource)null).rangeCount(false);
                }
                long elapsed = System.currentTimeMillis() - begin;
                BigdataRDFServlet.buildAndCommitRangeCountResponse(this.resp, rangeCount, elapsed);
                Void void_ = null;
                return void_;
            }
        }
    }

    private static class SparqlQueryTask
    extends AbstractRestApiTask<Void> {
        private final String queryStr;
        private final BigdataRDFContext context;

        public SparqlQueryTask(HttpServletRequest req, HttpServletResponse resp, String namespace, long timestamp, String queryStr, BigdataRDFContext context) {
            super(req, resp, namespace, timestamp);
            if (queryStr == null) {
                throw new IllegalArgumentException();
            }
            if (context == null) {
                throw new IllegalArgumentException();
            }
            this.queryStr = queryStr;
            this.context = context;
        }

        @Override
        public final boolean isReadOnly() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            try (BigdataSailRepositoryConnection conn = null;){
                conn = this.getQueryConnection();
                ServletOutputStream os = this.resp.getOutputStream();
                BigdataRDFContext.AbstractQueryTask queryTask = this.context.getQueryTask(conn, this.namespace, this.timestamp, this.queryStr, null, this.req, this.resp, (OutputStream)os);
                FutureTask<Void> ft = new FutureTask<Void>(queryTask);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Will run query: " + this.queryStr));
                }
                this.resp.setStatus(200);
                if (queryTask.explain) {
                    this.resp.setContentType("text/html");
                    OutputStreamWriter w = new OutputStreamWriter((OutputStream)os, queryTask.charset);
                    try {
                        this.context.queryService.execute(ft);
                        QueryServlet.explainQuery(this.queryStr, queryTask, ft, w);
                    }
                    finally {
                        ((Writer)w).flush();
                        ((Writer)w).close();
                        os.flush();
                        os.close();
                    }
                } else {
                    this.resp.setContentType(queryTask.mimeType);
                    if (queryTask.charset != null) {
                        this.resp.setCharacterEncoding(queryTask.charset.name());
                    }
                    if (BigdataRDFServlet.isAttachment(queryTask.mimeType)) {
                        this.resp.setHeader("Content-disposition", "attachment; filename=query" + queryTask.queryId + "." + queryTask.fileExt);
                    }
                    if (TimestampUtility.isCommitTime(queryTask.timestamp)) {
                        this.resp.addHeader("Cache-Control", "public");
                    }
                    this.context.queryService.execute(ft);
                    ft.get();
                }
                Void void_ = null;
                return void_;
            }
        }
    }

    private static class SparqlUpdateTask
    extends AbstractRestApiTask<Void> {
        private final String updateStr;
        private final BigdataRDFContext context;

        public SparqlUpdateTask(HttpServletRequest req, HttpServletResponse resp, String namespace, long timestamp, String updateStr, BigdataRDFContext context) {
            super(req, resp, namespace, timestamp);
            this.updateStr = updateStr;
            this.context = context;
        }

        @Override
        public final boolean isReadOnly() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            BigdataSailRepositoryConnection conn = null;
            boolean success = false;
            try {
                conn = this.getUnisolatedConnection();
                String baseURI = this.req.getRequestURL().toString();
                AbstractTripleStore tripleStore = conn.getTripleStore();
                ASTContainer astContainer = new Bigdata2ASTSPARQLParser(tripleStore).parseUpdate2(this.updateStr, baseURI);
                if (log.isDebugEnabled()) {
                    log.debug((Object)astContainer.toString());
                }
                BigdataRDFContext.UpdateTask updateTask = this.context.getUpdateTask(conn, this.namespace, this.timestamp, baseURI, astContainer, this.req, this.resp, (OutputStream)this.resp.getOutputStream());
                FutureTask<Void> ft = new FutureTask<Void>(updateTask);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Will run update: " + this.updateStr));
                }
                updateTask.updateFuture = ft;
                this.context.queryService.execute(ft);
                ft.get();
                success = true;
                Void void_ = null;
                return void_;
            }
            finally {
                if (conn != null) {
                    if (!success) {
                        conn.rollback();
                    }
                    conn.close();
                }
            }
        }

        @Override
        public String toString() {
            return this.getClass().getName() + "{namespace=" + this.getNamespace() + ",timestamp=" + this.getTimestamp() + ", updateStr=[" + this.updateStr + "]}";
        }
    }
}

