/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.webapp;

import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.NotMaterializedException;
import com.bigdata.rdf.model.BigdataResource;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.sail.webapp.SD;
import com.bigdata.rdf.sail.webapp.client.ConnectOptions;
import com.bigdata.rdf.spo.SPOKeyOrder;
import com.bigdata.rdf.spo.SPORelation;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.store.BigdataValueIteratorImpl;
import com.bigdata.rdf.vocab.decls.DCTermsVocabularyDecl;
import com.bigdata.rdf.vocab.decls.VoidVocabularyDecl;
import com.bigdata.striterator.IChunkedIterator;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import org.openrdf.model.BNode;
import org.openrdf.model.Graph;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.vocabulary.RDF;

public class VoID {
    private final Graph g;
    private final AbstractTripleStore tripleStore;
    private final String[] serviceURI;
    private final ValueFactory f;
    private final Resource aDataset;
    private final BNode aDefaultGraph;

    public VoID(Graph g, AbstractTripleStore tripleStore, String[] serviceURI, Resource aDataset) {
        if (g == null) {
            throw new IllegalArgumentException();
        }
        if (tripleStore == null) {
            throw new IllegalArgumentException();
        }
        if (serviceURI == null) {
            throw new IllegalArgumentException();
        }
        if (serviceURI.length == 0) {
            throw new IllegalArgumentException();
        }
        for (String s : serviceURI) {
            if (s != null) continue;
            throw new IllegalArgumentException();
        }
        if (aDataset == null) {
            throw new IllegalArgumentException();
        }
        this.g = g;
        this.tripleStore = tripleStore;
        this.serviceURI = serviceURI;
        this.f = g.getValueFactory();
        this.aDataset = aDataset;
        this.aDefaultGraph = this.f.createBNode("defaultGraph");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void describeDataSet(boolean describeStatistics, boolean describeNamedGraphs) {
        String namespace = this.tripleStore.getNamespace();
        this.g.add(this.aDataset, RDF.TYPE, (Value)VoidVocabularyDecl.Dataset, new Resource[0]);
        this.g.add(this.aDataset, DCTermsVocabularyDecl.title, (Value)this.f.createLiteral(namespace), new Resource[0]);
        this.g.add(this.aDataset, SD.KB_NAMESPACE, (Value)this.f.createLiteral(namespace), new Resource[0]);
        for (String uri : this.serviceURI) {
            this.g.add(this.aDataset, VoidVocabularyDecl.sparqlEndpoint, (Value)this.f.createURI(uri + "/" + ConnectOptions.urlEncode(namespace) + "/sparql"), new Resource[0]);
        }
        this.g.add(this.aDataset, VoidVocabularyDecl.uriRegexPattern, (Value)this.f.createLiteral("^.*"), new Resource[0]);
        if (!describeStatistics) {
            return;
        }
        IVCount[] predicatePartitionCounts = VoID.predicateUsage(this.tripleStore);
        IVCount[] classPartitionCounts = VoID.classUsage(this.tripleStore);
        this.describeVocabularies(predicatePartitionCounts);
        this.g.add(this.aDataset, SD.defaultGraph, (Value)this.aDefaultGraph, new Resource[0]);
        this.describeGraph((Resource)this.aDefaultGraph, predicatePartitionCounts, classPartitionCounts);
        if (describeNamedGraphs && this.tripleStore.isQuads()) {
            SPORelation r = this.tripleStore.getSPORelation();
            SPOKeyOrder keyOrder = SPOKeyOrder.CSPO;
            IChunkedIterator<IV> itr = r.distinctTermScan(keyOrder);
            try (BigdataValueIteratorImpl itr2 = new BigdataValueIteratorImpl(this.tripleStore, itr);){
                while (itr2.hasNext()) {
                    BigdataResource graph = (BigdataResource)itr2.next();
                    IVCount[] predicatePartitionCounts2 = VoID.predicateUsage(this.tripleStore, graph.getIV(), predicatePartitionCounts);
                    IVCount[] classPartitionCounts2 = VoID.classUsage(this.tripleStore, graph.getIV(), classPartitionCounts);
                    BNode aNamedGraph = this.f.createBNode();
                    this.g.add(this.aDataset, SD.namedGraph, (Value)aNamedGraph, new Resource[0]);
                    this.g.add((Resource)aNamedGraph, SD.name, (Value)graph, new Resource[0]);
                    this.describeGraph((Resource)aNamedGraph, predicatePartitionCounts2, classPartitionCounts2);
                }
            }
        }
    }

    protected void describeVocabularies(IVCount[] predicatePartitionCounts) {
        LinkedHashSet<String> namespaces = new LinkedHashSet<String>();
        for (IVCount tmp : predicatePartitionCounts) {
            URI p = (URI)tmp.getValue();
            String namespace = p.getNamespace();
            if (namespace.endsWith("#")) {
                namespace = namespace.substring(0, namespace.length() - 1);
            }
            namespaces.add(namespace);
        }
        Object[] a = namespaces.toArray(new String[namespaces.size()]);
        Arrays.sort(a);
        for (Object namespace : a) {
            this.g.add(this.aDataset, VoidVocabularyDecl.vocabulary, (Value)this.f.createURI((String)namespace), new Resource[0]);
        }
    }

    protected void describeGraph(Resource graph, IVCount[] predicatePartitionCounts, IVCount[] classPartitionCounts) {
        this.g.add(graph, RDF.TYPE, (Value)SD.Graph, new Resource[0]);
        this.g.add(graph, VoidVocabularyDecl.triples, (Value)this.f.createLiteral(this.tripleStore.getStatementCount()), new Resource[0]);
        this.g.add(graph, VoidVocabularyDecl.entities, (Value)this.f.createLiteral(this.tripleStore.getURICount()), new Resource[0]);
        this.g.add(graph, VoidVocabularyDecl.properties, (Value)this.f.createLiteral(predicatePartitionCounts.length), new Resource[0]);
        this.g.add(graph, VoidVocabularyDecl.classes, (Value)this.f.createLiteral(classPartitionCounts.length), new Resource[0]);
        for (IVCount tmp : predicatePartitionCounts) {
            BNode propertyPartition = this.f.createBNode();
            URI p = (URI)tmp.getValue();
            this.g.add(graph, VoidVocabularyDecl.propertyPartition, (Value)propertyPartition, new Resource[0]);
            this.g.add((Resource)propertyPartition, VoidVocabularyDecl.property, (Value)p, new Resource[0]);
            this.g.add((Resource)propertyPartition, VoidVocabularyDecl.triples, (Value)this.f.createLiteral(tmp.count), new Resource[0]);
        }
        for (IVCount tmp : classPartitionCounts) {
            BNode classPartition = this.f.createBNode();
            BigdataValue cls = tmp.getValue();
            this.g.add(graph, VoidVocabularyDecl.classPartition, (Value)classPartition, new Resource[0]);
            this.g.add((Resource)classPartition, VoidVocabularyDecl.class_, (Value)cls, new Resource[0]);
            this.g.add((Resource)classPartition, VoidVocabularyDecl.triples, (Value)this.f.createLiteral(tmp.count), new Resource[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static IVCount[] predicateUsage(AbstractTripleStore kb) {
        SPORelation r = kb.getSPORelation();
        if (r.oneAccessPath) {
            throw new UnsupportedOperationException();
        }
        boolean quads = kb.isQuads();
        SPOKeyOrder keyOrder = quads ? SPOKeyOrder.POCS : SPOKeyOrder.POS;
        IChunkedIterator<IV> itr = r.distinctTermScan(keyOrder);
        try (BigdataValueIteratorImpl itr2 = new BigdataValueIteratorImpl(kb, itr);){
            LinkedHashSet ivs = new LinkedHashSet();
            LinkedHashMap<IV, IVCount> counts = new LinkedHashMap<IV, IVCount>();
            while (itr2.hasNext()) {
                BigdataValue term = (BigdataValue)itr2.next();
                IV iv = term.getIV();
                long n = r.getAccessPath(null, iv, null, null).rangeCount(false);
                ivs.add(iv);
                counts.put(iv, new IVCount(iv, n));
            }
            Map<IV<?, ?>, BigdataValue> x = kb.getLexiconRelation().getTerms(ivs);
            for (Map.Entry<IV<?, ?>, BigdataValue> e : x.entrySet()) {
                IVCount count = (IVCount)counts.get(e.getKey());
                count.setValue(e.getValue());
            }
            Object[] a = counts.values().toArray(new IVCount[counts.size()]);
            Arrays.sort(a);
            Object[] objectArray = a;
            return objectArray;
        }
    }

    protected static IVCount[] predicateUsage(AbstractTripleStore kb, IV<?, ?> civ, IVCount[] predicatePartitionCounts) {
        SPORelation r = kb.getSPORelation();
        boolean quads = kb.isQuads();
        if (!quads) {
            throw new IllegalArgumentException();
        }
        LinkedList<IVCount> counts = new LinkedList<IVCount>();
        for (IVCount in : predicatePartitionCounts) {
            long n = r.getAccessPath(null, in.iv, null, civ).rangeCount(false);
            if (n == 0L) continue;
            IVCount out = new IVCount(in.iv, n);
            out.setValue(in.getValue());
            counts.add(out);
        }
        Object[] a = counts.toArray(new IVCount[counts.size()]);
        Arrays.sort(a);
        return a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static IVCount[] classUsage(AbstractTripleStore kb) {
        SPORelation r = kb.getSPORelation();
        if (r.oneAccessPath) {
            throw new UnsupportedOperationException();
        }
        boolean quads = kb.isQuads();
        SPOKeyOrder keyOrder = quads ? SPOKeyOrder.POCS : SPOKeyOrder.POS;
        BigdataURI rdfType = kb.getValueFactory().asValue(RDF.TYPE);
        kb.getLexiconRelation().addTerms(new BigdataValue[]{rdfType}, 1, true);
        if (rdfType.getIV() == null) {
            return new IVCount[0];
        }
        IChunkedIterator<IV> itr = r.distinctMultiTermScan(keyOrder, new IV[]{rdfType.getIV()});
        try (BigdataValueIteratorImpl itr2 = new BigdataValueIteratorImpl(kb, itr);){
            LinkedHashSet ivs = new LinkedHashSet();
            LinkedHashMap<IV, IVCount> counts = new LinkedHashMap<IV, IVCount>();
            while (itr2.hasNext()) {
                BigdataValue term = (BigdataValue)itr2.next();
                IV iv = term.getIV();
                long n = r.getAccessPath(null, rdfType.getIV(), iv, null).rangeCount(false);
                ivs.add(iv);
                counts.put(iv, new IVCount(iv, n));
            }
            Map<IV<?, ?>, BigdataValue> x = kb.getLexiconRelation().getTerms(ivs);
            for (Map.Entry<IV<?, ?>, BigdataValue> e : x.entrySet()) {
                IVCount count = (IVCount)counts.get(e.getKey());
                count.setValue(e.getValue());
            }
            Object[] a = counts.values().toArray(new IVCount[counts.size()]);
            Arrays.sort(a);
            Object[] objectArray = a;
            return objectArray;
        }
    }

    protected static IVCount[] classUsage(AbstractTripleStore kb, IV<?, ?> civ, IVCount[] classPartitionCounts) {
        SPORelation r = kb.getSPORelation();
        boolean quads = kb.isQuads();
        if (!quads) {
            throw new IllegalArgumentException();
        }
        BigdataURI rdfType = kb.getValueFactory().asValue(RDF.TYPE);
        kb.getLexiconRelation().addTerms(new BigdataValue[]{rdfType}, 1, true);
        if (rdfType.getIV() == null) {
            return new IVCount[0];
        }
        LinkedList<IVCount> counts = new LinkedList<IVCount>();
        for (IVCount in : classPartitionCounts) {
            long n = r.getAccessPath(null, rdfType.getIV(), in.iv, civ).rangeCount(false);
            if (n == 0L) continue;
            IVCount out = new IVCount(in.iv, n);
            out.setValue(in.getValue());
            counts.add(out);
        }
        Object[] a = counts.toArray(new IVCount[counts.size()]);
        Arrays.sort(a);
        return a;
    }

    protected static class IVCount
    implements Comparable<IVCount> {
        public final IV<?, ?> iv;
        public final long count;
        private BigdataValue val;

        public BigdataValue getValue() {
            if (this.val == null) {
                throw new NotMaterializedException(this.iv.toString());
            }
            return this.val;
        }

        public void setValue(BigdataValue val) {
            if (val == null) {
                throw new IllegalArgumentException();
            }
            if (this.val != null && !this.val.equals(val)) {
                throw new IllegalArgumentException();
            }
            this.val = val;
        }

        public IVCount(IV<?, ?> iv, long count) {
            if (iv == null) {
                throw new IllegalArgumentException();
            }
            this.iv = iv;
            this.count = count;
        }

        @Override
        public int compareTo(IVCount arg0) {
            if (this.count < arg0.count) {
                return 1;
            }
            if (this.count > arg0.count) {
                return -1;
            }
            return 0;
        }
    }
}

