/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.webapp;

import com.bigdata.rdf.sail.webapp.BigdataRDFServlet;
import com.bigdata.rdf.sail.webapp.client.MiniMime;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.openrdf.model.Graph;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.GraphImpl;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFParser;
import org.openrdf.rio.RDFParserFactory;
import org.openrdf.rio.RDFParserRegistry;
import org.openrdf.rio.helpers.StatementCollector;

public class WorkbenchServlet
extends BigdataRDFServlet {
    private static final long serialVersionUID = 1L;
    private static final transient Logger log = Logger.getLogger(WorkbenchServlet.class);
    static final transient String ATTR_WORKBENCH = "workbench";
    static final transient String ATTR_CONVERT = "convert";

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (req.getParameter(ATTR_CONVERT) != null) {
            this.doConvert(req, resp);
        }
    }

    private void doConvert(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        RDFFormat requestBodyFormat;
        String baseURI = req.getRequestURL().toString();
        String contentType = req.getContentType();
        if (log.isInfoEnabled()) {
            log.info((Object)("Request body: " + contentType));
        }
        if ((requestBodyFormat = RDFFormat.forMIMEType((String)new MiniMime(contentType).getMimeType())) == null) {
            WorkbenchServlet.buildAndCommitResponse(resp, 400, "text/plain", "Content-Type not recognized as RDF: " + contentType);
            return;
        }
        RDFParserFactory rdfParserFactory = (RDFParserFactory)RDFParserRegistry.getInstance().get((Object)requestBodyFormat);
        if (rdfParserFactory == null) {
            WorkbenchServlet.buildAndCommitResponse(resp, 500, "text/plain", "Parser factory not found: Content-Type=" + contentType + ", format=" + requestBodyFormat);
            return;
        }
        GraphImpl g = new GraphImpl();
        try {
            RDFParser rdfParser = rdfParserFactory.getParser();
            rdfParser.setValueFactory((ValueFactory)new ValueFactoryImpl());
            rdfParser.setVerifyData(true);
            rdfParser.setStopAtFirstError(true);
            rdfParser.setDatatypeHandling(RDFParser.DatatypeHandling.IGNORE);
            rdfParser.setRDFHandler((RDFHandler)new StatementCollector((Collection)g));
            rdfParser.parse((InputStream)req.getInputStream(), baseURI);
            WorkbenchServlet.sendGraph(req, resp, (Graph)g);
        }
        catch (Throwable t) {
            BigdataRDFServlet.launderThrowable(t, resp, null);
        }
    }
}

