/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.webapp.client;

import info.aduna.lang.FileFormat;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.openrdf.query.resultio.BooleanQueryResultFormat;
import org.openrdf.query.resultio.BooleanQueryResultParserRegistry;
import org.openrdf.query.resultio.TupleQueryResultFormat;
import org.openrdf.query.resultio.TupleQueryResultParserRegistry;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFParserRegistry;

public class AcceptHeaderFactory {
    private static final int defaultQValue = 10;

    public static List<String> getAcceptParams(Iterable<RDFFormat> rdfFormats, boolean requireContext, RDFFormat preferredFormat) {
        LinkedList<String> acceptParams = new LinkedList<String>();
        for (RDFFormat format : rdfFormats) {
            int qValue = 10;
            if (requireContext && !format.supportsContexts()) {
                qValue -= 5;
            }
            if (preferredFormat != null && !preferredFormat.equals((Object)format)) {
                qValue -= 2;
            }
            if (!format.supportsNamespaces()) {
                --qValue;
            }
            Iterator i$ = format.getMIMETypes().iterator();
            while (i$.hasNext()) {
                String mimeType;
                String acceptParam = mimeType = (String)i$.next();
                if (qValue < 10) {
                    acceptParam = acceptParam + ";q=0." + qValue;
                }
                acceptParams.add(acceptParam);
            }
        }
        return acceptParams;
    }

    public static <T extends FileFormat> List<String> getAcceptParams(Iterable<T> formats, T preferredFormat) {
        LinkedList<String> acceptParams = new LinkedList<String>();
        for (FileFormat format : formats) {
            int qValue = 10;
            if (preferredFormat != null && !preferredFormat.equals((Object)format)) {
                qValue -= 2;
            }
            Iterator i$ = format.getMIMETypes().iterator();
            while (i$.hasNext()) {
                String mimeType;
                String acceptParam = mimeType = (String)i$.next();
                if (qValue < 10) {
                    acceptParam = acceptParam + ";q=0." + qValue;
                }
                acceptParams.add(acceptParam);
            }
        }
        return acceptParams;
    }

    public static String getDefaultGraphAcceptHeader(boolean requireContext) {
        LinkedHashSet<RDFFormat> values = new LinkedHashSet<RDFFormat>(RDFFormat.values());
        RDFParserRegistry registry = RDFParserRegistry.getInstance();
        Iterator itr = values.iterator();
        while (itr.hasNext()) {
            RDFFormat format = (RDFFormat)itr.next();
            if (registry.get((Object)format) != null) continue;
            itr.remove();
        }
        List<String> list1 = AcceptHeaderFactory.getAcceptParams(values, requireContext, RDFFormat.BINARY);
        return AcceptHeaderFactory.toString(list1);
    }

    public static String getDefaultSolutionsAcceptHeader() {
        LinkedHashSet values = new LinkedHashSet(TupleQueryResultFormat.values());
        TupleQueryResultParserRegistry registry = TupleQueryResultParserRegistry.getInstance();
        Iterator itr = values.iterator();
        while (itr.hasNext()) {
            TupleQueryResultFormat format = (TupleQueryResultFormat)itr.next();
            if (registry.get((Object)format) != null) continue;
            itr.remove();
        }
        List<String> list2 = AcceptHeaderFactory.getAcceptParams(values, TupleQueryResultFormat.BINARY);
        return AcceptHeaderFactory.toString(list2);
    }

    public static String getDefaultBooleanAcceptHeader() {
        LinkedHashSet values = new LinkedHashSet(BooleanQueryResultFormat.values());
        BooleanQueryResultParserRegistry registry = BooleanQueryResultParserRegistry.getInstance();
        Iterator itr = values.iterator();
        while (itr.hasNext()) {
            BooleanQueryResultFormat format = (BooleanQueryResultFormat)itr.next();
            if (registry.get((Object)format) != null) continue;
            itr.remove();
        }
        List<String> list3 = AcceptHeaderFactory.getAcceptParams(values, BooleanQueryResultFormat.SPARQL);
        return AcceptHeaderFactory.toString(list3);
    }

    private static String toString(Iterable<String> values) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String s : values) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            sb.append(s);
        }
        String s = sb.toString();
        return s;
    }
}

