/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.webapp.client;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryResultHandlerException;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.query.TupleQueryResultHandler;
import org.openrdf.query.TupleQueryResultHandlerException;
import org.openrdf.query.impl.TupleQueryResultImpl;
import org.openrdf.query.resultio.QueryResultParseException;
import org.openrdf.query.resultio.TupleQueryResultParser;
import org.openrdf.repository.sparql.query.QueueCursor;

public class BackgroundTupleResult
extends TupleQueryResultImpl
implements TupleQueryResult,
Runnable,
TupleQueryResultHandler {
    private final Object closeLock = new Object();
    private volatile boolean closed;
    private Thread parserThread;
    private final TupleQueryResultParser parser;
    private final InputStream in;
    private final QueueCursor<BindingSet> queue;
    private List<String> bindingNames;
    private final CountDownLatch bindingNamesReady = new CountDownLatch(1);

    public BackgroundTupleResult(TupleQueryResultParser parser, InputStream in) {
        this((QueueCursor<BindingSet>)new QueueCursor(10), parser, in);
    }

    public BackgroundTupleResult(QueueCursor<BindingSet> queue, TupleQueryResultParser parser, InputStream in) {
        super(Collections.emptyList(), queue);
        this.queue = queue;
        this.parser = parser;
        this.in = in;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleClose() throws QueryEvaluationException {
        Object object = this.closeLock;
        synchronized (object) {
            if (!this.closed) {
                this.closed = true;
                if (this.parserThread != null) {
                    this.parserThread.interrupt();
                }
                if (this.in != null) {
                    try {
                        this.in.close();
                    }
                    catch (IOException e) {
                        throw new QueryEvaluationException((Throwable)e);
                    }
                }
            }
        }
    }

    public List<String> getBindingNames() {
        try {
            this.bindingNamesReady.await();
            this.queue.checkException();
            if (this.closed) {
                throw new UndeclaredThrowableException(null, "Result closed");
            }
            return this.bindingNames;
        }
        catch (InterruptedException e) {
            throw new UndeclaredThrowableException(e);
        }
        catch (QueryEvaluationException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object = this.closeLock;
        synchronized (object) {
            if (this.closed) {
                this.bindingNamesReady.countDown();
                return;
            }
            this.parserThread = Thread.currentThread();
        }
        try {
            this.parser.setTupleQueryResultHandler((TupleQueryResultHandler)this);
            this.parser.parse(this.in);
        }
        catch (TupleQueryResultHandlerException e) {
        }
        catch (QueryResultParseException e) {
            this.queue.toss((Exception)((Object)e));
        }
        catch (IOException e) {
            this.queue.toss((Exception)e);
        }
        finally {
            Object e = this.closeLock;
            synchronized (e) {
                this.parserThread = null;
            }
            this.queue.done();
            this.bindingNamesReady.countDown();
        }
    }

    public void startQueryResult(List<String> bindingNames) throws TupleQueryResultHandlerException {
        this.bindingNames = bindingNames;
        this.bindingNamesReady.countDown();
    }

    public void handleSolution(BindingSet bindingSet) throws TupleQueryResultHandlerException {
        if (this.closed) {
            throw new TupleQueryResultHandlerException("Result closed");
        }
        try {
            this.queue.put((Object)bindingSet);
        }
        catch (InterruptedException e) {
            throw new TupleQueryResultHandlerException((Throwable)e);
        }
    }

    public void endQueryResult() throws TupleQueryResultHandlerException {
    }

    public void handleBoolean(boolean arg0) throws QueryResultHandlerException {
        throw new UnsupportedOperationException("Cannot handle boolean results");
    }

    public void handleLinks(List<String> arg0) throws QueryResultHandlerException {
    }
}

