/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast;

import com.bigdata.bop.BOp;
import com.bigdata.bop.ModifiableBOpBase;
import java.util.Map;
import java.util.Properties;

public class ASTBase
extends ModifiableBOpBase {
    private static final long serialVersionUID = 1L;

    public ASTBase(ASTBase op) {
        super(op);
    }

    public ASTBase(BOp[] args, Map<String, Object> annotations) {
        super(args, annotations);
    }

    public Properties getQueryHints() {
        return (Properties)this.getProperty("queryHints");
    }

    public String getQueryHint(String name) {
        return this.getQueryHint(name, null);
    }

    public String getQueryHint(String name, String defaultValue) {
        Properties queryHints = (Properties)this.getProperty("queryHints");
        if (queryHints == null) {
            return defaultValue;
        }
        return queryHints.getProperty(name, defaultValue);
    }

    public boolean getQueryHintAsBoolean(String name, String defaultValue) {
        return Boolean.valueOf(this.getQueryHint(name, defaultValue));
    }

    public boolean getQueryHintAsBoolean(String name, boolean defaultValue) {
        return Boolean.valueOf(this.getQueryHint(name, Boolean.toString(defaultValue)));
    }

    public void setQueryHints(Properties queryHints) {
        this.setProperty("queryHints", queryHints);
    }

    public void setQueryHint(String name, String value) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (value == null) {
            throw new IllegalArgumentException();
        }
        Properties queryHints = this.getQueryHints();
        if (queryHints == null) {
            queryHints = new Properties();
            this.setProperty("queryHints", queryHints);
        }
        queryHints.setProperty(name, value);
    }

    public int replaceAllWith(BOp oldVal, BOp newVal) {
        int n = 0;
        int arity = this.arity();
        for (int i = 0; i < arity; ++i) {
            BOp child = this.get(i);
            if (child != null && child.equals(oldVal)) {
                this.setArg(i, newVal);
                ++n;
            }
            if (!(child instanceof ASTBase)) continue;
            n += ((ASTBase)child).replaceAllWith(oldVal, newVal);
        }
        for (Map.Entry<String, Object> e : this.annotations().entrySet()) {
            if (!(e.getValue() instanceof ASTBase)) continue;
            n += ((ASTBase)e.getValue()).replaceAllWith(oldVal, newVal);
        }
        return n;
    }

    public static interface Annotations
    extends BOp.Annotations {
        public static final String QUERY_HINTS = "queryHints";
    }
}

