/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast;

import com.bigdata.bop.BOp;
import com.bigdata.bop.Constant;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.NV;
import com.bigdata.rdf.sparql.ast.ASTBase;
import com.bigdata.rdf.sparql.ast.ConstantNode;
import com.bigdata.rdf.sparql.ast.GroupMemberNodeBase;
import com.bigdata.rdf.sparql.ast.GroupNodeBase;
import com.bigdata.rdf.sparql.ast.IBindingProducerNode;
import com.bigdata.rdf.sparql.ast.IReorderableNode;
import com.bigdata.rdf.sparql.ast.JoinGroupNode;
import com.bigdata.rdf.sparql.ast.PathNode;
import com.bigdata.rdf.sparql.ast.StatementPatternNode;
import com.bigdata.rdf.sparql.ast.TermNode;
import com.bigdata.rdf.sparql.ast.VarNode;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpBase;
import com.bigdata.rdf.sparql.ast.optimizers.StaticOptimizer;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ArbitraryLengthPathNode
extends GroupMemberNodeBase<ArbitraryLengthPathNode>
implements IBindingProducerNode,
IReorderableNode {
    private static final transient Logger log = Logger.getLogger(ArbitraryLengthPathNode.class);
    private static final long serialVersionUID = 1L;

    public ArbitraryLengthPathNode(ArbitraryLengthPathNode op) {
        super(op);
    }

    public ArbitraryLengthPathNode(BOp[] args, Map<String, Object> anns) {
        super(args, anns);
    }

    public ArbitraryLengthPathNode(TermNode left, TermNode right, VarNode transitivityVarLeft, VarNode transitivityVarRight, PathNode.PathMod mod) {
        this(new BOp[]{new JoinGroupNode()}, NV.asMap(new NV(Annotations.LEFT_TERM, left), new NV(Annotations.RIGHT_TERM, right), new NV(Annotations.TRANSITIVITY_VAR_LEFT, transitivityVarLeft), new NV(Annotations.TRANSITIVITY_VAR_RIGHT, transitivityVarRight), new NV(Annotations.LOWER_BOUND, mod == PathNode.PathMod.ONE_OR_MORE ? 1L : 0L), new NV(Annotations.UPPER_BOUND, mod == PathNode.PathMod.ZERO_OR_ONE ? 1L : Long.MAX_VALUE)));
    }

    public ArbitraryLengthPathNode(TermNode left, TermNode right, VarNode transitivityVarLeft, VarNode transitivityVarRight, long lowerBound, long upperBound) {
        this(new BOp[]{new JoinGroupNode()}, NV.asMap(new NV(Annotations.LEFT_TERM, left), new NV(Annotations.RIGHT_TERM, right), new NV(Annotations.TRANSITIVITY_VAR_LEFT, transitivityVarLeft), new NV(Annotations.TRANSITIVITY_VAR_RIGHT, transitivityVarRight), new NV(Annotations.LOWER_BOUND, lowerBound), new NV(Annotations.UPPER_BOUND, upperBound)));
    }

    public TermNode left() {
        return (TermNode)super.getRequiredProperty(Annotations.LEFT_TERM);
    }

    public TermNode right() {
        return (TermNode)super.getRequiredProperty(Annotations.RIGHT_TERM);
    }

    public VarNode tVarLeft() {
        return (VarNode)super.getRequiredProperty(Annotations.TRANSITIVITY_VAR_LEFT);
    }

    public VarNode tVarRight() {
        return (VarNode)super.getRequiredProperty(Annotations.TRANSITIVITY_VAR_RIGHT);
    }

    public long lowerBound() {
        return (Long)super.getRequiredProperty(Annotations.LOWER_BOUND);
    }

    public long upperBound() {
        return (Long)super.getRequiredProperty(Annotations.UPPER_BOUND);
    }

    public JoinGroupNode subgroup() {
        return (JoinGroupNode)this.get(0);
    }

    public Set<IVariable<?>> getMaybeProducedBindings() {
        LinkedHashSet producedBindings = new LinkedHashSet();
        this.addProducedBindings(this.left(), producedBindings);
        this.addProducedBindings(this.right(), producedBindings);
        for (StatementPatternNode sp : this.subgroup().getStatementPatterns()) {
            this.addProducedBindings(sp.s(), producedBindings);
            this.addProducedBindings(sp.p(), producedBindings);
            this.addProducedBindings(sp.o(), producedBindings);
            this.addProducedBindings(sp.c(), producedBindings);
        }
        return producedBindings;
    }

    public Set<IVariable<?>> getDefinitelyProducedBindings() {
        LinkedHashSet producedBindings = new LinkedHashSet();
        this.addProducedBindings(this.left(), producedBindings);
        this.addProducedBindings(this.right(), producedBindings);
        return producedBindings;
    }

    private void addProducedBindings(TermNode t, Set<IVariable<?>> producedBindings) {
        ConstantNode cNode;
        Constant c;
        IVariable var;
        if (t instanceof VarNode) {
            if (!((VarNode)t).isAnonymous()) {
                producedBindings.add((IVariable<?>)((VarNode)t).getValueExpression());
            }
        } else if (t instanceof ConstantNode && (var = (c = (Constant)(cNode = (ConstantNode)t).getValueExpression()).getVar()) != null) {
            producedBindings.add(var);
        }
    }

    @Override
    public String toString(int indent) {
        String s = ArbitraryLengthPathNode.indent(indent);
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        sb.append(s).append(this.getClass().getSimpleName());
        sb.append("(left=").append(this.left()).append(", right=").append(this.right()).append(") {");
        sb.append(this.subgroup().toString(indent + 1));
        sb.append("\n").append(s);
        sb.append("}");
        Long rangeCount = (Long)this.getProperty(AST2BOpBase.Annotations.ESTIMATED_CARDINALITY);
        if (rangeCount != null) {
            sb.append(" AST2BOpBase.estimatedCardinality=");
            sb.append(this.getProperty(AST2BOpBase.Annotations.ESTIMATED_CARDINALITY).toString());
        }
        return sb.toString();
    }

    @Override
    public boolean isReorderable() {
        long estCard = this.getEstimatedCardinality(null);
        return estCard >= 0L && estCard < Long.MAX_VALUE;
    }

    @Override
    public long getEstimatedCardinality(StaticOptimizer opt) {
        long estCard;
        JoinGroupNode group = this.subgroup();
        long zeroMatchAdjustment = 0L;
        if (this.lowerBound() == 0L) {
            int fixedCount = (this.left() instanceof VarNode ? 1 : 0) + (this.right() instanceof VarNode ? 1 : 0);
            switch (fixedCount) {
                case 0: {
                    zeroMatchAdjustment = this.left().getValue().equals(this.right().getValue()) ? 1L : 0L;
                    break;
                }
                case 1: {
                    zeroMatchAdjustment = 1L;
                    break;
                }
                case 2: {
                    zeroMatchAdjustment = 0x3FFFFFFFFFFFFFFFL;
                }
            }
        }
        BOp pathExpr = null;
        if (group.arity() == 1) {
            pathExpr = group.get(0);
        } else {
            for (BOp node : group.getChildren()) {
                ASTBase astNode = (ASTBase)node;
                if (!astNode.getQueryHintAsBoolean("alp.pathExpr", false)) continue;
                pathExpr = node;
                break;
            }
        }
        long result = pathExpr != null && pathExpr.getProperty(AST2BOpBase.Annotations.ESTIMATED_CARDINALITY) != null ? ((estCard = pathExpr.getProperty(AST2BOpBase.Annotations.ESTIMATED_CARDINALITY, Long.MAX_VALUE).longValue()) < Long.MAX_VALUE ? estCard + zeroMatchAdjustment : Long.MAX_VALUE) : Long.MAX_VALUE;
        if (log.isDebugEnabled()) {
            log.debug((Object)("reported cardinality: " + result));
        }
        return result;
    }

    public static interface Annotations
    extends GroupNodeBase.Annotations {
        public static final String LEFT_TERM = Annotations.class.getName() + ".leftTerm";
        public static final String RIGHT_TERM = Annotations.class.getName() + ".rightTerm";
        public static final String TRANSITIVITY_VAR_LEFT = Annotations.class.getName() + ".transitivityVarLeft";
        public static final String TRANSITIVITY_VAR_RIGHT = Annotations.class.getName() + ".transitivityVarRight";
        public static final String LOWER_BOUND = Annotations.class.getName() + ".lowerBound";
        public static final String UPPER_BOUND = Annotations.class.getName() + ".upperBound";
    }
}

