/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast;

import com.bigdata.bop.BOp;
import com.bigdata.rdf.sparql.ast.AssignmentNode;
import com.bigdata.rdf.sparql.ast.FilterNode;
import com.bigdata.rdf.sparql.ast.GraphPatternGroup;
import com.bigdata.rdf.sparql.ast.GroupNodeBase;
import com.bigdata.rdf.sparql.ast.IGroupMemberNode;
import com.bigdata.rdf.sparql.ast.IQueryNode;
import com.bigdata.rdf.sparql.ast.IReorderableNode;
import com.bigdata.rdf.sparql.ast.NamedSubqueryInclude;
import com.bigdata.rdf.sparql.ast.QueryHints;
import com.bigdata.rdf.sparql.ast.QueryOptimizerEnum;
import com.bigdata.rdf.sparql.ast.StatementPatternNode;
import com.bigdata.rdf.sparql.ast.TermNode;
import com.bigdata.rdf.sparql.ast.service.ServiceNode;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class JoinGroupNode
extends GraphPatternGroup<IGroupMemberNode> {
    private static final long serialVersionUID = 1L;

    public JoinGroupNode(JoinGroupNode op) {
        super(op);
    }

    public JoinGroupNode(BOp[] args, Map<String, Object> anns) {
        super(args, anns);
    }

    public JoinGroupNode() {
    }

    public JoinGroupNode(IGroupMemberNode child) {
        this.addChild(child);
    }

    public JoinGroupNode(boolean optional) {
        this.setOptional(optional);
    }

    public JoinGroupNode(boolean optional, IGroupMemberNode child) {
        this.setOptional(optional);
        this.addChild(child);
    }

    public JoinGroupNode(TermNode context, IGroupMemberNode child) {
        this.setContext(context);
        this.addChild(child);
    }

    public void setContext(TermNode context) {
        this.setProperty("context", context);
    }

    @Override
    public TermNode getContext() {
        TermNode context = (TermNode)this.getProperty("context");
        if (context != null) {
            return context;
        }
        return super.getContext();
    }

    @Override
    public final boolean isOptional() {
        return this.getProperty("optional", false);
    }

    public final void setOptional(boolean optional) {
        this.setProperty("optional", optional);
    }

    @Override
    public final boolean isMinus() {
        return this.getProperty("minus", false);
    }

    public void setMinus(boolean minus) {
        this.setProperty("minus", minus);
    }

    public final QueryOptimizerEnum getQueryOptimizer() {
        return this.getProperty("optimizer", QueryHints.DEFAULT_OPTIMIZER);
    }

    public List<StatementPatternNode> getStatementPatterns() {
        return this.getChildren(StatementPatternNode.class);
    }

    public int getStatementPatternCount() {
        int n = 0;
        for (IQueryNode node : this) {
            if (!(node instanceof StatementPatternNode)) continue;
            ++n;
        }
        return n;
    }

    public int getRequiredStatementPatternCount() {
        int n = 0;
        for (IQueryNode node : this) {
            if (!(node instanceof StatementPatternNode) || ((StatementPatternNode)node).isOptional()) continue;
            ++n;
        }
        return n;
    }

    public List<ServiceNode> getServiceNodes() {
        return this.getChildren(ServiceNode.class);
    }

    public List<NamedSubqueryInclude> getNamedSubqueryIncludes() {
        return this.getChildren(NamedSubqueryInclude.class);
    }

    public <T> List<T> getChildren(Class<T> type) {
        LinkedList<IQueryNode> children = new LinkedList<IQueryNode>();
        for (IQueryNode node : this) {
            if (!type.isAssignableFrom(node.getClass())) continue;
            children.add(node);
        }
        return children;
    }

    public List<AssignmentNode> getAssignments() {
        return this.getChildren(AssignmentNode.class);
    }

    public List<FilterNode> getAllFiltersInGroup() {
        return this.getChildren(FilterNode.class);
    }

    public List<FilterNode> getInFilters() {
        LinkedList<FilterNode> filters = new LinkedList<FilterNode>();
        for (IQueryNode node : this) {
            if (node instanceof FilterNode) continue;
        }
        return filters;
    }

    public List<IReorderableNode> getReorderableChildren() {
        List<IReorderableNode> nodes = this.getChildren(IReorderableNode.class);
        Iterator<IReorderableNode> it = nodes.iterator();
        while (it.hasNext()) {
            IReorderableNode node = it.next();
            if (node.isReorderable()) continue;
            it.remove();
        }
        return nodes;
    }

    static interface Annotations
    extends GroupNodeBase.Annotations {
        public static final String CONTEXT = "context";
        public static final String OPTIMIZER = "optimizer";
    }
}

