/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast;

import com.bigdata.bop.BOp;
import com.bigdata.rdf.rio.IRDFParserOptions;
import com.bigdata.rdf.sparql.ast.ConstantNode;
import com.bigdata.rdf.sparql.ast.GraphUpdate;
import com.bigdata.rdf.sparql.ast.Update;
import com.bigdata.rdf.sparql.ast.UpdateType;
import java.util.Map;

public class LoadGraph
extends GraphUpdate {
    private static final long serialVersionUID = 1L;

    public LoadGraph() {
        super(UpdateType.Load);
    }

    public LoadGraph(LoadGraph op) {
        super(op);
    }

    public LoadGraph(BOp[] args, Map<String, Object> anns) {
        super(args, anns);
    }

    @Override
    public ConstantNode getSourceGraph() {
        return (ConstantNode)this.getProperty("source");
    }

    @Override
    public void setSourceGraph(ConstantNode sourceGraph) {
        if (sourceGraph == null) {
            throw new IllegalArgumentException();
        }
        this.setProperty("source", sourceGraph);
    }

    @Override
    public ConstantNode getTargetGraph() {
        return (ConstantNode)this.getProperty("target");
    }

    @Override
    public void setTargetGraph(ConstantNode targetGraph) {
        if (targetGraph == null) {
            throw new IllegalArgumentException();
        }
        this.setProperty("target", targetGraph);
    }

    @Override
    public boolean isSilent() {
        return this.getProperty("silent", false);
    }

    @Override
    public void setSilent(boolean silent) {
        this.setProperty("silent", silent);
    }

    public IRDFParserOptions getRDFParserOptions() {
        return (IRDFParserOptions)this.getProperty("options");
    }

    public void setRDFParserOptions(IRDFParserOptions options) {
        this.setProperty("options", options);
    }

    @Override
    public String toString(int indent) {
        StringBuilder sb = new StringBuilder();
        sb.append(LoadGraph.indent(indent));
        sb.append((Object)this.getUpdateType());
        boolean silent = this.isSilent();
        ConstantNode sourceGraph = this.getSourceGraph();
        ConstantNode targetGraph = this.getTargetGraph();
        IRDFParserOptions rdfParserOptions = this.getRDFParserOptions();
        if (silent) {
            sb.append(" SILENT");
        }
        if (rdfParserOptions != null) {
            sb.append(" OPTIONS=" + rdfParserOptions);
        }
        if (sourceGraph != null) {
            sb.append("\n");
            sb.append(LoadGraph.indent(indent + 1));
            sb.append("source=" + sourceGraph);
        }
        if (targetGraph != null) {
            sb.append("\n");
            sb.append(LoadGraph.indent(indent + 1));
            sb.append("target=" + targetGraph);
        }
        sb.append("\n");
        return sb.toString();
    }

    public static interface Annotations
    extends Update.Annotations {
        public static final String OPTIONS = "options";
    }
}

