/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast;

import com.bigdata.bop.BOp;
import com.bigdata.bop.IVariable;
import com.bigdata.rdf.sparql.ast.ASTUtil;
import com.bigdata.rdf.sparql.ast.FilterNode;
import com.bigdata.rdf.sparql.ast.GroupMemberNodeBase;
import com.bigdata.rdf.sparql.ast.IJoinNode;
import com.bigdata.rdf.sparql.ast.INamedSolutionSet;
import com.bigdata.rdf.sparql.ast.VarNode;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class NamedSubqueryInclude
extends GroupMemberNodeBase<NamedSubqueryInclude>
implements IJoinNode,
INamedSolutionSet {
    private static final long serialVersionUID = 1L;

    public NamedSubqueryInclude(NamedSubqueryInclude op) {
        super(op);
    }

    public NamedSubqueryInclude(BOp[] args, Map<String, Object> anns) {
        super(args, anns);
    }

    public NamedSubqueryInclude(String name) {
        this.setName(name);
    }

    @Override
    public String getName() {
        return (String)this.getProperty("namedSet");
    }

    @Override
    public void setName(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        this.setProperty("namedSet", name);
    }

    public VarNode[] getJoinVars() {
        return (VarNode[])this.getProperty("joinVars");
    }

    public void setJoinVars(VarNode[] joinVars) {
        this.setProperty("joinVars", joinVars);
    }

    public Set<IVariable<?>> getJoinVarSet() {
        LinkedHashSet set = new LinkedHashSet();
        VarNode[] a = this.getJoinVars();
        if (a != null && a.length > 0) {
            for (IVariable v : ASTUtil.convert(a)) {
                set.add(v);
            }
        }
        return set;
    }

    @Override
    public final boolean isOptional() {
        return false;
    }

    @Override
    public final boolean isMinus() {
        return false;
    }

    @Override
    public final List<FilterNode> getAttachedJoinFilters() {
        List filters = (List)this.getProperty("filters");
        if (filters == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(filters);
    }

    @Override
    public final void setAttachedJoinFilters(List<FilterNode> filters) {
        this.setProperty("filters", filters);
    }

    @Override
    public String toString(int indent) {
        List<FilterNode> filters;
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        sb.append(NamedSubqueryInclude.indent(indent));
        sb.append("INCLUDE ").append(this.getName());
        VarNode[] joinVars = this.getJoinVars();
        if (joinVars != null) {
            sb.append(" JOIN ON (");
            boolean first = true;
            for (VarNode var : joinVars) {
                if (!first) {
                    sb.append(",");
                }
                sb.append(var);
                first = false;
            }
            sb.append(")");
        }
        if (!(filters = this.getAttachedJoinFilters()).isEmpty()) {
            for (FilterNode filter : filters) {
                sb.append(filter.toString(indent + 1));
            }
        }
        return sb.toString();
    }

    public static interface Annotations
    extends IJoinNode.Annotations,
    INamedSolutionSet.Annotations {
        public static final String JOIN_VARS = "joinVars";
    }
}

