/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast;

import com.bigdata.bop.BOp;
import com.bigdata.bop.NV;
import com.bigdata.rdf.sparql.ast.ASTBase;
import com.bigdata.rdf.sparql.ast.ConstantNode;
import com.bigdata.rdf.sparql.ast.ZeroLengthPathNode;
import java.util.Map;

public class PathNode
extends ASTBase {
    private static final long serialVersionUID = -4396141823074067307L;

    public PathNode(PathNode op) {
        super(op);
    }

    public PathNode(BOp[] args, Map<String, Object> anns) {
        super(args, anns);
    }

    public PathNode(PathAlternative arg) {
        this(new BOp[]{arg}, BOp.NOANNS);
    }

    public PathAlternative getPathAlternative() {
        return (PathAlternative)this.get(0);
    }

    public static class PathOneInPropertySet
    extends ASTBase {
        private static final long serialVersionUID = 1L;

        public PathOneInPropertySet(PathOneInPropertySet op) {
            super(op);
        }

        public PathOneInPropertySet(BOp[] args, Map<String, Object> anns) {
            super(args, anns);
        }

        public PathOneInPropertySet(ConstantNode arg) {
            this(arg, false);
        }

        public PathOneInPropertySet(ConstantNode arg, boolean inverse) {
            this(new BOp[]{arg}, NV.asMap(new NV(Annotations.INVERSE, inverse)));
        }

        public boolean inverse() {
            return (Boolean)super.getRequiredProperty(Annotations.INVERSE);
        }

        static interface Annotations
        extends ASTBase.Annotations {
            public static final String INVERSE = Annotations.class.getName() + ".inverse";
        }
    }

    public static class PathNegatedPropertySet
    extends ASTBase {
        private static final long serialVersionUID = 1L;

        public PathNegatedPropertySet(PathNegatedPropertySet op) {
            super(op);
        }

        public PathNegatedPropertySet(BOp[] args, Map<String, Object> anns) {
            super(args, anns);
        }

        public PathNegatedPropertySet(PathOneInPropertySet ... args) {
            this((BOp[])args, BOp.NOANNS);
        }
    }

    public static enum PathMod {
        ZERO_OR_ONE("?"),
        ZERO_OR_MORE("*"),
        ONE_OR_MORE("+");

        final String mod;

        private PathMod(String mod) {
            this.mod = mod;
        }

        public String toString() {
            return this.mod;
        }
    }

    public static class PathElt
    extends ASTBase {
        private static final long serialVersionUID = 1L;

        public PathElt(PathElt op) {
            super(op);
        }

        public PathElt(BOp[] args, Map<String, Object> anns) {
            super(args, anns);
        }

        public PathElt(BOp arg) {
            this(arg, false);
        }

        public PathElt(BOp arg, boolean inverse) {
            this(arg, inverse, null);
        }

        public PathElt(BOp arg, PathMod mod) {
            this(arg, false, mod);
        }

        public PathElt(BOp arg, boolean inverse, PathMod mod) {
            this(new BOp[]{arg}, NV.asMap(new NV(Annotations.INVERSE, inverse), new NV(Annotations.MOD, (Object)mod)));
            if (!(arg instanceof ConstantNode || arg instanceof PathAlternative || arg instanceof PathNegatedPropertySet || arg instanceof ZeroLengthPathNode)) {
                throw new IllegalArgumentException();
            }
        }

        public boolean inverse() {
            return (Boolean)super.getRequiredProperty(Annotations.INVERSE);
        }

        public void setInverse(boolean inverse) {
            super.setProperty(Annotations.INVERSE, inverse);
        }

        public PathMod getMod() {
            return (PathMod)((Object)super.getProperty(Annotations.MOD));
        }

        public void setMod(PathMod mod) {
            super.setProperty(Annotations.MOD, (Object)mod);
        }

        public boolean isIRI() {
            return this.get(0) instanceof ConstantNode;
        }

        public boolean isNestedPath() {
            return this.get(0) instanceof PathAlternative;
        }

        public boolean isNegatedPropertySet() {
            return this.get(0) instanceof PathNegatedPropertySet;
        }

        public boolean isZeroLengthPath() {
            return this.get(0) instanceof ZeroLengthPathNode;
        }

        static interface Annotations
        extends ASTBase.Annotations {
            public static final String INVERSE = Annotations.class.getName() + ".inverse";
            public static final String MOD = Annotations.class.getName() + ".mod";
        }
    }

    public static class PathSequence
    extends ASTBase {
        private static final long serialVersionUID = 1L;

        public PathSequence(PathSequence op) {
            super(op);
        }

        public PathSequence(BOp[] args, Map<String, Object> anns) {
            super(args, anns);
        }

        public PathSequence(PathElt ... args) {
            this((BOp[])args, BOp.NOANNS);
            if (args == null || args.length == 0) {
                throw new IllegalArgumentException("one or more args required");
            }
        }
    }

    public static class PathAlternative
    extends ASTBase {
        private static final long serialVersionUID = 1L;

        public PathAlternative(PathAlternative op) {
            super(op);
        }

        public PathAlternative(BOp[] args, Map<String, Object> anns) {
            super(args, anns);
        }

        public PathAlternative(PathSequence ... args) {
            this((BOp[])args, BOp.NOANNS);
            if (args == null || args.length == 0) {
                throw new IllegalArgumentException("one or more args required");
            }
        }
    }
}

