/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast;

import com.bigdata.bop.BOpUtility;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstant;
import com.bigdata.bop.IVariable;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.sparql.ast.CompiledSolutionSetStats;
import com.bigdata.rdf.sparql.ast.ISolutionSetStats;
import cutthecrap.utils.striterators.ICloseableIterator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class SolutionSetStatserator
implements ICloseableIterator<IBindingSet[]> {
    private final Iterator<IBindingSet[]> src;
    private boolean open = true;
    private ISolutionSetStats compiledStats;
    protected long nsolutions = 0L;
    protected final Set<IVariable<?>> usedVars = new HashSet();
    protected final Set<IVariable<?>> notAlwaysBound = new HashSet();
    protected final Set<IVariable<?>> notMaterialized = new HashSet();
    protected final Map<IVariable<?>, IConstant<?>> firstBoundValue = new HashMap();
    protected final Set<IVariable<?>> notConstant = new HashSet();
    protected final Set<IVariable<?>> currentVars = new HashSet();
    protected final Set<IVariable<?>> notBoundThisSolution = new HashSet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ISolutionSetStats get(IBindingSet[] bindingSets) {
        try (SolutionSetStatserator itr = new SolutionSetStatserator(BOpUtility.asIterator(bindingSets));){
            while (itr.hasNext()) {
                itr.next();
            }
            ISolutionSetStats iSolutionSetStats = itr.getStats();
            return iSolutionSetStats;
        }
    }

    public SolutionSetStatserator(Iterator<IBindingSet[]> src) {
        if (src == null) {
            throw new IllegalArgumentException();
        }
        this.src = src;
    }

    protected void filter(IBindingSet[] a) {
        for (IBindingSet bset : a) {
            if (bset == null) {
                throw new IllegalArgumentException();
            }
            ++this.nsolutions;
            this.currentVars.clear();
            Iterator<IVariable> vitr = bset.vars();
            while (vitr.hasNext()) {
                IV iv;
                IConstant<?> c2;
                IVariable v = vitr.next();
                if (this.usedVars.add(v) && this.nsolutions > 1L) {
                    this.notAlwaysBound.add(v);
                }
                this.currentVars.add(v);
                IConstant c = bset.get(v);
                if (this.nsolutions == 1L) {
                    this.firstBoundValue.put(v, c);
                } else if (!(this.notConstant.contains(v) || (c2 = this.firstBoundValue.get(v)) != null && c2.equals((Object)c))) {
                    this.notConstant.add(v);
                }
                if (this.notMaterialized.contains(v) || c == null || (iv = (IV)c.get()).hasValue()) continue;
                this.notMaterialized.add(v);
            }
            this.notBoundThisSolution.clear();
            this.notBoundThisSolution.addAll(this.usedVars);
            this.notBoundThisSolution.removeAll(this.currentVars);
            this.notAlwaysBound.addAll(this.notBoundThisSolution);
            this.notConstant.addAll(this.notBoundThisSolution);
        }
    }

    protected ISolutionSetStats compile() {
        HashSet alwaysBound = new HashSet(this.usedVars);
        alwaysBound.removeAll(this.notAlwaysBound);
        HashSet materialized = new HashSet(this.usedVars);
        materialized.removeAll(this.notMaterialized);
        HashMap constants = new HashMap(this.firstBoundValue);
        for (IVariable<?> v : this.notConstant) {
            constants.remove(v);
        }
        return new CompiledSolutionSetStats(this.nsolutions, this.usedVars, alwaysBound, this.notAlwaysBound, materialized, constants);
    }

    public ISolutionSetStats getStats() {
        if (this.compiledStats == null) {
            throw new IllegalStateException();
        }
        return this.compiledStats;
    }

    @Override
    public void close() {
        if (this.open) {
            this.open = false;
            if (this.src instanceof ICloseableIterator) {
                ((ICloseableIterator)this.src).close();
            }
        }
    }

    @Override
    public boolean hasNext() {
        if (this.open && !this.src.hasNext()) {
            this.close();
            this.compiledStats = this.compile();
            return false;
        }
        return this.open;
    }

    @Override
    public IBindingSet[] next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        IBindingSet[] a = this.src.next();
        this.filter(a);
        return a;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

