/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast;

import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpUtility;
import com.bigdata.bop.IConstant;
import com.bigdata.bop.IConstraint;
import com.bigdata.bop.IValueExpression;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.aggregate.IAggregate;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.constraints.INeedsMaterialization;
import com.bigdata.rdf.internal.constraints.IPassesMaterialization;
import com.bigdata.rdf.sparql.ast.ArbitraryLengthPathNode;
import com.bigdata.rdf.sparql.ast.AssignmentNode;
import com.bigdata.rdf.sparql.ast.BindingsClause;
import com.bigdata.rdf.sparql.ast.FilterNode;
import com.bigdata.rdf.sparql.ast.FunctionNode;
import com.bigdata.rdf.sparql.ast.FunctionRegistry;
import com.bigdata.rdf.sparql.ast.GraphPatternGroup;
import com.bigdata.rdf.sparql.ast.GroupByNode;
import com.bigdata.rdf.sparql.ast.HavingNode;
import com.bigdata.rdf.sparql.ast.IBindingProducerNode;
import com.bigdata.rdf.sparql.ast.IGroupMemberNode;
import com.bigdata.rdf.sparql.ast.IGroupNode;
import com.bigdata.rdf.sparql.ast.IJoinNode;
import com.bigdata.rdf.sparql.ast.IQueryNode;
import com.bigdata.rdf.sparql.ast.ISolutionSetStats;
import com.bigdata.rdf.sparql.ast.IValueExpressionNode;
import com.bigdata.rdf.sparql.ast.JoinGroupNode;
import com.bigdata.rdf.sparql.ast.NamedSubqueryInclude;
import com.bigdata.rdf.sparql.ast.NamedSubqueryRoot;
import com.bigdata.rdf.sparql.ast.ProjectionNode;
import com.bigdata.rdf.sparql.ast.QueryBase;
import com.bigdata.rdf.sparql.ast.QueryRoot;
import com.bigdata.rdf.sparql.ast.StatementPatternNode;
import com.bigdata.rdf.sparql.ast.StaticAnalysis_CanJoin;
import com.bigdata.rdf.sparql.ast.SubqueryBase;
import com.bigdata.rdf.sparql.ast.SubqueryFunctionNodeBase;
import com.bigdata.rdf.sparql.ast.SubqueryRoot;
import com.bigdata.rdf.sparql.ast.UnionNode;
import com.bigdata.rdf.sparql.ast.ZeroLengthPathNode;
import com.bigdata.rdf.sparql.ast.eval.IEvaluationContext;
import com.bigdata.rdf.sparql.ast.service.ServiceNode;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class StaticAnalysis
extends StaticAnalysis_CanJoin {
    private static final Logger log = Logger.getLogger(StaticAnalysis.class);

    StaticAnalysis(QueryRoot queryRoot) {
        this(queryRoot, null);
    }

    public StaticAnalysis(QueryRoot queryRoot, IEvaluationContext evaluationContext) {
        super(queryRoot, evaluationContext);
    }

    public JoinGroupNode findParentJoinGroup(GraphPatternGroup<?> group) {
        IQueryNode p = this.findParent(group);
        if (p instanceof JoinGroupNode) {
            return (JoinGroupNode)p;
        }
        if (p instanceof UnionNode) {
            return ((UnionNode)p).getParentJoinGroup();
        }
        if (p instanceof SubqueryRoot) {
            return ((SubqueryRoot)p).getParentJoinGroup();
        }
        if (p instanceof NamedSubqueryRoot || p instanceof QueryRoot) {
            return null;
        }
        if (p instanceof ServiceNode) {
            return ((ServiceNode)p).getParentJoinGroup();
        }
        if (p instanceof FilterNode) {
            return ((FilterNode)p).getParentJoinGroup();
        }
        throw new UnsupportedOperationException();
    }

    public IQueryNode findParent(GraphPatternGroup<?> group) {
        return StaticAnalysis.findParent(this.queryRoot, group);
    }

    public static IQueryNode findParent(QueryRoot queryRoot, GraphPatternGroup<?> group) {
        GraphPatternGroup whereClause;
        if (group == null) {
            throw new IllegalArgumentException();
        }
        IQueryNode p = group.getParentGraphPatternGroup();
        if (p != null) {
            return p;
        }
        if (queryRoot.getNamedSubqueries() != null) {
            for (NamedSubqueryRoot namedSubquery : queryRoot.getNamedSubqueries()) {
                GraphPatternGroup whereClause2 = namedSubquery.getWhereClause();
                if (whereClause2 == group) {
                    return namedSubquery;
                }
                p = StaticAnalysis.findParent2(whereClause2, group);
                if (p == null) continue;
                return p;
            }
        }
        if ((whereClause = queryRoot.getWhereClause()) == group) {
            return queryRoot;
        }
        p = StaticAnalysis.findParent2(whereClause, group);
        if (p != null) {
            return p;
        }
        return p;
    }

    public static IQueryNode findParent2(GraphPatternGroup<IGroupMemberNode> aGroup, GraphPatternGroup<?> theGroup) {
        if (aGroup == theGroup) {
            throw new AssertionError();
        }
        int arity = aGroup.arity();
        for (int i = 0; i < arity; ++i) {
            IGroupMemberNode child = (IGroupMemberNode)aGroup.get(i);
            if (child instanceof QueryBase) {
                QueryBase queryBase = (QueryBase)((Object)child);
                if (queryBase.getWhereClause() != theGroup) continue;
                return queryBase;
            }
            if (child instanceof ServiceNode) {
                ServiceNode serviceNode = (ServiceNode)child;
                if (serviceNode.getGraphPattern() != theGroup) continue;
                return serviceNode;
            }
            if (!(child instanceof FilterNode)) continue;
            FilterNode filter = (FilterNode)child;
            Iterator<SubqueryFunctionNodeBase> itr = BOpUtility.visitAll(filter, SubqueryFunctionNodeBase.class);
            while (itr.hasNext()) {
                SubqueryFunctionNodeBase tmp = itr.next();
                if (tmp.getGraphPattern() != theGroup) continue;
                return filter;
            }
        }
        return null;
    }

    public Set<IVariable<?>> getDefinitelyIncomingBindings(IGroupMemberNode node, Set<IVariable<?>> vars) {
        GraphPatternGroup<IGroupMemberNode> parent;
        if (this.evaluationContext != null) {
            ISolutionSetStats stats = this.evaluationContext.getSolutionSetStats();
            vars.addAll(stats.getAlwaysBound());
        }
        if ((parent = node.getParentGraphPatternGroup()) == null) {
            return vars;
        }
        if (!(parent instanceof UnionNode)) {
            IGroupMemberNode child;
            Iterator i$ = parent.iterator();
            while (i$.hasNext() && (child = (IGroupMemberNode)i$.next()) != node) {
                boolean minus;
                if (!(child instanceof IBindingProducerNode)) continue;
                boolean optional = child instanceof IJoinNode && ((IJoinNode)((Object)child)).isOptional();
                boolean bl = minus = child instanceof IJoinNode && ((IJoinNode)((Object)child)).isMinus();
                if (optional || minus) continue;
                this.getDefinitelyProducedBindings((IBindingProducerNode)((Object)child), vars, true);
            }
        }
        return this.getDefinitelyIncomingBindings(parent, vars);
    }

    public Set<IVariable<?>> getMaybeIncomingBindings(IGroupMemberNode node, Set<IVariable<?>> vars) {
        GraphPatternGroup<IGroupMemberNode> parent;
        if (this.evaluationContext != null) {
            ISolutionSetStats stats = this.evaluationContext.getSolutionSetStats();
            vars.addAll(stats.getAlwaysBound());
            vars.addAll(stats.getNotAlwaysBound());
        }
        if ((parent = node.getParentGraphPatternGroup()) == null) {
            return vars;
        }
        if (!(parent instanceof UnionNode)) {
            IGroupMemberNode child;
            Iterator i$ = parent.iterator();
            while (i$.hasNext() && (child = (IGroupMemberNode)i$.next()) != node) {
                boolean minus;
                if (!(child instanceof IBindingProducerNode) || (minus = child instanceof IJoinNode && ((IJoinNode)((Object)child)).isMinus())) continue;
                this.getMaybeProducedBindings((IBindingProducerNode)((Object)child), vars, true);
            }
        }
        return this.getMaybeIncomingBindings(parent, vars);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Set<IVariable<?>> getDefinitelyProducedBindings(IBindingProducerNode node, Set<IVariable<?>> vars, boolean recursive) {
        if (node instanceof GraphPatternGroup) {
            if (node instanceof JoinGroupNode) {
                this.getDefinitelyProducedBindings((JoinGroupNode)node, vars, recursive);
                return vars;
            } else {
                if (!(node instanceof UnionNode)) throw new AssertionError((Object)node.toString());
                this.getDefinitelyProducedBindings((UnionNode)node, vars, recursive);
            }
            return vars;
        } else if (node instanceof StatementPatternNode) {
            StatementPatternNode sp = (StatementPatternNode)node;
            vars.addAll(sp.getProducedBindings());
            return vars;
        } else if (node instanceof ArbitraryLengthPathNode) {
            vars.addAll(((ArbitraryLengthPathNode)node).getDefinitelyProducedBindings());
            return vars;
        } else if (node instanceof ZeroLengthPathNode) {
            vars.addAll(((ZeroLengthPathNode)node).getProducedBindings());
            return vars;
        } else if (node instanceof SubqueryRoot) {
            SubqueryRoot subquery = (SubqueryRoot)node;
            vars.addAll(this.getDefinitelyProducedBindings(subquery));
            return vars;
        } else if (node instanceof NamedSubqueryInclude) {
            NamedSubqueryInclude nsi = (NamedSubqueryInclude)node;
            String name = nsi.getName();
            NamedSubqueryRoot nsr = this.getNamedSubqueryRoot(name);
            if (nsr != null) {
                vars.addAll(this.getDefinitelyProducedBindings(nsr));
                return vars;
            } else {
                ISolutionSetStats stats = this.getSolutionSetStats(name);
                vars.addAll(stats.getAlwaysBound());
            }
            return vars;
        } else if (node instanceof ServiceNode) {
            ServiceNode service = (ServiceNode)node;
            vars.addAll(this.getDefinitelyProducedBindings(service));
            return vars;
        } else {
            if (node instanceof AssignmentNode || node instanceof FilterNode) return vars;
            if (!(node instanceof BindingsClause)) throw new AssertionError((Object)node.toString());
            BindingsClause bc = (BindingsClause)node;
            vars.addAll(bc.getDeclaredVariables());
        }
        return vars;
    }

    public Set<IVariable<?>> getDefinitelyProducedBindingsAndFilterVariables(IGroupNode<? extends IGroupMemberNode> group, Set<IVariable<?>> vars) {
        this.getDefinitelyProducedBindings((IBindingProducerNode)((Object)group), vars, false);
        for (IGroupMemberNode iGroupMemberNode : group) {
            if (!(iGroupMemberNode instanceof FilterNode)) continue;
            this.addAll(vars, iGroupMemberNode);
        }
        return vars;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Set<IVariable<?>> getMaybeProducedBindings(IBindingProducerNode node, Set<IVariable<?>> vars, boolean recursive) {
        if (node instanceof GraphPatternGroup) {
            if (node instanceof JoinGroupNode) {
                this.getMaybeProducedBindings((JoinGroupNode)node, vars, recursive);
                return vars;
            } else {
                if (!(node instanceof UnionNode)) throw new AssertionError((Object)node.toString());
                this.getMaybeProducedBindings((UnionNode)node, vars, recursive);
            }
            return vars;
        } else if (node instanceof StatementPatternNode) {
            StatementPatternNode sp = (StatementPatternNode)node;
            vars.addAll(sp.getProducedBindings());
            return vars;
        } else if (node instanceof ArbitraryLengthPathNode) {
            vars.addAll(((ArbitraryLengthPathNode)node).getMaybeProducedBindings());
            return vars;
        } else if (node instanceof ZeroLengthPathNode) {
            vars.addAll(((ZeroLengthPathNode)node).getProducedBindings());
            return vars;
        } else if (node instanceof SubqueryRoot) {
            SubqueryRoot subquery = (SubqueryRoot)node;
            vars.addAll(this.getMaybeProducedBindings(subquery));
            return vars;
        } else if (node instanceof NamedSubqueryInclude) {
            NamedSubqueryInclude nsi = (NamedSubqueryInclude)node;
            String name = nsi.getName();
            NamedSubqueryRoot nsr = this.getNamedSubqueryRoot(name);
            if (nsr != null) {
                vars.addAll(this.getMaybeProducedBindings(nsr));
                return vars;
            } else {
                ISolutionSetStats stats = this.getSolutionSetStats(name);
                vars.addAll(stats.getUsedVars());
            }
            return vars;
        } else if (node instanceof ServiceNode) {
            ServiceNode service = (ServiceNode)node;
            vars.addAll(this.getMaybeProducedBindings(service));
            return vars;
        } else if (node instanceof AssignmentNode) {
            vars.add(((AssignmentNode)node).getVar());
            return vars;
        } else {
            if (node instanceof FilterNode) return vars;
            if (!(node instanceof BindingsClause)) throw new AssertionError((Object)node.toString());
            BindingsClause bc = (BindingsClause)node;
            vars.addAll(bc.getDeclaredVariables());
        }
        return vars;
    }

    Set<IVariable<?>> getDefinitelyProducedBindings(JoinGroupNode node, Set<IVariable<?>> vars, boolean recursive) {
        for (IGroupMemberNode child : node) {
            if (!(child instanceof IBindingProducerNode)) continue;
            if (child instanceof StatementPatternNode) {
                StatementPatternNode sp = (StatementPatternNode)child;
                if (sp.isOptional()) continue;
                this.getDefinitelyProducedBindings(sp, vars, recursive);
                continue;
            }
            if (child instanceof ArbitraryLengthPathNode) {
                vars.addAll(((ArbitraryLengthPathNode)child).getDefinitelyProducedBindings());
                continue;
            }
            if (child instanceof ZeroLengthPathNode) {
                vars.addAll(((ZeroLengthPathNode)child).getProducedBindings());
                continue;
            }
            if (child instanceof NamedSubqueryInclude || child instanceof SubqueryRoot || child instanceof ServiceNode) {
                vars.addAll(this.getDefinitelyProducedBindings((IBindingProducerNode)((Object)child), new LinkedHashSet(), true));
                continue;
            }
            if (child instanceof GraphPatternGroup) {
                GraphPatternGroup group;
                if (!recursive || (group = (GraphPatternGroup)child).isOptional() || group.isMinus()) continue;
                this.getDefinitelyProducedBindings(group, vars, recursive);
                continue;
            }
            if (child instanceof AssignmentNode || child instanceof FilterNode) continue;
            if (child instanceof BindingsClause) {
                BindingsClause bc = (BindingsClause)child;
                vars.addAll(bc.getDeclaredVariables());
                continue;
            }
            throw new AssertionError((Object)child.toString());
        }
        return vars;
    }

    private Set<IVariable<?>> getMaybeProducedBindings(JoinGroupNode node, Set<IVariable<?>> vars, boolean recursive) {
        this.getDefinitelyProducedBindings(node, vars, false);
        for (AssignmentNode bind : node.getAssignments()) {
            vars.add(bind.getVar());
        }
        if (recursive) {
            for (IGroupMemberNode child : node) {
                IBindingProducerNode tmp;
                if (!(child instanceof IBindingProducerNode) || (tmp = (IBindingProducerNode)((Object)child)) instanceof IJoinNode && ((IJoinNode)tmp).isMinus()) continue;
                this.getMaybeProducedBindings(tmp, vars, recursive);
            }
        }
        return vars;
    }

    private Set<IVariable<?>> getDefinitelyProducedBindings(UnionNode node, Set<IVariable<?>> vars, boolean recursive) {
        if (!recursive || node.isOptional() || node.isMinus()) {
            return vars;
        }
        LinkedHashSet all = new LinkedHashSet();
        LinkedList perChildSets = new LinkedList();
        for (JoinGroupNode joinGroupNode : node) {
            LinkedHashSet childSet = new LinkedHashSet();
            perChildSets.add(childSet);
            this.getDefinitelyProducedBindings(joinGroupNode, childSet, recursive);
            all.addAll(childSet);
        }
        for (Set set : perChildSets) {
            all.retainAll(set);
        }
        vars.addAll(all);
        return vars;
    }

    private Set<IVariable<?>> getMaybeProducedBindings(UnionNode node, Set<IVariable<?>> vars, boolean recursive) {
        if (!recursive) {
            return vars;
        }
        for (JoinGroupNode child : node) {
            this.getMaybeProducedBindings(child, vars, recursive);
        }
        return vars;
    }

    public Set<IVariable<?>> getDefinitelyProducedBindings(QueryBase queryBase) {
        ProjectionNode projection = queryBase.getProjection();
        if (projection == null) {
            return new LinkedHashSet();
        }
        LinkedHashSet definitelyBound = new LinkedHashSet();
        GraphPatternGroup whereClause = queryBase.getWhereClause();
        if (whereClause != null) {
            this.getDefinitelyProducedBindings(whereClause, definitelyBound, true);
            if (log.isInfoEnabled()) {
                log.info((Object)whereClause);
                log.info(definitelyBound);
            }
        }
        boolean isAggregate = StaticAnalysis.isAggregate(queryBase);
        LinkedHashSet tmp = new LinkedHashSet();
        for (AssignmentNode bind : projection) {
            if (bind.getValueExpression() instanceof IConstant) {
                tmp.add(bind.getVar());
                continue;
            }
            if (bind.getVar().equals(bind.getValueExpression())) {
                if (!definitelyBound.contains(bind.getVar())) continue;
                tmp.add(bind.getVar());
                continue;
            }
            if (bind.getValueExpression() instanceof IVariable) {
                if (!definitelyBound.contains(bind.getValueExpression())) continue;
                tmp.add(bind.getVar());
                continue;
            }
            if (isAggregate) continue;
            Set<IVariable<IVariable<?>>> usedVars = this.getSpannedVariables(bind.getValueExpression(), new LinkedHashSet());
            usedVars.removeAll(definitelyBound);
            if (!usedVars.isEmpty()) continue;
            tmp.add(bind.getVar());
        }
        return tmp;
    }

    public Set<IVariable<?>> getMaybeProducedBindings(QueryBase node) {
        LinkedHashSet vars = new LinkedHashSet();
        ProjectionNode projection = node.getProjection();
        if (projection == null) {
            return vars;
        }
        return projection.getProjectionVars(vars);
    }

    public Set<IVariable<?>> getDefinitelyProducedBindings(ServiceNode node) {
        LinkedHashSet vars = new LinkedHashSet();
        GraphPatternGroup<IGroupMemberNode> graphPattern = node.getGraphPattern();
        if (graphPattern != null) {
            this.getDefinitelyProducedBindings(graphPattern, vars, true);
        }
        return vars;
    }

    public Set<IVariable<?>> getMaybeProducedBindings(ServiceNode node) {
        LinkedHashSet vars = new LinkedHashSet();
        GraphPatternGroup<IGroupMemberNode> graphPattern = node.getGraphPattern();
        if (graphPattern != null) {
            this.getMaybeProducedBindings(graphPattern, vars, true);
        }
        return vars;
    }

    public List<FilterNode> getPreFilters(JoinGroupNode group) {
        Set<IVariable<?>> knownBound = this.getDefinitelyIncomingBindings(group, new LinkedHashSet());
        List<FilterNode> filters = this.getBoundFilters(group, knownBound);
        return filters;
    }

    public List<FilterNode> getJoinFilters(JoinGroupNode group) {
        Set<IVariable<?>> knownBound = this.getDefinitelyIncomingBindings(group, new LinkedHashSet());
        this.getDefinitelyProducedBindings(group, knownBound, false);
        List<FilterNode> filters = this.getBoundFilters(group, knownBound);
        filters.removeAll(this.getPreFilters(group));
        return filters;
    }

    public List<FilterNode> getPostFilters(JoinGroupNode group) {
        List<FilterNode> filters = group.getAllFiltersInGroup();
        Set<IVariable<?>> knownBound = this.getDefinitelyIncomingBindings(group, new LinkedHashSet());
        this.getDefinitelyProducedBindings(group, knownBound, false);
        List<FilterNode> preAndJoinFilters = this.getBoundFilters(group, knownBound);
        filters.removeAll(preAndJoinFilters);
        return filters;
    }

    public List<FilterNode> getPruneFilters(JoinGroupNode group) {
        List<FilterNode> filters = group.getAllFiltersInGroup();
        Set<IVariable<?>> maybeBound = this.getDefinitelyIncomingBindings(group, new LinkedHashSet());
        this.getMaybeProducedBindings(group, maybeBound, true);
        List<FilterNode> maybeFilters = this.getBoundFilters(group, maybeBound);
        filters.removeAll(maybeFilters);
        LinkedHashSet<FilterNode> isBoundFilters = new LinkedHashSet<FilterNode>();
        for (FilterNode filter : maybeFilters) {
            IValueExpressionNode node = filter.getValueExpressionNode();
            if (!(node instanceof FunctionNode) || !((FunctionNode)node).isBound()) continue;
            isBoundFilters.add(filter);
        }
        filters.removeAll(isBoundFilters);
        return filters;
    }

    private final List<FilterNode> getBoundFilters(JoinGroupNode group, Set<IVariable<?>> knownBound) {
        LinkedList<FilterNode> filters = new LinkedList<FilterNode>();
        for (IQueryNode node : group) {
            if (!(node instanceof FilterNode)) continue;
            FilterNode filter = (FilterNode)node;
            Set<IVariable<?>> filterVars = filter.getConsumedVars();
            boolean allBound = true;
            for (IVariable<?> v : filterVars) {
                allBound &= knownBound.contains(v);
            }
            if (!allBound) continue;
            filters.add(filter);
        }
        return filters;
    }

    public static boolean requiresMaterialization(IConstraint c) {
        return StaticAnalysis.gatherVarsToMaterialize(c, new LinkedHashSet<IVariable<IV>>()) != INeedsMaterialization.Requirement.NEVER;
    }

    public static INeedsMaterialization.Requirement gatherVarsToMaterialize(BOp c, Set<IVariable<IV>> terms) {
        boolean materialize = false;
        boolean always = false;
        Iterator<BOp> it = BOpUtility.preOrderIterator(c);
        while (it.hasNext()) {
            BOp bop = it.next();
            if (!(bop instanceof INeedsMaterialization)) continue;
            INeedsMaterialization bop2 = (INeedsMaterialization)((Object)bop);
            Set<IVariable<IV>> t = StaticAnalysis.getVarsFromArguments(bop);
            if (t.size() <= 0) continue;
            terms.addAll(t);
            materialize = true;
            if (bop2.getRequirement() != INeedsMaterialization.Requirement.ALWAYS) continue;
            always = true;
        }
        return materialize ? (always ? INeedsMaterialization.Requirement.ALWAYS : INeedsMaterialization.Requirement.SOMETIMES) : INeedsMaterialization.Requirement.NEVER;
    }

    private static Set<IVariable<IV>> getVarsFromArguments(BOp c) {
        int arity = c.arity();
        LinkedHashSet<IVariable<IV>> terms = new LinkedHashSet<IVariable<IV>>(arity);
        for (int i = 0; i < arity; ++i) {
            BOp arg = c.get(i);
            if (arg == null) continue;
            if (arg instanceof IValueExpression && arg instanceof IPassesMaterialization) {
                terms.addAll(StaticAnalysis.getVarsFromArguments(arg));
                continue;
            }
            if (!(arg instanceof IVariable)) continue;
            terms.add((IVariable)arg);
        }
        return terms;
    }

    public Set<IVariable<?>> getJoinVars(NamedSubqueryRoot aNamedSubquery, NamedSubqueryInclude anInclude, Set<IVariable<?>> vars) {
        return this._getJoinVars(aNamedSubquery, anInclude, vars);
    }

    public Set<IVariable<?>> getJoinVars(SubqueryRoot subquery, Set<IVariable<?>> vars) {
        return this._getJoinVars(subquery, subquery, vars);
    }

    private Set<IVariable<?>> _getJoinVars(SubqueryBase aSubquery, IGroupMemberNode theNode, Set<IVariable<?>> vars) {
        Set<IVariable<IVariable<?>>> boundBySubquery = this.getDefinitelyProducedBindings(aSubquery);
        if (log.isInfoEnabled()) {
            log.info(boundBySubquery);
        }
        Set<IVariable<?>> incomingBindings = this.getDefinitelyIncomingBindings(theNode, new LinkedHashSet());
        if (log.isInfoEnabled()) {
            log.info(incomingBindings);
        }
        boundBySubquery.retainAll(incomingBindings);
        if (log.isInfoEnabled()) {
            log.info(boundBySubquery);
        }
        vars.addAll(boundBySubquery);
        if (log.isInfoEnabled()) {
            log.info(vars);
        }
        return vars;
    }

    public Set<IVariable<?>> getJoinVars(ServiceNode serviceNode, Set<IVariable<?>> vars) {
        Set<IVariable<IVariable<?>>> boundByService = this.getDefinitelyProducedBindings(serviceNode);
        Set<IVariable<?>> incomingBindings = this.getDefinitelyIncomingBindings(serviceNode, new LinkedHashSet());
        boundByService.retainAll(incomingBindings);
        vars.addAll(boundByService);
        return vars;
    }

    public Set<IVariable<?>> getJoinVars(BindingsClause bc, ISolutionSetStats stats, Set<IVariable<?>> vars) {
        LinkedHashSet boundByBindingsClause = new LinkedHashSet(stats.getAlwaysBound());
        Set<IVariable<?>> incomingBindings = this.getDefinitelyIncomingBindings(bc, new LinkedHashSet());
        boundByBindingsClause.retainAll(incomingBindings);
        vars.addAll(boundByBindingsClause);
        return vars;
    }

    public Set<IVariable<?>> getJoinVars(NamedSubqueryInclude nsi, String solutionSet, Set<IVariable<?>> vars) {
        String name = solutionSet;
        ISolutionSetStats stats = this.getSolutionSetStats(name);
        LinkedHashSet boundInSolutionSet = new LinkedHashSet(stats.getAlwaysBound());
        Set<IVariable<?>> incomingBindings = this.getDefinitelyIncomingBindings(nsi, new LinkedHashSet());
        boundInSolutionSet.retainAll(incomingBindings);
        vars.addAll(boundInSolutionSet);
        return vars;
    }

    public Set<IVariable<?>> getAfterVars(IGroupMemberNode node, Set<IVariable<?>> vars) {
        if (node.getParent() == null) {
            throw new IllegalArgumentException();
        }
        if (!(node.getParent() instanceof JoinGroupNode)) {
            throw new IllegalArgumentException();
        }
        JoinGroupNode p = node.getParentJoinGroup();
        boolean found = false;
        for (IGroupMemberNode c : p) {
            if (found) {
                this.getSpannedVariables(c, true, vars);
            }
            if (c != node) continue;
            found = true;
        }
        assert (found);
        return vars;
    }

    public Set<IVariable<?>> getProjectedVars(IGroupMemberNode proxy, GraphPatternGroup<?> groupToLift, QueryBase query, Set<IVariable<?>> exogenousVars, Set<IVariable<?>> projectedVars) {
        Set<IVariable<?>> groupVars = this.getSpannedVariables(groupToLift, new LinkedHashSet());
        Set<IVariable<IVariable<?>>> beforeVars = this.getMaybeIncomingBindings(proxy, new LinkedHashSet());
        beforeVars.addAll(exogenousVars);
        beforeVars.retainAll(groupVars);
        Set<IVariable<IVariable<?>>> afterVars = this.getAfterVars(proxy, new LinkedHashSet());
        query.getSelectExprVars(afterVars);
        afterVars.retainAll(groupVars);
        projectedVars.addAll(beforeVars);
        projectedVars.addAll(afterVars);
        return projectedVars;
    }

    public static boolean isAggregate(QueryBase query) {
        return StaticAnalysis.isAggregate(query.getProjection(), query.getGroupBy(), query.getHaving());
    }

    public static boolean isAggregate(ProjectionNode projection, GroupByNode groupBy, HavingNode having) {
        if (groupBy != null && !groupBy.isEmpty()) {
            return true;
        }
        if (having != null && !having.isEmpty()) {
            return true;
        }
        if (projection != null) {
            for (IValueExpressionNode exprNode : projection) {
                IValueExpression<? extends IV> expr = exprNode.getValueExpression();
                if (expr == null) {
                    FunctionNode functionNode;
                    return exprNode instanceof FunctionNode && FunctionRegistry.isAggregate((functionNode = (FunctionNode)exprNode).getFunctionURI());
                }
                if (!StaticAnalysis.isObviousAggregate(expr)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isObviousAggregate(IValueExpression<?> expr) {
        if (expr instanceof IAggregate) {
            return true;
        }
        Iterator<BOp> itr = expr.argIterator();
        while (itr.hasNext()) {
            IValueExpression arg = (IValueExpression)itr.next();
            if (arg == null || !StaticAnalysis.isObviousAggregate(arg)) continue;
            return true;
        }
        return false;
    }
}

