/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.cache;

import com.bigdata.bfs.BigdataFileSystem;
import com.bigdata.bop.engine.QueryEngine;
import com.bigdata.btree.HTreeIndexMetadata;
import com.bigdata.htree.HTree;
import com.bigdata.journal.AbstractJournal;
import com.bigdata.journal.AbstractLocalTransactionManager;
import com.bigdata.journal.BufferMode;
import com.bigdata.journal.ConcurrencyManager;
import com.bigdata.journal.IIndexManager;
import com.bigdata.journal.IJournal;
import com.bigdata.journal.IResourceLockService;
import com.bigdata.journal.IRootBlockView;
import com.bigdata.journal.Options;
import com.bigdata.journal.TemporaryStore;
import com.bigdata.journal.TimestampUtility;
import com.bigdata.rdf.sparql.ast.cache.DescribeCache;
import com.bigdata.rdf.sparql.ast.cache.ICacheConnection;
import com.bigdata.rdf.sparql.ast.cache.IDescribeCache;
import com.bigdata.relation.locator.DefaultResourceLocator;
import com.bigdata.sparse.SparseRowStore;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class CacheConnectionImpl
implements ICacheConnection {
    private final QueryEngine queryEngine;
    private final IJournal cacheStore;
    private boolean enableDescribeCache;
    private static final boolean useMainDatabaseForCache = true;

    private IIndexManager getLocalIndexManager() {
        return this.queryEngine.getIndexManager();
    }

    private ConcurrencyManager getConcurrencyManager() {
        return this.queryEngine.getConcurrencyManager();
    }

    public CacheConnectionImpl(QueryEngine queryEngine) {
        if (queryEngine == null) {
            throw new IllegalArgumentException();
        }
        this.queryEngine = queryEngine;
        Properties properties = new Properties();
        properties.setProperty(Options.BUFFER_MODE, BufferMode.MemStore.name());
        properties.setProperty(Options.INITIAL_EXTENT, "1048576");
        this.cacheStore = (IJournal)queryEngine.getIndexManager();
        this.enableDescribeCache = false;
    }

    @Override
    public void init() {
    }

    @Override
    public void close() {
    }

    @Override
    public void destroyCaches(String namespace, long timestamp) {
        IDescribeCache describeCache = this.getDescribeCache(namespace, timestamp);
        if (describeCache != null) {
            describeCache.destroy();
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IDescribeCache getDescribeCache(String namespace, long timestamp) {
        HTree htree;
        if (!this.enableDescribeCache) {
            return null;
        }
        if (namespace == null) {
            throw new IllegalArgumentException();
        }
        CacheConnectionImpl cacheConnectionImpl = this;
        synchronized (cacheConnectionImpl) {
            String name = namespace + ".describeCache";
            htree = (HTree)this.cacheStore.getUnisolatedIndex(name);
            if (htree == null) {
                if (TimestampUtility.isReadOnly(timestamp)) {
                    return null;
                }
                HTreeIndexMetadata metadata = new HTreeIndexMetadata(name, UUID.randomUUID());
                metadata.setRawRecords(true);
                metadata.setMaxRecLen(0);
                this.cacheStore.registerIndex(metadata);
            }
            htree = (HTree)this.cacheStore.getUnisolatedIndex(name);
        }
        return new DescribeCache(htree);
    }

    private class InnerCacheJournal
    extends AbstractJournal {
        protected InnerCacheJournal(Properties properties) {
            super(properties);
        }

        public String toString() {
            IRootBlockView rootBlock = this.getRootBlockView();
            return this.getClass().getName() + "{file=" + this.getFile() + ", open=" + this.isOpen() + (rootBlock != null ? ", uuid=" + this.getRootBlockView().getUUID() : "") + "}";
        }

        @Override
        public AbstractLocalTransactionManager getLocalTransactionManager() {
            return (AbstractLocalTransactionManager)CacheConnectionImpl.this.getConcurrencyManager().getTransactionManager();
        }

        @Override
        public SparseRowStore getGlobalRowStore() {
            return CacheConnectionImpl.this.getLocalIndexManager().getGlobalRowStore();
        }

        @Override
        public SparseRowStore getGlobalRowStore(long timestamp) {
            return CacheConnectionImpl.this.getLocalIndexManager().getGlobalRowStore(timestamp);
        }

        @Override
        public BigdataFileSystem getGlobalFileSystem() {
            return CacheConnectionImpl.this.getLocalIndexManager().getGlobalFileSystem();
        }

        @Override
        public DefaultResourceLocator getResourceLocator() {
            return (DefaultResourceLocator)CacheConnectionImpl.this.getLocalIndexManager().getResourceLocator();
        }

        @Override
        public ExecutorService getExecutorService() {
            return CacheConnectionImpl.this.getLocalIndexManager().getExecutorService();
        }

        @Override
        public IResourceLockService getResourceLockService() {
            return CacheConnectionImpl.this.getLocalIndexManager().getResourceLockService();
        }

        @Override
        public TemporaryStore getTempStore() {
            return CacheConnectionImpl.this.getLocalIndexManager().getTempStore();
        }

        @Override
        public ScheduledFuture<?> addScheduledTask(Runnable task, long initialDelay, long delay, TimeUnit unit) {
            return CacheConnectionImpl.this.getLocalIndexManager().addScheduledTask(task, initialDelay, delay, unit);
        }

        @Override
        public boolean getCollectPlatformStatistics() {
            return CacheConnectionImpl.this.getLocalIndexManager().getCollectPlatformStatistics();
        }

        @Override
        public boolean getCollectQueueStatistics() {
            return CacheConnectionImpl.this.getLocalIndexManager().getCollectQueueStatistics();
        }

        @Override
        public int getHttpdPort() {
            return CacheConnectionImpl.this.getLocalIndexManager().getHttpdPort();
        }

        @Override
        public boolean isGroupCommit() {
            return CacheConnectionImpl.this.getLocalIndexManager().isGroupCommit();
        }
    }
}

