/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.cache;

import com.bigdata.rdf.changesets.ChangeAction;
import com.bigdata.rdf.changesets.IChangeLog;
import com.bigdata.rdf.changesets.IChangeRecord;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.sparql.ast.cache.CacheConnectionFactory;
import com.bigdata.rdf.sparql.ast.cache.ICacheConnection;
import com.bigdata.rdf.sparql.ast.cache.IDescribeCache;
import com.bigdata.rdf.sparql.ast.service.BigdataNativeServiceOptions;
import com.bigdata.rdf.sparql.ast.service.CustomServiceFactory;
import com.bigdata.rdf.sparql.ast.service.IServiceOptions;
import com.bigdata.rdf.sparql.ast.service.ServiceCall;
import com.bigdata.rdf.sparql.ast.service.ServiceCallCreateParams;
import com.bigdata.rdf.spo.ISPO;
import com.bigdata.rdf.store.AbstractTripleStore;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class DescribeServiceFactory
implements CustomServiceFactory {
    private static final transient Logger log = Logger.getLogger(DescribeServiceFactory.class);
    private final IServiceOptions serviceOptions = new BigdataNativeServiceOptions();

    @Override
    public IServiceOptions getServiceOptions() {
        return this.serviceOptions;
    }

    @Override
    public ServiceCall<?> create(ServiceCallCreateParams params) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void startConnection(BigdataSail.BigdataSailConnection conn) {
        ICacheConnection cacheConn = CacheConnectionFactory.getCacheConnection(conn.getBigdataSail().getQueryEngine());
        if (cacheConn == null) {
            return;
        }
        AbstractTripleStore tripleStore = conn.getTripleStore();
        IDescribeCache describeCache = cacheConn.getDescribeCache(tripleStore.getNamespace(), tripleStore.getTimestamp());
        if (describeCache == null) {
            return;
        }
        conn.addChangeLog(new DescribeCacheChangeLogListener(describeCache));
    }

    private static class DescribeCacheChangeLogListener
    implements IChangeLog {
        private static final int threshold = 10000;
        private final IDescribeCache cache;
        private Set<IV<?, ?>> ivs;
        private int size = 0;

        DescribeCacheChangeLogListener(IDescribeCache cache) {
            if (cache == null) {
                throw new IllegalArgumentException();
            }
            this.cache = cache;
        }

        @Override
        public void changeEvent(IChangeRecord record) {
            if (record.getChangeAction() == ChangeAction.UPDATED) {
                return;
            }
            if (this.ivs == null) {
                this.ivs = new LinkedHashSet();
                this.size = 0;
            }
            ISPO spo = record.getStatement();
            if (log.isTraceEnabled()) {
                log.trace((Object)("Invalidation notice: spo=" + spo));
            }
            if (this.ivs.add(spo.s())) {
                ++this.size;
            }
            if (this.ivs.add(spo.o())) {
                ++this.size;
            }
            if (this.size > 10000) {
                this.flush();
            }
        }

        @Override
        public void transactionBegin() {
        }

        @Override
        public void transactionPrepare() {
            this.flush();
        }

        @Override
        public void transactionCommited(long commitTime) {
        }

        @Override
        public void transactionAborted() {
            this.reset();
        }

        private void flush() {
            if (this.ivs != null) {
                this.cache.invalidate(this.ivs);
                this.reset();
            }
        }

        private void reset() {
            this.ivs = null;
            this.size = 0;
        }
    }
}

