/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.eval;

import com.bigdata.bop.BOpContextBase;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.IdFactory;
import com.bigdata.bop.NamedSolutionSetRefUtility;
import com.bigdata.bop.SimpleIdFactory;
import com.bigdata.bop.engine.QueryEngine;
import com.bigdata.bop.fed.QueryEngineFactory;
import com.bigdata.journal.IBTreeManager;
import com.bigdata.journal.TimestampUtility;
import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.sparql.ast.ASTContainer;
import com.bigdata.rdf.sparql.ast.DescribeModeEnum;
import com.bigdata.rdf.sparql.ast.EmptySolutionSetStats;
import com.bigdata.rdf.sparql.ast.ISolutionSetStats;
import com.bigdata.rdf.sparql.ast.ProjectionNode;
import com.bigdata.rdf.sparql.ast.QueryHints;
import com.bigdata.rdf.sparql.ast.StaticAnalysis;
import com.bigdata.rdf.sparql.ast.cache.CacheConnectionFactory;
import com.bigdata.rdf.sparql.ast.cache.ICacheConnection;
import com.bigdata.rdf.sparql.ast.cache.IDescribeCache;
import com.bigdata.rdf.sparql.ast.eval.IEvaluationContext;
import com.bigdata.rdf.sparql.ast.optimizers.ASTBottomUpOptimizer;
import com.bigdata.rdf.sparql.ast.optimizers.ASTOptimizerList;
import com.bigdata.rdf.sparql.ast.optimizers.IASTOptimizer;
import com.bigdata.rdf.sparql.ast.ssets.ISolutionSetManager;
import com.bigdata.rdf.sparql.ast.ssets.SolutionSetManager;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.service.IBigdataFederation;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.log4j.Logger;

public class AST2BOpContext
implements IdFactory,
IEvaluationContext {
    private static final Logger log = Logger.getLogger(AST2BOpContext.class);
    public final ASTContainer astContainer;
    private final IdFactory idFactory;
    protected final AbstractTripleStore db;
    public final QueryEngine queryEngine;
    public final ISolutionSetManager solutionSetManager;
    public final IDescribeCache describeCache;
    public final Properties queryHints;
    public final UUID queryId;
    public final ASTOptimizerList optimizers;
    final BOpContextBase context;
    public boolean nativeDistinctSPO = false;
    public long nativeDistinctSPOThreshold = 102400L;
    public boolean nativeDistinctSolutions = false;
    public boolean nativeHashJoins = false;
    public boolean mergeJoin = true;
    public int maxParallelForSolutionSetHashJoin = 1;
    boolean materializeProjectionInQuery = false;
    public boolean remoteAPs = false;
    public int accessPathSampleLimit = 100;
    public boolean accessPathScanAndFilter = true;
    private int varIdFactory = 0;
    private ISolutionSetStats sss = null;
    StaticAnalysis sa = null;
    private final AtomicReference<Map<Object, Object>> queryAttributes = new AtomicReference();

    @Override
    public ISolutionSetStats getSolutionSetStats() {
        if (this.sss == null) {
            return EmptySolutionSetStats.INSTANCE;
        }
        return this.sss;
    }

    public void setSolutionSetStats(ISolutionSetStats stats) {
        if (stats == null) {
            throw new IllegalArgumentException();
        }
        if (this.sss != null) {
            throw new IllegalStateException();
        }
        this.sss = stats;
    }

    public void addQueryAttribute(Object key, Object val) {
        if (this.queryAttributes.get() == null) {
            this.queryAttributes.compareAndSet(null, new LinkedHashMap());
        }
        this.queryAttributes.get().put(key, val);
    }

    public Map<Object, Object> getQueryAttributes() {
        Map<Object, Object> tmp = this.queryAttributes.get();
        if (tmp == null) {
            return null;
        }
        return Collections.unmodifiableMap(tmp);
    }

    public AST2BOpContext(ASTContainer astContainer, AbstractTripleStore db) {
        this(astContainer, db, new SimpleIdFactory());
    }

    AST2BOpContext(ASTContainer astContainer, AbstractTripleStore db, IdFactory idFactory) {
        UUID queryId;
        if (astContainer == null) {
            throw new IllegalArgumentException();
        }
        if (db == null) {
            throw new IllegalArgumentException();
        }
        if (idFactory == null) {
            throw new IllegalArgumentException();
        }
        this.astContainer = astContainer;
        this.db = db;
        this.optimizers = AST2BOpContext.newOptimizerList(db);
        this.idFactory = idFactory;
        this.queryEngine = QueryEngineFactory.getQueryController(db.getIndexManager());
        this.queryHints = astContainer.getQueryHints();
        String queryIdStr = this.queryHints == null ? null : this.queryHints.getProperty("queryId");
        this.queryId = queryId = queryIdStr == null ? UUID.randomUUID() : UUID.fromString(queryIdStr);
        this.solutionSetManager = this.queryEngine.getIndexManager() instanceof IBTreeManager ? new SolutionSetManager((IBTreeManager)this.queryEngine.getIndexManager(), db.getNamespace(), db.getTimestamp()) : null;
        ICacheConnection cacheConn = CacheConnectionFactory.getCacheConnection(this.queryEngine);
        if (cacheConn != null) {
            String namespace = db.getNamespace();
            long timestamp = db.getTimestamp();
            this.describeCache = cacheConn.getDescribeCache(namespace, timestamp);
        } else {
            this.describeCache = null;
        }
        this.context = new BOpContextBase(this.queryEngine);
    }

    private static ASTOptimizerList newOptimizerList(AbstractTripleStore db) {
        ASTOptimizerList optimizers;
        try {
            Class<?> cls = Class.forName(QueryHints.DEFAULT_AST_OPTIMIZER_CLASS);
            if (!ASTOptimizerList.class.isAssignableFrom(cls)) {
                throw new RuntimeException(cls.getCanonicalName() + " does not extend " + ASTOptimizerList.class.getCanonicalName());
            }
            optimizers = (ASTOptimizerList)cls.newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
        if (!db.isBottomUpEvaluation()) {
            Iterator itr = optimizers.iterator();
            while (itr.hasNext()) {
                IASTOptimizer opt = (IASTOptimizer)itr.next();
                if (!(opt instanceof ASTBottomUpOptimizer)) continue;
                itr.remove();
                break;
            }
        }
        return optimizers;
    }

    @Override
    public long getTimestamp() {
        return this.db.getTimestamp();
    }

    @Override
    public int nextId() {
        return this.idFactory.nextId();
    }

    @Override
    public boolean isCluster() {
        return this.db.getIndexManager() instanceof IBigdataFederation;
    }

    @Override
    public boolean isQuads() {
        return this.db.isQuads();
    }

    @Override
    public boolean isSIDs() {
        return this.db.isStatementIdentifiers();
    }

    @Override
    public boolean isTriples() {
        return !this.db.isQuads() && !this.db.isStatementIdentifiers();
    }

    @Override
    public String getNamespace() {
        return this.db.getNamespace();
    }

    @Override
    public String getSPONamespace() {
        return this.db.getSPORelation().getNamespace();
    }

    @Override
    public String getLexiconNamespace() {
        return this.db.getLexiconRelation().getNamespace();
    }

    public final String createVar(String prefix) {
        return prefix + this.varIdFactory++;
    }

    @Override
    public long getLexiconReadTimestamp() {
        long timestamp = this.db.getTimestamp();
        if (TimestampUtility.isReadWriteTx(timestamp)) {
            timestamp = 0L;
        }
        return timestamp;
    }

    @Override
    public AbstractTripleStore getAbstractTripleStore() {
        return this.db;
    }

    @Override
    public ISolutionSetManager getSolutionSetManager() {
        return this.solutionSetManager;
    }

    @Override
    public IDescribeCache getDescribeCache() {
        return this.describeCache;
    }

    public DescribeModeEnum getDescribeMode(ProjectionNode projection) {
        DescribeModeEnum describeMode = projection.getDescribeMode();
        if (describeMode != null) {
            return describeMode;
        }
        String describeDefaultStr = this.db.getProperties().getProperty(BigdataSail.Options.DESCRIBE_MODE);
        describeMode = describeDefaultStr != null ? DescribeModeEnum.valueOf(describeDefaultStr) : QueryHints.DEFAULT_DESCRIBE_MODE;
        return describeMode;
    }

    public int getDescribeIterationLimit(ProjectionNode projection) {
        Integer limit = projection.getDescribeIterationLimit();
        if (limit != null) {
            return limit;
        }
        String limitStr = this.db.getProperties().getProperty(BigdataSail.Options.DESCRIBE_ITERATION_LIMIT);
        limit = limitStr != null ? Integer.valueOf(limitStr) : Integer.valueOf(5);
        return limit;
    }

    public int getDescribeStatementLimit(ProjectionNode projection) {
        Integer limit = projection.getDescribeStatementLimit();
        if (limit != null) {
            return limit;
        }
        String limitStr = this.db.getProperties().getProperty(BigdataSail.Options.DESCRIBE_STATEMENT_LIMIT);
        limit = limitStr != null ? Integer.valueOf(limitStr) : Integer.valueOf(5000);
        return limit;
    }

    @Override
    public ISolutionSetStats getSolutionSetStats(String localName) {
        IVariable[] joinVars = IVariable.EMPTY;
        return NamedSolutionSetRefUtility.getSolutionSetStats(this.solutionSetManager, (IBTreeManager)this.queryEngine.getIndexManager(), this.getNamespace(), this.getTimestamp(), localName, joinVars);
    }
}

