/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.eval;

import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpBase;
import com.bigdata.bop.BOpEvaluationContext;
import com.bigdata.bop.CoreBaseBOp;
import com.bigdata.bop.IConstraint;
import com.bigdata.bop.IValueExpression;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.NV;
import com.bigdata.bop.PipelineOp;
import com.bigdata.bop.Var;
import com.bigdata.bop.ap.Predicate;
import com.bigdata.bop.bset.ConditionalRoutingOp;
import com.bigdata.bop.join.PipelineJoin;
import com.bigdata.bop.rdf.join.ChunkedMaterializationOp;
import com.bigdata.bop.rdf.join.InlineMaterializeOp;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.constraints.INeedsMaterialization;
import com.bigdata.rdf.internal.constraints.IsInlineBOp;
import com.bigdata.rdf.internal.constraints.IsMaterializedBOp;
import com.bigdata.rdf.internal.constraints.NeedsMaterializationBOp;
import com.bigdata.rdf.internal.constraints.SPARQLConstraint;
import com.bigdata.rdf.internal.constraints.TryBeforeMaterializationConstraint;
import com.bigdata.rdf.lexicon.LexPredicate;
import com.bigdata.rdf.sparql.ast.FilterNode;
import com.bigdata.rdf.sparql.ast.IJoinNode;
import com.bigdata.rdf.sparql.ast.StaticAnalysis;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpBase;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpContext;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.log4j.Logger;

public class AST2BOpFilters
extends AST2BOpBase {
    private static final Logger log = Logger.getLogger(AST2BOpFilters.class);

    protected AST2BOpFilters() {
    }

    protected static PipelineOp addMaterializationSteps1(PipelineOp left, int rightId, IValueExpression<IV> ve, Set<IVariable<IV>> vars, Properties queryHints, AST2BOpContext ctx) {
        SPARQLConstraint c2 = new SPARQLConstraint(new NeedsMaterializationBOp(ve));
        left = AST2BOpFilters.applyQueryHints((PipelineOp)new ConditionalRoutingOp(AST2BOpFilters.leftOrEmpty(left), new NV(BOp.Annotations.BOP_ID, ctx.nextId()), new NV(ConditionalRoutingOp.Annotations.CONDITION, c2), new NV(PipelineOp.Annotations.ALT_SINK_REF, rightId)), queryHints, ctx);
        return AST2BOpFilters.addMaterializationSteps2(left, rightId, vars, queryHints, ctx);
    }

    protected static PipelineOp addMaterializationSteps2(PipelineOp left, int rightId, Set<IVariable<IV>> vars, Properties queryHints, AST2BOpContext ctx) {
        int nvars = vars.size();
        if (nvars == 0) {
            return left;
        }
        if (nvars >= 1) {
            return AST2BOpFilters.addChunkedMaterializationStep(left, vars, false, null, queryHints, ctx);
        }
        long timestamp = ctx.getLexiconReadTimestamp();
        String ns = ctx.getLexiconNamespace();
        Iterator<IVariable<IV>> it = vars.iterator();
        int firstId = ctx.nextId();
        while (it.hasNext()) {
            IVariable<IV> v = it.next();
            int condId1 = firstId;
            int condId2 = ctx.nextId();
            int inlineMaterializeId = ctx.nextId();
            int lexJoinId = ctx.nextId();
            int endId = !it.hasNext() ? rightId : (firstId = ctx.nextId());
            SPARQLConstraint c1 = new SPARQLConstraint(new IsMaterializedBOp(v, false));
            PipelineOp condOp1 = AST2BOpFilters.applyQueryHints((PipelineOp)new ConditionalRoutingOp(AST2BOpFilters.leftOrEmpty(left), new NV(BOp.Annotations.BOP_ID, condId1), new NV(ConditionalRoutingOp.Annotations.CONDITION, c1), new NV(PipelineOp.Annotations.SINK_REF, condId2), new NV(PipelineOp.Annotations.ALT_SINK_REF, endId)), queryHints, ctx);
            if (log.isDebugEnabled()) {
                log.debug((Object)("adding 1st conditional routing op: " + condOp1));
            }
            SPARQLConstraint c2 = new SPARQLConstraint(new IsInlineBOp(v, true));
            PipelineOp condOp2 = AST2BOpFilters.applyQueryHints((PipelineOp)new ConditionalRoutingOp(AST2BOpFilters.leftOrEmpty(condOp1), new NV(BOp.Annotations.BOP_ID, condId2), new NV(ConditionalRoutingOp.Annotations.CONDITION, c2), new NV(PipelineOp.Annotations.SINK_REF, inlineMaterializeId), new NV(PipelineOp.Annotations.ALT_SINK_REF, lexJoinId)), queryHints, ctx);
            if (log.isDebugEnabled()) {
                log.debug((Object)("adding 2nd conditional routing op: " + condOp2));
            }
            Var anonvar = Var.var("--" + v.getName() + "-" + ctx.nextId());
            LexPredicate lexPred = LexPredicate.reverseInstance(ns, timestamp, anonvar, v);
            if (log.isDebugEnabled()) {
                log.debug((Object)("lex pred: " + lexPred));
            }
            PipelineOp inlineMaterializeOp = AST2BOpFilters.applyQueryHints(new InlineMaterializeOp(AST2BOpFilters.leftOrEmpty(condOp2), new NV(BOp.Annotations.BOP_ID, inlineMaterializeId), new NV(InlineMaterializeOp.Annotations.PREDICATE, ((Predicate)lexPred).clone()), new NV(PipelineOp.Annotations.SINK_REF, endId)), queryHints, ctx);
            if (log.isDebugEnabled()) {
                log.debug((Object)("adding inline materialization op: " + inlineMaterializeOp));
            }
            LinkedList<NV> anns = new LinkedList<NV>();
            CoreBaseBOp pred = ((Predicate)lexPred).clone();
            anns.add(new NV(BOp.Annotations.BOP_ID, lexJoinId));
            anns.add(new NV(PipelineOp.Annotations.SINK_REF, endId));
            if (ctx.isCluster() && !ctx.remoteAPs) {
                anns.add(new NV(Predicate.Annotations.EVALUATION_CONTEXT, (Object)BOpEvaluationContext.SHARDED));
                pred = (Predicate)((BOpBase)pred).setProperty(Predicate.Annotations.REMOTE_ACCESS_PATH, false);
            }
            anns.add(new NV(PipelineJoin.Annotations.PREDICATE, pred));
            PipelineOp lexJoinOp = AST2BOpFilters.applyQueryHints(new PipelineJoin(AST2BOpFilters.leftOrEmpty(inlineMaterializeOp), anns.toArray(new NV[anns.size()])), queryHints, ctx);
            if (log.isDebugEnabled()) {
                log.debug((Object)("adding lex join op: " + lexJoinOp));
            }
            left = lexJoinOp;
        }
        return left;
    }

    protected static PipelineOp addChunkedMaterializationStep(PipelineOp left, Set<IVariable<IV>> vars, boolean materializeInlineIvs, Long cutoffLimit, Properties queryHints, AST2BOpContext ctx) {
        int nvars = vars.size();
        if (nvars == 0) {
            return left;
        }
        long timestamp = ctx.getLexiconReadTimestamp();
        String ns = ctx.getLexiconNamespace();
        boolean reorderSolutions = cutoffLimit == null;
        int maxParallel = cutoffLimit != null ? 1 : 5;
        return AST2BOpFilters.applyQueryHints((PipelineOp)new ChunkedMaterializationOp(AST2BOpFilters.leftOrEmpty(left), new NV(ChunkedMaterializationOp.Annotations.VARS, vars.toArray(new IVariable[nvars])), new NV(ChunkedMaterializationOp.Annotations.RELATION_NAME, new String[]{ns}), new NV(ChunkedMaterializationOp.Annotations.TIMESTAMP, timestamp), new NV(ChunkedMaterializationOp.Annotations.MATERIALIZE_INLINE_IVS, materializeInlineIvs), new NV(PipelineOp.Annotations.SHARED_STATE, !ctx.isCluster()), new NV(PipelineOp.Annotations.REORDER_SOLUTIONS, reorderSolutions), new NV(PipelineOp.Annotations.MAX_PARALLEL, maxParallel), new NV(BOp.Annotations.BOP_ID, ctx.nextId())), queryHints, ctx);
    }

    protected static PipelineOp addMaterializationSteps3(PipelineOp left, Set<IVariable<?>> doneSet, Map<IConstraint, Set<IVariable<IV>>> needsMaterialization, Properties queryHints, AST2BOpContext ctx) {
        if (needsMaterialization.isEmpty()) {
            return left;
        }
        Set<IVariable<?>> alreadyMaterialized = doneSet;
        for (Map.Entry<IConstraint, Set<IVariable<IV>>> e : needsMaterialization.entrySet()) {
            IConstraint c = e.getKey();
            Set<IVariable<IV>> terms = e.getValue();
            terms.removeAll(alreadyMaterialized);
            if (c instanceof INeedsMaterialization && ((INeedsMaterialization)((Object)c)).getRequirement() == INeedsMaterialization.Requirement.ALWAYS) {
                alreadyMaterialized.addAll(terms);
            }
            int condId = ctx.nextId();
            if (!terms.isEmpty()) {
                IValueExpression ve = (IValueExpression)c.get(0);
                left = AST2BOpFilters.addMaterializationSteps1(left, condId, ve, terms, queryHints, ctx);
            }
            left = AST2BOpFilters.applyQueryHints((PipelineOp)new ConditionalRoutingOp(AST2BOpFilters.leftOrEmpty(left), new NV(BOp.Annotations.BOP_ID, condId), new NV(ConditionalRoutingOp.Annotations.CONDITION, c)), queryHints, ctx);
        }
        return left;
    }

    protected static PipelineOp addNonConditionalMaterializationSteps(PipelineOp left, Set<IVariable<?>> doneSet, Map<IConstraint, Set<IVariable<IV>>> needsMaterialization, Long cutoffLimit, Properties queryHints, AST2BOpContext ctx) {
        if (needsMaterialization.isEmpty()) {
            return left;
        }
        LinkedHashSet<IVariable<IV>> matvars = new LinkedHashSet<IVariable<IV>>();
        for (Map.Entry<IConstraint, Set<IVariable<IV>>> e : needsMaterialization.entrySet()) {
            matvars.addAll((Collection)e.getValue());
        }
        if (!matvars.isEmpty()) {
            left = AST2BOpFilters.addChunkedMaterializationStep(left, matvars, true, cutoffLimit, queryHints, ctx);
            doneSet.addAll(matvars);
        }
        for (IConstraint c : needsMaterialization.keySet()) {
            left = AST2BOpFilters.applyQueryHints((PipelineOp)new ConditionalRoutingOp(AST2BOpFilters.leftOrEmpty(left), new NV(BOp.Annotations.BOP_ID, ctx.nextId()), new NV(PipelineOp.Annotations.MAX_PARALLEL, 1), new NV(PipelineJoin.Annotations.REORDER_SOLUTIONS, Boolean.FALSE), new NV(ConditionalRoutingOp.Annotations.CONDITION, c)), queryHints, ctx);
        }
        return left;
    }

    protected static IConstraint[] getJoinConstraints(Collection<IConstraint> constraints, Map<IConstraint, Set<IVariable<IV>>> needsMaterialization) {
        return AST2BOpFilters.getJoinConstraints2(constraints, needsMaterialization, true);
    }

    protected static IConstraint[] getJoinConstraints2(Collection<IConstraint> constraints, Map<IConstraint, Set<IVariable<IV>>> needsMaterialization, boolean conditionalRouting) {
        if (constraints == null || constraints.isEmpty()) {
            return null;
        }
        LinkedList<IConstraint> joinConstraints = new LinkedList<IConstraint>();
        joinConstraints.addAll(constraints);
        LinkedList<IConstraint> tryBeforeMaterialization = new LinkedList<IConstraint>();
        Iterator it = joinConstraints.iterator();
        while (it.hasNext()) {
            LinkedHashSet<IVariable<IV>> terms;
            IConstraint c = (IConstraint)it.next();
            INeedsMaterialization.Requirement req = StaticAnalysis.gatherVarsToMaterialize(c, terms = new LinkedHashSet<IVariable<IV>>());
            if (req == INeedsMaterialization.Requirement.NEVER) continue;
            it.remove();
            if (req == INeedsMaterialization.Requirement.SOMETIMES && conditionalRouting) {
                tryBeforeMaterialization.add(c);
            }
            needsMaterialization.put(c, terms);
        }
        for (IConstraint c : tryBeforeMaterialization) {
            c = (IConstraint)c.clone();
            joinConstraints.add(new TryBeforeMaterializationConstraint(c));
        }
        return joinConstraints.toArray(new IConstraint[joinConstraints.size()]);
    }

    protected static List<IConstraint> getJoinConstraints(IJoinNode joinNode) {
        List<FilterNode> joinFilters = joinNode.getAttachedJoinFilters();
        if (joinFilters == null || joinFilters.isEmpty()) {
            return null;
        }
        LinkedList<IConstraint> constraints = new LinkedList<IConstraint>();
        for (FilterNode filter : joinFilters) {
            constraints.add(new SPARQLConstraint(filter.getValueExpression()));
        }
        return constraints;
    }
}

