/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.eval;

import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpContext;
import com.bigdata.bop.Constant;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.PipelineOp;
import com.bigdata.bop.Var;
import com.bigdata.bop.bindingSet.ListBindingSet;
import com.bigdata.bop.engine.AbstractRunningQuery;
import com.bigdata.bop.engine.IRunningQuery;
import com.bigdata.bop.rdf.join.ChunkedMaterializationIterator;
import com.bigdata.journal.TimestampUtility;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.model.BigdataBNode;
import com.bigdata.rdf.model.BigdataStatement;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.sail.Bigdata2Sesame2BindingSetIterator;
import com.bigdata.rdf.sail.BigdataSailRepositoryConnection;
import com.bigdata.rdf.sail.BigdataValueReplacer;
import com.bigdata.rdf.sail.RunningQueryCloseableIterator;
import com.bigdata.rdf.sparql.ast.ASTContainer;
import com.bigdata.rdf.sparql.ast.BindingsClause;
import com.bigdata.rdf.sparql.ast.DatasetNode;
import com.bigdata.rdf.sparql.ast.DescribeModeEnum;
import com.bigdata.rdf.sparql.ast.GroupNodeBase;
import com.bigdata.rdf.sparql.ast.IDataSetNode;
import com.bigdata.rdf.sparql.ast.IGroupMemberNode;
import com.bigdata.rdf.sparql.ast.JoinGroupNode;
import com.bigdata.rdf.sparql.ast.QueryRoot;
import com.bigdata.rdf.sparql.ast.QueryType;
import com.bigdata.rdf.sparql.ast.SubqueryRoot;
import com.bigdata.rdf.sparql.ast.UnionNode;
import com.bigdata.rdf.sparql.ast.Update;
import com.bigdata.rdf.sparql.ast.UpdateRoot;
import com.bigdata.rdf.sparql.ast.cache.DescribeBindingsCollector;
import com.bigdata.rdf.sparql.ast.cache.DescribeCacheUpdater;
import com.bigdata.rdf.sparql.ast.cache.IDescribeCache;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpContext;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpUpdate;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpUpdateContext;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpUtility;
import com.bigdata.rdf.sparql.ast.eval.CBD;
import com.bigdata.rdf.sparql.ast.eval.IEvaluationContext;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.store.BigdataBindingSetResolverator;
import com.bigdata.striterator.ChunkedWrappedIterator;
import com.bigdata.striterator.Dechunkerator;
import cutthecrap.utils.striterators.ICloseableIterator;
import info.aduna.iteration.CloseableIteration;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;
import org.apache.log4j.MDC;
import org.openrdf.query.Binding;
import org.openrdf.query.BindingSet;
import org.openrdf.query.Dataset;
import org.openrdf.query.GraphQueryResult;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.query.UpdateExecutionException;
import org.openrdf.query.algebra.evaluation.QueryBindingSet;
import org.openrdf.query.impl.GraphQueryResultImpl;
import org.openrdf.query.impl.TupleQueryResultImpl;

public class ASTEvalHelper {
    private static final Logger log = Logger.getLogger(ASTEvalHelper.class);

    static IBindingSet batchResolveIVs(AbstractTripleStore store, BindingSet bs) throws QueryEvaluationException {
        if (bs == null || bs.size() == 0) {
            return new ListBindingSet();
        }
        Object[] tmp = new BigdataValueReplacer(store).replaceValues(null, new BindingSet[]{bs});
        BindingSet[] a = (BindingSet[])tmp[1];
        BindingSet tmp2 = a[0];
        return ASTEvalHelper.toBindingSet(tmp2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean evaluateBooleanQuery(AbstractTripleStore store, ASTContainer astContainer, BindingSet bs) throws QueryEvaluationException {
        AST2BOpContext context = new AST2BOpContext(astContainer, store);
        astContainer.clearOptimizedAST();
        IBindingSet[] bindingSets = ASTEvalHelper.mergeBindingSets(astContainer, ASTEvalHelper.batchResolveIVs(store, bs));
        AST2BOpUtility.convert(context, bindingSets);
        QueryRoot optimizedQuery = astContainer.getOptimizedAST();
        boolean materializeProjectionInQuery = context.materializeProjectionInQuery && !optimizedQuery.hasSlice();
        try (CloseableIteration<BindingSet, QueryEvaluationException> itr = null;){
            itr = ASTEvalHelper.evaluateQuery(astContainer, context, bindingSets, materializeProjectionInQuery, new IVariable[0]);
            boolean bl = itr.hasNext();
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TupleQueryResult evaluateTupleQuery(AbstractTripleStore store, ASTContainer astContainer, QueryBindingSet bs) throws QueryEvaluationException {
        AST2BOpContext context = new AST2BOpContext(astContainer, store);
        astContainer.clearOptimizedAST();
        IBindingSet[] bindingSets = ASTEvalHelper.mergeBindingSets(astContainer, ASTEvalHelper.batchResolveIVs(store, (BindingSet)bs));
        AST2BOpUtility.convert(context, bindingSets);
        IVariable[] projected = astContainer.getOptimizedAST().getProjection().getProjectionVars();
        LinkedList<String> projectedSet = new LinkedList<String>();
        for (IVariable var : projected) {
            projectedSet.add(var.getName());
        }
        QueryRoot optimizedQuery = astContainer.getOptimizedAST();
        boolean materializeProjectionInQuery = context.materializeProjectionInQuery && !optimizedQuery.hasSlice();
        CloseableIteration<BindingSet, QueryEvaluationException> itr = ASTEvalHelper.evaluateQuery(astContainer, context, bindingSets, materializeProjectionInQuery, projected);
        TupleQueryResultImpl r = null;
        try {
            TupleQueryResultImpl tupleQueryResultImpl = r = new TupleQueryResultImpl(projectedSet, itr);
            return tupleQueryResultImpl;
        }
        finally {
            if (r == null) {
                itr.close();
            }
        }
    }

    public static ICloseableIterator<IBindingSet[]> evaluateTupleQuery2(AbstractTripleStore store, ASTContainer astContainer, QueryBindingSet bs, boolean materialize) throws QueryEvaluationException {
        LinkedList<String> projectedSet;
        boolean materializeProjectionInQuery;
        AST2BOpContext context = new AST2BOpContext(astContainer, store);
        astContainer.clearOptimizedAST();
        IBindingSet[] bindingSets = ASTEvalHelper.mergeBindingSets(astContainer, ASTEvalHelper.batchResolveIVs(store, (BindingSet)bs));
        AST2BOpUtility.convert(context, bindingSets);
        QueryRoot optimizedQuery = astContainer.getOptimizedAST();
        boolean bl = materializeProjectionInQuery = materialize && context.materializeProjectionInQuery && !optimizedQuery.hasSlice();
        if (materialize) {
            IVariable[] projected = astContainer.getOptimizedAST().getProjection().getProjectionVars();
            projectedSet = new LinkedList<String>();
            for (IVariable var : projected) {
                projectedSet.add(var.getName());
            }
        } else {
            projectedSet = null;
        }
        ASTEvalHelper.doSparqlLogging(context);
        PipelineOp queryPlan = astContainer.getQueryPlan();
        AbstractRunningQuery runningQuery = null;
        try {
            ChunkedMaterializationIterator it2;
            runningQuery = context.queryEngine.eval((BOp)queryPlan, bindingSets);
            ChunkedMaterializationIterator it1 = runningQuery.iterator();
            if (materialize && !materializeProjectionInQuery && !projectedSet.isEmpty()) {
                IVariable[] vars = projectedSet.toArray(new IVariable[projectedSet.size()]);
                it2 = new ChunkedMaterializationIterator(vars, context.db.getLexiconRelation(), false, it1);
            } else {
                it2 = it1;
            }
            return it2;
        }
        catch (Throwable t) {
            if (runningQuery != null) {
                runningQuery.cancel(true);
            }
            throw new QueryEvaluationException(t);
        }
    }

    public static QueryRoot optimizeQuery(AbstractTripleStore store, ASTContainer astContainer, QueryBindingSet bs) throws QueryEvaluationException {
        AST2BOpContext context = new AST2BOpContext(astContainer, store);
        astContainer.clearOptimizedAST();
        IBindingSet[] bindingSets = ASTEvalHelper.mergeBindingSets(astContainer, ASTEvalHelper.batchResolveIVs(store, (BindingSet)bs));
        AST2BOpUtility.convert(context, bindingSets);
        QueryRoot optimizedQuery = astContainer.getOptimizedAST();
        return optimizedQuery;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GraphQueryResult evaluateGraphQuery(AbstractTripleStore store, ASTContainer astContainer, QueryBindingSet bs) throws QueryEvaluationException {
        Set<IVariable<?>> describeVars;
        IDescribeCache describeCache;
        LinkedHashMap<String, BigdataBNode> bnodes;
        AST2BOpContext context = new AST2BOpContext(astContainer, store);
        astContainer.clearOptimizedAST();
        IBindingSet[] bindingSets = ASTEvalHelper.mergeBindingSets(astContainer, ASTEvalHelper.batchResolveIVs(store, (BindingSet)bs));
        boolean isDescribe = astContainer.getOriginalAST().getQueryType() == QueryType.DESCRIBE;
        LinkedHashMap<String, BigdataBNode> linkedHashMap = bnodes = isDescribe ? new LinkedHashMap<String, BigdataBNode>() : null;
        if (isDescribe && context.describeCache != null) {
            describeCache = context.getDescribeCache();
            describeVars = astContainer.getOriginalAST().getProjectedVars(new LinkedHashSet());
        } else {
            describeCache = null;
            describeVars = null;
        }
        AST2BOpUtility.convert(context, bindingSets);
        QueryRoot optimizedQuery = astContainer.getOptimizedAST();
        boolean materializeProjectionInQuery = context.materializeProjectionInQuery && !optimizedQuery.hasSlice();
        DescribeModeEnum describeMode = context.getDescribeMode(optimizedQuery.getProjection());
        int describeIterationLimit = context.getDescribeIterationLimit(optimizedQuery.getProjection());
        int describeStatementlimit = context.getDescribeStatementLimit(optimizedQuery.getProjection());
        GraphQueryResultImpl result = null;
        DescribeBindingsCollector solutions = ASTEvalHelper.evaluateQuery(astContainer, context, bindingSets, materializeProjectionInQuery, optimizedQuery.getProjection().getProjectionVars());
        try {
            CloseableIteration<BigdataStatement, QueryEvaluationException> src2;
            Set<BigdataValue> describedResources;
            block14: {
                CloseableIteration<BigdataStatement, QueryEvaluationException> src;
                block13: {
                    DescribeBindingsCollector solutions2;
                    if (describeCache != null) {
                        describedResources = Collections.newSetFromMap(new ConcurrentHashMap());
                        solutions2 = new DescribeBindingsCollector(describeVars, describedResources, solutions);
                    } else {
                        solutions2 = solutions;
                        describedResources = null;
                    }
                    src = new CloseableIteration<BigdataStatement, QueryEvaluationException>(store, optimizedQuery.getConstruct(), optimizedQuery.getWhereClause(), bnodes, (CloseableIteration<BindingSet, QueryEvaluationException>)solutions2);
                    if (!isDescribe) break block13;
                    switch (describeMode) {
                        case SymmetricOneStep: 
                        case ForwardOneStep: {
                            src2 = src;
                            break block14;
                        }
                        case CBD: 
                        case SCBD: {
                            src2 = new CBD(store, describeMode, describeIterationLimit, describeStatementlimit, bnodes).computeClosure(src);
                            break block14;
                        }
                        default: {
                            throw new UnsupportedOperationException("describeMode=" + (Object)((Object)describeMode));
                        }
                    }
                }
                src2 = src;
            }
            Object src3 = describeCache != null ? new DescribeCacheUpdater(describeCache, describedResources, src2) : src2;
            result = new GraphQueryResultImpl(optimizedQuery.getPrefixDecls(), (CloseableIteration)src3);
        }
        finally {
            if (result == null) {
                solutions.close();
            }
        }
        return result;
    }

    static CloseableIteration<BindingSet, QueryEvaluationException> evaluateQuery(ASTContainer astContainer, AST2BOpContext ctx, IBindingSet[] bindingSets, boolean materializeProjectionInQuery, IVariable<?>[] required) throws QueryEvaluationException {
        ASTEvalHelper.doSparqlLogging(ctx);
        PipelineOp queryPlan = astContainer.getQueryPlan();
        Future runningQuery = null;
        try {
            Map<Object, Object> queryAttributes = ctx.getQueryAttributes();
            runningQuery = ctx.queryEngine.eval(queryPlan, bindingSets, queryAttributes);
            return ASTEvalHelper.iterator((IRunningQuery)runningQuery, ctx.db, materializeProjectionInQuery, required);
        }
        catch (Throwable t) {
            if (runningQuery != null) {
                runningQuery.cancel(true);
            }
            throw new QueryEvaluationException(t);
        }
    }

    static IBindingSet[] mergeBindingSets(ASTContainer astContainer, IBindingSet src) {
        LinkedList<List<IBindingSet>> bindingsClauses;
        if (astContainer == null) {
            throw new IllegalArgumentException();
        }
        if (src == null) {
            throw new IllegalArgumentException();
        }
        List<BindingsClause> x = ASTEvalHelper.getDefinitelyProducedBindingsClauses(astContainer.getOriginalAST());
        if (x == null) {
            bindingsClauses = null;
        } else {
            bindingsClauses = new LinkedList<List<IBindingSet>>();
            for (BindingsClause bindingsClause : x) {
                bindingsClauses.add(bindingsClause.getBindingSets());
            }
        }
        if (bindingsClauses == null || bindingsClauses.isEmpty()) {
            return new IBindingSet[]{src};
        }
        if (src.isEmpty() && bindingsClauses.size() == 1) {
            return ((List)bindingsClauses.get(0)).toArray(new IBindingSet[((List)bindingsClauses.get(0)).size()]);
        }
        bindingsClauses.add(0, Arrays.asList(src));
        LinkedList left = new LinkedList();
        for (List list : bindingsClauses) {
            LinkedList<IBindingSet> tmp = new LinkedList<IBindingSet>();
            for (IBindingSet l : left) {
                for (IBindingSet right : list) {
                    IBindingSet join = BOpContext.bind(l, right, null, null);
                    if (join == null) continue;
                    tmp.add(join);
                }
            }
            left = tmp;
        }
        return left.toArray(new IBindingSet[left.size()]);
    }

    static List<BindingsClause> getDefinitelyProducedBindingsClauses(QueryRoot query) {
        LinkedList<BindingsClause> bindingsClauses = new LinkedList<BindingsClause>();
        if (query.getBindingsClause() != null) {
            bindingsClauses.add(query.getBindingsClause());
        }
        ASTEvalHelper.getDefinitelyProducedBindingsClauses(query.getWhereClause(), bindingsClauses);
        return bindingsClauses;
    }

    static void getDefinitelyProducedBindingsClauses(GroupNodeBase<?> group, List<BindingsClause> bindingsClauses) {
        if (group == null) {
            return;
        }
        if (group instanceof JoinGroupNode && ((JoinGroupNode)group).isOptional()) {
            return;
        }
        if (group instanceof UnionNode) {
            return;
        }
        for (IGroupMemberNode child : group) {
            if (child instanceof SubqueryRoot) {
                SubqueryRoot subquery = (SubqueryRoot)child;
                if (subquery.getBindingsClause() != null) {
                    bindingsClauses.add(subquery.getBindingsClause());
                }
                ASTEvalHelper.getDefinitelyProducedBindingsClauses(subquery.getWhereClause(), bindingsClauses);
                continue;
            }
            if (!(child instanceof BindingsClause)) continue;
            bindingsClauses.add((BindingsClause)child);
        }
        for (IGroupMemberNode child : group) {
            if (!(child instanceof GroupNodeBase)) continue;
            ASTEvalHelper.getDefinitelyProducedBindingsClauses((GroupNodeBase)child, bindingsClauses);
        }
    }

    private static IBindingSet toBindingSet(BindingSet src) {
        if (src == null) {
            throw new IllegalArgumentException();
        }
        ListBindingSet bindingSet = new ListBindingSet();
        for (Binding binding : src) {
            Var var = Var.var(binding.getName());
            IV iv = ((BigdataValue)binding.getValue()).getIV();
            Constant<IV> val = new Constant<IV>(iv);
            bindingSet.set(var, val);
        }
        return bindingSet;
    }

    private static CloseableIteration<BindingSet, QueryEvaluationException> iterator(IRunningQuery runningQuery, AbstractTripleStore db, boolean materializeProjectionInQuery, IVariable<?>[] required) {
        Bigdata2Sesame2BindingSetIterator it3;
        ICloseableIterator<IBindingSet> it1 = ASTEvalHelper.iterator(runningQuery);
        BOp query = runningQuery.getQuery();
        int chunkCapacity = query.getProperty(PipelineOp.Annotations.CHUNK_CAPACITY, 100);
        ChunkedWrappedIterator<IBindingSet> it2 = new ChunkedWrappedIterator<IBindingSet>(it1, chunkCapacity, IBindingSet.class);
        if (materializeProjectionInQuery) {
            it3 = new Bigdata2Sesame2BindingSetIterator(it2);
        } else {
            int chunkOfChunksCapacity = query.getProperty(PipelineOp.Annotations.CHUNK_OF_CHUNKS_CAPACITY, 5);
            long chunkTimeout = query.getProperty(PipelineOp.Annotations.CHUNK_TIMEOUT, 10).intValue();
            int termsChunkSize = chunkCapacity;
            int blobsChunkSize = chunkCapacity;
            it3 = new Bigdata2Sesame2BindingSetIterator(new BigdataBindingSetResolverator(db, it2, runningQuery.getQueryId(), required, chunkCapacity, chunkOfChunksCapacity, chunkTimeout, termsChunkSize, blobsChunkSize).start(db.getExecutorService()));
        }
        return it3;
    }

    private static ICloseableIterator<IBindingSet> iterator(IRunningQuery runningQuery) {
        ICloseableIterator<IBindingSet[]> it1 = runningQuery.iterator();
        Dechunkerator it2 = new Dechunkerator(it1);
        RunningQueryCloseableIterator<IBindingSet> it3 = new RunningQueryCloseableIterator<IBindingSet>(runningQuery, it2);
        return it3;
    }

    public static long executeUpdate(BigdataSailRepositoryConnection conn, ASTContainer astContainer, Dataset dataset, boolean includeInferred, QueryBindingSet bs) throws UpdateExecutionException {
        if (conn == null) {
            throw new IllegalArgumentException();
        }
        if (astContainer == null) {
            throw new IllegalArgumentException();
        }
        try {
            if (dataset != null) {
                ASTEvalHelper.applyDataSet(conn.getTripleStore(), astContainer, dataset);
            }
            AST2BOpUpdateContext ctx = new AST2BOpUpdateContext(astContainer, conn);
            ASTEvalHelper.doSparqlLogging(ctx);
            ctx.setIncludeInferred(includeInferred);
            IBindingSet[] bindingSets = new IBindingSet[]{ASTEvalHelper.batchResolveIVs(conn.getTripleStore(), (BindingSet)bs)};
            ctx.setQueryBindingSet(bs);
            ctx.setBindings(bindingSets);
            AST2BOpUpdate.optimizeUpdateRoot(ctx);
            AST2BOpUpdate.convertUpdate(ctx);
            return ctx.getCommitTime();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new UpdateExecutionException((Throwable)ex);
        }
    }

    private static void applyDataSet(AbstractTripleStore tripleStore, ASTContainer astContainer, Dataset dataset) {
        if (tripleStore == null) {
            throw new IllegalArgumentException();
        }
        if (astContainer == null) {
            throw new IllegalArgumentException();
        }
        if (dataset == null) {
            throw new IllegalArgumentException();
        }
        Object[] tmp = new BigdataValueReplacer(tripleStore).replaceValues(dataset, null);
        Dataset resolvedDataset = (Dataset)tmp[0];
        UpdateRoot updateRoot = astContainer.getOriginalUpdateAST();
        for (Update op : updateRoot) {
            if (!(op instanceof IDataSetNode)) continue;
            IDataSetNode node = (IDataSetNode)((Object)op);
            node.setDataset(new DatasetNode(resolvedDataset, true));
        }
    }

    private static void doSparqlLogging(AST2BOpContext ctx) {
        if (!log.isInfoEnabled()) {
            return;
        }
        ASTEvalHelper.setupLoggingContext(ctx);
        ASTContainer astContainer = ctx.astContainer;
        String queryString = astContainer.getQueryString();
        if (queryString != null) {
            log.info((Object)queryString);
        } else if (astContainer.isQuery()) {
            log.info((Object)astContainer.getOriginalAST());
        } else {
            log.info((Object)astContainer.getOriginalUpdateAST());
        }
        ASTEvalHelper.clearLoggingContext();
    }

    private static void setupLoggingContext(IEvaluationContext context) {
        MDC.put((String)"tx", (Object)TimestampUtility.toString(context.getTimestamp()));
    }

    private static void clearLoggingContext() {
        MDC.remove((String)"tx");
    }
}

