/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.eval;

import com.bigdata.bop.Constant;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstant;
import com.bigdata.bop.NV;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.lexicon.ITextIndexer;
import com.bigdata.rdf.lexicon.IValueCentricTextIndexer;
import com.bigdata.rdf.sparql.ast.ConstantNode;
import com.bigdata.rdf.sparql.ast.FilterNode;
import com.bigdata.rdf.sparql.ast.FunctionNode;
import com.bigdata.rdf.sparql.ast.FunctionRegistry;
import com.bigdata.rdf.sparql.ast.IValueExpressionNode;
import com.bigdata.rdf.sparql.ast.JoinGroupNode;
import com.bigdata.rdf.sparql.ast.StaticAnalysis;
import com.bigdata.rdf.sparql.ast.ValueExpressionNode;
import com.bigdata.rdf.sparql.ast.VarNode;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpContext;
import com.bigdata.rdf.sparql.ast.optimizers.AbstractJoinGroupOptimizer;
import com.bigdata.rdf.store.BDS;
import com.bigdata.search.Hiterator;
import java.util.Map;
import org.openrdf.model.Literal;

public class ASTSearchInSearchOptimizer
extends AbstractJoinGroupOptimizer {
    @Override
    protected void optimizeJoinGroup(AST2BOpContext ctx, StaticAnalysis sa, IBindingSet[] bSets, JoinGroupNode group) {
        for (FilterNode node : group.getChildren(FilterNode.class)) {
            this.optimize(ctx, sa, group, node);
        }
    }

    protected void optimize(AST2BOpContext ctx, StaticAnalysis sa, JoinGroupNode group, FilterNode filterNode) {
        FunctionNode funcNode;
        IValueExpressionNode veNode = filterNode.getValueExpressionNode();
        if (veNode instanceof FunctionNode && (funcNode = (FunctionNode)veNode).getFunctionURI().equals((Object)BDS.SEARCH_IN_SEARCH)) {
            filterNode.setArg(0, this.convert(ctx, funcNode));
        }
    }

    protected FunctionNode convert(AST2BOpContext ctx, FunctionNode searchInSearch) {
        String regex;
        String match;
        VarNode var = (VarNode)searchInSearch.get(0);
        Literal search = (Literal)((ConstantNode)searchInSearch.get(1)).getValue();
        if (searchInSearch.arity() > 2) {
            Literal l = (Literal)((ConstantNode)searchInSearch.get(2)).getValue();
            match = l.getLabel();
        } else {
            match = "ANY";
        }
        if (searchInSearch.arity() > 3) {
            Literal l = (Literal)((ConstantNode)searchInSearch.get(3)).getValue();
            regex = l.getLabel();
        } else {
            regex = null;
        }
        IV[] hits = this.getHits(ctx, search, match, regex);
        ValueExpressionNode[] args = new ValueExpressionNode[hits.length + 1];
        args[0] = var;
        for (int i = 0; i < hits.length; ++i) {
            args[i + 1] = new ConstantNode((IConstant<IV>)new Constant<IV>(hits[i]));
        }
        Map<String, Object> props = NV.asMap(new NV(FunctionRegistry.InFactory.Annotations.ALLOW_LITERALS, true));
        FunctionNode in = new FunctionNode(FunctionRegistry.IN, props, args);
        return in;
    }

    protected IV[] getHits(AST2BOpContext ctx, Literal search, String match, String regex) {
        boolean prefixMatch;
        IValueCentricTextIndexer<?> textIndex = ctx.getAbstractTripleStore().getLexiconRelation().getSearchEngine();
        if (textIndex == null) {
            throw new UnsupportedOperationException("No free text index?");
        }
        String s = search.getLabel();
        if (s.indexOf(42) >= 0) {
            prefixMatch = true;
            s = s.replaceAll("\\*", "");
        } else {
            prefixMatch = false;
        }
        Hiterator it = textIndex.search(new ITextIndexer.FullTextQuery(s, search.getLanguage(), prefixMatch, regex, match != null && match.equalsIgnoreCase("ALL"), match != null && match.equalsIgnoreCase("EXACT")));
        IV[] hits = new IV[it.size()];
        int i = 0;
        while (it.hasNext()) {
            hits[i++] = (IV)it.next().getDocId();
        }
        return hits;
    }
}

