/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.hints;

import com.bigdata.rdf.sparql.ast.hints.AccessPathSampleLimitHint;
import com.bigdata.rdf.sparql.ast.hints.AccessPathScanAndFilterHint;
import com.bigdata.rdf.sparql.ast.hints.AnalyticQueryHint;
import com.bigdata.rdf.sparql.ast.hints.AtOnceHint;
import com.bigdata.rdf.sparql.ast.hints.BufferChunkCapacityHint;
import com.bigdata.rdf.sparql.ast.hints.BufferChunkOfChunksCapacityHint;
import com.bigdata.rdf.sparql.ast.hints.ChunkSizeHint;
import com.bigdata.rdf.sparql.ast.hints.CutoffLimitHint;
import com.bigdata.rdf.sparql.ast.hints.DescribeIterationLimitHint;
import com.bigdata.rdf.sparql.ast.hints.DescribeModeHint;
import com.bigdata.rdf.sparql.ast.hints.DescribeStatementLimitHint;
import com.bigdata.rdf.sparql.ast.hints.FilterExistsHint;
import com.bigdata.rdf.sparql.ast.hints.HashJoinHint;
import com.bigdata.rdf.sparql.ast.hints.IQueryHint;
import com.bigdata.rdf.sparql.ast.hints.KeyOrderHint;
import com.bigdata.rdf.sparql.ast.hints.MergeJoinHint;
import com.bigdata.rdf.sparql.ast.hints.NativeDistinctQueryHint;
import com.bigdata.rdf.sparql.ast.hints.NativeDistinctSPOHint;
import com.bigdata.rdf.sparql.ast.hints.NativeDistinctSPOThresholdHint;
import com.bigdata.rdf.sparql.ast.hints.NativeHashJoinsHint;
import com.bigdata.rdf.sparql.ast.hints.OptimisticQueryHint;
import com.bigdata.rdf.sparql.ast.hints.OptimizerQueryHint;
import com.bigdata.rdf.sparql.ast.hints.PipelineMaxMessagesPerTaskHint;
import com.bigdata.rdf.sparql.ast.hints.PipelineMaxParallelHint;
import com.bigdata.rdf.sparql.ast.hints.PipelineQueueCapacityHint;
import com.bigdata.rdf.sparql.ast.hints.QueryIdHint;
import com.bigdata.rdf.sparql.ast.hints.RTOLimitQueryHint;
import com.bigdata.rdf.sparql.ast.hints.RTONEdgesQueryHint;
import com.bigdata.rdf.sparql.ast.hints.RTOSampleTypeQueryHint;
import com.bigdata.rdf.sparql.ast.hints.RangeHint;
import com.bigdata.rdf.sparql.ast.hints.RemoteAPHint;
import com.bigdata.rdf.sparql.ast.hints.RunFirstHint;
import com.bigdata.rdf.sparql.ast.hints.RunLastHint;
import com.bigdata.rdf.sparql.ast.hints.RunOnceHint;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class QueryHintRegistry {
    private static ConcurrentMap<String, IQueryHint<?>> registry = new ConcurrentHashMap();

    public static final void add(IQueryHint<?> queryHint) {
        if (registry.putIfAbsent(queryHint.getName(), queryHint) != null) {
            throw new UnsupportedOperationException("Already declared.");
        }
    }

    public static final IQueryHint<?> get(String name) {
        return (IQueryHint)registry.get(name);
    }

    static {
        QueryHintRegistry.add(new QueryIdHint());
        QueryHintRegistry.add(new RunFirstHint());
        QueryHintRegistry.add(new RunLastHint());
        QueryHintRegistry.add(new RunOnceHint());
        QueryHintRegistry.add(new OptimizerQueryHint());
        QueryHintRegistry.add(new RTOSampleTypeQueryHint());
        QueryHintRegistry.add(new RTOLimitQueryHint());
        QueryHintRegistry.add(new RTONEdgesQueryHint());
        QueryHintRegistry.add(new OptimisticQueryHint());
        QueryHintRegistry.add(new AnalyticQueryHint());
        QueryHintRegistry.add(new NativeDistinctQueryHint());
        QueryHintRegistry.add(new NativeDistinctSPOHint());
        QueryHintRegistry.add(new NativeDistinctSPOThresholdHint());
        QueryHintRegistry.add(new NativeHashJoinsHint());
        QueryHintRegistry.add(new MergeJoinHint());
        QueryHintRegistry.add(new HashJoinHint());
        QueryHintRegistry.add(new KeyOrderHint());
        QueryHintRegistry.add(new RemoteAPHint());
        QueryHintRegistry.add(new AccessPathSampleLimitHint());
        QueryHintRegistry.add(new AccessPathScanAndFilterHint());
        QueryHintRegistry.add(new DescribeModeHint());
        QueryHintRegistry.add(new DescribeIterationLimitHint());
        QueryHintRegistry.add(new DescribeStatementLimitHint());
        QueryHintRegistry.add(new BufferChunkOfChunksCapacityHint());
        QueryHintRegistry.add(new BufferChunkCapacityHint());
        QueryHintRegistry.add(new ChunkSizeHint());
        QueryHintRegistry.add(new AtOnceHint());
        QueryHintRegistry.add(new PipelineMaxParallelHint());
        QueryHintRegistry.add(new PipelineMaxMessagesPerTaskHint());
        QueryHintRegistry.add(new PipelineQueueCapacityHint());
        QueryHintRegistry.add(new RangeHint());
        QueryHintRegistry.add(new CutoffLimitHint());
        QueryHintRegistry.add(new FilterExistsHint());
    }
}

