/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.optimizers;

import com.bigdata.bop.BOp;
import com.bigdata.bop.IBindingSet;
import com.bigdata.rdf.sparql.ast.ArbitraryLengthPathNode;
import com.bigdata.rdf.sparql.ast.GroupMemberNodeBase;
import com.bigdata.rdf.sparql.ast.IGroupMemberNode;
import com.bigdata.rdf.sparql.ast.JoinGroupNode;
import com.bigdata.rdf.sparql.ast.StatementPatternNode;
import com.bigdata.rdf.sparql.ast.StaticAnalysis;
import com.bigdata.rdf.sparql.ast.TermNode;
import com.bigdata.rdf.sparql.ast.UnionNode;
import com.bigdata.rdf.sparql.ast.VarNode;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpContext;
import com.bigdata.rdf.sparql.ast.hints.BasicBooleanQueryHint;
import com.bigdata.rdf.sparql.ast.hints.BasicIntQueryHint;
import com.bigdata.rdf.sparql.ast.hints.QueryHintRegistry;
import com.bigdata.rdf.sparql.ast.optimizers.AbstractJoinGroupOptimizer;
import com.bigdata.rdf.sparql.ast.optimizers.IASTOptimizer;
import com.bigdata.rdf.sparql.ast.service.ServiceNode;
import com.bigdata.rdf.store.BD;
import java.util.Properties;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.openrdf.model.URI;

public class ASTALPServiceOptimizer
extends AbstractJoinGroupOptimizer
implements IASTOptimizer {
    private static final transient Logger log = Logger.getLogger(ASTALPServiceOptimizer.class);
    public static final URI ALP = BD.ALP_SERVICE;
    public static final String PATH_EXPR = "alp.pathExpr";
    public static final String LOWER_BOUND = "alp.lowerBound";
    public static final String UPPER_BOUND = "alp.upperBound";
    public static final String BIDIRECTIONAL = "alp.bidirectional";

    @Override
    protected void optimizeJoinGroup(AST2BOpContext ctx, StaticAnalysis sa, IBindingSet[] bSets, JoinGroupNode group) {
        for (ServiceNode node : group.getChildren(ServiceNode.class)) {
            Properties hints;
            TermNode serviceRef;
            if (log.isDebugEnabled()) {
                log.debug((Object)node);
            }
            if (!(serviceRef = node.getServiceRef()).isConstant() || !serviceRef.getValue().equals(ALP)) continue;
            JoinGroupNode subgroup = (JoinGroupNode)node.getGraphPattern();
            if (log.isDebugEnabled()) {
                log.debug((Object)("found an alp service to optimize:\n" + subgroup));
            }
            if (!(hints = subgroup.getQueryHints()).containsKey(LOWER_BOUND)) {
                throw new RuntimeException("missing: alp.lowerBound");
            }
            if (!hints.containsKey(UPPER_BOUND)) {
                throw new RuntimeException("missing: alp.upperBound");
            }
            for (IGroupMemberNode child : subgroup.getChildren()) {
                if (child instanceof StatementPatternNode) continue;
                throw new RuntimeException("Complex groups not allowed in alp service");
            }
            int lowerBound = Integer.valueOf(subgroup.getQueryHint(LOWER_BOUND));
            int upperBound = Integer.valueOf(subgroup.getQueryHint(UPPER_BOUND));
            VarNode tVarLeft = new VarNode("-tVarLeft-" + UUID.randomUUID().toString());
            tVarLeft.setAnonymous(true);
            VarNode tVarRight = new VarNode("-tVarRight-" + UUID.randomUUID().toString());
            tVarRight.setAnonymous(true);
            boolean bidirectional = subgroup.getQueryHintAsBoolean(BIDIRECTIONAL, false);
            TermNode left = null;
            TermNode right = null;
            GroupMemberNodeBase pathExpr = null;
            for (StatementPatternNode child : subgroup.getStatementPatterns()) {
                if (!child.getQueryHintAsBoolean(PATH_EXPR, false)) continue;
                if (pathExpr != null) {
                    throw new RuntimeException("Only one alp.pathExpr allowed");
                }
                if (child.p() instanceof VarNode) {
                    ((VarNode)child.p()).setAnonymous(true);
                }
                left = child.s();
                right = child.o();
                if (bidirectional) {
                    StatementPatternNode forward = new StatementPatternNode(tVarLeft, child.p(), tVarRight, child.c(), child.getScope());
                    JoinGroupNode group1 = new JoinGroupNode();
                    group1.addChild(forward);
                    StatementPatternNode reverse = new StatementPatternNode(tVarRight, child.p(), tVarLeft, child.c(), child.getScope());
                    JoinGroupNode group2 = new JoinGroupNode();
                    group2.addChild(reverse);
                    UnionNode union = new UnionNode();
                    union.addArg(group1);
                    union.addArg(group2);
                    union.setQueryHint(PATH_EXPR, "true");
                    pathExpr = union;
                } else {
                    StatementPatternNode sp = new StatementPatternNode(tVarLeft, child.p(), tVarRight, child.c(), child.getScope());
                    sp.setQueryHint(PATH_EXPR, "true");
                    pathExpr = sp;
                }
                subgroup.removeChild(child);
            }
            ArbitraryLengthPathNode alpNode = new ArbitraryLengthPathNode(left, right, tVarLeft, tVarRight, lowerBound, upperBound);
            alpNode.subgroup().addChild(pathExpr);
            for (StatementPatternNode child : subgroup.getStatementPatterns()) {
                if (child.getQueryHintAsBoolean(PATH_EXPR, false)) continue;
                for (BOp term : child.args()) {
                    if (!(term instanceof VarNode)) continue;
                    ((VarNode)term).setAnonymous(true);
                }
                child.setQueryHints(new Properties());
                subgroup.removeChild(child);
                alpNode.subgroup().addChild(child);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("optimized alpNode:\n" + alpNode));
            }
            group.removeChild(node);
            group.addChild(alpNode);
        }
    }

    static {
        QueryHintRegistry.add(new BasicBooleanQueryHint(PATH_EXPR, false));
        QueryHintRegistry.add(new BasicIntQueryHint(LOWER_BOUND, 1));
        QueryHintRegistry.add(new BasicIntQueryHint(UPPER_BOUND, Integer.MAX_VALUE));
        QueryHintRegistry.add(new BasicBooleanQueryHint(BIDIRECTIONAL, false));
    }
}

