/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.optimizers;

import com.bigdata.bop.BOpUtility;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IVariable;
import com.bigdata.rdf.sparql.ast.ConstructNode;
import com.bigdata.rdf.sparql.ast.IQueryNode;
import com.bigdata.rdf.sparql.ast.JoinGroupNode;
import com.bigdata.rdf.sparql.ast.OrderByNode;
import com.bigdata.rdf.sparql.ast.ProjectionNode;
import com.bigdata.rdf.sparql.ast.QueryRoot;
import com.bigdata.rdf.sparql.ast.QueryType;
import com.bigdata.rdf.sparql.ast.SliceNode;
import com.bigdata.rdf.sparql.ast.SubqueryRoot;
import com.bigdata.rdf.sparql.ast.VarNode;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpContext;
import com.bigdata.rdf.sparql.ast.optimizers.IASTOptimizer;
import java.util.Iterator;

public class ASTConstructOptimizer
implements IASTOptimizer {
    @Override
    public IQueryNode optimize(AST2BOpContext context, IQueryNode queryNode, IBindingSet[] bindingSets) {
        ProjectionNode projection;
        if (!(queryNode instanceof QueryRoot)) {
            return queryNode;
        }
        QueryRoot queryRoot = (QueryRoot)queryNode;
        switch (queryRoot.getQueryType()) {
            case CONSTRUCT: {
                break;
            }
            default: {
                if (context.nativeDistinctSPO) {
                    queryRoot.setProperty("nativeDistinct", true);
                }
                return queryRoot;
            }
        }
        ConstructNode constructNode = queryRoot.getConstruct();
        if (constructNode == null) {
            throw new RuntimeException("No CONSTRUCT clause?");
        }
        if (queryRoot.getProjection() == null) {
            projection = new ProjectionNode();
            queryRoot.setProjection(projection);
            projection.setReduced(true);
        } else {
            projection = queryRoot.getProjection();
        }
        Iterator<IVariable<?>> itr = BOpUtility.getSpannedVariables(constructNode);
        while (itr.hasNext()) {
            projection.addProjectionVar(new VarNode(itr.next().getName()));
        }
        if (context.nativeDistinctSPO) {
            constructNode.setNativeDistinct(true);
        }
        SliceNode slice = queryRoot.getSlice();
        OrderByNode orderBy = queryRoot.getOrderBy();
        if (slice == null) {
            if (orderBy != null) {
                queryRoot.setOrderBy(null);
            }
        } else if (slice != null) {
            SubqueryRoot subqueryRoot = new SubqueryRoot(QueryType.SELECT);
            subqueryRoot.setProjection((ProjectionNode)projection.clone());
            subqueryRoot.setWhereClause(queryRoot.getWhereClause());
            queryRoot.setWhereClause(new JoinGroupNode(subqueryRoot));
            subqueryRoot.setSlice(slice);
            queryRoot.setSlice(null);
            if (orderBy != null) {
                subqueryRoot.setOrderBy(orderBy);
                queryRoot.setOrderBy(null);
            }
        }
        return queryRoot;
    }
}

