/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.optimizers;

import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpUtility;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstant;
import com.bigdata.bop.IPredicate;
import com.bigdata.bop.IValueExpression;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.IVariableOrConstant;
import com.bigdata.bop.Var;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.sparql.ast.AssignmentNode;
import com.bigdata.rdf.sparql.ast.DatasetNode;
import com.bigdata.rdf.sparql.ast.GraphPatternGroup;
import com.bigdata.rdf.sparql.ast.IGroupMemberNode;
import com.bigdata.rdf.sparql.ast.IQueryNode;
import com.bigdata.rdf.sparql.ast.NamedSubqueriesNode;
import com.bigdata.rdf.sparql.ast.NamedSubqueryRoot;
import com.bigdata.rdf.sparql.ast.ProjectionNode;
import com.bigdata.rdf.sparql.ast.QueryBase;
import com.bigdata.rdf.sparql.ast.QueryRoot;
import com.bigdata.rdf.sparql.ast.QueryType;
import com.bigdata.rdf.sparql.ast.StatementPatternNode;
import com.bigdata.rdf.sparql.ast.StaticAnalysis;
import com.bigdata.rdf.sparql.ast.SubqueryBase;
import com.bigdata.rdf.sparql.ast.SubqueryRoot;
import com.bigdata.rdf.sparql.ast.VarNode;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpBase;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpContext;
import com.bigdata.rdf.sparql.ast.optimizers.IASTOptimizer;
import com.bigdata.rdf.sparql.ast.service.ServiceNode;
import com.bigdata.rdf.spo.ISPO;
import com.bigdata.rdf.spo.SPOKeyOrder;
import com.bigdata.striterator.IKeyOrder;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class ASTDistinctTermScanOptimizer
implements IASTOptimizer {
    @Override
    public IQueryNode optimize(AST2BOpContext context, IQueryNode queryNode, IBindingSet[] bindingSets) {
        NamedSubqueriesNode namedSubqueries;
        QueryRoot queryRoot = (QueryRoot)queryNode;
        StaticAnalysis sa = new StaticAnalysis(queryRoot, context);
        DatasetNode dataset = queryRoot.getDataset();
        if (context.getAbstractTripleStore().isQuads()) {
            boolean ok = false;
            if (dataset == null || dataset.getNamedGraphs() == null) {
                ok = true;
            }
            if (!ok) {
                return queryNode;
            }
        }
        if ((namedSubqueries = queryRoot.getNamedSubqueries()) != null) {
            List<NamedSubqueryRoot> list = BOpUtility.toList(namedSubqueries, NamedSubqueryRoot.class);
            for (NamedSubqueryRoot namedSubquery : list) {
                this.doSelectQuery(context, sa, (QueryRoot)queryNode, namedSubquery);
            }
        }
        this.doSelectQuery(context, sa, (QueryRoot)queryNode, (QueryBase)queryNode);
        return queryNode;
    }

    private void doRecursiveRewrite(AST2BOpContext context, StaticAnalysis sa, QueryRoot queryRoot, GraphPatternGroup<IGroupMemberNode> group) {
        int arity = group.arity();
        for (int i = 0; i < arity; ++i) {
            BOp child = group.get(i);
            if (child instanceof GraphPatternGroup) {
                this.doRecursiveRewrite(context, sa, queryRoot, (GraphPatternGroup)child);
                continue;
            }
            if (child instanceof SubqueryRoot) {
                SubqueryRoot subqueryRoot = (SubqueryRoot)child;
                this.doRecursiveRewrite(context, sa, queryRoot, subqueryRoot.getWhereClause());
                this.doSelectQuery(context, sa, queryRoot, (SubqueryBase)child);
                continue;
            }
            if (!(child instanceof ServiceNode)) continue;
        }
    }

    private void doSelectQuery(AST2BOpContext context, StaticAnalysis sa, QueryRoot queryRoot, QueryBase queryBase) {
        this.doRecursiveRewrite(context, sa, queryRoot, queryBase.getWhereClause());
        if (queryBase.getQueryType() != QueryType.SELECT) {
            return;
        }
        ProjectionNode projection = queryBase.getProjection();
        if (!projection.isDistinct() && !projection.isReduced()) {
            return;
        }
        if (projection.isEmpty()) {
            return;
        }
        if (projection.arity() > 1) {
            return;
        }
        AssignmentNode assignmentNode = (AssignmentNode)projection.getExpr(0);
        if (!(assignmentNode.getValueExpressionNode() instanceof VarNode)) {
            return;
        }
        IVariable<IV> projectedVar = assignmentNode.getVar();
        GraphPatternGroup whereClause = queryBase.getWhereClause();
        if (whereClause == null || whereClause.arity() != 1) {
            return;
        }
        if (!(whereClause.get(0) instanceof StatementPatternNode)) {
            return;
        }
        StatementPatternNode sp = (StatementPatternNode)whereClause.get(0);
        IKeyOrder<ISPO> keyOrder = this.getApplicableKeyOrderIfExists(sp, projectedVar, context);
        if (keyOrder == null) {
            return;
        }
        LinkedHashSet<VarNode> vars = new LinkedHashSet<VarNode>();
        for (VarNode varNode : BOpUtility.toList(sp, VarNode.class)) {
            if (vars.add(varNode)) continue;
            return;
        }
        Set<IVariable<?>> producedBindings = sp.getProducedBindings();
        if (!producedBindings.contains(projectedVar)) {
            return;
        }
        if (queryBase instanceof SubqueryRoot) {
            ((SubqueryRoot)queryBase).setRunOnce(true);
        }
        projection.setDistinct(false);
        projection.setReduced(false);
        VarNode distinctTermScanVar = new VarNode(projectedVar.getName());
        sp.setDistinctTermScanVar(distinctTermScanVar);
        sp.setQueryHint(IPredicate.Annotations.KEY_ORDER, keyOrder.toString());
        Long oldCard = (Long)sp.getProperty(AST2BOpBase.Annotations.ESTIMATED_CARDINALITY);
        if (oldCard == null) {
            throw new AssertionError((Object)("Expecting estimated-cardinality to be bound: sp=" + sp));
        }
        int arity = context.isQuads() ? 4 : 3;
        long newCard = (long)(1.0 / (double)arity);
        sp.setProperty(AST2BOpBase.Annotations.ESTIMATED_CARDINALITY, newCard);
    }

    private IKeyOrder<ISPO> getApplicableKeyOrderIfExists(StatementPatternNode sp, IVariable<?> termScanVar, AST2BOpContext context) {
        Set<SPOKeyOrder> candidateKeyOrder;
        boolean isQuads = context.getAbstractTripleStore().isQuads();
        IVariableOrConstant[] args = new IVariableOrConstant[isQuads ? 4 : 3];
        args[0] = sp.s().getValueExpression();
        args[1] = sp.p().getValueExpression();
        args[2] = sp.o().getValueExpression();
        if (isQuads) {
            IValueExpression iValueExpression = args[3] = sp.c() == null ? Var.var("--anon-" + context.nextId()) : sp.c().getValueExpression();
        }
        if ((candidateKeyOrder = this.getCandidateKeyOrders(sp, termScanVar, context, isQuads)).isEmpty()) {
            return null;
        }
        return candidateKeyOrder.iterator().next();
    }

    private Set<SPOKeyOrder> getCandidateKeyOrders(StatementPatternNode sp, IVariable<?> termScanVar, AST2BOpContext context, boolean isQuads) {
        StringBuffer constantPosBuf = new StringBuffer();
        Character distinctTermScanPos = null;
        StringBuffer unconstrainedPosBuf = new StringBuffer();
        int pcS = this.getPositionConstraint((IVariableOrConstant)sp.s().getValueExpression(), termScanVar);
        int pcP = this.getPositionConstraint((IVariableOrConstant)sp.p().getValueExpression(), termScanVar);
        int pcO = this.getPositionConstraint((IVariableOrConstant)sp.o().getValueExpression(), termScanVar);
        if (pcS == 2) {
            constantPosBuf.append("S");
        }
        if (pcP == 2) {
            constantPosBuf.append("P");
        }
        if (pcO == 2) {
            constantPosBuf.append("O");
        }
        if (pcS == 1) {
            distinctTermScanPos = Character.valueOf('S');
        }
        if (pcP == 1) {
            distinctTermScanPos = Character.valueOf('P');
        }
        if (pcO == 1) {
            distinctTermScanPos = Character.valueOf('O');
        }
        if (pcS == 0) {
            unconstrainedPosBuf.append("S");
        }
        if (pcP == 0) {
            unconstrainedPosBuf.append("P");
        }
        if (pcO == 0) {
            unconstrainedPosBuf.append("O");
        }
        if (isQuads) {
            if (sp.c() == null || sp.c().getValueExpression() == null) {
                unconstrainedPosBuf.append("C");
            } else {
                int pcC = this.getPositionConstraint((IVariableOrConstant)sp.c().getValueExpression(), termScanVar);
                if (pcC == 2) {
                    constantPosBuf.append("C");
                }
                if (pcC == 1) {
                    distinctTermScanPos = Character.valueOf('C');
                }
                if (pcC == 0) {
                    unconstrainedPosBuf.append("C");
                }
            }
        }
        String prefix = constantPosBuf.toString();
        LinkedHashSet<String> allPossibleConstPrefixes = new LinkedHashSet<String>();
        this.getPermutations(prefix, allPossibleConstPrefixes);
        if (allPossibleConstPrefixes.isEmpty()) {
            allPossibleConstPrefixes.add("");
        }
        String suffix = unconstrainedPosBuf.toString();
        LinkedHashSet<String> allPossibleConstSuffixes = new LinkedHashSet<String>();
        this.getPermutations(suffix, allPossibleConstSuffixes);
        if (allPossibleConstSuffixes.isEmpty()) {
            allPossibleConstSuffixes.add("");
        }
        LinkedHashSet<SPOKeyOrder> allPossiblePrefixes = new LinkedHashSet<SPOKeyOrder>();
        for (String constPrefix : allPossibleConstPrefixes) {
            for (String constSuffix : allPossibleConstSuffixes) {
                String index = constPrefix + distinctTermScanPos + constSuffix;
                try {
                    allPossiblePrefixes.add(SPOKeyOrder.fromString(index));
                }
                catch (IllegalArgumentException e) {}
            }
        }
        return allPossiblePrefixes;
    }

    private int getPositionConstraint(IVariableOrConstant val, IVariable<?> termScanVar) {
        if (val instanceof IConstant) {
            return 2;
        }
        if (val instanceof IVariable) {
            return val.equals(termScanVar) ? 1 : 0;
        }
        return 0;
    }

    private void getPermutations(String str, Set<String> collector) {
        this.getPermutations("", str, collector);
    }

    private void getPermutations(String prefix, String str, Set<String> collector) {
        int n = str.length();
        if (n == 0) {
            collector.add(prefix);
        } else {
            for (int i = 0; i < n; ++i) {
                this.getPermutations(prefix + str.charAt(i), str.substring(0, i) + str.substring(i + 1, n), collector);
            }
        }
    }
}

