/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.optimizers;

import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpUtility;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.aggregate.AggregateBase;
import com.bigdata.rdf.sparql.ast.AssignmentNode;
import com.bigdata.rdf.sparql.ast.DatasetNode;
import com.bigdata.rdf.sparql.ast.FunctionNode;
import com.bigdata.rdf.sparql.ast.FunctionRegistry;
import com.bigdata.rdf.sparql.ast.GraphPatternGroup;
import com.bigdata.rdf.sparql.ast.IGroupMemberNode;
import com.bigdata.rdf.sparql.ast.IQueryNode;
import com.bigdata.rdf.sparql.ast.NamedSubqueriesNode;
import com.bigdata.rdf.sparql.ast.NamedSubqueryRoot;
import com.bigdata.rdf.sparql.ast.ProjectionNode;
import com.bigdata.rdf.sparql.ast.QueryBase;
import com.bigdata.rdf.sparql.ast.QueryRoot;
import com.bigdata.rdf.sparql.ast.QueryType;
import com.bigdata.rdf.sparql.ast.StatementPatternNode;
import com.bigdata.rdf.sparql.ast.StaticAnalysis;
import com.bigdata.rdf.sparql.ast.SubqueryBase;
import com.bigdata.rdf.sparql.ast.SubqueryRoot;
import com.bigdata.rdf.sparql.ast.ValueExpressionNode;
import com.bigdata.rdf.sparql.ast.VarNode;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpBase;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpContext;
import com.bigdata.rdf.sparql.ast.optimizers.IASTOptimizer;
import com.bigdata.rdf.sparql.ast.service.ServiceNode;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openrdf.query.algebra.StatementPattern;

public class ASTFastRangeCountOptimizer
implements IASTOptimizer {
    @Override
    public IQueryNode optimize(AST2BOpContext context, IQueryNode queryNode, IBindingSet[] bindingSets) {
        if (context.getAbstractTripleStore().getSPORelation().indicesHaveDeleteMarkers()) {
            return queryNode;
        }
        QueryRoot queryRoot = (QueryRoot)queryNode;
        StaticAnalysis sa = new StaticAnalysis(queryRoot, context);
        NamedSubqueriesNode namedSubqueries = queryRoot.getNamedSubqueries();
        if (namedSubqueries != null) {
            List<NamedSubqueryRoot> list = BOpUtility.toList(namedSubqueries, NamedSubqueryRoot.class);
            for (NamedSubqueryRoot namedSubquery : list) {
                this.doSelectQuery(context, sa, namedSubquery);
            }
        }
        this.doSelectQuery(context, sa, (QueryRoot)queryNode);
        return queryNode;
    }

    private void doRecursiveRewrite(AST2BOpContext context, StaticAnalysis sa, GraphPatternGroup<IGroupMemberNode> group) {
        int arity = group.arity();
        for (int i = 0; i < arity; ++i) {
            BOp child = group.get(i);
            if (child instanceof GraphPatternGroup) {
                this.doRecursiveRewrite(context, sa, (GraphPatternGroup)child);
                continue;
            }
            if (child instanceof SubqueryRoot) {
                SubqueryRoot subqueryRoot = (SubqueryRoot)child;
                this.doRecursiveRewrite(context, sa, subqueryRoot.getWhereClause());
                this.doSelectQuery(context, sa, (SubqueryBase)child);
                continue;
            }
            if (!(child instanceof ServiceNode)) continue;
        }
    }

    private void doSelectQuery(AST2BOpContext context, StaticAnalysis sa, QueryBase queryBase) {
        this.doRecursiveRewrite(context, sa, queryBase.getWhereClause());
        if (queryBase.getQueryType() != QueryType.SELECT) {
            return;
        }
        ProjectionNode projection = queryBase.getProjection();
        if (projection.isEmpty()) {
            return;
        }
        if (projection.arity() > 1) {
            return;
        }
        AssignmentNode assignmentNode = (AssignmentNode)projection.getExpr(0);
        if (!(assignmentNode.getValueExpressionNode() instanceof FunctionNode)) {
            return;
        }
        FunctionNode functionNode = (FunctionNode)assignmentNode.getValueExpressionNode();
        if (!functionNode.getFunctionURI().equals((Object)FunctionRegistry.COUNT)) {
            return;
        }
        GraphPatternGroup whereClause = queryBase.getWhereClause();
        if (whereClause == null || whereClause.arity() != 1) {
            return;
        }
        if (!(whereClause.get(0) instanceof StatementPatternNode)) {
            return;
        }
        StatementPatternNode sp = (StatementPatternNode)whereClause.get(0);
        if (context.getAbstractTripleStore().isQuads()) {
            Boolean isDistinct;
            Map<String, Object> scalarValues;
            DatasetNode dataset = sa.getQueryRoot().getDataset();
            boolean ok = false;
            if (dataset == null || dataset.getNamedGraphs() == null) {
                ok = true;
            }
            if (sp.getScope() == StatementPattern.Scope.DEFAULT_CONTEXTS && (scalarValues = functionNode.getScalarValues()) != null && (isDistinct = (Boolean)scalarValues.get(AggregateBase.Annotations.DISTINCT)) != null && isDistinct.booleanValue()) {
                ok = false;
            }
            if (!ok) {
                return;
            }
        }
        boolean isCountStar = false;
        if (functionNode.arity() == 1 && functionNode.get(0) instanceof VarNode && ((VarNode)functionNode.get(0)).isWildcard()) {
            isCountStar = true;
        }
        if (!isCountStar && functionNode.arity() == context.getAbstractTripleStore().getSPOKeyArity()) {
            ValueExpressionNode arg;
            Set<IVariable<?>> boundVars = sp.getProducedBindings();
            for (int i = 0; i < functionNode.arity() && (arg = (ValueExpressionNode)functionNode.get(i)) instanceof VarNode; ++i) {
                boundVars.remove(((VarNode)arg).getValueExpression());
            }
            if (boundVars.isEmpty()) {
                isCountStar = true;
            }
        }
        if (!isCountStar) {
            return;
        }
        VarNode theVar = assignmentNode.getVarNode();
        sp.setFastRangeCount(theVar);
        sp.setProperty(AST2BOpBase.Annotations.ESTIMATED_CARDINALITY, 1L);
        ProjectionNode newProjection = new ProjectionNode();
        newProjection.addProjectionVar(theVar);
        queryBase.setProjection(newProjection);
    }
}

