/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.optimizers;

import com.bigdata.bop.BOp;
import com.bigdata.bop.IBindingSet;
import com.bigdata.rdf.sparql.ast.GraphPatternGroup;
import com.bigdata.rdf.sparql.ast.GroupNodeBase;
import com.bigdata.rdf.sparql.ast.IQueryNode;
import com.bigdata.rdf.sparql.ast.JoinGroupNode;
import com.bigdata.rdf.sparql.ast.NamedSubqueriesNode;
import com.bigdata.rdf.sparql.ast.NamedSubqueryRoot;
import com.bigdata.rdf.sparql.ast.QueryBase;
import com.bigdata.rdf.sparql.ast.QueryRoot;
import com.bigdata.rdf.sparql.ast.UnionNode;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpContext;
import com.bigdata.rdf.sparql.ast.optimizers.IASTOptimizer;
import java.util.LinkedList;

public class ASTFlattenUnionsOptimizer
implements IASTOptimizer {
    @Override
    public IQueryNode optimize(AST2BOpContext context, IQueryNode queryNode, IBindingSet[] bindingSets) {
        if (!(queryNode instanceof QueryRoot)) {
            return queryNode;
        }
        QueryRoot queryRoot = (QueryRoot)queryNode;
        GraphPatternGroup whereClause = queryRoot.getWhereClause();
        if (whereClause != null) {
            ASTFlattenUnionsOptimizer.flattenUnions(whereClause);
        }
        if (queryRoot.getNamedSubqueries() != null) {
            NamedSubqueriesNode namedSubqueries = queryRoot.getNamedSubqueries();
            for (int i = 0; i < namedSubqueries.size(); ++i) {
                NamedSubqueryRoot namedSubquery = (NamedSubqueryRoot)namedSubqueries.get(i);
                GraphPatternGroup whereClause2 = namedSubquery.getWhereClause();
                if (whereClause2 == null) continue;
                ASTFlattenUnionsOptimizer.flattenUnions(whereClause2);
            }
        }
        return queryNode;
    }

    private static void flattenUnions(GroupNodeBase<?> op) {
        if (op instanceof UnionNode) {
            UnionNode thisUnion = (UnionNode)op;
            LinkedList<JoinGroupNode> childrenToRemove = new LinkedList<JoinGroupNode>();
            for (int i = 0; i < op.arity(); ++i) {
                JoinGroupNode directChild = (JoinGroupNode)op.get(i);
                if (directChild.arity() != 1 || !(directChild.get(0) instanceof UnionNode)) continue;
                UnionNode childUnion = (UnionNode)directChild.get(0);
                for (int j = 0; j < childUnion.arity(); ++j) {
                    JoinGroupNode childToLift = (JoinGroupNode)childUnion.get(j);
                    thisUnion.addChild(childToLift);
                    childrenToRemove.add(directChild);
                }
            }
            for (JoinGroupNode directChild : childrenToRemove) {
                thisUnion.removeChild(directChild);
            }
        }
        for (int i = 0; i < op.arity(); ++i) {
            BOp child = op.get(i);
            if (child instanceof GroupNodeBase) {
                GroupNodeBase childGroup = (GroupNodeBase)child;
                ASTFlattenUnionsOptimizer.flattenUnions(childGroup);
                continue;
            }
            if (!(child instanceof QueryBase)) continue;
            QueryBase subquery = (QueryBase)child;
            GraphPatternGroup childGroup = subquery.getWhereClause();
            ASTFlattenUnionsOptimizer.flattenUnions(childGroup);
        }
    }
}

