/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.optimizers;

import com.bigdata.bop.BOpUtility;
import com.bigdata.bop.IBindingSet;
import com.bigdata.rdf.sparql.ast.IQueryNode;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpContext;
import com.bigdata.rdf.sparql.ast.optimizers.IASTOptimizer;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.log4j.Logger;

public class ASTOptimizerList
extends LinkedList<IASTOptimizer>
implements IASTOptimizer {
    private static final Logger log = Logger.getLogger(ASTOptimizerList.class);
    private static final long serialVersionUID = 1L;

    public ASTOptimizerList(Collection<IASTOptimizer> c) {
        super(c);
    }

    public ASTOptimizerList(IASTOptimizer ... optimizers) {
        this((Collection<IASTOptimizer>)Arrays.asList(optimizers));
    }

    @Override
    public boolean add(IASTOptimizer opt) {
        if (opt == null) {
            throw new IllegalArgumentException();
        }
        if (opt == this) {
            throw new IllegalArgumentException();
        }
        return super.add(opt);
    }

    @Override
    public IQueryNode optimize(AST2BOpContext context, IQueryNode queryNode, IBindingSet[] bindingSets) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Original AST:\n" + queryNode));
        }
        queryNode = BOpUtility.deepCopy(queryNode);
        for (IASTOptimizer opt : this) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Applying: " + opt));
            }
            if ((queryNode = opt.optimize(context, queryNode, bindingSets)) == null) {
                throw new AssertionError((Object)("Optimized discarded query: " + opt));
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Rewritten AST:\n" + queryNode));
        }
        return queryNode;
    }
}

