/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.optimizers;

import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IValueExpression;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.constraints.RangeBOp;
import com.bigdata.rdf.sparql.ast.FilterNode;
import com.bigdata.rdf.sparql.ast.FunctionNode;
import com.bigdata.rdf.sparql.ast.FunctionRegistry;
import com.bigdata.rdf.sparql.ast.GlobalAnnotations;
import com.bigdata.rdf.sparql.ast.IQueryNode;
import com.bigdata.rdf.sparql.ast.JoinGroupNode;
import com.bigdata.rdf.sparql.ast.RangeNode;
import com.bigdata.rdf.sparql.ast.StatementPatternNode;
import com.bigdata.rdf.sparql.ast.StaticAnalysis;
import com.bigdata.rdf.sparql.ast.ValueExpressionNode;
import com.bigdata.rdf.sparql.ast.VarNode;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpContext;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpUtility;
import com.bigdata.rdf.sparql.ast.optimizers.AbstractJoinGroupOptimizer;
import com.bigdata.rdf.sparql.ast.optimizers.IASTOptimizer;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.openrdf.model.URI;

public class ASTRangeOptimizer
extends AbstractJoinGroupOptimizer
implements IASTOptimizer {
    private static final transient Logger log = Logger.getLogger(ASTRangeOptimizer.class);

    public ASTRangeOptimizer() {
        super(false, true);
    }

    @Override
    protected void optimizeJoinGroup(AST2BOpContext ctx, StaticAnalysis sa, IBindingSet[] bSets, JoinGroupNode group) {
        boolean rangeSafe = false;
        for (IQueryNode node : group) {
            if (!(node instanceof StatementPatternNode)) continue;
            StatementPatternNode sp = (StatementPatternNode)node;
            rangeSafe |= sp.getQueryHintAsBoolean("rangeSafe", false);
        }
        if (!rangeSafe) {
            return;
        }
        LinkedHashMap<VarNode, RangeNode> ranges = new LinkedHashMap<VarNode, RangeNode>();
        for (IQueryNode node : group) {
            if (!(node instanceof FilterNode)) continue;
            FilterNode filter = (FilterNode)node;
            if (log.isDebugEnabled()) {
                log.debug((Object)filter);
            }
            if (!(filter.getValueExpressionNode() instanceof FunctionNode)) continue;
            FunctionNode function = (FunctionNode)filter.getValueExpressionNode();
            if (log.isDebugEnabled()) {
                log.debug((Object)function);
            }
            this.processFunction(function, ranges);
        }
        if (ranges.isEmpty()) {
            return;
        }
        GlobalAnnotations globals = new GlobalAnnotations(ctx.getLexiconNamespace(), ctx.getTimestamp());
        for (IQueryNode node : group) {
            VarNode v;
            StatementPatternNode sp;
            if (!(node instanceof StatementPatternNode) || !(sp = (StatementPatternNode)node).getQueryHintAsBoolean("rangeSafe", false) || !sp.o().isVariable() || !ranges.containsKey(v = (VarNode)sp.o())) continue;
            RangeNode range = (RangeNode)ranges.get(v);
            RangeBOp bop = ASTRangeOptimizer.toRangeBOp(range, globals);
            if (log.isDebugEnabled()) {
                log.debug((Object)("attaching a range:\n" + range + "\n to statement pattern: " + sp));
            }
            range.setRangeBOp(bop);
            sp.setRange(range);
        }
    }

    public static RangeBOp toRangeBOp(RangeNode range, GlobalAnnotations globals) {
        ValueExpressionNode to;
        RangeBOp bop = new RangeBOp();
        ValueExpressionNode from = range.from();
        if (from != null) {
            IValueExpression<? extends IV> ve = AST2BOpUtility.toVE(globals, from);
            bop.setFrom(ve);
        }
        if ((to = range.to()) != null) {
            IValueExpression<? extends IV> ve = AST2BOpUtility.toVE(globals, to);
            bop.setTo(ve);
        }
        return bop;
    }

    private void processFunction(FunctionNode function, Map<VarNode, RangeNode> ranges) {
        URI uri = function.getFunctionURI();
        if (uri.equals((Object)FunctionRegistry.AND)) {
            ValueExpressionNode right;
            ValueExpressionNode left = (ValueExpressionNode)function.get(0);
            if (left instanceof FunctionNode) {
                this.processFunction((FunctionNode)left, ranges);
            }
            if ((right = (ValueExpressionNode)function.get(1)) instanceof FunctionNode) {
                this.processFunction((FunctionNode)right, ranges);
            }
        } else if (uri.equals((Object)FunctionRegistry.GT) || uri.equals((Object)FunctionRegistry.GE)) {
            ValueExpressionNode left = (ValueExpressionNode)function.get(0);
            ValueExpressionNode right = (ValueExpressionNode)function.get(1);
            if (left instanceof VarNode) {
                this.addLowerBound((VarNode)left, right, ranges);
            }
            if (right instanceof VarNode) {
                this.addUpperBound((VarNode)right, left, ranges);
            }
        } else if (uri.equals((Object)FunctionRegistry.LT) || uri.equals((Object)FunctionRegistry.LE)) {
            ValueExpressionNode left = (ValueExpressionNode)function.get(0);
            ValueExpressionNode right = (ValueExpressionNode)function.get(1);
            if (left instanceof VarNode) {
                this.addUpperBound((VarNode)left, right, ranges);
            }
            if (right instanceof VarNode) {
                this.addLowerBound((VarNode)right, left, ranges);
            }
        }
    }

    private void addUpperBound(VarNode var, ValueExpressionNode ve, Map<VarNode, RangeNode> ranges) {
        ValueExpressionNode to;
        RangeNode range = ranges.get(var);
        if (range == null) {
            range = new RangeNode(var);
            ranges.put(var, range);
        }
        to = (to = range.to()) == null ? (ValueExpressionNode)ve.clone() : FunctionNode.MIN(to, ve);
        range.setTo(to);
    }

    private void addLowerBound(VarNode var, ValueExpressionNode ve, Map<VarNode, RangeNode> ranges) {
        ValueExpressionNode from;
        RangeNode range = ranges.get(var);
        if (range == null) {
            range = new RangeNode(var);
            ranges.put(var, range);
        }
        from = (from = range.from()) == null ? (ValueExpressionNode)ve.clone() : FunctionNode.MAX(from, ve);
        range.setFrom(from);
    }
}

