/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.optimizers;

import com.bigdata.bop.BOp;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstant;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.bindingSet.ListBindingSet;
import com.bigdata.rdf.sparql.ast.ArbitraryLengthPathNode;
import com.bigdata.rdf.sparql.ast.ConstantNode;
import com.bigdata.rdf.sparql.ast.FilterNode;
import com.bigdata.rdf.sparql.ast.GraphPatternGroup;
import com.bigdata.rdf.sparql.ast.IGroupMemberNode;
import com.bigdata.rdf.sparql.ast.IQueryNode;
import com.bigdata.rdf.sparql.ast.IValueExpressionNode;
import com.bigdata.rdf.sparql.ast.JoinGroupNode;
import com.bigdata.rdf.sparql.ast.NamedSubqueriesNode;
import com.bigdata.rdf.sparql.ast.NamedSubqueryRoot;
import com.bigdata.rdf.sparql.ast.QueryBase;
import com.bigdata.rdf.sparql.ast.QueryRoot;
import com.bigdata.rdf.sparql.ast.StaticAnalysis;
import com.bigdata.rdf.sparql.ast.SubqueryFunctionNodeBase;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpContext;
import com.bigdata.rdf.sparql.ast.optimizers.IASTOptimizer;
import com.bigdata.rdf.sparql.ast.service.ServiceNode;
import java.util.Iterator;

public abstract class AbstractJoinGroupOptimizer
implements IASTOptimizer {
    private final boolean childFirst;
    private final boolean optimizeServiceNodes;

    public AbstractJoinGroupOptimizer() {
        this(false, false);
    }

    protected AbstractJoinGroupOptimizer(boolean childFirst, boolean optimizeServiceNodes) {
        this.childFirst = childFirst;
        this.optimizeServiceNodes = optimizeServiceNodes;
    }

    @Override
    public IQueryNode optimize(AST2BOpContext context, IQueryNode queryNode, IBindingSet[] bindingSets) {
        if (!(queryNode instanceof QueryRoot)) {
            return queryNode;
        }
        QueryRoot queryRoot = (QueryRoot)queryNode;
        StaticAnalysis sa = new StaticAnalysis(queryRoot, context);
        GraphPatternGroup whereClause = queryRoot.getWhereClause();
        if (whereClause != null) {
            this.optimize(context, sa, bindingSets, whereClause);
        }
        if (queryRoot.getNamedSubqueries() != null) {
            NamedSubqueriesNode namedSubqueries = queryRoot.getNamedSubqueries();
            for (NamedSubqueryRoot namedSubquery : namedSubqueries) {
                GraphPatternGroup whereClause2 = namedSubquery.getWhereClause();
                if (whereClause2 == null) continue;
                this.optimize(context, sa, bindingSets, whereClause2);
            }
        }
        return queryNode;
    }

    private void optimize(AST2BOpContext ctx, StaticAnalysis sa, IBindingSet[] bSets, GraphPatternGroup<?> op) {
        if (!this.childFirst && op instanceof JoinGroupNode) {
            JoinGroupNode joinGroup = (JoinGroupNode)op;
            this.optimizeJoinGroup(ctx, sa, bSets, joinGroup);
        }
        for (int i = 0; i < op.arity(); ++i) {
            GraphPatternGroup<IGroupMemberNode> childGroup;
            BOp child = op.get(i);
            if (child instanceof GraphPatternGroup) {
                GraphPatternGroup childGroup2 = (GraphPatternGroup)child;
                this.optimize(ctx, sa, bSets, childGroup2);
                continue;
            }
            if (child instanceof QueryBase) {
                QueryBase subquery = (QueryBase)child;
                childGroup = subquery.getWhereClause();
                this.optimize(ctx, sa, bSets, childGroup);
                continue;
            }
            if (child instanceof FilterNode) {
                FilterNode filter = (FilterNode)child;
                IValueExpressionNode ve = filter.getValueExpressionNode();
                this.optimize(ctx, sa, bSets, ve);
                continue;
            }
            if (child instanceof ArbitraryLengthPathNode) {
                IBindingSet[] bSets2;
                ArbitraryLengthPathNode alpNode = (ArbitraryLengthPathNode)child;
                ListBindingSet bs = new ListBindingSet();
                if (alpNode.left().isConstant()) {
                    bs.set((IVariable)alpNode.tVarLeft().getValueExpression(), (IConstant)((ConstantNode)alpNode.left()).getValueExpression());
                }
                if (alpNode.right().isConstant()) {
                    bs.set((IVariable)alpNode.tVarRight().getValueExpression(), (IConstant)((ConstantNode)alpNode.right()).getValueExpression());
                }
                if (bSets == null || bSets.length == 0 || bSets.length == 1 && bSets[0].isEmpty()) {
                    bSets2 = new IBindingSet[]{bs};
                } else {
                    bSets2 = new IBindingSet[bSets.length + 1];
                    bSets2[0] = bs;
                    System.arraycopy(bSets, 0, bSets2, 1, bSets.length);
                }
                this.optimize(ctx, sa, bSets2, alpNode.subgroup());
                continue;
            }
            if (!(child instanceof ServiceNode) || !this.optimizeServiceNodes) continue;
            ServiceNode serviceNode = (ServiceNode)child;
            childGroup = serviceNode.getGraphPattern();
            this.optimize(ctx, sa, bSets, childGroup);
        }
        if (this.childFirst && op instanceof JoinGroupNode) {
            JoinGroupNode joinGroup = (JoinGroupNode)op;
            this.optimizeJoinGroup(ctx, sa, bSets, joinGroup);
        }
    }

    private void optimize(AST2BOpContext ctx, StaticAnalysis sa, IBindingSet[] bSets, IValueExpressionNode ve) {
        if (ve instanceof SubqueryFunctionNodeBase) {
            SubqueryFunctionNodeBase subqueryFunction = (SubqueryFunctionNodeBase)ve;
            GraphPatternGroup<IGroupMemberNode> graphPattern = subqueryFunction.getGraphPattern();
            if (graphPattern != null) {
                this.optimize(ctx, sa, bSets, graphPattern);
            }
        } else {
            Iterator<BOp> it = ((BOp)((Object)ve)).argIterator();
            while (it.hasNext()) {
                BOp b = it.next();
                if (!(b instanceof IValueExpressionNode)) continue;
                this.optimize(ctx, sa, bSets, (IValueExpressionNode)((Object)b));
            }
        }
    }

    protected abstract void optimizeJoinGroup(AST2BOpContext var1, StaticAnalysis var2, IBindingSet[] var3, JoinGroupNode var4);
}

