/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.optimizers;

import com.bigdata.bop.IBindingSet;
import com.bigdata.rdf.sparql.ast.IQueryNode;
import com.bigdata.rdf.sparql.ast.QueryRoot;
import com.bigdata.rdf.sparql.ast.QueryType;
import com.bigdata.rdf.sparql.ast.SliceNode;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpContext;
import com.bigdata.rdf.sparql.ast.optimizers.IASTOptimizer;

public class AskOptimizer
implements IASTOptimizer {
    @Override
    public IQueryNode optimize(AST2BOpContext context, IQueryNode queryNode, IBindingSet[] bindingSet) {
        QueryRoot queryRoot = (QueryRoot)queryNode;
        if (queryRoot.getQueryType() != QueryType.ASK) {
            return queryRoot;
        }
        if (queryRoot.getGroupBy() != null && !queryRoot.getGroupBy().isEmpty()) {
            return queryRoot;
        }
        if (queryRoot.getHaving() != null && !queryRoot.getHaving().isEmpty()) {
            return queryRoot;
        }
        SliceNode slice = queryRoot.getSlice();
        if (slice == null) {
            slice = new SliceNode();
            queryRoot.setSlice(slice);
        }
        if (slice.getLimit() > 1L) {
            slice.setLimit(1L);
        }
        return queryRoot;
    }
}

