/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.service;

import com.bigdata.bop.Constant;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstant;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.IVariableOrConstant;
import com.bigdata.bop.Var;
import com.bigdata.bop.bindingSet.ListBindingSet;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.NotMaterializedException;
import com.bigdata.rdf.lexicon.LexiconRelation;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.sail.BigdataValueReplacer;
import com.bigdata.rdf.store.AbstractTripleStore;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.openrdf.query.Binding;
import org.openrdf.query.BindingSet;
import org.openrdf.query.impl.MapBindingSet;

public class ServiceCallUtility {
    private static final String ERR_NOT_BOUND = "Service reference variable is not bound";
    private static final String ERR_NOT_URI = "Service reference does not evaluate to a URI";
    private static final String ERR_NOT_MATERIALIZED = "Service reference is not materialized";

    public static BigdataURI getConstantServiceURI(IVariableOrConstant<?> serviceRef) {
        if (serviceRef.isVar()) {
            return null;
        }
        IV serviceRefIV = (IV)((IConstant)serviceRef).get();
        if (!serviceRefIV.isURI()) {
            throw new RuntimeException(ERR_NOT_URI);
        }
        if (!serviceRefIV.hasValue()) {
            throw new NotMaterializedException(ERR_NOT_MATERIALIZED);
        }
        BigdataURI serviceURI = (BigdataURI)serviceRefIV.getValue();
        return serviceURI;
    }

    public static BigdataURI getServiceURI(IVariableOrConstant<?> serviceRef, IBindingSet bset) {
        IV serviceRefIV = (IV)serviceRef.get(bset);
        if (serviceRefIV == null) {
            throw new RuntimeException(ERR_NOT_BOUND);
        }
        if (!serviceRefIV.isURI()) {
            throw new RuntimeException(ERR_NOT_URI);
        }
        if (!serviceRefIV.hasValue()) {
            throw new NotMaterializedException(ERR_NOT_MATERIALIZED);
        }
        BigdataURI serviceURI = (BigdataURI)serviceRefIV.getValue();
        return serviceURI;
    }

    public static BindingSet bigdata2Openrdf(LexiconRelation lex, Set<IVariable<?>> vars, IBindingSet in) {
        MapBindingSet out = new MapBindingSet();
        Iterator<Map.Entry<IVariable, IConstant>> itr = in.iterator();
        while (itr.hasNext()) {
            Object value;
            Map.Entry<IVariable, IConstant> e = itr.next();
            IVariable var = e.getKey();
            if (vars != null && !vars.contains(var)) continue;
            String name = var.getName();
            IV iv = (IV)e.getValue().get();
            if (iv.isInline()) {
                value = iv.asValue(lex);
            } else {
                try {
                    value = iv.getValue();
                }
                catch (NotMaterializedException ex) {
                    throw new NotMaterializedException("var=" + name + ", val=" + iv, ex);
                }
            }
            out.addBinding(name, value);
        }
        return out;
    }

    private static IBindingSet openrdf2Bigdata(Set<IVariable<?>> vars, BindingSet in) {
        ListBindingSet out = new ListBindingSet();
        for (Binding e : in) {
            String name = e.getName();
            Var var = Var.var(name);
            if (vars != null && !vars.contains(var)) continue;
            BigdataValue value = (BigdataValue)e.getValue();
            IV iv = value.getIV();
            if (iv == null) {
                throw new AssertionError();
            }
            if (!iv.hasValue()) {
                throw new AssertionError();
            }
            if (iv.getValue() != value) {
                throw new AssertionError();
            }
            out.set(var, new Constant<IV>(iv));
        }
        return out;
    }

    public static BindingSet[] convert(LexiconRelation lex, Set<IVariable<?>> projectedVars, IBindingSet[] in) {
        BindingSet[] out = new BindingSet[in.length];
        for (int i = 0; i < in.length; ++i) {
            out[i] = ServiceCallUtility.bigdata2Openrdf(lex, projectedVars, in[i]);
        }
        return out;
    }

    public static IBindingSet[] resolve(AbstractTripleStore db, BindingSet[] serviceResults) {
        Object[] b = new BigdataValueReplacer(db).replaceValues(null, serviceResults);
        BindingSet[] resolvedServiceResults = (BindingSet[])b[1];
        IBindingSet[] bigdataSolutions = new IBindingSet[resolvedServiceResults.length];
        for (int i = 0; i < resolvedServiceResults.length; ++i) {
            IBindingSet bset2;
            BindingSet bset = resolvedServiceResults[i];
            bigdataSolutions[i] = bset2 = ServiceCallUtility.openrdf2Bigdata(null, bset);
        }
        return bigdataSolutions;
    }
}

