/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.service;

import com.bigdata.rdf.graph.impl.bd.GASService;
import com.bigdata.rdf.sparql.ast.eval.SampleServiceFactory;
import com.bigdata.rdf.sparql.ast.eval.SearchInSearchServiceFactory;
import com.bigdata.rdf.sparql.ast.eval.SearchServiceFactory;
import com.bigdata.rdf.sparql.ast.eval.SliceServiceFactory;
import com.bigdata.rdf.sparql.ast.eval.ValuesServiceFactory;
import com.bigdata.rdf.sparql.ast.service.CustomServiceFactory;
import com.bigdata.rdf.sparql.ast.service.IServiceOptions;
import com.bigdata.rdf.sparql.ast.service.RemoteServiceFactoryImpl;
import com.bigdata.rdf.sparql.ast.service.ServiceCall;
import com.bigdata.rdf.sparql.ast.service.ServiceCallCreateParams;
import com.bigdata.rdf.sparql.ast.service.ServiceFactory;
import com.bigdata.rdf.sparql.ast.service.ServiceNode;
import com.bigdata.rdf.sparql.ast.service.history.HistoryServiceFactory;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.store.BDS;
import cutthecrap.utils.striterators.ReadOnlyIterator;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.client.HttpClient;
import org.openrdf.model.URI;
import org.openrdf.model.impl.URIImpl;

public class ServiceRegistry {
    private static final ServiceRegistry DEFAULT = new ServiceRegistry();
    private final ConcurrentMap<URI, ServiceFactory> services = new ConcurrentHashMap<URI, ServiceFactory>();
    private final ConcurrentMap<URI, URI> aliases;
    private final CopyOnWriteArrayList<CustomServiceFactory> customServices = new CopyOnWriteArrayList();
    private AtomicReference<ServiceFactory> defaultServiceFactoryRef;

    public static ServiceRegistry getInstance() {
        return DEFAULT;
    }

    protected ServiceRegistry() {
        this.aliases = new ConcurrentHashMap<URI, URI>();
        this.defaultServiceFactoryRef = new AtomicReference<RemoteServiceFactoryImpl>(new RemoteServiceFactoryImpl(true));
        this.add(BDS.SEARCH, new SearchServiceFactory());
        this.add(BDS.SEARCH_IN_SEARCH, new SearchInSearchServiceFactory());
        this.add(SampleServiceFactory.SERVICE_KEY, new SampleServiceFactory());
        this.add(SliceServiceFactory.SERVICE_KEY, new SliceServiceFactory());
        this.add(ValuesServiceFactory.SERVICE_KEY, new ValuesServiceFactory());
        this.add((URI)new URIImpl("http://www.bigdata.com/rdf#history"), new HistoryServiceFactory());
        this.add(GASService.Options.SERVICE_KEY, new GASService());
    }

    public void setDefaultServiceFactory(ServiceFactory defaultServiceFactory) {
        if (defaultServiceFactory == null) {
            throw new IllegalArgumentException();
        }
        this.defaultServiceFactoryRef.set(defaultServiceFactory);
    }

    public ServiceFactory getDefaultServiceFactory() {
        return this.defaultServiceFactoryRef.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void add(URI serviceURI, ServiceFactory factory) {
        ServiceRegistry serviceRegistry = this;
        synchronized (serviceRegistry) {
            if (this.aliases.containsKey(serviceURI)) {
                throw new UnsupportedOperationException("Already declared.");
            }
            if (this.services.putIfAbsent(serviceURI, factory) != null) {
                throw new UnsupportedOperationException("Already declared.");
            }
            if (factory instanceof CustomServiceFactory) {
                this.customServices.add((CustomServiceFactory)factory);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean remove(URI serviceURI) {
        boolean modified = false;
        ServiceRegistry serviceRegistry = this;
        synchronized (serviceRegistry) {
            ServiceFactory factory;
            if (this.aliases.remove(serviceURI) != null) {
                modified = true;
            }
            if ((factory = (ServiceFactory)this.services.remove(serviceURI)) != null) {
                modified = true;
                if (factory instanceof CustomServiceFactory) {
                    this.customServices.remove(factory);
                }
            }
        }
        return modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addAlias(URI serviceURI, URI aliasURI) {
        if (serviceURI == null) {
            throw new IllegalArgumentException();
        }
        if (aliasURI == null) {
            throw new IllegalArgumentException();
        }
        ServiceRegistry serviceRegistry = this;
        synchronized (serviceRegistry) {
            if (this.services.containsKey(aliasURI)) {
                throw new IllegalStateException("Alias already registered as service: uri=" + aliasURI);
            }
            if (this.aliases.containsKey(aliasURI)) {
                throw new IllegalStateException("Alias already registered: uri=" + aliasURI);
            }
            this.aliases.put(aliasURI, serviceURI);
        }
    }

    public Iterator<CustomServiceFactory> customServices() {
        return new ReadOnlyIterator<CustomServiceFactory>(this.customServices.iterator());
    }

    public ServiceFactory get(URI serviceURI) {
        if (serviceURI == null) {
            throw new IllegalArgumentException();
        }
        URI alias = (URI)this.aliases.get(serviceURI);
        if (alias != null) {
            return (ServiceFactory)this.services.get(alias);
        }
        return (ServiceFactory)this.services.get(serviceURI);
    }

    public final ServiceCall<? extends Object> toServiceCall(AbstractTripleStore store, HttpClient cm, URI serviceURI, ServiceNode serviceNode) {
        ServiceFactory f;
        if (serviceURI == null) {
            throw new IllegalArgumentException();
        }
        URI dealiasedServiceURI = (URI)this.aliases.get(serviceURI);
        if (dealiasedServiceURI != null) {
            serviceURI = dealiasedServiceURI;
        }
        if ((f = (ServiceFactory)this.services.get(serviceURI)) == null && (f = this.getDefaultServiceFactory()) == null) {
            throw new AssertionError();
        }
        ServiceCallCreateParamsImpl params = new ServiceCallCreateParamsImpl(serviceURI, store, serviceNode, cm, f.getServiceOptions());
        return f.create(params);
    }

    private static class ServiceCallCreateParamsImpl
    implements ServiceCallCreateParams {
        private final URI serviceURI;
        private final AbstractTripleStore store;
        private final ServiceNode serviceNode;
        private final HttpClient cm;
        private final IServiceOptions serviceOptions;

        public ServiceCallCreateParamsImpl(URI serviceURI, AbstractTripleStore store, ServiceNode serviceNode, HttpClient cm, IServiceOptions serviceOptions) {
            this.serviceURI = serviceURI;
            this.store = store;
            this.serviceNode = serviceNode;
            this.cm = cm;
            this.serviceOptions = serviceOptions;
        }

        @Override
        public URI getServiceURI() {
            return this.serviceURI;
        }

        @Override
        public AbstractTripleStore getTripleStore() {
            return this.store;
        }

        @Override
        public ServiceNode getServiceNode() {
            return this.serviceNode;
        }

        @Override
        public HttpClient getClientConnectionManager() {
            return this.cm;
        }

        @Override
        public IServiceOptions getServiceOptions() {
            return this.serviceOptions;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getClass().getName());
            sb.append("{serviceURI=" + this.getServiceURI());
            sb.append(",serviceNode=" + this.getServiceNode());
            sb.append(",serviceOptions=" + this.getServiceOptions());
            sb.append(",tripleStore=" + this.getTripleStore());
            sb.append(",clientConnectionManager=" + this.getClientConnectionManager());
            sb.append("}");
            return sb.toString();
        }
    }
}

