/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.spo;

import com.bigdata.bop.BOp;
import com.bigdata.bop.Constant;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstant;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.IVariableOrConstant;
import com.bigdata.bop.Var;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.IVUtility;
import com.bigdata.rdf.spo.ISPO;
import com.bigdata.rdf.spo.SPOPredicate;
import com.bigdata.relation.rule.IStarJoin;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public class SPOStarJoin
extends SPOPredicate
implements IStarJoin<ISPO>,
Serializable {
    private static final long serialVersionUID = 981603459301801862L;
    private final Collection<IStarJoin.IStarConstraint<ISPO>> starConstraints;

    public SPOStarJoin(BOp[] values, Map<String, Object> annotations) {
        super(values, annotations);
        this.starConstraints = new LinkedList<IStarJoin.IStarConstraint<ISPO>>();
    }

    public SPOStarJoin(SPOStarJoin op) {
        super(op);
        this.starConstraints = new LinkedList<IStarJoin.IStarConstraint<ISPO>>();
    }

    public SPOStarJoin(SPOPredicate pred) {
        BOp[] bOpArray;
        if (pred.arity() == 3) {
            BOp[] bOpArray2 = new BOp[3];
            bOpArray2[0] = pred.s();
            bOpArray2[1] = Var.var();
            bOpArray = bOpArray2;
            bOpArray2[2] = Var.var();
        } else {
            BOp[] bOpArray3 = new BOp[4];
            bOpArray3[0] = pred.s();
            bOpArray3[1] = Var.var();
            bOpArray3[2] = Var.var();
            bOpArray = bOpArray3;
            bOpArray3[3] = pred.c();
        }
        super(bOpArray, SPOStarJoin.deepCopy(pred.annotations()));
        this.starConstraints = new LinkedList<IStarJoin.IStarConstraint<ISPO>>();
    }

    @Override
    public void addStarConstraint(IStarJoin.IStarConstraint<ISPO> constraint) {
        this.starConstraints.add(constraint);
    }

    @Override
    public Iterator<IStarJoin.IStarConstraint<ISPO>> getStarConstraints() {
        return this.starConstraints.iterator();
    }

    @Override
    public int getNumStarConstraints() {
        return this.starConstraints.size();
    }

    @Override
    public Iterator<IVariable> getConstraintVariables() {
        HashSet<IVariable> vars = new HashSet<IVariable>();
        for (IStarJoin.IStarConstraint<ISPO> constraint : this.starConstraints) {
            if (((SPOStarConstraint)constraint).p.isVar()) {
                vars.add((IVariable)((SPOStarConstraint)constraint).p);
            }
            if (!((SPOStarConstraint)constraint).o.isVar()) continue;
            vars.add((IVariable)((SPOStarConstraint)constraint).o);
        }
        return vars.iterator();
    }

    @Override
    public SPOPredicate asBound(IBindingSet bindingSet) {
        SPOStarJoin starJoin = (SPOStarJoin)super.asBound(bindingSet);
        for (IStarJoin.IStarConstraint<ISPO> starConstraint : this.starConstraints) {
            starJoin.addStarConstraint(starConstraint.asBound(bindingSet));
        }
        return starJoin;
    }

    @Override
    public String toString(IBindingSet bindingSet) {
        StringBuilder sb = new StringBuilder(super.toString(bindingSet));
        if (this.starConstraints.size() > 0) {
            sb.append("star[");
            for (IStarJoin.IStarConstraint<ISPO> sc : this.starConstraints) {
                sb.append(sc);
                sb.append(",");
            }
            sb.setCharAt(sb.length() - 1, ']');
        }
        return sb.toString();
    }

    public static class SPOStarConstraint
    implements IStarJoin.IStarConstraint<ISPO>,
    Serializable {
        private static final long serialVersionUID = 997244773880938817L;
        protected final IVariableOrConstant<IV> p;
        protected final IVariableOrConstant<IV> o;
        protected final boolean optional;

        public SPOStarConstraint(IVariableOrConstant<IV> p, IVariableOrConstant<IV> o) {
            this(p, o, false);
        }

        public SPOStarConstraint(IVariableOrConstant<IV> p, IVariableOrConstant<IV> o, boolean optional) {
            this.p = p;
            this.o = o;
            this.optional = optional;
        }

        public final IVariableOrConstant<IV> p() {
            return this.p;
        }

        public final IVariableOrConstant<IV> o() {
            return this.o;
        }

        @Override
        public final boolean isOptional() {
            return this.optional;
        }

        @Override
        public final int getNumVars() {
            return (this.p.isVar() ? 1 : 0) + (this.o.isVar() ? 1 : 0);
        }

        @Override
        public final boolean isMatch(ISPO spo) {
            return !(!this.p.isVar() && !IVUtility.equals(this.p.get(), spo.p()) || !this.o.isVar() && !IVUtility.equals(this.o.get(), spo.o()));
        }

        @Override
        public final void bind(IBindingSet bs, ISPO spo) {
            if (this.p.isVar()) {
                bs.set((IVariable)this.p, new Constant<IV>(spo.p()));
            }
            if (this.o.isVar()) {
                bs.set((IVariable)this.o, new Constant<IV>(spo.o()));
            }
        }

        @Override
        public IStarJoin.IStarConstraint<ISPO> asBound(IBindingSet bindingSet) {
            IConstant p = this.p.isVar() && bindingSet.isBound((IVariable)this.p) ? bindingSet.get((IVariable)this.p) : this.p;
            IConstant o = this.o.isVar() && bindingSet.isBound((IVariable)this.o) ? bindingSet.get((IVariable)this.o) : this.o;
            return new SPOStarConstraint(p, o, this.optional);
        }

        public String toString() {
            return this.toString(null);
        }

        public String toString(IBindingSet bindingSet) {
            StringBuilder sb = new StringBuilder();
            sb.append("(");
            sb.append(this.p.isConstant() || bindingSet == null || !bindingSet.isBound((IVariable)this.p) ? this.p.toString() : bindingSet.get((IVariable)this.p));
            sb.append(", ");
            sb.append(this.o.isConstant() || bindingSet == null || !bindingSet.isBound((IVariable)this.o) ? this.o.toString() : bindingSet.get((IVariable)this.o));
            sb.append(")");
            if (this.optional) {
                sb.append("[");
                if (this.optional) {
                    sb.append("optional");
                }
                sb.append("]");
            }
            return sb.toString();
        }
    }

    public static interface Annotations
    extends SPOPredicate.Annotations {
    }
}

