/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.store;

import com.bigdata.bop.BOp;
import com.bigdata.bop.Constant;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstant;
import com.bigdata.bop.IPredicate;
import com.bigdata.bop.NV;
import com.bigdata.bop.Var;
import com.bigdata.bop.bindingSet.ListBindingSet;
import com.bigdata.bop.joinGraph.IEvaluationPlanFactory;
import com.bigdata.bop.joinGraph.fast.DefaultEvaluationPlanFactory2;
import com.bigdata.btree.BytesUtil;
import com.bigdata.btree.IIndex;
import com.bigdata.btree.ITupleIterator;
import com.bigdata.btree.keys.KeyBuilder;
import com.bigdata.btree.keys.SuccessorUtil;
import com.bigdata.journal.IIndexManager;
import com.bigdata.journal.IResourceLock;
import com.bigdata.journal.TimestampUtility;
import com.bigdata.rdf.ServiceProviderHook;
import com.bigdata.rdf.axioms.Axioms;
import com.bigdata.rdf.axioms.BaseAxioms;
import com.bigdata.rdf.axioms.NoAxioms;
import com.bigdata.rdf.axioms.OwlAxioms;
import com.bigdata.rdf.changesets.IChangeLog;
import com.bigdata.rdf.inf.Justification;
import com.bigdata.rdf.inf.JustificationIterator;
import com.bigdata.rdf.internal.DefaultExtensionFactory;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.InlineURIFactory;
import com.bigdata.rdf.internal.NotMaterializedException;
import com.bigdata.rdf.internal.VTE;
import com.bigdata.rdf.internal.constraints.RangeBOp;
import com.bigdata.rdf.internal.impl.BlobIV;
import com.bigdata.rdf.lexicon.BigdataSubjectCentricFullTextIndex;
import com.bigdata.rdf.lexicon.BigdataValueCentricFullTextIndex;
import com.bigdata.rdf.lexicon.LexiconRelation;
import com.bigdata.rdf.model.BigdataResource;
import com.bigdata.rdf.model.BigdataStatement;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.model.BigdataValueFactoryImpl;
import com.bigdata.rdf.rio.StatementBuffer;
import com.bigdata.rdf.rules.BaseClosure;
import com.bigdata.rdf.rules.FastClosure;
import com.bigdata.rdf.rules.InferenceEngine;
import com.bigdata.rdf.rules.MatchRule;
import com.bigdata.rdf.rules.RDFJoinNexusFactory;
import com.bigdata.rdf.rules.RuleContextEnum;
import com.bigdata.rdf.spo.BulkCompleteConverter;
import com.bigdata.rdf.spo.BulkFilterConverter;
import com.bigdata.rdf.spo.ExplicitSPOFilter;
import com.bigdata.rdf.spo.ISPO;
import com.bigdata.rdf.spo.JustificationWriter;
import com.bigdata.rdf.spo.SPO;
import com.bigdata.rdf.spo.SPOKeyOrder;
import com.bigdata.rdf.spo.SPOPredicate;
import com.bigdata.rdf.spo.SPORelation;
import com.bigdata.rdf.spo.SPOTupleSerializer;
import com.bigdata.rdf.spo.StatementWriter;
import com.bigdata.rdf.store.BigdataSolutionResolverator;
import com.bigdata.rdf.store.BigdataStatementIterator;
import com.bigdata.rdf.store.BigdataStatementIteratorImpl;
import com.bigdata.rdf.store.BigdataTriplePattern;
import com.bigdata.rdf.store.BigdataTriplePatternMaterializer;
import com.bigdata.rdf.store.DataLoader;
import com.bigdata.rdf.store.DatabaseMode;
import com.bigdata.rdf.store.IRawTripleStore;
import com.bigdata.rdf.store.ITripleStore;
import com.bigdata.rdf.store.TempTripleStore;
import com.bigdata.rdf.store.TripleStoreSchema;
import com.bigdata.rdf.vocab.BaseVocabulary;
import com.bigdata.rdf.vocab.DefaultBigdataVocabulary;
import com.bigdata.rdf.vocab.NoVocabulary;
import com.bigdata.rdf.vocab.Vocabulary;
import com.bigdata.relation.AbstractResource;
import com.bigdata.relation.IDatabase;
import com.bigdata.relation.IMutableDatabase;
import com.bigdata.relation.IRelation;
import com.bigdata.relation.RelationSchema;
import com.bigdata.relation.accesspath.ElementFilter;
import com.bigdata.relation.accesspath.EmptyAccessPath;
import com.bigdata.relation.accesspath.IAccessPath;
import com.bigdata.relation.accesspath.IElementFilter;
import com.bigdata.relation.locator.DefaultResourceLocator;
import com.bigdata.relation.locator.IResourceLocator;
import com.bigdata.relation.rule.IRule;
import com.bigdata.relation.rule.Program;
import com.bigdata.relation.rule.eval.ActionEnum;
import com.bigdata.relation.rule.eval.DefaultRuleTaskFactory;
import com.bigdata.relation.rule.eval.IJoinNexus;
import com.bigdata.relation.rule.eval.IJoinNexusFactory;
import com.bigdata.relation.rule.eval.IRuleTaskFactory;
import com.bigdata.search.FullTextIndex;
import com.bigdata.service.IBigdataFederation;
import com.bigdata.sparse.GlobalRowStoreUtil;
import com.bigdata.striterator.ChunkedArrayIterator;
import com.bigdata.striterator.ChunkedConvertingIterator;
import com.bigdata.striterator.ChunkedWrappedIterator;
import com.bigdata.striterator.DelegateChunkedIterator;
import com.bigdata.striterator.EmptyChunkedIterator;
import com.bigdata.striterator.IChunkedIterator;
import com.bigdata.striterator.IChunkedOrderedIterator;
import com.bigdata.striterator.IKeyOrder;
import com.bigdata.util.InnerCause;
import com.bigdata.util.PropertyUtil;
import cutthecrap.utils.striterators.ICloseableIterator;
import java.io.Externalizable;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.log4j.Logger;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.vocabulary.OWL;

public abstract class AbstractTripleStore
extends AbstractResource<IDatabase<AbstractTripleStore>>
implements ITripleStore,
IRawTripleStore,
IMutableDatabase<AbstractTripleStore> {
    private static final Logger log = Logger.getLogger(AbstractTripleStore.class);
    private final boolean justify;
    protected final boolean lexicon;
    private final int spoKeyArity;
    private final boolean quads;
    private final boolean statementIdentifiers;
    private final Class<? extends BaseAxioms> axiomClass;
    private final Class<? extends BaseVocabulary> vocabularyClass;
    private final Class<? extends BaseClosure> closureClass;
    private final boolean constrainXXXCShards;
    private final boolean bottomUpEvaluation;
    private volatile BigdataValueFactory valueFactory;
    private boolean open;
    private volatile Axioms axioms;
    private final AtomicReference<Vocabulary> vocabRef;
    private final AtomicReference<SPORelation> spoRelationRef;
    private LexiconRelation lexiconRelation;
    private volatile InferenceEngine inferenceEngine;
    private WeakReference<DataLoader> dataLoaderRef;
    private final Map<String, String> uriToPrefix;

    public final boolean isJustify() {
        return this.justify;
    }

    public final int getSPOKeyArity() {
        return this.spoKeyArity;
    }

    @Override
    public final boolean isQuads() {
        return this.quads;
    }

    public final boolean isStatementIdentifiers() {
        return this.statementIdentifiers;
    }

    public BaseClosure getClosureInstance() {
        try {
            Constructor<? extends BaseClosure> ctor = this.closureClass.getConstructor(AbstractTripleStore.class);
            return ctor.newInstance(this);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isAxiom(IV s, IV p, IV o) {
        return this.getAxioms().isAxiom(s, p, o);
    }

    public boolean getStatementIdentifiers() {
        return this.statementIdentifiers;
    }

    public boolean isInlineLiterals() {
        return this.getLexiconRelation().isInlineLiterals();
    }

    public final boolean isConstrainXXXCShards() {
        return this.constrainXXXCShards;
    }

    public final boolean isBottomUpEvaluation() {
        return this.bottomUpEvaluation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final BigdataValueFactory getValueFactory() {
        if (this.valueFactory == null) {
            if (!this.lexicon) {
                throw new UnsupportedOperationException();
            }
            AbstractTripleStore abstractTripleStore = this;
            synchronized (abstractTripleStore) {
                if (this.valueFactory == null) {
                    this.valueFactory = this.getLexiconRelation().getValueFactory();
                }
            }
        }
        return this.valueFactory;
    }

    @Override
    public Iterator<IRelation> relations() {
        return Collections.unmodifiableList(Arrays.asList(this.getSPORelation(), this.getLexiconRelation())).iterator();
    }

    protected Class determineAxiomClass() {
        Class<?> cls;
        String className = this.getProperty(Options.AXIOMS_CLASS, Options.DEFAULT_AXIOMS_CLASS);
        try {
            cls = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Bad option: " + Options.AXIOMS_CLASS, e);
        }
        if (!BaseAxioms.class.isAssignableFrom(cls)) {
            throw new RuntimeException(Options.AXIOMS_CLASS + ": Must extend: " + BaseAxioms.class.getName());
        }
        if (cls != NoAxioms.class && this.quads) {
            throw new UnsupportedOperationException(Options.QUADS + " does not support inference (" + Options.AXIOMS_CLASS + ")");
        }
        return cls;
    }

    protected Class determineVocabularyClass() {
        Class<?> cls;
        String className = this.getProperty(Options.VOCABULARY_CLASS, Options.DEFAULT_VOCABULARY_CLASS);
        try {
            cls = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Bad option: " + Options.VOCABULARY_CLASS, e);
        }
        if (!BaseVocabulary.class.isAssignableFrom(cls)) {
            throw new RuntimeException(Options.VOCABULARY_CLASS + ": Must extend: " + BaseVocabulary.class.getName());
        }
        return cls;
    }

    protected AbstractTripleStore(IIndexManager indexManager, String namespace, Long timestamp, Properties properties) {
        Class<?> cls;
        block17: {
            block16: {
                super(indexManager, namespace, timestamp, properties);
                this.open = true;
                this.vocabRef = new AtomicReference();
                this.spoRelationRef = new AtomicReference();
                this.inferenceEngine = null;
                this.dataLoaderRef = null;
                this.uriToPrefix = new LinkedHashMap<String, String>();
                ServiceProviderHook.forceLoad();
                this.lexicon = Boolean.parseBoolean(this.getProperty(Options.LEXICON, "true"));
                DatabaseMode mode = null;
                if (Boolean.parseBoolean(this.getProperty(Options.TRIPLES_MODE, "false"))) {
                    mode = DatabaseMode.TRIPLES;
                } else if (Boolean.parseBoolean(this.getProperty(Options.TRIPLES_MODE_WITH_PROVENANCE, "false"))) {
                    if (mode != null) {
                        throw new UnsupportedOperationException("please select only one of triples, provenance, or quads modes");
                    }
                    mode = DatabaseMode.PROVENANCE;
                } else if (Boolean.parseBoolean(this.getProperty(Options.QUADS_MODE, "false"))) {
                    if (mode != null) {
                        throw new UnsupportedOperationException("please select only one of triples, provenance, or quads modes");
                    }
                    mode = DatabaseMode.QUADS;
                }
                this.vocabularyClass = this.lexicon ? this.determineVocabularyClass() : NoVocabulary.class;
                properties.setProperty(Options.VOCABULARY_CLASS, this.vocabularyClass.getName());
                if (mode == null) break block16;
                switch (mode) {
                    case TRIPLES: {
                        this.quads = false;
                        this.statementIdentifiers = false;
                        this.axiomClass = this.determineAxiomClass();
                        properties.setProperty(Options.QUADS, "false");
                        properties.setProperty(Options.STATEMENT_IDENTIFIERS, "false");
                        break block17;
                    }
                    case PROVENANCE: {
                        this.quads = false;
                        this.statementIdentifiers = true;
                        this.axiomClass = this.determineAxiomClass();
                        properties.setProperty(Options.QUADS, "false");
                        properties.setProperty(Options.STATEMENT_IDENTIFIERS, "true");
                        break block17;
                    }
                    case QUADS: {
                        this.quads = true;
                        this.statementIdentifiers = false;
                        this.axiomClass = NoAxioms.class;
                        properties.setProperty(Options.QUADS, "true");
                        properties.setProperty(Options.STATEMENT_IDENTIFIERS, "false");
                        properties.setProperty(Options.AXIOMS_CLASS, NoAxioms.class.getName());
                        break block17;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            }
            this.quads = Boolean.valueOf(this.getProperty(Options.QUADS, "false"));
            this.statementIdentifiers = Boolean.parseBoolean(this.getProperty(Options.STATEMENT_IDENTIFIERS, "false"));
            this.axiomClass = this.lexicon ? this.determineAxiomClass() : NoAxioms.class;
        }
        this.justify = Boolean.parseBoolean(this.getProperty(Options.JUSTIFY, "true"));
        int n = this.spoKeyArity = this.quads ? 4 : 3;
        if (this.statementIdentifiers && this.quads) {
            throw new UnsupportedOperationException(Options.QUADS + " does not support the provenance mode (" + Options.STATEMENT_IDENTIFIERS + ")");
        }
        String className = this.getProperty(Options.CLOSURE_CLASS, Options.DEFAULT_CLOSURE_CLASS);
        try {
            cls = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Bad option: " + Options.CLOSURE_CLASS, e);
        }
        if (!BaseClosure.class.isAssignableFrom(cls)) {
            throw new RuntimeException(Options.CLOSURE_CLASS + ": Must extend: " + BaseClosure.class.getName());
        }
        this.closureClass = cls;
        this.constrainXXXCShards = Boolean.valueOf(this.getProperty(Options.CONSTRAIN_XXXC_SHARDS, "true"));
        this.bottomUpEvaluation = Boolean.valueOf(this.getProperty(Options.BOTTOM_UP_EVALUATION, "true"));
        this.addNamespace("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "rdf");
        this.addNamespace("http://www.w3.org/2000/01/rdf-schema#", "rdfs");
        this.addNamespace("http://www.w3.org/2002/07/owl#", "owl");
        this.addNamespace("http://www.w3.org/2001/XMLSchema#", "xsd");
    }

    public abstract boolean isConcurrent();

    public void __tearDownUnitTest() {
        if (this.isOpen()) {
            this.destroy();
        }
        this.getIndexManager().destroy();
    }

    public boolean isOpen() {
        return this.open;
    }

    @Override
    public void close() {
        this.shutdown();
    }

    protected final void shutdown() {
        this.open = false;
    }

    public abstract boolean isStable();

    @Override
    public AbstractTripleStore init() {
        super.init();
        return this;
    }

    @Override
    public void create() {
        if (log.isInfoEnabled()) {
            log.info((Object)this.toString());
        }
        this.assertWritable();
        IResourceLock resourceLock = this.acquireExclusiveLock();
        try {
            Constructor<Externalizable> ctor;
            String LEXICON_NAMESPACE;
            Properties tmp = PropertyUtil.flatCopy(this.getProperties());
            tmp.setProperty(RelationSchema.CONTAINER, this.getNamespace());
            if (Boolean.valueOf(tmp.getProperty(Options.TEXT_INDEX, "true")).booleanValue()) {
                tmp.setProperty(FullTextIndex.Options.FIELDS_ENABLED, "false");
            }
            String SPO_NAMESPACE = this.getNamespace() + "." + "spo";
            String string = LEXICON_NAMESPACE = this.lexicon ? this.getNamespace() + "." + "lex" : null;
            if (this.lexicon) {
                assert (this.vocabRef.get() == null);
                try {
                    ctor = this.vocabularyClass.getConstructor(String.class);
                    this.vocabRef.set(ctor.newInstance(LEXICON_NAMESPACE));
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
                ((BaseVocabulary)this.vocabRef.get()).init();
                this.lexiconRelation = new LexiconRelation(this, this.getIndexManager(), LEXICON_NAMESPACE, (Long)this.getTimestamp(), new Properties(tmp));
                this.lexiconRelation.create();
                this.valueFactory = this.lexiconRelation.getValueFactory();
            }
            this.spoRelationRef.set(new SPORelation(this, this.getIndexManager(), SPO_NAMESPACE, (Long)this.getTimestamp(), new Properties(tmp)));
            this.spoRelationRef.get().create();
            if (this.lexicon) {
                assert (this.axioms == null);
                try {
                    ctor = this.axiomClass.getConstructor(String.class);
                    this.axioms = (Axioms)((Object)ctor.newInstance(LEXICON_NAMESPACE));
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
                ((BaseAxioms)this.axioms).init(this);
            }
            Map<String, Object> map = GlobalRowStoreUtil.convert(tmp);
            map.put(RelationSchema.NAMESPACE, this.getNamespace());
            if (this.axioms != null) {
                map.put(TripleStoreSchema.AXIOMS, this.axioms);
            }
            if (this.vocabRef.get() != null) {
                map.put(TripleStoreSchema.VOCABULARY, this.vocabRef.get());
            }
            Map<String, Object> afterMap = this.getIndexManager().getGlobalRowStore().write(RelationSchema.INSTANCE, map);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Properties after write: " + afterMap));
            }
            this.commit();
            ((DefaultResourceLocator)this.getIndexManager().getResourceLocator()).putInstance(this);
        }
        catch (Throwable t) {
            if (!InnerCause.isInnerCause(t, InterruptedException.class)) {
                log.error((Object)t, t);
            }
            throw new RuntimeException(t);
        }
        finally {
            this.unlock(resourceLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void destroy() {
        this.assertWritable();
        BigdataValueFactory tmp = this.valueFactory;
        IResourceLock resourceLock = this.acquireExclusiveLock();
        try {
            SPORelation spo;
            if (this.lexicon) {
                LexiconRelation lex = this.getLexiconRelation();
                if (lex != null && lex.getIndexManager() == this.getIndexManager()) {
                    lex.destroy();
                }
                this.lexiconRelation = null;
                this.valueFactory = null;
                this.axioms = null;
                this.vocabRef.set(null);
            }
            if ((spo = this.getSPORelation()) != null) {
                spo.destroy();
            }
            this.spoRelationRef.set(null);
            super.destroy();
            if (this.lexicon && tmp != null) {
                tmp.remove();
            }
        }
        finally {
            this.unlock(resourceLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Axioms getAxioms() {
        if (!this.lexicon) {
            throw new IllegalStateException();
        }
        if (this.axioms == null) {
            AbstractTripleStore abstractTripleStore = this;
            synchronized (abstractTripleStore) {
                if (this.axioms == null) {
                    this.axioms = (Axioms)this.getBareProperties().get(TripleStoreSchema.AXIOMS);
                    if (this.axioms == null) {
                        throw new RuntimeException("No axioms defined? : " + this);
                    }
                    if (log.isInfoEnabled()) {
                        log.info((Object)("read axioms: " + this.axioms.getClass().getName() + ", size=" + this.axioms.size()));
                    }
                }
            }
        }
        return this.axioms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Vocabulary getVocabulary() {
        if (!this.lexicon) {
            throw new IllegalStateException();
        }
        Vocabulary vocab = this.vocabRef.get();
        if (vocab == null) {
            AtomicReference<Vocabulary> atomicReference = this.vocabRef;
            synchronized (atomicReference) {
                vocab = this.vocabRef.get();
                if (vocab == null) {
                    vocab = (Vocabulary)this.getBareProperties().get(TripleStoreSchema.VOCABULARY);
                    if (vocab == null) {
                        throw new RuntimeException("No vocabulary defined? : " + this);
                    }
                    if (log.isInfoEnabled()) {
                        log.info((Object)("read vocabulary: " + vocab.getClass().getName() + ", size=" + vocab.size()));
                    }
                    if (!this.vocabRef.compareAndSet(null, vocab)) {
                        throw new AssertionError();
                    }
                }
            }
        }
        return vocab;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final SPORelation getSPORelation() {
        if (this.spoRelationRef.get() == null) {
            AbstractTripleStore abstractTripleStore = this;
            synchronized (abstractTripleStore) {
                if (this.spoRelationRef.get() == null) {
                    this.spoRelationRef.set((SPORelation)this.getIndexManager().getResourceLocator().locate(this.getNamespace() + "." + "spo", this.getTimestamp()));
                }
            }
        }
        return this.spoRelationRef.get();
    }

    public final synchronized LexiconRelation getLexiconRelation() {
        if (this.lexiconRelation == null && this.lexicon) {
            long t = this.getTimestamp();
            if (TimestampUtility.isReadWriteTx(t)) {
                t = 0L;
            }
            this.lexiconRelation = (LexiconRelation)this.getIndexManager().getResourceLocator().locate(this.getNamespace() + "." + "lex", t);
        }
        return this.lexiconRelation;
    }

    @Override
    public final long getNamedGraphCount() {
        if (!this.isQuads()) {
            throw new UnsupportedOperationException();
        }
        IChunkedIterator<IV> itr = this.getSPORelation().distinctTermScan(SPOKeyOrder.CSPO);
        long n = 0L;
        while (itr.hasNext()) {
            itr.next();
            ++n;
        }
        return n;
    }

    @Override
    public final long getStatementCount() {
        return this.getStatementCount(null, false);
    }

    @Override
    public final long getStatementCount(boolean exact) {
        return this.getStatementCount(null, exact);
    }

    @Override
    public final long getStatementCount(Resource c) {
        return this.getStatementCount(c, false);
    }

    @Override
    public final long getStatementCount(Resource c, boolean exact) {
        if (exact) {
            return this.getAccessPath(null, null, null, c).rangeCount(exact);
        }
        return this.getAccessPath(null, null, null, c).rangeCount(exact);
    }

    public long getExplicitStatementCount(Resource c) {
        return this.getAccessPath(null, null, null, c, ExplicitSPOFilter.INSTANCE, null).rangeCount(true);
    }

    @Override
    public synchronized void abort() {
        SPORelation tmp;
        if (this.isReadOnly()) {
            throw new IllegalStateException();
        }
        IResourceLocator locator = this.getIndexManager().getResourceLocator();
        if (this.lexiconRelation != null) {
            locator.discard(this.lexiconRelation, false);
            this.lexiconRelation = null;
        }
        if ((tmp = (SPORelation)this.spoRelationRef.getAndSet(null)) != null) {
            locator.discard(tmp, false);
        }
    }

    @Override
    public long commit() {
        if (this.isReadOnly()) {
            throw new IllegalStateException();
        }
        return 0L;
    }

    public final long getJustificationCount() {
        if (this.justify) {
            return this.getSPORelation().getJustificationIndex().rangeCount();
        }
        return 0L;
    }

    @Override
    public final long getTermCount() {
        long rangeCount = 0L;
        rangeCount += this.getLexiconRelation().getTerm2IdIndex().rangeCount();
        return rangeCount += this.getLexiconRelation().getBlobsIndex().rangeCount();
    }

    @Override
    public final long getURICount() {
        long rangeCount = 0L;
        byte[] fromKey = new byte[]{1};
        byte[] toKey = new byte[]{2};
        rangeCount += this.getLexiconRelation().getTerm2IdIndex().rangeCount(fromKey, toKey);
        fromKey = new byte[]{KeyBuilder.encodeByte(BlobIV.toFlags(VTE.URI))};
        toKey = SuccessorUtil.successor((byte[])fromKey.clone());
        return rangeCount += this.getLexiconRelation().getBlobsIndex().rangeCount(fromKey, toKey);
    }

    @Override
    public final long getLiteralCount() {
        long rangeCount = 0L;
        byte[] fromKey = new byte[]{2};
        byte[] toKey = new byte[]{5};
        rangeCount += this.getLexiconRelation().getTerm2IdIndex().rangeCount(fromKey, toKey);
        fromKey = new byte[]{KeyBuilder.encodeByte(BlobIV.toFlags(VTE.LITERAL))};
        toKey = SuccessorUtil.successor((byte[])fromKey.clone());
        return rangeCount += this.getLexiconRelation().getBlobsIndex().rangeCount(fromKey, toKey);
    }

    @Override
    public final long getBNodeCount() {
        if (!this.getLexiconRelation().isStoreBlankNodes()) {
            return 0L;
        }
        long rangeCount = 0L;
        byte[] fromKey = new byte[]{5};
        byte[] toKey = new byte[]{6};
        rangeCount += this.getLexiconRelation().getTerm2IdIndex().rangeCount(fromKey, toKey);
        fromKey = new byte[]{KeyBuilder.encodeByte(BlobIV.toFlags(VTE.BNODE))};
        toKey = SuccessorUtil.successor((byte[])fromKey.clone());
        return rangeCount += this.getLexiconRelation().getBlobsIndex().rangeCount(fromKey, toKey);
    }

    @Override
    public IV addTerm(Value value) {
        BigdataValue[] terms = new BigdataValue[]{this.getValueFactory().asValue(value)};
        this.getLexiconRelation().addTerms(terms, 1, false);
        return terms[0].getIV();
    }

    @Override
    public final BigdataValue getTerm(IV iv) {
        LexiconRelation r = this.getLexiconRelation();
        if (r == null) {
            return null;
        }
        return r.getTerm(iv);
    }

    @Override
    public final IV getIV(Value value) {
        return this.getLexiconRelation().getIV(value);
    }

    @Override
    public void addTerms(BigdataValue[] terms) {
        this.getLexiconRelation().addTerms(terms, terms.length, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final InferenceEngine getInferenceEngine() {
        AbstractTripleStore abstractTripleStore = this;
        synchronized (abstractTripleStore) {
            if (this.inferenceEngine == null) {
                this.inferenceEngine = new InferenceEngine(this);
            }
        }
        return this.inferenceEngine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final DataLoader getDataLoader() {
        AbstractTripleStore abstractTripleStore = this;
        synchronized (abstractTripleStore) {
            DataLoader dataLoader;
            DataLoader dataLoader2 = dataLoader = this.dataLoaderRef == null ? null : (DataLoader)this.dataLoaderRef.get();
            if (dataLoader == null) {
                dataLoader = new DataLoader(this);
                this.dataLoaderRef = new WeakReference<DataLoader>(dataLoader);
            }
            return dataLoader;
        }
    }

    @Override
    public final void addStatement(Resource s, URI p, Value o) {
        this.addStatement(s, p, o, null);
    }

    @Override
    public final void addStatement(Resource s, URI p, Value o, Resource c) {
        if (this.quads && c == null) {
            throw new UnsupportedOperationException();
        }
        StatementBuffer buffer = new StatementBuffer(this, 1);
        buffer.add(s, p, o, c);
        buffer.flush();
    }

    @Override
    public final ISPO getStatement(IV s, IV p, IV o) {
        return this.getStatement(s, p, o, null);
    }

    @Override
    public final ISPO getStatement(IV s, IV p, IV o, IV c) {
        SPOTupleSerializer tupleSer;
        byte[] key;
        if (s == null || p == null || o == null || c == null && this.spoKeyArity == 4) {
            throw new IllegalArgumentException();
        }
        SPO spo = this.spoKeyArity == 4 ? new SPO(s, p, o) : new SPO(s, p, o, c);
        IIndex ndx = this.getSPORelation().getPrimaryIndex();
        byte[] val = ndx.lookup(key = (tupleSer = (SPOTupleSerializer)ndx.getIndexMetadata().getTupleSerializer()).serializeKey(spo));
        if (val == null) {
            return null;
        }
        return tupleSer.decodeValue(spo, val);
    }

    public final boolean hasStatement(IV s, IV p, IV o) {
        return this.hasStatement(s, p, o, null);
    }

    public final boolean hasStatement(IV s, IV p, IV o, IV c) {
        if (!(s == null || p == null || o == null || this.quads && c == null)) {
            IIndex ndx = this.getSPORelation().getPrimaryIndex();
            SPO spo = new SPO(s, p, o, c);
            byte[] key = ndx.getIndexMetadata().getTupleSerializer().serializeKey(spo);
            boolean found = ndx.contains(key);
            if (log.isDebugEnabled()) {
                log.debug((Object)(spo + " : found=" + found + ", key=" + BytesUtil.toString(key)));
            }
            return found;
        }
        return !this.getSPORelation().getAccessPath(s, p, o, c).isEmpty();
    }

    @Override
    public final boolean hasStatement(Resource s, URI p, Value o) {
        return this.hasStatement(s, p, o, null);
    }

    @Override
    public final boolean hasStatement(Resource s, URI p, Value o, Resource c) {
        BigdataValueFactory valueFactory = this.getValueFactory();
        s = valueFactory.asValue(s);
        p = valueFactory.asValue(p);
        o = valueFactory.asValue(o);
        c = valueFactory.asValue(c);
        IV _s = this.getIV((Value)s);
        if (_s == null && s != null) {
            return false;
        }
        IV _p = this.getIV((Value)p);
        if (_p == null && p != null) {
            return false;
        }
        IV _o = this.getIV(o);
        if (_o == null && o != null) {
            return false;
        }
        IV _c = this.getIV((Value)c);
        if (_c == null && c != null) {
            return false;
        }
        boolean found = this.hasStatement(_s, _p, _o, _c);
        return found;
    }

    @Override
    public final long removeStatements(Resource s, URI p, Value o) {
        return this.removeStatements(s, p, o, null);
    }

    @Override
    public final long removeStatements(Resource s, URI p, Value o, Resource c) {
        return this.getAccessPath(s, p, o, c).removeAll();
    }

    public final BigdataStatement getStatement(Statement s) {
        return this.getStatement(s.getSubject(), s.getPredicate(), s.getObject(), s.getContext());
    }

    @Override
    public final BigdataStatement getStatement(Resource s, URI p, Value o) {
        return this.getStatement(s, p, o, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final BigdataStatement getStatement(Resource s, URI p, Value o, Resource c) {
        if (s == null || p == null || o == null || this.quads && c == null) {
            throw new IllegalArgumentException();
        }
        try (BigdataStatementIterator itr = this.getStatements(s, p, o, c);){
            if (!itr.hasNext()) {
                BigdataStatement bigdataStatement = null;
                return bigdataStatement;
            }
            BigdataStatement bigdataStatement = (BigdataStatement)itr.next();
            return bigdataStatement;
        }
    }

    @Override
    public final BigdataStatementIterator getStatements(Resource s, URI p, Value o) {
        return this.getStatements(s, p, o, null);
    }

    @Override
    public final BigdataStatementIterator getStatements(Resource s, URI p, Value o, Resource c) {
        return this.asStatementIterator(this.getAccessPath(s, p, o, c).iterator());
    }

    public BigdataStatementIterator getStatements(IChunkedOrderedIterator<BigdataTriplePattern> triplePatterns) {
        return this.asStatementIterator(new ChunkedWrappedIterator<ISPO>(new BigdataTriplePatternMaterializer(this, triplePatterns).start(this.getExecutorService())));
    }

    @Override
    public final BigdataValue asValue(Value value) {
        return this.getValueFactory().asValue(value);
    }

    @Override
    public BigdataStatement asStatement(ISPO spo) {
        ArrayList ivs = new ArrayList(4);
        ivs.add(spo.s());
        ivs.add(spo.p());
        ivs.add(spo.o());
        IV c = spo.c();
        if (c != null) {
            ivs.add(c);
        }
        Map<IV<?, ?>, BigdataValue> terms = this.getLexiconRelation().getTerms(ivs);
        return this.getValueFactory().createStatement((BigdataResource)terms.get(spo.s()), (BigdataURI)terms.get(spo.p()), terms.get(spo.o()), (BigdataResource)(c != null ? terms.get(c) : null), spo.getStatementType(), spo.getUserFlag());
    }

    @Override
    public BigdataStatementIterator asStatementIterator(IChunkedOrderedIterator<ISPO> src) {
        return new BigdataStatementIteratorImpl(this, src).start(this.getExecutorService());
    }

    @Override
    public IAccessPath<ISPO> getAccessPath(Resource s, URI p, Value o) {
        return this.getAccessPath(s, p, o, null, null, null);
    }

    public IAccessPath<ISPO> getAccessPath(Resource s, URI p, Value o, IElementFilter<ISPO> filter) {
        return this.getAccessPath(s, p, o, null, filter, null);
    }

    @Override
    public final IAccessPath<ISPO> getAccessPath(Resource s, URI p, Value o, Resource c) {
        return this.getAccessPath(s, p, o, c, null, null);
    }

    public final IAccessPath<ISPO> getAccessPath(Resource s, URI p, Value o, Resource c, IElementFilter<ISPO> filter, RangeBOp range) {
        BigdataValue _o;
        BigdataValueFactory valueFactory = s != null || p != null || o != null | c != null ? this.getValueFactory() : null;
        BigdataResource _s = valueFactory == null ? null : valueFactory.asValue(s);
        BigdataURI _p = valueFactory == null ? null : valueFactory.asValue(p);
        BigdataValue bigdataValue = _o = valueFactory == null ? null : valueFactory.asValue(o);
        BigdataResource _c = this.quads ? (valueFactory == null ? null : valueFactory.asValue(c)) : null;
        int nnonNull = 0;
        BigdataValue[] values = new BigdataValue[this.spoKeyArity];
        if (s != null) {
            values[nnonNull++] = _s;
        }
        if (p != null) {
            values[nnonNull++] = _p;
        }
        if (o != null) {
            values[nnonNull++] = _o;
        }
        if (c != null && this.quads) {
            values[nnonNull++] = _c;
        }
        if (nnonNull > 0) {
            this.getLexiconRelation().addTerms(values, nnonNull, true);
        }
        if (s != null && _s.getIV() == null) {
            return new EmptyAccessPath<ISPO>();
        }
        if (p != null && _p.getIV() == null) {
            return new EmptyAccessPath<ISPO>();
        }
        if (o != null && _o.getIV() == null) {
            return new EmptyAccessPath<ISPO>();
        }
        if (this.quads && c != null && _c.getIV() == null) {
            return new EmptyAccessPath<ISPO>();
        }
        return this.getSPORelation().getAccessPath(s == null ? null : _s.getIV(), p == null ? null : _p.getIV(), o == null ? null : _o.getIV(), c == null || !this.quads ? null : _c.getIV(), filter, range);
    }

    public IPredicate<ISPO> getPredicate(Resource s, URI p, Value o) {
        return this.getPredicate(s, p, o, null, null, null);
    }

    public IPredicate<ISPO> getPredicate(Resource s, URI p, Value o, Resource c) {
        return this.getPredicate(s, p, o, c, null, null);
    }

    public final IPredicate<ISPO> getPredicate(Resource s, URI p, Value o, Resource c, IElementFilter<ISPO> filter, RangeBOp range) {
        BigdataValue _o;
        BigdataValueFactory valueFactory = s != null || p != null || o != null | c != null ? this.getValueFactory() : null;
        BigdataResource _s = valueFactory == null ? null : valueFactory.asValue(s);
        BigdataURI _p = valueFactory == null ? null : valueFactory.asValue(p);
        BigdataValue bigdataValue = _o = valueFactory == null ? null : valueFactory.asValue(o);
        BigdataResource _c = this.quads ? (valueFactory == null ? null : valueFactory.asValue(c)) : null;
        int nnonNull = 0;
        BigdataValue[] values = new BigdataValue[this.spoKeyArity];
        if (s != null) {
            values[nnonNull++] = _s;
        }
        if (p != null) {
            values[nnonNull++] = _p;
        }
        if (o != null) {
            values[nnonNull++] = _o;
        }
        if (c != null && this.quads) {
            values[nnonNull++] = _c;
        }
        if (nnonNull > 0) {
            this.getLexiconRelation().addTerms(values, nnonNull, true);
        }
        if (s != null && _s.getIV() == null) {
            return null;
        }
        if (p != null && _p.getIV() == null) {
            return null;
        }
        if (o != null && _o.getIV() == null) {
            return null;
        }
        if (this.quads && c != null && _c.getIV() == null) {
            return null;
        }
        return this.getSPORelation().getPredicate(s == null ? null : _s.getIV(), p == null ? null : _p.getIV(), o == null ? null : _o.getIV(), c == null || !this.quads ? null : _c.getIV(), filter, range);
    }

    @Override
    public final IAccessPath<ISPO> getAccessPath(IV s, IV p, IV o) {
        return this.getSPORelation().getAccessPath(s, p, o, null);
    }

    public final IAccessPath<ISPO> getAccessPath(IV s, IV p, IV o, IElementFilter<ISPO> filter) {
        return this.getSPORelation().getAccessPath(s, p, o, null, filter);
    }

    public final IAccessPath<ISPO> getAccessPath(IV s, IV p, IV o, IV c) {
        return this.getSPORelation().getAccessPath(s, p, o, c);
    }

    public final IAccessPath<ISPO> getAccessPath(IV s, IV p, IV o, IV c, RangeBOp range) {
        return this.getSPORelation().getAccessPath(s, p, o, c, range);
    }

    public final IAccessPath<ISPO> getAccessPath(IV s, IV p, IV o, IV c, IElementFilter<ISPO> filter) {
        return this.getSPORelation().getAccessPath(s, p, o, c, filter);
    }

    @Override
    public final IAccessPath<ISPO> getAccessPath(IKeyOrder<ISPO> keyOrder) {
        return this.getAccessPath(keyOrder, null);
    }

    public final IAccessPath<ISPO> getAccessPath(IKeyOrder<ISPO> keyOrder, IElementFilter<ISPO> filter) {
        BOp[] bOpArray;
        SPORelation r = this.getSPORelation();
        if (this.quads) {
            BOp[] bOpArray2 = new BOp[4];
            bOpArray2[0] = Var.var("s");
            bOpArray2[1] = Var.var("p");
            bOpArray2[2] = Var.var("o");
            bOpArray = bOpArray2;
            bOpArray2[3] = Var.var("c");
        } else {
            BOp[] bOpArray3 = new BOp[3];
            bOpArray3[0] = Var.var("s");
            bOpArray3[1] = Var.var("p");
            bOpArray = bOpArray3;
            bOpArray3[2] = Var.var("o");
        }
        SPOPredicate p = new SPOPredicate(bOpArray, NV.asMap(new NV(IPredicate.Annotations.RELATION_NAME, new String[]{r.getNamespace()}), new NV(IPredicate.Annotations.INDEX_LOCAL_FILTER, ElementFilter.newInstance(filter))));
        return r.getAccessPath(keyOrder, p);
    }

    public final void addNamespace(String namespace, String prefix) {
        this.uriToPrefix.put(namespace, prefix);
    }

    public final Map<String, String> getNamespaces() {
        return Collections.unmodifiableMap(this.uriToPrefix);
    }

    public final String getNamespace(String prefix) {
        for (Map.Entry<String, String> entry : this.uriToPrefix.entrySet()) {
            if (!entry.getValue().equals(prefix)) continue;
            return entry.getKey();
        }
        return null;
    }

    public final String removeNamespace(String prefix) {
        Iterator<Map.Entry<String, String>> itr = this.uriToPrefix.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry<String, String> entry = itr.next();
            if (!entry.getValue().equals(prefix)) continue;
            itr.remove();
            return entry.getKey();
        }
        return null;
    }

    public final void clearNamespaces() {
        this.uriToPrefix.clear();
    }

    @Override
    public final String toString(IV s, IV p, IV o) {
        return this.toString(s, p, o, null);
    }

    @Override
    public final String toString(IV s, IV p, IV o, IV c) {
        return "< " + this.toString(s) + ", " + this.toString(p) + ", " + this.toString(o) + ", " + this.toString(c) + " >";
    }

    public final String toString(ISPO spo) {
        return this.toString(spo.s(), spo.p(), spo.o(), spo.c());
    }

    @Override
    public final String toString(IV iv) {
        if (iv == null) {
            return "NULL";
        }
        String s = "";
        try {
            BigdataValue v = this.getTerm(iv);
            if (v == null) {
                return "<NOT_FOUND#" + iv + ">";
            }
            s = v instanceof URI ? this.abbrev((URI)v) : v.toString();
        }
        catch (NotMaterializedException notMaterializedException) {
            // empty catch block
        }
        return s + "(" + iv + ")";
    }

    private final String abbrev(URI uri) {
        String uriString = uri.toString();
        String namespace = uri.getNamespace();
        String prefix = this.uriToPrefix.get(namespace);
        if (prefix != null) {
            return prefix + ":" + uri.getLocalName();
        }
        return uriString;
    }

    public final StringBuilder dumpStore() {
        return this.dumpStore(true, true, true);
    }

    public final StringBuilder dumpStore(boolean explicit, boolean inferred, boolean axioms) {
        return this.dumpStore(this, explicit, inferred, axioms);
    }

    public final StringBuilder dumpStore(AbstractTripleStore resolveTerms, boolean explicit, boolean inferred, boolean axioms) {
        return this.dumpStore(resolveTerms, explicit, inferred, axioms, false);
    }

    public final StringBuilder dumpStore(AbstractTripleStore resolveTerms, boolean explicit, boolean inferred, boolean axioms, boolean justifications) {
        return this.dumpStore(resolveTerms, explicit, inferred, axioms, justifications, this.getSPORelation().getPrimaryKeyOrder());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringBuilder dumpStore(AbstractTripleStore resolveTerms, boolean explicit, boolean inferred, boolean axioms, boolean justifications, IKeyOrder<ISPO> keyOrder) {
        StringBuilder sb = new StringBuilder();
        long nstmts = this.getAccessPath(keyOrder).rangeCount(true);
        long nexplicit = 0L;
        long ninferred = 0L;
        long naxioms = 0L;
        int i = 0;
        try (BigdataStatementIterator itr = resolveTerms.asStatementIterator(this.getAccessPath(keyOrder).iterator());){
            block8: while (itr.hasNext()) {
                BigdataStatement stmt = (BigdataStatement)itr.next();
                switch (stmt.getStatementType()) {
                    case Explicit: {
                        ++nexplicit;
                        if (explicit) break;
                        continue block8;
                    }
                    case Inferred: {
                        ++ninferred;
                        if (inferred) break;
                        continue block8;
                    }
                    case Axiom: {
                        ++naxioms;
                        if (axioms) break;
                        continue block8;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
                sb.append("#" + (i + 1) + "\t" + stmt + " (" + stmt.s() + "," + stmt.p() + "," + stmt.o() + "," + stmt.c() + ")" + "\n");
                ++i;
            }
        }
        int njust = 0;
        if (justifications && this.justify) {
            IIndex ndx = this.getSPORelation().getJustificationIndex();
            ITupleIterator itrj = ndx.rangeIterator();
            while (itrj.hasNext()) {
                Justification jst = (Justification)itrj.next().getObject();
                sb.append("#" + (njust + 1) + jst.toString(resolveTerms) + "\n");
                ++njust;
            }
        }
        sb.append("dumpStore: #statements=" + nstmts + ", #explicit=" + nexplicit + ", #inferred=" + ninferred + ", #axioms=" + naxioms + (justifications ? ", #just=" + njust : ""));
        return sb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringBuilder dumpStatements(IAccessPath<ISPO> accessPath) {
        StringBuilder sb = new StringBuilder();
        try (BigdataStatementIterator itr = this.asStatementIterator(accessPath.iterator());){
            while (itr.hasNext()) {
                sb.append("\n" + itr.next());
            }
            StringBuilder stringBuilder = sb;
            return stringBuilder;
        }
    }

    public long copyStatements(AbstractTripleStore dst, IElementFilter<ISPO> filter, boolean copyJustifications) {
        return this.copyStatements(dst, filter, copyJustifications, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long copyStatements(AbstractTripleStore dst, IElementFilter<ISPO> filter, boolean copyJustifications, IChangeLog changeLog) {
        if (dst == this) {
            throw new IllegalArgumentException();
        }
        try (IChunkedOrderedIterator<ISPO> itr = this.getAccessPath(this.getSPORelation().getPrimaryKeyOrder(), filter).iterator();){
            long elapsed_JST;
            long elapsed_SPO;
            if (!copyJustifications) {
                if (changeLog == null) {
                    long l = dst.addStatements(dst, true, itr, null);
                    return l;
                }
                long l = com.bigdata.rdf.changesets.StatementWriter.addStatements(dst, dst, true, null, itr, changeLog);
                return l;
            }
            ArrayList<Callable<Long>> tasks = new ArrayList<Callable<Long>>(2);
            AtomicLong nwritten = new AtomicLong();
            tasks.add(new StatementWriter(dst, dst, true, itr, nwritten, changeLog));
            AtomicLong nwrittenj = new AtomicLong();
            if (this.justify) {
                JustificationIterator jitr = new JustificationIterator(this.getIndexManager(), this.getSPORelation().getJustificationIndex(), 0);
                tasks.add(new JustificationWriter(dst, jitr, nwrittenj));
            }
            try {
                List futures = this.getIndexManager().getExecutorService().invokeAll(tasks);
                elapsed_SPO = (Long)futures.get(0).get();
                elapsed_JST = this.justify ? (Long)futures.get(1).get() : 0L;
            }
            catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
            catch (ExecutionException ex) {
                throw new RuntimeException(ex);
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("Copied " + nwritten + " statements in " + elapsed_SPO + "ms" + (this.justify ? " and " + nwrittenj + " justifications in " + elapsed_JST + "ms" : "")));
            }
            long l = nwritten.get();
            return l;
        }
    }

    @Override
    public IChunkedOrderedIterator<ISPO> bulkFilterStatements(ISPO[] stmts, int numStmts, boolean present) {
        if (numStmts == 0) {
            return new EmptyChunkedIterator<ISPO>(this.getSPORelation().getPrimaryKeyOrder());
        }
        return this.bulkFilterStatements(new ChunkedArrayIterator<ISPO>(numStmts, stmts, null), present);
    }

    @Override
    public IChunkedOrderedIterator<ISPO> bulkFilterStatements(IChunkedOrderedIterator<ISPO> itr, boolean present) {
        return new ChunkedConvertingIterator<ISPO, ISPO>(itr, new BulkFilterConverter(this.getSPORelation().getPrimaryIndex(), present));
    }

    public IChunkedOrderedIterator<ISPO> bulkCompleteStatements(SPO[] stmts, int numStmts) {
        if (numStmts == 0) {
            return new EmptyChunkedIterator<ISPO>(this.getSPORelation().getPrimaryKeyOrder());
        }
        return this.bulkCompleteStatements(new ChunkedArrayIterator<ISPO>(numStmts, stmts, null));
    }

    public ISPO[] bulkCompleteStatements(ISPO[] stmts) {
        return new BulkCompleteConverter(this.getSPORelation().getPrimaryIndex()).convert(stmts);
    }

    @Override
    public IChunkedOrderedIterator<ISPO> bulkCompleteStatements(IChunkedOrderedIterator<ISPO> itr) {
        return new ChunkedConvertingIterator<ISPO, ISPO>(itr, new BulkCompleteConverter(this.getSPORelation().getPrimaryIndex()));
    }

    @Override
    public long addStatements(ISPO[] stmts, int numStmts) {
        if (numStmts == 0) {
            return 0L;
        }
        return this.addStatements(new ChunkedArrayIterator<ISPO>(numStmts, stmts, null), null);
    }

    @Override
    public long addStatements(ISPO[] stmts, int numStmts, IElementFilter<ISPO> filter) {
        if (numStmts == 0) {
            return 0L;
        }
        return this.addStatements(new ChunkedArrayIterator<ISPO>(numStmts, stmts, null), filter);
    }

    @Override
    public long addStatements(IChunkedOrderedIterator<ISPO> itr, IElementFilter<ISPO> filter) {
        return this.addStatements(this, false, itr, filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long addStatements(AbstractTripleStore statementStore, boolean copyOnly, IChunkedOrderedIterator<ISPO> itr, IElementFilter<ISPO> filter) {
        if (statementStore == null) {
            throw new IllegalArgumentException();
        }
        if (itr == null) {
            throw new IllegalArgumentException();
        }
        try {
            SPORelation spoRelation = statementStore.getSPORelation();
            if (!itr.hasNext()) {
                long l = 0L;
                return l;
            }
            long mutationCount = 0L;
            while (itr.hasNext()) {
                long statementIdentifierTime;
                ISPO[] a = (ISPO[])itr.nextChunk();
                int numStmts = a.length;
                if (this.statementIdentifiers && !copyOnly) {
                    long begin = System.currentTimeMillis();
                    statementIdentifierTime = System.currentTimeMillis() - begin;
                } else {
                    statementIdentifierTime = 0L;
                }
                long numWritten = spoRelation.insert(a, numStmts, filter);
                mutationCount += numWritten;
                if (numStmts <= 1000 || !log.isInfoEnabled()) continue;
                log.info((Object)("Wrote " + numStmts + " statements (mutationCount=" + numWritten + ")" + (statementStore != this ? "; truthMaintenance" : "") + (this.statementIdentifiers ? "; sid=" + statementIdentifierTime + "ms" : "")));
            }
            long l = mutationCount;
            return l;
        }
        finally {
            itr.close();
        }
    }

    @Override
    public long removeStatements(ISPO[] stmts, int numStmts) {
        return this.removeStatements(new ChunkedArrayIterator<ISPO>(numStmts, stmts, null), true);
    }

    @Override
    public long removeStatements(IChunkedOrderedIterator<ISPO> itr) {
        return this.removeStatements(itr, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long removeStatements(IChunkedOrderedIterator<ISPO> itr, boolean computeClosureForStatementIdentifiers) {
        if (itr == null) {
            throw new IllegalArgumentException();
        }
        long mutationCount = 0L;
        if (this.statementIdentifiers && computeClosureForStatementIdentifiers) {
            itr = this.computeClosureForStatementIdentifiers(itr);
        }
        try {
            while (itr.hasNext()) {
                ISPO[] stmts = (ISPO[])itr.nextChunk();
                int numStmts = stmts.length;
                mutationCount += this.getSPORelation().delete(stmts, numStmts);
            }
        }
        finally {
            itr.close();
        }
        return mutationCount;
    }

    public IChunkedOrderedIterator<ISPO> computeClosureForStatementIdentifiers(IChunkedOrderedIterator<ISPO> src) {
        if (!this.statementIdentifiers) {
            return src;
        }
        Properties properties = this.getProperties();
        properties.setProperty(Options.LEXICON, "false");
        properties.setProperty(Options.ONE_ACCESS_PATH, "true");
        properties.setProperty(Options.BLOOM_FILTER, "false");
        properties.setProperty(Options.AXIOMS_CLASS, NoAxioms.class.getName());
        final TempTripleStore tmp = new TempTripleStore(this.getIndexManager().getTempStore(), properties, this);
        this.addStatements(tmp, false, src, null);
        AbstractTripleStore.fixPointStatementIdentifiers(this, tmp);
        return new DelegateChunkedIterator<ISPO>(tmp.getAccessPath(SPOKeyOrder.SPO).iterator()){

            @Override
            public void close() {
                super.close();
                tmp.close();
            }

            protected void finalize() throws Throwable {
                super.finalize();
                if (tmp.isOpen()) {
                    tmp.close();
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fixPointStatementIdentifiers(AbstractTripleStore db, AbstractTripleStore tempStore) {
        long statementCount1;
        long statementCount0;
        HashSet<IV> sids = new HashSet<IV>();
        int nrounds = 0;
        do {
            ++nrounds;
            statementCount0 = tempStore.getStatementCount();
            try (IChunkedOrderedIterator<ISPO> itr = tempStore.getAccessPath(SPOKeyOrder.SPO, ExplicitSPOFilter.INSTANCE).iterator();){
                while (itr.hasNext()) {
                    IV sid = ((ISPO)itr.next()).getStatementIdentifier();
                    if (sids.contains(sid)) continue;
                    tempStore.addStatements(tempStore, true, db.getAccessPath(sid, null, null).iterator(), null);
                    tempStore.addStatements(tempStore, true, db.getAccessPath(null, sid, null).iterator(), null);
                    tempStore.addStatements(tempStore, true, db.getAccessPath((IV)null, (IV)null, sid).iterator(), null);
                    sids.add(sid);
                }
            }
            statementCount1 = tempStore.getStatementCount();
            if (!log.isInfoEnabled()) continue;
            log.info((Object)("Finished " + nrounds + " rounds: statementBefore=" + statementCount0 + ", statementsAfter=" + statementCount1));
        } while (statementCount0 < statementCount1);
    }

    public IJoinNexusFactory newJoinNexusFactory(RuleContextEnum ruleContext, ActionEnum action, int solutionFlags, IElementFilter filter) {
        return this.newJoinNexusFactory(ruleContext, action, solutionFlags, filter, this.isJustify(), false, DefaultEvaluationPlanFactory2.INSTANCE);
    }

    public IJoinNexusFactory newJoinNexusFactory(RuleContextEnum ruleContext, ActionEnum action, int solutionFlags, IElementFilter filter, boolean justify, boolean backchain, IEvaluationPlanFactory planFactory) {
        return this.newJoinNexusFactory(ruleContext, action, solutionFlags, filter, justify, backchain, planFactory, null);
    }

    public IJoinNexusFactory newJoinNexusFactory(RuleContextEnum ruleContext, ActionEnum action, int solutionFlags, IElementFilter filter, boolean justify, boolean backchain, IEvaluationPlanFactory planFactory, Properties overrides) {
        long readTimestamp;
        if (ruleContext == null) {
            throw new IllegalArgumentException();
        }
        if (action == null) {
            throw new IllegalArgumentException();
        }
        if (action.isMutation()) {
            this.assertWritable();
        }
        long writeTimestamp = this.getTimestamp();
        if (action.isMutation()) {
            if (writeTimestamp != 0L) {
                throw new UnsupportedOperationException();
            }
            readTimestamp = this.getIndexManager() instanceof IBigdataFederation ? TimestampUtility.asHistoricalRead(this.getIndexManager().getLastCommitTime()) : this.getTimestamp();
        } else {
            readTimestamp = this.getTimestamp();
        }
        boolean isOwlSameAsUsed = this.getAxioms().isOwlSameAs() && !this.getAccessPath(null, this.getVocabulary().get((Value)OWL.SAMEAS), null).isEmpty();
        IRuleTaskFactory defaultRuleTaskFactory = DefaultRuleTaskFactory.PIPELINE;
        Properties tmp = this.getProperties();
        if (overrides != null) {
            tmp.putAll((Map<?, ?>)overrides);
        }
        return new RDFJoinNexusFactory(action, writeTimestamp, readTimestamp, tmp, solutionFlags, filter, planFactory, defaultRuleTaskFactory, ruleContext, justify, backchain, isOwlSameAsUsed);
    }

    public ICloseableIterator<IBindingSet> match(Literal[] lits, URI[] preds, URI cls) {
        if (lits == null || lits.length == 0) {
            throw new IllegalArgumentException();
        }
        if (preds == null || preds.length == 0) {
            throw new IllegalArgumentException();
        }
        if (cls == null) {
            throw new IllegalArgumentException();
        }
        BigdataValue[] terms = new BigdataValue[preds.length + 1];
        BigdataValueFactory valueFactory = this.getValueFactory();
        for (int i = 0; i < preds.length; ++i) {
            terms[i] = valueFactory.asValue(preds[i]);
        }
        terms[preds.length] = valueFactory.asValue(cls);
        this.getLexiconRelation().addTerms(terms, terms.length, true);
        IConstant[] _preds = new IConstant[preds.length];
        int nknown = 0;
        for (int i = 0; i < preds.length; ++i) {
            IV iv = terms[i].getIV();
            if (iv != null) {
                ++nknown;
            }
            _preds[i] = new Constant<IV>(iv);
        }
        if (nknown == 0) {
            log.warn((Object)("No known predicates: preds=" + Arrays.toString(preds)));
            return new EmptyChunkedIterator<IBindingSet>(null);
        }
        IV _cls = terms[preds.length].getIV();
        if (_cls == null) {
            log.warn((Object)("Unknown class: class=" + cls));
            return new EmptyChunkedIterator<IBindingSet>(null);
        }
        Program program = this.getMatchProgram(lits, _preds, _cls);
        int solutionFlags = 2;
        IJoinNexus joinNexus = this.newJoinNexusFactory(RuleContextEnum.HighLevelQuery, ActionEnum.Query, 2, null).newInstance(this.getIndexManager());
        try {
            return new BigdataSolutionResolverator(this, joinNexus.runQuery(program)).start(this.getExecutorService());
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    protected Program getMatchProgram(Literal[] lits, IConstant<IV>[] _preds, IV _cls) {
        Iterator<IV> ivIterator = this.getLexiconRelation().prefixScan(lits);
        Var lit = Var.var("lit");
        MatchRule r = new MatchRule(this.getSPORelation().getNamespace(), this.getVocabulary(), lit, _preds, new Constant<IV>(_cls));
        Program program = new Program("match", true);
        while (ivIterator.hasNext()) {
            IV iv = ivIterator.next();
            ListBindingSet constants = new ListBindingSet();
            constants.set(lit, new Constant<IV>(iv));
            IRule tmp = r.specialize(constants, null);
            if (log.isDebugEnabled()) {
                log.debug((Object)tmp.toString());
            }
            program.addStep(tmp);
        }
        return program;
    }

    public static interface Options
    extends AbstractResource.Options,
    InferenceEngine.Options,
    com.bigdata.journal.Options,
    KeyBuilder.Options,
    DataLoader.Options,
    FullTextIndex.Options {
        public static final String LEXICON = AbstractTripleStore.class.getName() + ".lexicon";
        public static final String DEFAULT_LEXICON = "true";
        public static final String STORE_BLANK_NODES = AbstractTripleStore.class.getName() + ".storeBlankNodes";
        public static final String DEFAULT_STORE_BLANK_NODES = "false";
        public static final String TERMID_BITS_TO_REVERSE = AbstractTripleStore.class.getName() + ".termIdBitsToReverse";
        public static final String DEFAULT_TERMID_BITS_TO_REVERSE = "6";
        public static final String TERM_CACHE_CAPACITY = AbstractTripleStore.class.getName() + ".termCache.capacity";
        public static final String DEFAULT_TERM_CACHE_CAPACITY = "10000";
        public static final String VOCABULARY_CLASS = AbstractTripleStore.class.getName() + ".vocabularyClass";
        public static final String DEFAULT_VOCABULARY_CLASS = DefaultBigdataVocabulary.class.getName();
        public static final String AXIOMS_CLASS = AbstractTripleStore.class.getName() + ".axiomsClass";
        public static final String DEFAULT_AXIOMS_CLASS = OwlAxioms.class.getName();
        public static final String CLOSURE_CLASS = AbstractTripleStore.class.getName() + ".closureClass";
        public static final String DEFAULT_CLOSURE_CLASS = FastClosure.class.getName();
        public static final String ONE_ACCESS_PATH = AbstractTripleStore.class.getName() + ".oneAccessPath";
        public static final String DEFAULT_ONE_ACCESS_PATH = "false";
        public static final String BLOOM_FILTER = AbstractTripleStore.class.getName() + ".bloomFilter";
        public static final String DEFAULT_BLOOM_FILTER = "true";
        public static final String JUSTIFY = AbstractTripleStore.class.getName() + ".justify";
        public static final String DEFAULT_JUSTIFY = "true";
        public static final String STATEMENT_IDENTIFIERS = AbstractTripleStore.class.getName() + ".statementIdentifiers";
        public static final String DEFAULT_STATEMENT_IDENTIFIERS = "false";
        public static final String QUADS = AbstractTripleStore.class.getName() + ".quads";
        public static final String DEFAULT_QUADS = "false";
        public static final String TRIPLES_MODE = AbstractTripleStore.class.getName() + ".triplesMode";
        public static final String DEFAULT_TRIPLES_MODE = "false";
        public static final String TRIPLES_MODE_WITH_PROVENANCE = AbstractTripleStore.class.getName() + ".triplesModeWithProvenance";
        public static final String DEFAULT_TRIPLES_MODE_WITH_PROVENANCE = "false";
        public static final String QUADS_MODE = AbstractTripleStore.class.getName() + ".quadsMode";
        public static final String DEFAULT_QUADS_MODE = "false";
        public static final String VALUE_FACTORY_CLASS = AbstractTripleStore.class.getName() + ".valueFactoryClass";
        public static final String DEFAULT_VALUE_FACTORY_CLASS = BigdataValueFactoryImpl.class.getName();
        public static final String TEXT_INDEX = AbstractTripleStore.class.getName() + ".textIndex";
        public static final String DEFAULT_TEXT_INDEX = "true";
        public static final String SUBJECT_CENTRIC_TEXT_INDEX = AbstractTripleStore.class.getName() + ".subjectCentricTextIndex";
        public static final String DEFAULT_SUBJECT_CENTRIC_TEXT_INDEX = "false";
        public static final String TEXT_INDEX_DATATYPE_LITERALS = AbstractTripleStore.class.getName() + ".textIndex.datatypeLiterals";
        public static final String DEFAULT_TEXT_INDEX_DATATYPE_LITERALS = "true";
        public static final String TEXT_INDEXER_CLASS = AbstractTripleStore.class.getName() + ".textIndexerClass";
        public static final String DEFAULT_TEXT_INDEXER_CLASS = BigdataValueCentricFullTextIndex.class.getName();
        public static final String SUBJECT_CENTRIC_TEXT_INDEXER_CLASS = AbstractTripleStore.class.getName() + ".subjectCentricTextIndexerClass";
        public static final String DEFAULT_SUBJECT_CENTRIC_TEXT_INDEXER_CLASS = BigdataSubjectCentricFullTextIndex.class.getName();
        public static final String BLOBS_THRESHOLD = AbstractTripleStore.class.getName() + ".blobsThreshold";
        public static final String DEFAULT_BLOBS_THRESHOLD = "256";
        public static final String INLINE_XSD_DATATYPE_LITERALS = AbstractTripleStore.class.getName() + ".inlineXSDDatatypeLiterals";
        public static final String DEFAULT_INLINE_XSD_DATATYPE_LITERALS = "true";
        public static final String INLINE_TEXT_LITERALS = AbstractTripleStore.class.getName() + ".inlineTextLiterals";
        public static final String DEFAULT_INLINE_TEXT_LITERALS = "false";
        public static final String MAX_INLINE_TEXT_LENGTH = AbstractTripleStore.class.getName() + ".maxInlineTextLength";
        public static final String DEFAULT_MAX_INLINE_STRING_LENGTH = "0";
        public static final String INLINE_BNODES = AbstractTripleStore.class.getName() + ".inlineBNodes";
        public static final String DEFAULT_INLINE_BNODES = "true";
        public static final String INLINE_DATE_TIMES = AbstractTripleStore.class.getName() + ".inlineDateTimes";
        public static final String DEFAULT_INLINE_DATE_TIMES = "true";
        public static final String INLINE_DATE_TIMES_TIMEZONE = AbstractTripleStore.class.getName() + ".inlineDateTimesTimezone";
        public static final String DEFAULT_INLINE_DATE_TIMES_TIMEZONE = "GMT";
        public static final String EXTENSION_FACTORY_CLASS = AbstractTripleStore.class.getName() + ".extensionFactoryClass";
        public static final String DEFAULT_EXTENSION_FACTORY_CLASS = DefaultExtensionFactory.class.getName();
        public static final String REJECT_INVALID_XSD_VALUES = AbstractTripleStore.class.getName() + ".rejectInvalidXSDValues";
        public static final String DEFAULT_REJECT_INVALID_XSD_VALUES = "false";
        public static final String CONSTRAIN_XXXC_SHARDS = (AbstractTripleStore.class.getName() + ".constrainXXXCShards").intern();
        public static final String DEFAULT_CONSTRAIN_XXXC_SHARDS = "true";
        public static final String HISTORY_SERVICE = AbstractTripleStore.class.getName() + ".historyService";
        public static final String DEFAULT_HISTORY_SERVICE = "false";
        public static final String HISTORY_SERVICE_MIN_RELEASE_AGE = AbstractTripleStore.class.getName() + ".historyService.minReleaseAge";
        public static final String DEFAULT_HISTORY_SERVICE_MIN_RELEASE_AGE = Long.toString(Long.MAX_VALUE);
        public static final String BOTTOM_UP_EVALUATION = AbstractTripleStore.class.getName() + ".bottomUpEvaluation";
        public static final String DEFAULT_BOTTOM_UP_EVALUATION = "true";
        public static final String INLINE_URI_FACTORY_CLASS = AbstractTripleStore.class.getName() + ".inlineURIFactory";
        public static final String DEFAULT_INLINE_URI_FACTORY_CLASS = InlineURIFactory.class.getName();
    }
}

