/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.util;

import com.bigdata.rdf.ServiceProviderHook;
import com.bigdata.rdf.model.BigdataBNode;
import com.bigdata.rdf.model.StatementEnum;
import com.bigdata.rdf.rio.BasicRioLoader;
import com.bigdata.rdf.rio.IStatementBuffer;
import com.bigdata.rdf.rio.RDFParserOptions;
import com.bigdata.rdf.store.AbstractTripleStore;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.text.NumberFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicLong;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.config.ConfigurationProvider;
import org.apache.log4j.Logger;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.ContextStatementImpl;
import org.openrdf.model.impl.StatementImpl;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParser;
import org.openrdf.rio.RDFParserRegistry;
import org.openrdf.rio.RDFWriter;
import org.openrdf.rio.RDFWriterRegistry;
import org.openrdf.rio.Rio;

public class Splitter {
    protected static final Logger log = Logger.getLogger(Splitter.class);
    public static final String COMPONENT = Splitter.class.getName();
    private final Settings s;
    private volatile ExecutorService service;
    private final AtomicLong nextId = new AtomicLong();

    protected Splitter(Settings settings) {
        this.s = settings;
    }

    public synchronized void start() throws InterruptedException, Exception {
        if (this.service != null) {
            throw new IllegalStateException();
        }
        this.service = Executors.newFixedThreadPool(this.s.threadPoolSize);
    }

    public synchronized void terminate() {
        if (this.service == null) {
            return;
        }
        this.service.shutdownNow();
        this.service = null;
    }

    public void submitAll(File fileOrDir, FilenameFilter filter, RDFFormat rdfFormat) throws InterruptedException, Exception {
        List<Callable<Void>> tasks = this.acceptAll(this.s.srcDir, this.s.srcFilter, this.s.srcFormat);
        if (log.isInfoEnabled()) {
            log.info((Object)("Running: " + tasks.size() + " tasks"));
        }
        this.service.invokeAll(tasks);
    }

    private List<Callable<Void>> acceptAll(File fileOrDir, FilenameFilter filter, RDFFormat rdfFormat) throws Exception {
        return new RunnableFileSystemLoader(fileOrDir, filter, rdfFormat).call();
    }

    public Future<Void> submitOne(File file, RDFFormat rdfFormat) throws Exception {
        if (log.isInfoEnabled()) {
            log.info((Object)("file=" + file + ", rdfFormat=" + rdfFormat));
        }
        FutureTask<Void> ft = new FutureTask<Void>(new ParserTask(file, rdfFormat));
        this.service.execute(ft);
        return ft;
    }

    protected File getOutDir() {
        if (!this.s.subdirs) {
            return this.s.outDir;
        }
        int n = this.s.maxPerSubdir;
        long k = this.nextId.incrementAndGet();
        File p = new File(this.s.outDir, Long.toString(k / (long)n));
        if (p.mkdirs() && log.isInfoEnabled()) {
            log.info((Object)("new subdirectory: " + p));
        }
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        ServiceProviderHook.forceLoad();
        Configuration c = ConfigurationProvider.getInstance((String[])args);
        Settings settings = new Settings(c);
        settings.outDir.mkdirs();
        final Splitter splitter = new Splitter(settings);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                splitter.terminate();
            }
        });
        splitter.start();
        try {
            splitter.submitAll(settings.srcDir, settings.srcFilter, settings.srcFormat);
            System.exit(0);
        }
        finally {
            splitter.terminate();
        }
    }

    private class MyStatementBuffer
    implements IStatementBuffer<Statement> {
        private final File srcFile;
        private final Statement[] stmts;
        private int numStmts;
        private long nwritten;
        private int nchunks;

        public MyStatementBuffer(File srcFile) {
            this.stmts = new Statement[((Splitter)Splitter.this).s.outChunkSize];
            this.numStmts = 0;
            this.nwritten = 0L;
            this.nchunks = 0;
            this.srcFile = srcFile;
        }

        @Override
        public AbstractTripleStore getDatabase() {
            return null;
        }

        @Override
        public AbstractTripleStore getStatementStore() {
            return null;
        }

        @Override
        public void setBNodeMap(Map<String, BigdataBNode> bnodes) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isEmpty() {
            return this.numStmts == 0;
        }

        @Override
        public int size() {
            return this.numStmts;
        }

        @Override
        public void add(Resource s, URI p, Value o) {
            this.add((Statement)new StatementImpl(s, p, o));
        }

        @Override
        public void add(Resource s, URI p, Value o, Resource c) {
            this.add((Statement)new ContextStatementImpl(s, p, o, c));
        }

        @Override
        public void add(Resource s, URI p, Value o, Resource c, StatementEnum type) {
            this.add((Statement)new ContextStatementImpl(s, p, o, c));
        }

        @Override
        public void add(Statement stmt) {
            if (this.numStmts == this.stmts.length) {
                this.flush();
            }
            this.stmts[this.numStmts++] = stmt;
        }

        @Override
        public void reset() {
            for (int i = 0; i < this.stmts.length; ++i) {
                this.stmts[i] = null;
            }
            this.numStmts = 0;
            this.nwritten = 0;
        }

        @Override
        public long flush() {
            if (this.numStmts == 0) {
                return 0L;
            }
            File outDir = Splitter.this.getOutDir();
            String basename = this.srcFile.getName();
            RDFFormat srcfmt = null;
            if (basename.endsWith(".zip")) {
                basename = basename.substring(0, basename.length() - 4);
            } else if (basename.endsWith(".gz")) {
                basename = basename.substring(0, basename.length() - 3);
            }
            srcfmt = RDFFormat.forFileName((String)basename);
            if (srcfmt != null) {
                for (String ext : srcfmt.getFileExtensions()) {
                    if (!basename.endsWith(ext)) continue;
                    if (!(basename = basename.substring(0, basename.length() - ext.length())).endsWith(".")) break;
                    basename = basename.substring(0, basename.length() - 1);
                    break;
                }
            }
            if (srcfmt == null && (srcfmt = ((Splitter)Splitter.this).s.srcFormat) == null) {
                throw new UnsupportedOperationException("Could not identify format: " + this.srcFile);
            }
            RDFFormat outfmt = ((Splitter)Splitter.this).s.outFormat;
            if (outfmt == null) {
                outfmt = srcfmt;
            }
            NumberFormat d = NumberFormat.getIntegerInstance();
            d.setMinimumIntegerDigits(6);
            d.setGroupingUsed(false);
            String chunkStr = d.format(this.nchunks);
            File outFile = new File(outDir, basename + "_" + chunkStr + "." + outfmt.getDefaultFileExtension() + ((Splitter)Splitter.this).s.outCompress.getExt());
            try {
                this.writeFile(outFile, this.numStmts, this.stmts);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            for (int i = 0; i < this.numStmts; ++i) {
                this.stmts[i] = null;
            }
            this.nwritten += (long)this.numStmts;
            ++this.nchunks;
            this.numStmts = 0;
            return this.nwritten;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void writeFile(File outFile, int n, Statement[] a) throws IOException {
            if (log.isInfoEnabled()) {
                log.info((Object)("Writing " + n + " statements on " + outFile));
            }
            try (OutputStream os = new FileOutputStream(outFile);){
                os = new BufferedOutputStream(os);
                switch (((Splitter)Splitter.this).s.outCompress) {
                    case None: {
                        break;
                    }
                    case GZip: {
                        os = new GZIPOutputStream(os);
                        break;
                    }
                    case Zip: {
                        os = new ZipOutputStream(os);
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("Unknown value: outCompress=" + (Object)((Object)((Splitter)Splitter.this).s.outCompress)));
                    }
                }
                RDFWriter w = Rio.createWriter((RDFFormat)((Splitter)Splitter.this).s.outFormat, (OutputStream)os);
                try {
                    w.startRDF();
                    for (int i = 0; i < n; ++i) {
                        w.handleStatement(a[i]);
                    }
                    w.endRDF();
                }
                catch (RDFHandlerException ex) {
                    throw new IOException(ex);
                }
            }
        }
    }

    private static class MyLoader
    extends BasicRioLoader
    implements RDFHandler {
        protected final IStatementBuffer<?> buffer;

        public MyLoader(IStatementBuffer<?> buffer) {
            super((ValueFactory)new ValueFactoryImpl());
            this.buffer = buffer;
        }

        @Override
        protected void success() {
            if (this.buffer != null) {
                this.buffer.flush();
            }
        }

        @Override
        protected void error(Exception ex) {
            if (this.buffer != null) {
                this.buffer.reset();
            }
            super.error(ex);
        }

        @Override
        public RDFHandler newRDFHandler() {
            return this;
        }

        public void handleStatement(Statement stmt) {
            if (log.isDebugEnabled()) {
                log.debug((Object)stmt);
            }
            this.buffer.add(stmt.getSubject(), stmt.getPredicate(), stmt.getObject(), stmt.getContext());
            ++this.stmtsAdded;
            if (this.stmtsAdded % 100000L == 0L) {
                this.notifyListeners();
            }
        }

        public void endRDF() throws RDFHandlerException {
        }

        public void handleComment(String arg0) throws RDFHandlerException {
        }

        public void handleNamespace(String arg0, String arg1) throws RDFHandlerException {
        }

        public void startRDF() throws RDFHandlerException {
        }
    }

    protected class ParserTask
    implements Callable<Void> {
        private final File file;
        private final String baseURL;
        private final RDFFormat defaultRDFFormat;

        public ParserTask(File file, RDFFormat defaultRDFFormat) {
            if (file == null) {
                throw new IllegalArgumentException();
            }
            this.file = file;
            this.baseURL = file.toURI().toString();
            this.defaultRDFFormat = defaultRDFFormat;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            if (log.isInfoEnabled()) {
                log.info((Object)("file=" + this.file));
            }
            MyStatementBuffer buffer = new MyStatementBuffer(this.file);
            try (InputStream is = new FileInputStream(this.file);){
                String basename = this.file.getName();
                RDFFormat srcfmt = null;
                if (basename.endsWith(".zip")) {
                    basename = basename.substring(0, basename.length() - 4);
                    is = new ZipInputStream(is);
                } else if (basename.endsWith(".gz")) {
                    basename = basename.substring(0, basename.length() - 3);
                    is = new GZIPInputStream(is);
                }
                srcfmt = RDFFormat.forFileName((String)basename);
                if (srcfmt != null) {
                    for (String ext : srcfmt.getFileExtensions()) {
                        if (!basename.endsWith(ext)) continue;
                        if (!(basename = basename.substring(0, basename.length() - ext.length())).endsWith(".")) break;
                        basename = basename.substring(0, basename.length() - 1);
                        break;
                    }
                }
                if (srcfmt == null && (srcfmt = this.defaultRDFFormat) == null) {
                    throw new UnsupportedOperationException("Could not identify format: " + this.file);
                }
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(is));){
                    new MyLoader(buffer).loadRdf(reader, this.baseURL, this.defaultRDFFormat, null, ((Splitter)Splitter.this).s.parserOptions);
                }
            }
            catch (Exception ex) {
                log.error((Object)("file=" + this.file + " : " + ex), (Throwable)ex);
                throw ex;
            }
            buffer.flush();
            return null;
        }
    }

    private class RunnableFileSystemLoader
    implements Callable<List<Callable<Void>>> {
        final File fileOrDir;
        final FilenameFilter filter;
        final RDFFormat rdfFormat;
        final List<Callable<Void>> futures = new LinkedList<Callable<Void>>();

        public RunnableFileSystemLoader(File fileOrDir, FilenameFilter filter, RDFFormat rdfFormat) {
            if (fileOrDir == null) {
                throw new IllegalArgumentException();
            }
            this.fileOrDir = fileOrDir;
            this.filter = filter;
            this.rdfFormat = rdfFormat;
        }

        @Override
        public List<Callable<Void>> call() throws Exception {
            this.process2(this.fileOrDir);
            return this.futures;
        }

        private void process2(File file) throws InterruptedException {
            if (file.isHidden()) {
                return;
            }
            if (file.isDirectory()) {
                File[] files;
                if (log.isInfoEnabled()) {
                    log.info((Object)("Scanning directory: " + file));
                }
                for (File f : files = this.filter == null ? file.listFiles() : file.listFiles(this.filter)) {
                    this.process2(f);
                }
            } else {
                try {
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Accepting file: " + file));
                    }
                    this.futures.add(new ParserTask(file, this.rdfFormat));
                    return;
                }
                catch (Exception ex) {
                    log.error((Object)file, (Throwable)ex);
                }
            }
        }
    }

    private static class Settings {
        final File srcDir;
        final FilenameFilter srcFilter;
        final RDFFormat srcFormat;
        final File outDir;
        final RDFFormat outFormat;
        final CompressEnum outCompress;
        final int outChunkSize;
        final RDFParserOptions parserOptions;
        final boolean subdirs;
        final int maxPerSubdir;
        final int threadPoolSize;

        public Settings(Configuration c) throws ConfigurationException {
            this.srcDir = (File)c.getEntry(COMPONENT, "srcDir", File.class);
            this.srcFilter = (FilenameFilter)c.getEntry(COMPONENT, "srcFilter", FilenameFilter.class, null);
            this.srcFormat = RDFFormat.valueOf((String)((String)c.getEntry(COMPONENT, "srcFormat", String.class, (Object)ConfigurationOptions.DEFAULT_SRC_FORMAT)));
            if (this.srcFormat != null && RDFParserRegistry.getInstance().get((Object)this.srcFormat) == null) {
                throw new ConfigurationException("srcFormat=" + this.srcFormat);
            }
            this.outDir = (File)c.getEntry(COMPONENT, "outDir", File.class);
            this.outFormat = RDFFormat.valueOf((String)((String)c.getEntry(COMPONENT, "outFormat", String.class)));
            if (this.outFormat != null && RDFWriterRegistry.getInstance().get((Object)this.outFormat) == null) {
                throw new ConfigurationException("outFormat=" + this.outFormat);
            }
            this.outCompress = (CompressEnum)((Object)c.getEntry(COMPONENT, "outCompress", CompressEnum.class, (Object)CompressEnum.None));
            this.outChunkSize = (Integer)c.getEntry(COMPONENT, "outChunkSize", Integer.TYPE, (Object)10000);
            RDFParserOptions defaultParserOptions = new RDFParserOptions();
            defaultParserOptions.setPreserveBNodeIDs(true);
            defaultParserOptions.setStopAtFirstError(false);
            defaultParserOptions.setVerifyData(false);
            defaultParserOptions.setDatatypeHandling(RDFParser.DatatypeHandling.IGNORE);
            this.parserOptions = (RDFParserOptions)c.getEntry(COMPONENT, "parserOptions", RDFParserOptions.class, (Object)defaultParserOptions);
            this.subdirs = (Boolean)c.getEntry(COMPONENT, "subdirs", Boolean.TYPE, (Object)true);
            this.maxPerSubdir = (Integer)c.getEntry(COMPONENT, "maxPerSubDir", Integer.TYPE, (Object)1000);
            this.threadPoolSize = (Integer)c.getEntry(COMPONENT, "threadPoolSize", Integer.TYPE, (Object)10);
        }
    }

    public static interface ConfigurationOptions {
        public static final String SRC_DIR = "srcDir";
        public static final String SRC_FILTER = "srcFilter";
        public static final String SRC_FORMAT = "srcFormat";
        public static final String DEFAULT_SRC_FORMAT = RDFFormat.RDFXML.getName();
        public static final String PARSER_OPTIONS = "parserOptions";
        public static final String OUT_DIR = "outDir";
        public static final String OUT_FORMAT = "outFormat";
        public static final String OUT_CHUNK_SIZE = "outChunkSize";
        public static final int DEFAULT_OUT_CHUNK_SIZE = 10000;
        public static final String OUT_COMPRESS = "outCompress";
        public static final String DEFAULT_OUT_COMPRESS = CompressEnum.None.toString();
        public static final String THREAD_POOL_SIZE = "threadPoolSize";
        public static final int DEFAULT_THREAD_POOL_SIZE = 10;
        public static final String SUBDIRS = "subdirs";
        public static final boolean DEFAULT_SUBDIRS = true;
        public static final String MAX_PER_SUB_DIR = "maxPerSubDir";
        public static final int DEFAULT_MAX_PER_SUBDIR = 1000;
    }

    public static enum CompressEnum {
        None(""),
        GZip(".gz"),
        Zip(".zip");

        private final String ext;

        private CompressEnum(String ext) {
            this.ext = ext;
        }

        public String getExt() {
            return this.ext;
        }
    }
}

