/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.vocab;

import com.bigdata.bop.Constant;
import com.bigdata.bop.IConstant;
import com.bigdata.io.LongPacker;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.impl.AbstractInlineIV;
import com.bigdata.rdf.internal.impl.uri.VocabURIByteIV;
import com.bigdata.rdf.internal.impl.uri.VocabURIShortIV;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.model.BigdataValueFactoryImpl;
import com.bigdata.rdf.vocab.Vocabulary;
import com.bigdata.rdf.vocab.VocabularyDecl;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.log4j.Logger;
import org.openrdf.model.URI;
import org.openrdf.model.Value;

public abstract class BaseVocabulary
implements Vocabulary,
Externalizable {
    private static final transient Logger log = Logger.getLogger(BaseVocabulary.class);
    private static final long serialVersionUID = 1560142397515291331L;
    private transient BigdataValueFactory valueFactory;
    private transient LinkedHashSet<VocabularyDecl> decls;
    private transient LinkedHashMap<Value, BigdataValue> val2iv;
    private transient Map<IV, BigdataValue> iv2val;
    private static final int MAX_ITEMS = 33023;
    private static final transient short VERSION2 = 2;
    private static final transient short currentVersion = 2;

    protected BaseVocabulary() {
    }

    protected BaseVocabulary(String namespace) {
        if (namespace == null) {
            throw new IllegalArgumentException();
        }
        this.valueFactory = BigdataValueFactoryImpl.getInstance(namespace);
    }

    public final synchronized void init() {
        this.init(16, 16);
    }

    private final synchronized void init(int declsInitialCapacity, int valuesInitialCapacity) {
        if (this.valueFactory == null) {
            throw new IllegalStateException();
        }
        if (this.val2iv != null) {
            throw new IllegalStateException();
        }
        if (this.iv2val != null) {
            throw new IllegalStateException();
        }
        this.decls = new LinkedHashSet(declsInitialCapacity);
        this.val2iv = new LinkedHashMap(valuesInitialCapacity);
        this.addValues();
        this.iv2val = new LinkedHashMap<IV, BigdataValue>(this.val2iv.size());
        this.addAllDecls();
        this.generateIVs();
    }

    protected abstract void addValues();

    protected final void addDecl(VocabularyDecl decl) {
        if (decl == null) {
            throw new IllegalArgumentException();
        }
        if (log.isInfoEnabled()) {
            log.info((Object)decl.getClass().getName());
        }
        this.decls.add(decl);
    }

    private void addAllDecls() {
        for (VocabularyDecl decl : this.decls) {
            Iterator<URI> itr = decl.values();
            while (itr.hasNext()) {
                BigdataURI value = this.valueFactory.asValue(itr.next());
                if (this.val2iv.put(value, value) != null) {
                    log.warn((Object)("Duplicate declaration: " + value));
                    continue;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)(decl.getClass().getName() + ":" + value));
            }
        }
    }

    private void generateIVs() {
        int n = this.size();
        if (n > 33023) {
            throw new UnsupportedOperationException("Too many vocabulary items: n=" + n + ", but maximum is " + 33023);
        }
        int i = 0;
        for (Map.Entry<Value, BigdataValue> e : this.val2iv.entrySet()) {
            BigdataValue value = e.getValue();
            AbstractInlineIV iv = i <= 255 ? new VocabURIByteIV((byte)i) : new VocabURIShortIV((short)i);
            value.setIV(iv);
            this.iv2val.put(iv, value);
            ++i;
        }
        assert (this.iv2val.size() == this.val2iv.size());
    }

    @Override
    public final String getNamespace() {
        return this.valueFactory.getNamespace();
    }

    @Override
    public final int size() {
        if (this.val2iv == null) {
            throw new IllegalStateException();
        }
        return this.val2iv.size();
    }

    public final Iterator<BigdataValue> values() {
        return Collections.unmodifiableMap(this.val2iv).values().iterator();
    }

    @Override
    public final BigdataValue asValue(IV iv) {
        if (this.val2iv == null) {
            throw new IllegalStateException();
        }
        if (iv == null) {
            throw new IllegalArgumentException();
        }
        return this.iv2val.get(iv);
    }

    @Override
    public final IV get(Value value) {
        if (this.val2iv == null) {
            throw new IllegalStateException();
        }
        if (value == null) {
            throw new IllegalArgumentException();
        }
        BigdataValue tmp = this.val2iv.get(value);
        if (tmp == null) {
            return null;
        }
        return tmp.getIV();
    }

    @Override
    public final IConstant<IV> getConstant(Value value) {
        IV iv = this.get(value);
        if (iv == null) {
            throw new IllegalArgumentException("Not defined: " + value);
        }
        return new Constant<IV>(iv);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        if (this.val2iv != null) {
            throw new IllegalStateException();
        }
        if (this.iv2val != null) {
            throw new IllegalStateException();
        }
        short version = in.readShort();
        switch (version) {
            case 2: {
                this.readVersion2(in);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown version: " + version);
            }
        }
    }

    private void readVersion2(ObjectInput in) throws IOException {
        int ndecls = LongPacker.unpackInt(in);
        int nvalues = LongPacker.unpackInt(in);
        long checksumActual = in.readLong();
        String namespace = in.readUTF();
        this.valueFactory = BigdataValueFactoryImpl.getInstance(namespace);
        this.init(ndecls, nvalues);
        if (ndecls != this.decls.size()) {
            throw new IOException();
        }
        if (nvalues != this.val2iv.size()) {
            throw new VocabularyVersioningException();
        }
        long checksum = 0L;
        for (Value value : this.val2iv.keySet()) {
            checksum += (long)value.hashCode();
        }
        if (checksum != checksumActual) {
            throw new VocabularyVersioningException();
        }
        this.generateIVs();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        if (this.val2iv == null) {
            throw new IllegalStateException();
        }
        if (this.iv2val == null) {
            throw new IllegalStateException();
        }
        out.writeShort(2);
        switch (2) {
            case 2: {
                this.writeVersion2(out);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    private void writeVersion2(ObjectOutput out) throws IOException {
        assert (this.iv2val.size() == this.val2iv.size());
        long checksum = 0L;
        for (Value value : this.val2iv.keySet()) {
            checksum += (long)value.hashCode();
        }
        LongPacker.packLong(out, (long)this.decls.size());
        LongPacker.packLong(out, (long)this.val2iv.size());
        out.writeLong(checksum);
        out.writeUTF(this.valueFactory.getNamespace());
    }

    public static class VocabularyVersioningException
    extends IOException {
        private static final long serialVersionUID = 1L;
    }
}

