/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.relation.accesspath;

import com.bigdata.relation.accesspath.IBuffer;
import com.bigdata.relation.accesspath.IElementFilter;
import java.lang.reflect.Array;
import org.apache.log4j.Logger;

public abstract class AbstractUnsynchronizedArrayBuffer<E>
implements IBuffer<E> {
    private static final Logger log = Logger.getLogger(AbstractUnsynchronizedArrayBuffer.class);
    private final int capacity;
    private int size = 0;
    private E[] buffer = null;
    private final Class<? extends E> cls;
    private final IElementFilter<? extends E> filter;
    private long counter = 0L;

    @Override
    public final boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public final int size() {
        return this.size;
    }

    public AbstractUnsynchronizedArrayBuffer(int capacity, Class<? extends E> cls) {
        this(capacity, cls, null);
    }

    public AbstractUnsynchronizedArrayBuffer(int capacity, Class<? extends E> cls, IElementFilter<E> filter) {
        if (capacity <= 0) {
            throw new IllegalArgumentException();
        }
        if (cls == null) {
            throw new IllegalArgumentException();
        }
        this.capacity = capacity;
        this.filter = filter;
        this.cls = cls;
    }

    protected boolean accept(E e) {
        if (this.filter != null && this.filter.canAccept(e)) {
            return this.filter.isValid(e);
        }
        return true;
    }

    @Override
    public final void add(E e) {
        this.add2(e);
    }

    public boolean add2(E e) {
        if (e == null) {
            throw new IllegalArgumentException();
        }
        if (!this.accept(e)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("reject: " + e.toString()));
            }
            return false;
        }
        boolean overflow = false;
        if (this.buffer == null) {
            this.buffer = (Object[])Array.newInstance(this.cls, this.capacity);
            this.size = 0;
        } else if (this.size == this.buffer.length) {
            this.overflow();
            assert (this.size == 0);
            assert (this.buffer == null);
            this.buffer = (Object[])Array.newInstance(this.cls, this.capacity);
            this.size = 0;
            overflow = true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("accept: " + e));
        }
        this.buffer[this.size++] = e;
        return overflow;
    }

    protected void overflow() {
        assert (this.size >= 0);
        if (this.size > 0) {
            Object[] a;
            boolean dense;
            assert (this.buffer != null);
            assert (this.buffer.length > 0);
            boolean bl = dense = this.size == this.buffer.length;
            if (log.isInfoEnabled()) {
                log.info((Object)("size=" + this.size + ", dense=" + dense));
            }
            if (dense) {
                a = this.buffer;
            } else {
                assert (this.buffer[0] != null);
                a = (Object[])Array.newInstance(this.cls, this.size);
                System.arraycopy(this.buffer, 0, a, 0, this.size);
            }
            this.buffer = null;
            this.size = 0;
            this.handleChunk(a);
        }
    }

    protected abstract void handleChunk(E[] var1);

    @Override
    public long flush() {
        if (this.size == 0) {
            return this.counter;
        }
        int n = this.size;
        this.overflow();
        this.counter += (long)n;
        if (log.isInfoEnabled()) {
            log.info((Object)("wrote " + n + " elements, cumulative total=" + this.counter));
        }
        return this.counter;
    }

    @Override
    public void reset() {
        if (log.isInfoEnabled()) {
            log.info((Object)"Resetting buffer state and counter.");
        }
        this.buffer = null;
        this.size = 0;
        this.counter = 0L;
    }
}

