/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.relation.accesspath;

import com.bigdata.bop.IPredicate;
import com.bigdata.btree.IIndex;
import com.bigdata.btree.ITuple;
import com.bigdata.btree.ITupleIterator;
import com.bigdata.btree.view.FusedTupleIterator;
import com.bigdata.relation.accesspath.AccessPath;
import com.bigdata.relation.accesspath.IAccessPath;
import com.bigdata.striterator.ChunkedWrappedIterator;
import com.bigdata.striterator.IChunkedOrderedIterator;
import com.bigdata.striterator.IKeyOrder;
import cutthecrap.utils.striterators.Resolver;
import cutthecrap.utils.striterators.Striterator;
import org.apache.log4j.Logger;

public class AccessPathFusedView<E>
implements IAccessPath<E> {
    protected static final Logger log = Logger.getLogger(IAccessPath.class);
    private final AccessPath<E> path1;
    private final AccessPath<E> path2;

    public AccessPathFusedView(AccessPath<E> path1, AccessPath<E> path2) {
        if (path1 == null) {
            throw new IllegalArgumentException();
        }
        if (path2 == null) {
            throw new IllegalArgumentException();
        }
        if (path1 == path2) {
            throw new IllegalArgumentException();
        }
        IPredicate<E> p1 = path1.getPredicate();
        IPredicate<E> p2 = path2.getPredicate();
        if (p1.arity() != p2.arity()) {
            throw new IllegalArgumentException();
        }
        int arity = p1.arity();
        for (int i = 0; i < arity; ++i) {
            if (p1.get(i).equals(p2.get(i))) continue;
            throw new IllegalArgumentException();
        }
        this.path1 = path1;
        this.path2 = path2;
    }

    @Override
    public IPredicate<E> getPredicate() {
        return this.path1.getPredicate();
    }

    @Override
    public boolean isEmpty() {
        return this.path1.isEmpty() && this.path2.isEmpty();
    }

    @Override
    public long rangeCount(boolean exact) {
        if (exact) {
            throw new UnsupportedOperationException();
        }
        return this.path1.rangeCount(exact) + this.path2.rangeCount(exact);
    }

    @Override
    public IIndex getIndex() {
        throw new UnsupportedOperationException();
    }

    private ITupleIterator<E> rangeIterator(int capacity) {
        return new FusedTupleIterator(this.path1.flags, false, new ITupleIterator[]{this.path1.rangeIterator(capacity, this.path1.flags, this.path1.indexLocalFilter), this.path2.rangeIterator(capacity, this.path2.flags, this.path2.indexLocalFilter)});
    }

    @Override
    public IChunkedOrderedIterator<E> iterator() {
        return this.iterator(0L, 0L, 0);
    }

    @Override
    public IChunkedOrderedIterator<E> iterator(long offset, long limit, int capacity) {
        if (offset > 0L) {
            throw new UnsupportedOperationException();
        }
        if (limit == Long.MAX_VALUE) {
            limit = 0L;
        }
        if (limit > 10000000L) {
            throw new UnsupportedOperationException();
        }
        if (this.path1.predicate.isFullyBound(this.path1.getKeyOrder())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Predicate is fully bound.");
            }
            capacity = 1;
            limit = 1L;
        } else if (limit > 0L) {
            capacity = (int)limit;
        }
        int chunkSize = capacity == 0 ? 100 : capacity;
        return new ChunkedWrappedIterator(new Striterator(this.rangeIterator(capacity)).addFilter(new Resolver(){
            private static final long serialVersionUID = 0L;

            @Override
            protected Object resolve(Object arg0) {
                ITuple tuple = (ITuple)arg0;
                return tuple.getObject();
            }
        }), chunkSize, this.path1.keyOrder, null);
    }

    @Override
    public long removeAll() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IKeyOrder<E> getKeyOrder() {
        return this.path1.getKeyOrder();
    }
}

