/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.relation.rule.eval;

import com.bigdata.bop.IPredicate;
import com.bigdata.journal.AbstractTask;
import com.bigdata.journal.ConcurrencyManager;
import com.bigdata.journal.IIndexManager;
import com.bigdata.relation.IMutableRelation;
import com.bigdata.relation.IRelation;
import com.bigdata.relation.accesspath.IBuffer;
import com.bigdata.relation.rule.IProgram;
import com.bigdata.relation.rule.IRule;
import com.bigdata.relation.rule.IStep;
import com.bigdata.relation.rule.eval.ActionEnum;
import com.bigdata.relation.rule.eval.IJoinNexus;
import com.bigdata.relation.rule.eval.IJoinNexusFactory;
import com.bigdata.relation.rule.eval.ISolution;
import com.bigdata.relation.rule.eval.IStepTask;
import com.bigdata.relation.rule.eval.ProgramUtility;
import com.bigdata.relation.rule.eval.RuleStats;
import com.bigdata.service.DataService;
import com.bigdata.service.DataServiceCallable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import org.apache.log4j.Logger;

public abstract class AbstractStepTask
extends DataServiceCallable<RuleStats>
implements IStepTask,
Cloneable {
    protected static final transient Logger log = Logger.getLogger(AbstractStepTask.class);
    protected final ActionEnum action;
    protected final IJoinNexusFactory joinNexusFactory;
    protected IIndexManager indexManager;
    protected final IStep step;

    protected AbstractStepTask(ActionEnum action, IJoinNexusFactory joinNexusFactory, IStep step, IIndexManager indexManager, DataService dataService) {
        if (action == null) {
            throw new IllegalArgumentException();
        }
        if (joinNexusFactory == null) {
            throw new IllegalArgumentException();
        }
        if (step == null) {
            throw new IllegalArgumentException();
        }
        this.action = action;
        this.joinNexusFactory = joinNexusFactory;
        this.step = step;
        this.indexManager = indexManager;
        if (dataService != null) {
            this.setDataService(dataService);
        }
    }

    public String toString() {
        return "{" + this.getClass().getSimpleName() + ", action=" + (Object)((Object)this.action) + ", step=" + this.step.getName() + ", joinNexusFactory=" + this.joinNexusFactory + ", indexManager=" + this.indexManager + "}";
    }

    protected RuleStats runParallel(IJoinNexus joinNexus, IStep program, List<Callable<RuleStats>> tasks) throws InterruptedException, ExecutionException {
        if (log.isInfoEnabled()) {
            log.info((Object)("program=" + program.getName() + ", #tasks=" + tasks.size()));
        }
        if (this.indexManager == null) {
            throw new IllegalStateException();
        }
        RuleStats totals = joinNexus.getRuleStatisticsFactory().newInstance(program);
        ExecutorService service = this.indexManager.getExecutorService();
        List<Future<RuleStats>> futures = service.invokeAll(tasks);
        for (Future<RuleStats> f : futures) {
            RuleStats tmp = f.get();
            totals.add(tmp);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("program=" + program.getName() + ", #tasks=" + tasks.size() + " - done"));
        }
        return totals;
    }

    protected RuleStats runSequential(IJoinNexus joinNexus, IStep program, List<Callable<RuleStats>> tasks) throws InterruptedException, ExecutionException {
        int ntasks = tasks.size();
        if (log.isInfoEnabled()) {
            log.info((Object)("program=" + program.getName() + ", #tasks=" + ntasks));
        }
        if (this.indexManager == null) {
            throw new IllegalStateException();
        }
        ExecutorService service = this.indexManager.getExecutorService();
        RuleStats totals = joinNexus.getRuleStatisticsFactory().newInstance(program);
        Iterator<Callable<RuleStats>> itr = tasks.iterator();
        int n = 0;
        while (itr.hasNext()) {
            Callable<RuleStats> task = itr.next();
            RuleStats tmp = service.submit(task).get();
            totals.add(tmp);
            ++n;
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("program=" + program.getName() + ", finished " + n + " of " + ntasks + " seqential tasks."));
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("program=" + program.getName() + ", #tasks=" + ntasks + " - done"));
        }
        return totals;
    }

    protected RuleStats runOne(IJoinNexus joinNexus, IStep program, Callable<RuleStats> task) throws InterruptedException, ExecutionException {
        RuleStats stats;
        if (log.isInfoEnabled()) {
            log.info((Object)("program=" + program.getName()));
        }
        if (this.indexManager == null) {
            throw new IllegalStateException();
        }
        try {
            stats = task.call();
        }
        catch (Exception ex) {
            throw new ExecutionException(ex);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("program=" + program.getName() + " - done"));
        }
        return stats;
    }

    public Future<RuleStats> submit() {
        if (!this.isDataService()) {
            return this.indexManager.getExecutorService().submit(this);
        }
        return this.submitToConcurrencyManager();
    }

    private Future<RuleStats> submitToConcurrencyManager() {
        Map<String, IRelation> tmpRelations;
        if (!this.isDataService()) {
            throw new IllegalStateException();
        }
        ProgramUtility util = new ProgramUtility();
        if (util.isClosureProgram(this.step)) {
            throw new UnsupportedOperationException();
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("running w/ concurrency control: " + this));
        }
        HashSet<String> indexNames = new HashSet<String>();
        if (this.action.isMutation()) {
            tmpRelations = this.getWriteRelations(this.indexManager, this.step, 0L);
            Set<String> writeIndexNames = this.getIndexNames(tmpRelations.values());
            indexNames.addAll(writeIndexNames);
        }
        tmpRelations = this.getReadRelations(this.indexManager, this.step, 0L);
        Set<String> readIndexNames = this.getIndexNames(tmpRelations.values());
        indexNames.addAll(readIndexNames);
        Object[] resource = indexNames.toArray(new String[0]);
        if (log.isInfoEnabled()) {
            log.info((Object)("resource=" + Arrays.toString(resource)));
        }
        long timestamp = this.action.isMutation() ? this.joinNexusFactory.getWriteTimestamp() : this.joinNexusFactory.getReadTimestamp();
        if (log.isInfoEnabled()) {
            log.info((Object)("timestamp=" + timestamp + ", task=" + this));
        }
        final AbstractStepTask innerTask = this.clone();
        ConcurrencyManager concurrencyManager = this.getDataService().getConcurrencyManager();
        AbstractTask task = new AbstractTask(concurrencyManager, timestamp, (String[])resource){

            protected Object doTask() throws Exception {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Executing inner task: " + this));
                }
                innerTask.indexManager = this.getJournal();
                return innerTask.call();
            }
        };
        if (log.isInfoEnabled()) {
            log.info((Object)("running on concurrencyManager: " + this));
        }
        FutureTask<RuleStats> future = concurrencyManager.submit(task);
        return future;
    }

    public AbstractStepTask clone() {
        try {
            return (AbstractStepTask)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected Set<String> getWriteRelationNames(IStep step) {
        HashSet<String> c = new HashSet<String>();
        this.getWriteRelationNames(step, c);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Found " + c.size() + " relations, program=" + step.getName()));
        }
        return c;
    }

    private void getWriteRelationNames(IStep p, Set<String> c) {
        if (p.isRule()) {
            IRule r = (IRule)p;
            if (r.getHead() == null) {
                throw new IllegalArgumentException("No head for this rule: rule=" + p);
            }
            c.add(r.getHead().getOnlyRelationName());
        } else {
            Iterator<IStep> itr = ((IProgram)p).steps();
            while (itr.hasNext()) {
                this.getWriteRelationNames(itr.next(), c);
            }
        }
    }

    protected Map<String, IRelation> getWriteRelations(IIndexManager indexManager, IStep step, long timestamp) {
        if (step == null) {
            throw new IllegalArgumentException();
        }
        HashMap<String, IRelation> c = new HashMap<String, IRelation>();
        this.getWriteRelations(indexManager, step, c, timestamp);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Located " + c.size() + " relations in the head(s), program=" + step.getName()));
        }
        return c;
    }

    private void getWriteRelations(IIndexManager indexManager, IStep p, Map<String, IRelation> c, long timestamp) {
        if (p.isRule()) {
            IRule r = (IRule)p;
            String relationIdentifier = r.getHead().getOnlyRelationName();
            if (!c.containsKey(relationIdentifier)) {
                IRelation relation = (IRelation)indexManager.getResourceLocator().locate(relationIdentifier, timestamp);
                c.put(relationIdentifier, relation);
            }
        } else {
            Iterator<IStep> itr = ((IProgram)p).steps();
            while (itr.hasNext()) {
                this.getWriteRelations(indexManager, itr.next(), c, timestamp);
            }
        }
    }

    protected Map<String, IRelation> getReadRelations(IIndexManager indexManager, IStep step, long timestamp) {
        if (step == null) {
            throw new IllegalArgumentException();
        }
        HashMap<String, IRelation> c = new HashMap<String, IRelation>();
        this.getReadRelations(indexManager, step, c, timestamp);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Located " + c.size() + " relations in the tail(s), program=" + step.getName()));
        }
        return c;
    }

    private void getReadRelations(IIndexManager indexManager, IStep p, Map<String, IRelation> c, long timestamp) {
        if (p.isRule()) {
            IRule r = (IRule)p;
            Iterator<IPredicate> itr = r.getTail();
            while (itr.hasNext()) {
                IPredicate pred = itr.next();
                int relationCount = pred.getRelationCount();
                for (int i = 0; i < relationCount; ++i) {
                    String relationName = pred.getRelationName(i);
                    if (c.containsKey(relationName)) continue;
                    IRelation relation = (IRelation)indexManager.getResourceLocator().locate(relationName, timestamp);
                    c.put(relationName, relation);
                }
            }
        } else {
            Iterator<IStep> itr = ((IProgram)p).steps();
            while (itr.hasNext()) {
                this.getReadRelations(indexManager, itr.next(), c, timestamp);
            }
        }
    }

    protected Map<String, IBuffer<ISolution[]>> getMutationBuffers(IJoinNexus joinNexus, Map<String, IRelation> relations) {
        if (!this.action.isMutation()) {
            throw new IllegalStateException();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"");
        }
        HashMap<String, IBuffer<ISolution[]>> c = new HashMap<String, IBuffer<ISolution[]>>(relations.size());
        for (Map.Entry<String, IRelation> entry : relations.entrySet()) {
            IBuffer<ISolution[]> buffer;
            String relationIdentifier = entry.getKey();
            IRelation relation = entry.getValue();
            switch (this.action) {
                case Insert: {
                    buffer = joinNexus.newInsertBuffer((IMutableRelation)relation);
                    break;
                }
                case Delete: {
                    buffer = joinNexus.newDeleteBuffer((IMutableRelation)relation);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("action=" + (Object)((Object)this.action)));
                }
            }
            c.put(relationIdentifier, buffer);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created " + c.size() + " mutation buffers: action=" + (Object)((Object)this.action)));
        }
        return c;
    }

    protected Set<String> getIndexNames(Collection<IRelation> c) {
        if (c == null) {
            throw new IllegalArgumentException();
        }
        if (c.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        HashSet<String> set = new HashSet<String>();
        for (IRelation relation : c) {
            set.addAll(relation.getIndexNames());
        }
        return set;
    }
}

