/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.relation.rule.eval.pipeline;

import com.bigdata.bop.IBindingSet;
import com.bigdata.relation.accesspath.BlockingBuffer;
import com.bigdata.relation.accesspath.BufferClosedException;
import com.bigdata.relation.accesspath.IBuffer;
import com.bigdata.relation.accesspath.ThickAsynchronousIterator;
import com.bigdata.relation.rule.IRule;
import com.bigdata.relation.rule.eval.IJoinNexus;
import com.bigdata.relation.rule.eval.IJoinNexusFactory;
import com.bigdata.relation.rule.eval.IRuleState;
import com.bigdata.relation.rule.eval.ISolution;
import com.bigdata.relation.rule.eval.IStepTask;
import com.bigdata.relation.rule.eval.RuleLog;
import com.bigdata.relation.rule.eval.RuleState;
import com.bigdata.relation.rule.eval.RuleStats;
import com.bigdata.relation.rule.eval.pipeline.IJoinMaster;
import com.bigdata.relation.rule.eval.pipeline.JoinStats;
import com.bigdata.util.InnerCause;
import com.bigdata.util.concurrent.ExecutionExceptions;
import java.io.IOException;
import java.nio.channels.ClosedByInterruptException;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.log4j.Logger;

public abstract class JoinMasterTask
implements IStepTask,
IJoinMaster {
    protected static final Logger log = Logger.getLogger(JoinMasterTask.class);
    protected static final boolean DEBUG = log.isDebugEnabled();
    protected final IRule rule;
    protected final IJoinNexus joinNexus;
    protected final IJoinNexusFactory joinNexusFactory;
    protected final IBuffer<ISolution[]> solutionBuffer;
    protected final int tailCount;
    protected final IRuleState ruleState;
    protected final int[] order;
    protected final RuleStats ruleStats;
    protected final JoinStats[] joinStats;
    protected final UUID masterUUID;

    protected JoinMasterTask(IRule rule, IJoinNexus joinNexus, IBuffer<ISolution[]> solutionBuffer) {
        if (rule == null) {
            throw new IllegalArgumentException();
        }
        if (joinNexus == null) {
            throw new IllegalArgumentException();
        }
        this.rule = rule;
        this.joinNexus = joinNexus;
        this.joinNexusFactory = joinNexus.getJoinNexusFactory();
        this.tailCount = rule.getTailCount();
        this.masterUUID = UUID.randomUUID();
        this.ruleState = new RuleState(rule, joinNexus);
        this.order = this.ruleState.getPlan().getOrder();
        this.ruleStats = joinNexus.getRuleStatisticsFactory().newInstance(this.ruleState);
        this.joinStats = new JoinStats[this.tailCount];
        for (int orderIndex = 0; orderIndex < this.tailCount; ++orderIndex) {
            this.joinStats[orderIndex] = new JoinStats(orderIndex);
        }
        this.solutionBuffer = solutionBuffer;
    }

    @Override
    public final UUID getUUID() {
        return this.masterUUID;
    }

    @Override
    public RuleStats call() throws Exception {
        if (this.ruleState.getPlan().isEmpty()) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Rule proven to have no solutions.");
            }
            return this.ruleStats;
        }
        long begin = System.currentTimeMillis();
        List<Future<Void>> futures = this.start();
        try {
            this.awaitAll(futures, Long.MAX_VALUE, TimeUnit.SECONDS);
        }
        catch (InterruptedException ex) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Interrupted");
            }
            if (log.isInfoEnabled()) {
                try {
                    this.awaitAll(futures, 1L, TimeUnit.SECONDS);
                }
                catch (Throwable t) {}
            }
        }
        catch (ExecutionExceptions ex) {
            log.error((Object)ex, (Throwable)ex);
            throw new RuntimeException(ex);
        }
        this.ruleStats.elapsed += System.currentTimeMillis() - begin;
        this.combineJoinStats();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Done");
        }
        return this.ruleStats;
    }

    abstract List<Future<Void>> start() throws Exception;

    protected void awaitAll(List<Future<Void>> futures, long timeout, TimeUnit unit) throws ExecutionExceptions, InterruptedException, TimeoutException {
        long nanos;
        long begin = System.nanoTime();
        long remaining = nanos = unit.toNanos(timeout);
        LinkedList<ExecutionException> errors = new LinkedList<ExecutionException>();
        for (Future<Void> f : futures) {
            if (remaining < 0L) {
                int ncancelled = 0;
                for (Future<Void> x : futures) {
                    if (!x.cancel(true)) continue;
                    ++ncancelled;
                }
                log.warn((Object)("Cancelled " + ncancelled + " futures due to timeout"));
                throw new TimeoutException();
            }
            try {
                f.get(remaining, TimeUnit.NANOSECONDS);
            }
            catch (CancellationException ex) {
                if (log.isInfoEnabled()) {
                    log.info((Object)ex.getLocalizedMessage(), (Throwable)ex);
                }
            }
            catch (ExecutionException ex) {
                if (InnerCause.isInnerCause(ex, InterruptedException.class) || InnerCause.isInnerCause(ex, ClosedByInterruptException.class) || InnerCause.isInnerCause(ex, BufferClosedException.class) || InnerCause.isInnerCause(ex, CancellationException.class)) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)ex.getLocalizedMessage(), (Throwable)ex);
                    }
                }
                errors.add(new ExecutionException(ex));
                log.error((Object)ex.getMessage(), (Throwable)ex);
            }
            remaining = nanos - (System.nanoTime() - begin);
        }
        if (!errors.isEmpty()) {
            throw new ExecutionExceptions(errors);
        }
    }

    protected ThickAsynchronousIterator<IBindingSet[]> newBindingSetIterator(IBindingSet bindingSet) {
        return new ThickAsynchronousIterator<IBindingSet[]>((E[])new IBindingSet[][]{{bindingSet}});
    }

    protected void combineJoinStats() {
        long solutionCount = !this.joinNexus.getAction().isMutation() ? ((BlockingBuffer)this.solutionBuffer).getElementsAddedCount() : this.joinStats[this.order[this.tailCount - 1]].bindingSetsOut;
        this.ruleStats.solutionCount.addAndGet(solutionCount);
        this.ruleStats.mutationCount.addAndGet(this.joinStats[this.order[this.tailCount - 1]].mutationCount.get());
        int[] order = this.ruleState.getPlan().getOrder();
        int tailIndex = 0;
        while (tailIndex < this.tailCount) {
            JoinStats o = this.joinStats[order[tailIndex]];
            int n = tailIndex;
            this.ruleStats.chunkCount[n] = this.ruleStats.chunkCount[n] + o.chunkCount;
            int n2 = tailIndex++;
            this.ruleStats.elementCount[n2] = this.ruleStats.elementCount[n2] + o.elementCount;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("\n" + this.ruleState));
            log.info((Object)("\n" + this.ruleStats));
        }
        RuleLog.log(this.rule, this.ruleState, this.joinStats);
    }

    @Override
    public void report(JoinStats joinStats) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("\n" + joinStats.toString()));
        }
        JoinStats total = this.joinStats[joinStats.orderIndex];
        total.add(joinStats);
    }

    @Override
    public IBuffer<ISolution[]> getSolutionBuffer() throws IOException {
        return this.solutionBuffer;
    }
}

