/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.resources;

import com.bigdata.btree.ILocalBTreeView;
import com.bigdata.cache.ConcurrentWeakValueCacheWithTimeout;
import com.bigdata.util.NT;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class IndexCache<H extends ILocalBTreeView>
extends ConcurrentWeakValueCacheWithTimeout<NT, H> {
    private static final boolean debug = false;
    private final AtomicLong retentionTime = new AtomicLong(-1L);

    public IndexCache(int cacheCapacity, long cacheTimeoutMillis) {
        super(cacheCapacity, TimeUnit.MILLISECONDS.toNanos(cacheTimeoutMillis));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getRetentionTime() {
        AtomicLong atomicLong = this.retentionTime;
        synchronized (atomicLong) {
            if (this.retentionTime.get() == -1L) {
                long tmp = Long.MAX_VALUE;
                int n = 0;
                long now = System.currentTimeMillis();
                Iterator itr = this.entryIterator();
                while (itr.hasNext()) {
                    long timestamp;
                    Map.Entry entry = itr.next();
                    if (entry.getValue().get() == null || (timestamp = ((NT)entry.getKey()).getTimestamp()) == 0L) continue;
                    if (timestamp < tmp) {
                        tmp = timestamp;
                    }
                    ++n;
                }
                this.retentionTime.set(tmp);
            }
            return this.retentionTime.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public H put(NT k, H v) {
        AtomicLong atomicLong = this.retentionTime;
        synchronized (atomicLong) {
            if (this.retentionTime.get() > k.getTimestamp()) {
                this.retentionTime.set(k.getTimestamp());
            }
        }
        return (H)((ILocalBTreeView)super.put(k, v));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public H putIfAbsent(NT k, H v) {
        AtomicLong atomicLong = this.retentionTime;
        synchronized (atomicLong) {
            if (this.retentionTime.get() > k.getTimestamp()) {
                this.retentionTime.set(k.getTimestamp());
            }
        }
        return (H)((ILocalBTreeView)super.putIfAbsent(k, v));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected WeakReference<H> removeMapEntry(NT k) {
        AtomicLong atomicLong = this.retentionTime;
        synchronized (atomicLong) {
            if (this.retentionTime.get() == k.getTimestamp()) {
                this.retentionTime.set(-1L);
            }
        }
        return super.removeMapEntry(k);
    }
}

