/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.resources;

import com.bigdata.btree.BTree;
import com.bigdata.btree.Checkpoint;
import com.bigdata.btree.IndexMetadata;
import com.bigdata.btree.keys.IKeyBuilder;
import com.bigdata.btree.keys.KeyBuilder;
import com.bigdata.io.SerializerUtil;
import com.bigdata.mdi.SegmentMetadata;
import com.bigdata.rawstore.IRawStore;
import java.util.UUID;

public class IndexSegmentIndex
extends BTree {
    private final IKeyBuilder keyBuilder = new KeyBuilder(24);

    public static IndexSegmentIndex createTransient() {
        IndexMetadata metadata = new IndexMetadata(UUID.randomUUID());
        metadata.setBTreeClassName(IndexSegmentIndex.class.getName());
        return (IndexSegmentIndex)BTree.createTransient(metadata);
    }

    public IndexSegmentIndex(IRawStore store, Checkpoint checkpoint, IndexMetadata metadata, boolean readOnly) {
        super(store, checkpoint, metadata, readOnly);
    }

    protected byte[] getKey(long commitTime, UUID uuid) {
        return this.keyBuilder.reset().append(commitTime).append(uuid).getKey();
    }

    public synchronized void add(SegmentMetadata resourceMetadata) {
        if (resourceMetadata == null) {
            throw new IllegalArgumentException();
        }
        assert (resourceMetadata.isIndexSegment());
        long createTime = resourceMetadata.getCreateTime();
        if (createTime == 0L) {
            throw new IllegalArgumentException();
        }
        byte[] key = this.getKey(createTime, resourceMetadata.getUUID());
        if (super.contains(key)) {
            throw new IllegalArgumentException("entry exists: timestamp=" + createTime);
        }
        super.insert(key, SerializerUtil.serialize(resourceMetadata));
    }
}

