/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.resources;

import com.bigdata.resources.StoreManager;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import org.apache.log4j.Logger;

public class ResourceFileFilter
implements FileFilter {
    private final StoreManager resourceManager;
    protected static final Logger log = Logger.getLogger(ResourceFileFilter.class);

    public ResourceFileFilter(StoreManager resourceManager) {
        if (resourceManager == null) {
            throw new IllegalArgumentException();
        }
        this.resourceManager = resourceManager;
    }

    protected boolean accept2(File f) {
        return false;
    }

    @Override
    public final boolean accept(File f) {
        if (f.isDirectory()) {
            String fc;
            File dir = f;
            try {
                fc = dir.getCanonicalPath();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            if (!fc.startsWith(this.resourceManager.getDataDir().getPath())) {
                throw new RuntimeException("File not in data directory: file=" + f + ", dataDir=" + this.resourceManager.dataDir);
            }
            return true;
        }
        if (f.getName().endsWith(".jnl")) {
            return true;
        }
        if (f.getName().endsWith(".seg")) {
            return true;
        }
        if (this.accept2(f)) {
            return true;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Unknown file: " + f));
        }
        return false;
    }
}

