/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.resources;

import com.bigdata.btree.IndexSegmentBuilder;
import com.bigdata.counters.CounterSet;
import com.bigdata.counters.Instrument;
import com.bigdata.counters.OneShotInstrument;
import com.bigdata.journal.IConcurrencyManager;
import com.bigdata.mdi.LocalPartitionMetadata;
import com.bigdata.resources.IPartitionIdFactory;
import com.bigdata.resources.IndexManager;
import com.bigdata.resources.OverflowManager;
import com.bigdata.resources.StoreManager;
import com.bigdata.service.DataService;
import com.bigdata.service.IMetadataService;
import com.bigdata.util.ReverseLongComparator;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public abstract class ResourceManager
extends OverflowManager
implements IPartitionIdFactory {
    protected static final Logger log = Logger.getLogger(ResourceManager.class);
    private IConcurrencyManager concurrencyManager;

    @Override
    public CounterSet getCounters() {
        CounterSet root = new CounterSet();
        root.makePath("Live Journal").attach(this.getLiveJournal().getCounters());
        CounterSet tmp = root.makePath("Overflow Manager");
        tmp.addCounter("Overflow Enabled", new Instrument<Boolean>(){

            @Override
            public void sample() {
                this.setValue(ResourceManager.this.isOverflowEnabled());
            }
        });
        tmp.addCounter("Overflow Allowed", new Instrument<Boolean>(){

            @Override
            public void sample() {
                this.setValue(ResourceManager.this.isOverflowAllowed());
            }
        });
        tmp.addCounter("Should Overflow", new Instrument<Boolean>(){

            @Override
            public void sample() {
                this.setValue(ResourceManager.this.shouldOverflow());
            }
        });
        tmp.addCounter("Synchronous Overflow Count", new Instrument<Long>(){

            @Override
            public void sample() {
                this.setValue(ResourceManager.this.getSynchronousOverflowCount());
            }
        });
        tmp.attach(this.overflowCounters.getCounters());
        tmp.addCounter("Asynchronous Overflow Millis", new Instrument<Long>(){

            @Override
            public void sample() {
                long t = ResourceManager.this.overflowCounters.asynchronousOverflowMillis.get();
                if (ResourceManager.this.isOverflowEnabled() && !ResourceManager.this.isOverflowAllowed()) {
                    t += System.currentTimeMillis() - ResourceManager.this.overflowCounters.asynchronousOverflowStartMillis.get();
                }
                this.setValue(t);
            }
        });
        CounterSet tmp2 = tmp.makePath("Overflow Tasks");
        tmp2.addCounter("Concurrent Build Count", new Instrument<Integer>(){

            @Override
            public void sample() {
                this.setValue(ResourceManager.this.concurrentBuildTaskCount.get());
            }
        });
        tmp2.addCounter("Concurrent Merge Count", new Instrument<Integer>(){

            @Override
            public void sample() {
                this.setValue(ResourceManager.this.concurrentMergeTaskCount.get());
            }
        });
        tmp2.addCounter("Active Builds", new Instrument<String>(){

            @Override
            public void sample() {
                TreeMap<Long, IndexSegmentBuilder> map = new TreeMap<Long, IndexSegmentBuilder>(new ReverseLongComparator());
                long now = System.currentTimeMillis();
                for (IndexSegmentBuilder task : ResourceManager.this.buildTasks.values()) {
                    long startTime = task.getStartTime();
                    if (startTime == 0L) continue;
                    long elapsed = startTime == 0L ? 0L : now - startTime;
                    map.put(elapsed, task);
                }
                StringBuilder sb = new StringBuilder();
                for (Map.Entry e : map.entrySet()) {
                    long elapsed = e.getKey();
                    IndexSegmentBuilder task = (IndexSegmentBuilder)e.getValue();
                    String name = task.metadata.getName();
                    LocalPartitionMetadata pmd = task.metadata.getPartitionMetadata();
                    int partitionId = pmd == null ? -1 : pmd.getPartitionId();
                    String cause = pmd == null ? "N/A" : pmd.getIndexPartitionCause().toString();
                    String indexPartitionName = DataService.getIndexPartitionName(name, partitionId);
                    sb.append(indexPartitionName + "{elapsed=" + elapsed + "ms, cause=" + cause + ", compactingMerge=" + task.compactingMerge + ", commitTime=" + task.commitTime + ", plan=" + task.plan + "} ");
                }
                this.setValue(sb.toString());
            }
        });
        tmp = root.makePath("Index Manager");
        tmp.addCounter("Stale Locator Cache Capacity", new Instrument<Integer>(){

            @Override
            public void sample() {
                this.setValue(ResourceManager.this.staleLocatorCache.capacity());
            }
        });
        tmp.addCounter("Stale Locator Cache Size", new Instrument<Integer>(){

            @Override
            public void sample() {
                this.setValue(ResourceManager.this.getStaleLocatorCount());
            }
        });
        tmp.addCounter("Index Count", new Instrument<Long>(){

            @Override
            public void sample() {
                StoreManager.ManagedJournal liveJournal = ResourceManager.this.getLiveJournal();
                long lastCommitTime = liveJournal.getLastCommitTime();
                if (lastCommitTime == 0L) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)"No commit points on the live journal?");
                    }
                    return;
                }
                long indexCount = liveJournal.getName2Addr(lastCommitTime).rangeCount();
                this.setValue(indexCount);
            }
        });
        tmp.addCounter("Index Cache Capacity", new Instrument<Integer>(){

            @Override
            public void sample() {
                this.setValue(ResourceManager.this.getIndexCacheCapacity());
            }
        });
        tmp.addCounter("Index Cache Size", new Instrument<Integer>(){

            @Override
            public void sample() {
                this.setValue(ResourceManager.this.getIndexCacheSize());
            }
        });
        tmp.addCounter("Index Segment Cache Capacity", new Instrument<Integer>(){

            @Override
            public void sample() {
                this.setValue(ResourceManager.this.getIndexSegmentCacheCapacity());
            }
        });
        tmp.addCounter("Index Segment Cache Size", new Instrument<Integer>(){

            @Override
            public void sample() {
                this.setValue(ResourceManager.this.getIndexSegmentCacheSize());
            }
        });
        tmp.makePath("indices").attach(this.getIndexCounters());
        tmp = root.makePath("Store Manager");
        tmp.addCounter("DataDir", new Instrument<String>(){

            @Override
            public void sample() {
                this.setValue(ResourceManager.this.dataDir == null ? "N/A" : ResourceManager.this.dataDir.getAbsolutePath());
            }
        });
        tmp.addCounter("TmpDir", new Instrument<String>(){

            @Override
            public void sample() {
                this.setValue(ResourceManager.this.tmpDir == null ? "N/A" : ResourceManager.this.tmpDir.getAbsolutePath());
            }
        });
        tmp.addCounter("isOpen", new Instrument<Boolean>(){

            @Override
            public void sample() {
                this.setValue(ResourceManager.this.isOpen());
            }
        });
        tmp.addCounter("isStarting", new Instrument<Boolean>(){

            @Override
            public void sample() {
                this.setValue(ResourceManager.this.isStarting());
            }
        });
        tmp.addCounter("isRunning", new Instrument<Boolean>(){

            @Override
            public void sample() {
                this.setValue(ResourceManager.this.isRunning());
            }
        });
        tmp.addCounter("Store Cache Capacity", new OneShotInstrument<Integer>(this.storeCache.capacity()));
        tmp.addCounter("Store Cache Size", new Instrument<Long>(){

            @Override
            public void sample() {
                this.setValue(Long.valueOf(ResourceManager.this.getStoreCacheSize()));
            }
        });
        tmp.addCounter("Managed Journal Count", new Instrument<Long>(){

            @Override
            public void sample() {
                this.setValue(ResourceManager.this.getManagedJournalCount());
            }
        });
        tmp.addCounter("Managed Segment Store Count", new Instrument<Long>(){

            @Override
            public void sample() {
                this.setValue(ResourceManager.this.getManagedSegmentCount());
            }
        });
        tmp.addCounter("Journal (Re-)open Count", new Instrument<Long>(){

            @Override
            public void sample() {
                this.setValue(ResourceManager.this.journalReopenCount.get());
            }
        });
        tmp.addCounter("Segment Store (Re-)open Count", new Instrument<Long>(){

            @Override
            public void sample() {
                this.setValue(ResourceManager.this.segmentStoreReopenCount.get());
            }
        });
        tmp.addCounter("Journal Delete Count", new Instrument<Long>(){

            @Override
            public void sample() {
                this.setValue(ResourceManager.this.journalDeleteCount.get());
            }
        });
        tmp.addCounter("Segment Store Delete Count", new Instrument<Long>(){

            @Override
            public void sample() {
                this.setValue(ResourceManager.this.segmentStoreDeleteCount.get());
            }
        });
        tmp.addCounter("Bytes Under Management", new Instrument<Long>(){

            @Override
            public void sample() {
                if (ResourceManager.this.isRunning()) {
                    this.setValue(ResourceManager.this.getBytesUnderManagement());
                }
            }
        });
        tmp.addCounter("Journal Bytes Under Management", new Instrument<Long>(){

            @Override
            public void sample() {
                if (ResourceManager.this.isRunning()) {
                    this.setValue(ResourceManager.this.getJournalBytesUnderManagement());
                }
            }
        });
        tmp.addCounter("Segment Bytes Under Management", new Instrument<Long>(){

            @Override
            public void sample() {
                if (ResourceManager.this.isRunning()) {
                    this.setValue(ResourceManager.this.getSegmentBytesUnderManagement());
                }
            }
        });
        tmp.addCounter("Bytes Deleted", new Instrument<Long>(){

            @Override
            public void sample() {
                this.setValue(ResourceManager.this.bytesDeleted.get());
            }
        });
        tmp.addCounter("Data Volume Bytes Available", new Instrument<Long>(){

            @Override
            public void sample() {
                if (!ResourceManager.this.isTransient()) {
                    this.setValue(ResourceManager.this.getDataDirFreeSpace());
                }
            }
        });
        tmp.addCounter("Temp Volume Bytes Available", new Instrument<Long>(){

            @Override
            public void sample() {
                this.setValue(ResourceManager.this.getTempDirFreeSpace());
            }
        });
        tmp.addCounter("Maximum Journal Size At Overflow", new Instrument<Long>(){

            @Override
            public void sample() {
                this.setValue(ResourceManager.this.maximumJournalSizeAtOverflow);
            }
        });
        tmp.addCounter("Purge Resources Millis", new Instrument<Long>(){

            @Override
            public void sample() {
                this.setValue(ResourceManager.this.purgeResourcesMillis);
            }
        });
        tmp.addCounter("Release Time", new Instrument<Long>(){

            @Override
            public void sample() {
                this.setValue(ResourceManager.this.getReleaseTime());
            }
        });
        tmp.addCounter("Last Overflow Time", new Instrument<Long>(){

            @Override
            public void sample() {
                this.setValue(ResourceManager.this.lastOverflowTime);
            }
        });
        tmp.addCounter("Last Commit Time Preserved", new Instrument<Long>(){

            @Override
            public void sample() {
                this.setValue(ResourceManager.this.lastCommitTimePreserved);
            }
        });
        tmp.addCounter("Last Commit Time", new Instrument<Long>(){

            @Override
            public void sample() {
                try {
                    StoreManager.ManagedJournal liveJournal = ResourceManager.this.getLiveJournal();
                    this.setValue(liveJournal.getLastCommitTime());
                }
                catch (Throwable t) {
                    log.warn((Object)t);
                }
            }
        });
        tmp2 = tmp.makePath("resourceService");
        tmp2.attach(this.getResourceService().counters.getCounters());
        return root;
    }

    @Override
    public IConcurrencyManager getConcurrencyManager() {
        if (this.concurrencyManager == null) {
            throw new IllegalStateException();
        }
        return this.concurrencyManager;
    }

    @Override
    public void setConcurrencyManager(IConcurrencyManager concurrencyManager) {
        if (concurrencyManager == null) {
            throw new IllegalArgumentException();
        }
        if (this.concurrencyManager != null) {
            throw new IllegalStateException();
        }
        this.concurrencyManager = concurrencyManager;
    }

    public ResourceManager(Properties properties) {
        super(properties);
    }

    @Override
    public int nextPartitionId(String scaleOutIndexName) {
        IMetadataService mds = this.getFederation().getMetadataService();
        if (mds == null) {
            throw new RuntimeException("Metadata service not discovered.");
        }
        try {
            int newPartitionId = mds.nextPartitionId(scaleOutIndexName);
            return newPartitionId;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static interface Options
    extends OverflowManager.Options {
    }

    public static interface IResourceManagerCounters
    extends OverflowManager.IOverflowManagerCounters,
    IndexManager.IIndexManagerCounters,
    StoreManager.IStoreManagerCounters {
        public static final String OverflowManager = "Overflow Manager";
        public static final String IndexPartitionTasks = "Overflow Tasks";
        public static final String IndexManager = "Index Manager";
        public static final String StoreManager = "Store Manager";
        public static final String LiveJournal = "Live Journal";
    }
}

