/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rwstore.sector;

import com.bigdata.cache.ConcurrentWeakValueCache;
import com.bigdata.counters.CounterSet;
import com.bigdata.journal.AbstractJournal;
import com.bigdata.journal.BufferMode;
import com.bigdata.journal.ForceEnum;
import com.bigdata.journal.IBufferStrategy;
import com.bigdata.journal.ICommitter;
import com.bigdata.journal.IRootBlockView;
import com.bigdata.journal.RootBlockView;
import com.bigdata.journal.StoreTypeEnum;
import com.bigdata.mdi.IResourceMetadata;
import com.bigdata.rawstore.IAddressManager;
import com.bigdata.rawstore.IAllocationContext;
import com.bigdata.rawstore.IAllocationManagerStore;
import com.bigdata.rawstore.IPSOutputStream;
import com.bigdata.rwstore.IRWStrategy;
import com.bigdata.rwstore.IRawTx;
import com.bigdata.rwstore.sector.IMemoryManager;
import com.bigdata.util.ChecksumUtility;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.UUID;
import java.util.concurrent.locks.Lock;

public class MemStrategy
implements IBufferStrategy,
IRWStrategy,
IAllocationManagerStore {
    private final IMemoryManager m_mmgr;
    private final IAddressManager m_am;
    private volatile boolean m_modifiable = true;
    private volatile boolean m_open = true;
    private volatile boolean m_dirty = true;
    private volatile IRootBlockView m_rb0 = null;
    private volatile IRootBlockView m_rb1 = null;
    private CounterSet root;

    public MemStrategy(IMemoryManager mmgr) {
        if (mmgr == null) {
            throw new IllegalArgumentException();
        }
        this.m_mmgr = mmgr;
        this.m_am = new IAddressManager(){

            @Override
            public int getByteCount(long addr) {
                return (int)(0xFFFFL & addr);
            }

            @Override
            public long getOffset(long addr) {
                return addr >> 32;
            }

            @Override
            public long getPhysicalAddress(long addr) {
                return MemStrategy.this.m_mmgr.getPhysicalAddress(addr);
            }

            @Override
            public long toAddr(int nbytes, long offset) {
                return (offset << 32) + (long)nbytes;
            }

            @Override
            public String toString(long addr) {
                return "PhysicalAddress: " + this.getPhysicalAddress(addr) + ", length: " + this.getByteCount(addr);
            }
        };
        UUID uuid = UUID.randomUUID();
        long createTime = System.currentTimeMillis();
        ChecksumUtility checker = new ChecksumUtility();
        this.m_rb0 = new RootBlockView(true, 0, 0L, 0L, 0L, 0L, 0L, 0L, uuid, 0L, 0L, 0L, 0L, StoreTypeEnum.RW, createTime, 0L, 3, checker);
        this.m_rb1 = new RootBlockView(false, 0, 0L, 0L, 0L, 0L, 0L, 0L, uuid, 0L, 0L, 0L, 0L, StoreTypeEnum.RW, createTime, 0L, 3, checker);
    }

    @Override
    public IMemoryManager getStore() {
        return this.m_mmgr;
    }

    @Override
    public void abort() {
    }

    @Override
    public void closeForWrites() {
        this.m_modifiable = false;
    }

    @Override
    public void commit() {
        this.m_mmgr.commit();
    }

    @Override
    public Lock getCommitLock() {
        return this.m_mmgr.getCommitLock();
    }

    @Override
    public void postCommit() {
        this.m_mmgr.postCommit();
        this.m_dirty = false;
    }

    @Override
    public IAddressManager getAddressManager() {
        return this.m_am;
    }

    @Override
    public BufferMode getBufferMode() {
        return BufferMode.MemStore;
    }

    @Override
    public synchronized CounterSet getCounters() {
        if (this.root == null) {
            this.root = new CounterSet();
        }
        return this.root;
    }

    @Override
    public long getExtent() {
        long ssze = this.m_mmgr.getSectorSize();
        return ssze * (long)this.m_mmgr.getSectorCount();
    }

    @Override
    public int getHeaderSize() {
        return 0;
    }

    @Override
    public long getInitialExtent() {
        return this.m_mmgr.getSectorSize();
    }

    @Override
    public int getMaxRecordSize() {
        return (int)this.getMaximumExtent();
    }

    @Override
    public long getMaximumExtent() {
        long ssze = this.m_mmgr.getSectorSize();
        return ssze * (long)this.m_mmgr.getMaxSectors();
    }

    @Override
    public long getMetaBitsAddr() {
        return 0L;
    }

    @Override
    public long getMetaStartAddr() {
        return 0L;
    }

    @Override
    public long getNextOffset() {
        return 0L;
    }

    @Override
    public int getOffsetBits() {
        return 0;
    }

    @Override
    public long getUserExtent() {
        return 0L;
    }

    @Override
    public ByteBuffer readRootBlock(boolean rootBlock0) {
        return (rootBlock0 ? this.m_rb0 : this.m_rb1).asReadOnlyBuffer();
    }

    @Override
    public boolean requiresCommit(IRootBlockView block) {
        return this.m_dirty;
    }

    @Override
    public long transferTo(RandomAccessFile out) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void truncate(long extent) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean useChecksums() {
        return false;
    }

    @Override
    public void writeRootBlock(IRootBlockView rootBlock, ForceEnum forceOnCommitEnum) {
        if (rootBlock.isRootBlock0()) {
            this.m_rb0 = rootBlock;
        } else {
            this.m_rb1 = rootBlock;
        }
    }

    @Override
    public void close() {
        this.m_open = false;
        this.destroy();
    }

    @Override
    public void delete(long addr) {
        if (!this.m_modifiable) {
            throw new IllegalStateException("The store is not modifiable");
        }
        this.m_mmgr.free(addr);
        this.m_dirty = true;
    }

    @Override
    public void deleteResources() {
        this.m_mmgr.close();
    }

    @Override
    public void destroy() {
        this.deleteResources();
    }

    @Override
    public void force(boolean metadata) {
    }

    @Override
    public File getFile() {
        return null;
    }

    @Override
    public IResourceMetadata getResourceMetadata() {
        throw new UnsupportedOperationException();
    }

    @Override
    public UUID getUUID() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isFullyBuffered() {
        return true;
    }

    @Override
    public boolean isOpen() {
        return this.m_open;
    }

    @Override
    public boolean isReadOnly() {
        return !this.m_modifiable;
    }

    @Override
    public boolean isStable() {
        return false;
    }

    @Override
    public ByteBuffer read(long addr) {
        return ByteBuffer.wrap(this.m_mmgr.read(addr));
    }

    @Override
    public long size() {
        return this.getExtent();
    }

    @Override
    public long write(ByteBuffer data) {
        this.m_dirty = true;
        return this.m_mmgr.allocate(data);
    }

    @Override
    public int getByteCount(long addr) {
        return this.m_am.getByteCount(addr);
    }

    @Override
    public long getOffset(long addr) {
        return this.m_am.getOffset(addr);
    }

    @Override
    public long getPhysicalAddress(long addr) {
        return this.m_am.getPhysicalAddress(addr);
    }

    @Override
    public long toAddr(int nbytes, long offset) {
        return this.m_am.toAddr(nbytes, offset);
    }

    @Override
    public String toString(long addr) {
        return this.m_am.toString(addr);
    }

    @Override
    public IRawTx newTx() {
        return this.m_mmgr.newTx();
    }

    @Override
    public void abortContext(IAllocationContext context) {
        this.m_mmgr.abortContext(context);
    }

    @Override
    public void detachContext(IAllocationContext context) {
        this.m_mmgr.detachContext(context);
    }

    @Override
    public void registerContext(IAllocationContext context) {
        this.m_mmgr.registerContext(context);
    }

    @Override
    public int checkDeferredFrees(AbstractJournal abstractJournal) {
        return this.m_mmgr.checkDeferredFrees(abstractJournal);
    }

    @Override
    public void delete(long addr, IAllocationContext context) {
        this.m_mmgr.free(addr, context);
    }

    @Override
    public long getLastReleaseTime() {
        return this.m_mmgr.getLastReleaseTime();
    }

    @Override
    public void registerExternalCache(ConcurrentWeakValueCache<Long, ICommitter> historicalIndexCache, int byteCount) {
        this.m_mmgr.registerExternalCache(historicalIndexCache, byteCount);
    }

    @Override
    public long saveDeferrals() {
        return this.m_mmgr.saveDeferrals();
    }

    @Override
    public long write(ByteBuffer data, IAllocationContext context) {
        return this.m_mmgr.allocate(data, context);
    }

    @Override
    public boolean isCommitted(long addr) {
        return this.m_mmgr.isCommitted(addr);
    }

    @Override
    public InputStream getInputStream(long addr) {
        return this.m_mmgr.getInputStream(addr);
    }

    @Override
    public IPSOutputStream getOutputStream() {
        return this.m_mmgr.getOutputStream();
    }

    @Override
    public IPSOutputStream getOutputStream(IAllocationContext context) {
        return this.m_mmgr.getOutputStream(context);
    }

    @Override
    public boolean isDirty() {
        return this.m_dirty;
    }
}

