/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.service;

import com.bigdata.counters.CounterSet;
import com.bigdata.counters.ICounterSetAccess;
import com.bigdata.counters.httpd.CounterSetHTTPD;
import com.bigdata.io.DirectBufferPool;
import com.bigdata.service.AbstractService;
import com.bigdata.service.IFederationDelegate;
import com.bigdata.service.IService;
import com.bigdata.util.httpd.AbstractHTTPD;
import com.bigdata.util.httpd.NanoHTTPD;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.UUID;
import org.apache.log4j.Logger;

public class DefaultServiceFederationDelegate<T extends AbstractService>
implements IFederationDelegate<T> {
    protected static final Logger log = Logger.getLogger(DefaultServiceFederationDelegate.class);
    protected final T service;

    public DefaultServiceFederationDelegate(T service) {
        if (service == null) {
            throw new IllegalArgumentException();
        }
        this.service = service;
    }

    @Override
    public T getService() {
        return this.service;
    }

    @Override
    public String getServiceName() {
        return ((AbstractService)this.service).getServiceName();
    }

    @Override
    public UUID getServiceUUID() {
        return ((AbstractService)this.service).getServiceUUID();
    }

    @Override
    public Class getServiceIface() {
        return ((AbstractService)this.service).getServiceIface();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reattachDynamicCounters() {
        CounterSet tmp;
        CounterSet serviceRoot = ((AbstractService)this.service).getFederation().getServiceCounterSet();
        CounterSet counterSet = tmp = serviceRoot.makePath("Memory");
        synchronized (counterSet) {
            tmp.detach("DirectBufferPool");
            tmp.makePath("DirectBufferPool").attach(DirectBufferPool.getCounters());
        }
    }

    @Override
    public boolean isServiceReady() {
        return true;
    }

    @Override
    public void didStart() {
    }

    @Override
    public void serviceJoin(IService service, UUID serviceUUID) {
    }

    @Override
    public void serviceLeave(UUID serviceUUID) {
    }

    @Override
    public AbstractHTTPD newHttpd(int httpdPort, ICounterSetAccess access) throws IOException {
        return new CounterSetHTTPD(httpdPort, access, (IService)this.service){

            @Override
            public NanoHTTPD.Response doGet(NanoHTTPD.Request req) throws Exception {
                try {
                    DefaultServiceFederationDelegate.this.reattachDynamicCounters();
                }
                catch (Exception ex) {
                    log.warn((Object)("Could not re-attach dynamic counters: " + ex), (Throwable)ex);
                }
                return super.doGet(req);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void logHttpdURL(File file) {
        file.delete();
        String httpdURL = ((AbstractService)this.service).getFederation().getHttpdURL();
        if (httpdURL != null) {
            try (BufferedWriter w = new BufferedWriter(new FileWriter(file));){
                w.write(httpdURL);
            }
            catch (IOException ex) {
                log.warn((Object)("Problem writing httpdURL on file: " + file));
            }
        }
    }
}

