/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.service;

import com.bigdata.service.IBigdataFederation;
import java.util.Properties;

public interface IBigdataClient<T> {
    public IBigdataFederation<T> connect();

    public IBigdataFederation<T> getFederation();

    public void disconnect(boolean var1);

    public boolean isConnected();

    public int getThreadPoolSize();

    public int getDefaultRangeQueryCapacity();

    public boolean getBatchApiOnly();

    public int getMaxStaleLocatorRetries();

    public int getMaxParallelTasksPerRequest();

    public boolean isReadConsistent();

    public long getTaskTimeout();

    public int getIndexCacheCapacity();

    public long getIndexCacheTimeout();

    public Properties getProperties();

    public static interface Options {
        public static final String CLIENT_THREAD_POOL_SIZE = IBigdataClient.class.getName() + ".threadPoolSize";
        public static final String DEFAULT_CLIENT_THREAD_POOL_SIZE = "0";
        public static final String CLIENT_MAX_STALE_LOCATOR_RETRIES = IBigdataClient.class.getName() + ".maxStaleLocatorRetries";
        public static final String DEFAULT_CLIENT_MAX_STALE_LOCATOR_RETRIES = "100";
        public static final String CLIENT_READ_CONSISTENT = IBigdataClient.class.getName() + ".readConsistent";
        public static final String DEFAULT_CLIENT_READ_CONSISTENT = "true";
        public static final String CLIENT_MAX_PARALLEL_TASKS_PER_REQUEST = IBigdataClient.class.getName() + ".maxParallelTasksPerRequest";
        public static final String DEFAULT_CLIENT_MAX_PARALLEL_TASKS_PER_REQUEST = "100";
        public static final String CLIENT_TASK_TIMEOUT = IBigdataClient.class.getName() + "taskTimeout";
        public static final String DEFAULT_CLIENT_TASK_TIMEOUT = "9223372036854775807";
        public static final String CLIENT_RANGE_QUERY_CAPACITY = IBigdataClient.class.getName() + ".rangeIteratorCapacity";
        public static final String DEFAULT_CLIENT_RANGE_QUERY_CAPACITY = "10000";
        public static final String CLIENT_BATCH_API_ONLY = IBigdataClient.class.getName() + ".batchOnly";
        public static final String DEFAULT_CLIENT_BATCH_API_ONLY = "false";
        public static final String CLIENT_LOCATOR_CACHE_CAPACITY = IBigdataClient.class.getName() + ".locatorCacheCapacity";
        public static final String DEFAULT_CLIENT_LOCATOR_CACHE_CAPACITY = "20";
        public static final String CLIENT_LOCATOR_CACHE_TIMEOUT = IBigdataClient.class.getName() + ".locatorCacheTimeout";
        public static final String DEFAULT_CLIENT_LOCATOR_CACHE_TIMEOUT = "60000";
        public static final String CLIENT_INDEX_CACHE_CAPACITY = IBigdataClient.class.getName() + ".indexCacheCapacity";
        public static final String DEFAULT_CLIENT_INDEX_CACHE_CAPACITY = "20";
        public static final String CLIENT_INDEX_CACHE_TIMEOUT = IBigdataClient.class.getName() + ".indexCacheTimeout";
        public static final String DEFAULT_CLIENT_INDEX_CACHE_TIMEOUT = "60000";
        public static final String COLLECT_PLATFORM_STATISTICS = IBigdataClient.class.getName() + ".collectPlatformStatistics";
        public static final String DEFAULT_COLLECT_PLATFORM_STATISTICS = "true";
        public static final String COLLECT_QUEUE_STATISTICS = IBigdataClient.class.getName() + ".collectQueueStatistics";
        public static final String DEFAULT_COLLECT_QUEUE_STATISTICS = "true";
        public static final String REPORT_DELAY = IBigdataClient.class.getName() + ".reportDelay";
        public static final String DEFAULT_REPORT_DELAY = "60000";
        public static final String REPORT_ALL = IBigdataClient.class.getName() + ".reportAll";
        public static final String DEFAULT_REPORT_ALL = "false";
        public static final String HTTPD_PORT = IBigdataClient.class.getName() + ".httpdPort";
        public static final String DEFAULT_HTTPD_PORT = "0";
        public static final String GANGLIA_LISTEN_GROUP = IBigdataClient.class.getName() + ".ganglia.listenGroup";
        public static final String DEFAULT_GANGLIA_LISTEN_GROUP = "239.2.11.71";
        public static final String GANGLIA_LISTEN_PORT = IBigdataClient.class.getName() + ".ganglia.listenPort";
        public static final String DEFAULT_GANGLIA_LISTEN_PORT = Integer.toString(8649);
        public static final String GANGLIA_LISTEN = IBigdataClient.class.getName() + ".ganglia.listen";
        public static final String DEFAULT_GANGLIA_LISTEN = "true";
        public static final String GANGLIA_REPORT = IBigdataClient.class.getName() + ".ganglia.report";
        public static final String DEFAULT_GANGLIA_REPORT = "true";
        public static final String GANGLIA_SERVERS = IBigdataClient.class.getName() + ".ganglia.servers";
        public static final String DEFAULT_GANGLIA_SERVERS = "239.2.11.71";
    }
}

