/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.service;

import com.bigdata.counters.CounterSet;
import com.bigdata.counters.DefaultInstrumentFactory;
import com.bigdata.counters.History;
import com.bigdata.counters.HistoryInstrument;
import com.bigdata.counters.ICounter;
import com.bigdata.counters.ICounterSet;
import com.bigdata.counters.PeriodEnum;
import com.bigdata.journal.BufferMode;
import com.bigdata.journal.Journal;
import com.bigdata.service.AbstractFederation;
import com.bigdata.service.AbstractRoundRobinServiceLoadHelper;
import com.bigdata.service.AbstractScaleOutFederation;
import com.bigdata.service.AbstractService;
import com.bigdata.service.AbstractServiceLoadHelperWithScores;
import com.bigdata.service.AbstractServiceLoadHelperWithoutScores;
import com.bigdata.service.Event;
import com.bigdata.service.EventReceiver;
import com.bigdata.service.HostScore;
import com.bigdata.service.IDataService;
import com.bigdata.service.IEventReportingService;
import com.bigdata.service.ILoadBalancerService;
import com.bigdata.service.IServiceShutdown;
import com.bigdata.service.ServiceScore;
import com.bigdata.util.concurrent.DaemonThreadFactory;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Properties;
import java.util.UUID;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;

public abstract class LoadBalancerService
extends AbstractService
implements ILoadBalancerService,
IServiceShutdown,
IEventReportingService {
    protected static final Logger log = Logger.getLogger(LoadBalancerService.class);
    protected final String ps = "/";
    private final ICounterSet.IInstrumentFactory instrumentFactory = DefaultInstrumentFactory.OVERWRITE_60M;
    protected final long serviceJoinTimeout;
    protected final ReentrantLock lock = new ReentrantLock();
    protected final Condition joined = this.lock.newCondition();
    protected ConcurrentHashMap<String, HostScore> activeHosts = new ConcurrentHashMap();
    protected ConcurrentHashMap<UUID, ServiceScore> activeDataServices = new ConcurrentHashMap();
    protected AtomicReference<HostScore[]> hostScores = new AtomicReference<Object>(null);
    protected AtomicReference<ServiceScore[]> serviceScores = new AtomicReference<Object>(null);
    protected long nupdates = 0L;
    protected final long initialRoundRobinUpdateCount;
    private final RoundRobinServiceLoadHelper roundRobinServiceLoadHelper;
    protected final File logDir;
    protected final boolean isTransient;
    private final Properties properties;
    protected final ScheduledExecutorService updateService;
    private final long logDelayMillis;
    private final long logMaxFiles;
    private long logLastMillis = System.currentTimeMillis();
    private int logFileCount = 0;
    protected final int historyMinutes;
    protected final Journal eventStore;
    protected final EventReceiver eventReceiver;

    public Properties getProperties() {
        return new Properties(this.properties);
    }

    protected abstract String getClientHostname();

    public LoadBalancerService(Properties properties) {
        Properties p;
        if (properties == null) {
            throw new IllegalArgumentException();
        }
        this.properties = (Properties)properties.clone();
        this.isTransient = Boolean.valueOf(properties.getProperty(Options.TRANSIENT, "false"));
        if (log.isInfoEnabled()) {
            log.info((Object)(Options.TRANSIENT + "=" + this.isTransient));
        }
        if (this.isTransient) {
            this.logDir = null;
        } else {
            String val = properties.getProperty(Options.LOG_DIR, ".");
            this.logDir = new File(val);
            if (log.isInfoEnabled()) {
                log.info((Object)(Options.LOG_DIR + "=" + this.logDir));
            }
            this.logDir.mkdirs();
        }
        this.logDelayMillis = Long.parseLong(properties.getProperty(Options.LOG_DELAY, "3600000"));
        if (log.isInfoEnabled()) {
            log.info((Object)(Options.LOG_DELAY + "=" + this.logDelayMillis));
        }
        this.logMaxFiles = Integer.parseInt(properties.getProperty(Options.LOG_MAX_FILES, "168"));
        if (log.isInfoEnabled()) {
            log.info((Object)(Options.LOG_MAX_FILES + "=" + this.logMaxFiles));
        }
        this.historyMinutes = Integer.parseInt(properties.getProperty(Options.HISTORY_MINUTES, "5"));
        if (log.isInfoEnabled()) {
            log.info((Object)(Options.HISTORY_MINUTES + "=" + this.historyMinutes));
        }
        if (this.historyMinutes <= 0 || this.historyMinutes > 60) {
            throw new RuntimeException(Options.HISTORY_MINUTES + " must be in [1:60].");
        }
        this.serviceJoinTimeout = Long.parseLong(properties.getProperty(Options.SERVICE_JOIN_TIMEOUT, "3000"));
        if (log.isInfoEnabled()) {
            log.info((Object)(Options.SERVICE_JOIN_TIMEOUT + "=" + this.serviceJoinTimeout));
        }
        if (this.serviceJoinTimeout <= 0L) {
            throw new RuntimeException(Options.SERVICE_JOIN_TIMEOUT + " must be positive.");
        }
        this.initialRoundRobinUpdateCount = Long.parseLong(properties.getProperty(Options.INITIAL_ROUND_ROBIN_UPDATE_COUNT, "5"));
        if (log.isInfoEnabled()) {
            log.info((Object)(Options.INITIAL_ROUND_ROBIN_UPDATE_COUNT + "=" + this.initialRoundRobinUpdateCount));
        }
        this.roundRobinServiceLoadHelper = new RoundRobinServiceLoadHelper();
        long delay = Long.parseLong(properties.getProperty(Options.UPDATE_DELAY, "60000"));
        if (log.isInfoEnabled()) {
            log.info((Object)(Options.UPDATE_DELAY + "=" + delay));
        }
        long initialDelay = delay * 2L;
        TimeUnit unit = TimeUnit.MILLISECONDS;
        this.updateService = Executors.newSingleThreadScheduledExecutor(new DaemonThreadFactory(this.getClass().getName() + ".updateService"));
        this.updateService.scheduleWithFixedDelay(new UpdateTask(), initialDelay, delay, unit);
        long eventHistoryMillis = Long.parseLong(properties.getProperty(Options.EVENT_HISTORY_MILLIS, "3600000"));
        if (log.isInfoEnabled()) {
            log.info((Object)(Options.EVENT_HISTORY_MILLIS + "=" + eventHistoryMillis));
        }
        if (this.isTransient) {
            p = new Properties();
            p.setProperty(com.bigdata.journal.Options.BUFFER_MODE, BufferMode.Transient.toString());
            this.eventStore = new Journal(p);
        } else {
            p = new Properties();
            p.setProperty(com.bigdata.journal.Options.FILE, new File(this.logDir, "events.jnl").toString());
            this.eventStore = new Journal(p);
        }
        EventReceiver.EventBTree eventBTree = (EventReceiver.EventBTree)this.eventStore.getIndex("events");
        if (eventBTree == null) {
            eventBTree = EventReceiver.EventBTree.create(this.eventStore);
            this.eventStore.registerIndex("events", eventBTree);
        }
        this.eventReceiver = new EventReceiver(eventHistoryMillis, eventBTree);
    }

    @Override
    public synchronized LoadBalancerService start() {
        return this;
    }

    @Override
    public boolean isOpen() {
        return !this.updateService.isShutdown();
    }

    protected void finalized() throws Throwable {
        super.finalize();
        this.shutdownNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void shutdown() {
        if (!this.isOpen()) {
            return;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)"begin");
        }
        this.updateService.shutdown();
        this.logCounters("final");
        Lock tmpLock = this.eventReceiver.getWriteLock();
        tmpLock.lock();
        try {
            this.eventStore.getIndex("events").writeCheckpoint();
            this.eventStore.shutdown();
        }
        catch (Throwable t) {
            log.error((Object)t, t);
        }
        finally {
            tmpLock.unlock();
        }
        super.shutdown();
        if (log.isInfoEnabled()) {
            log.info((Object)"done");
        }
    }

    @Override
    public synchronized void shutdownNow() {
        if (!this.isOpen()) {
            return;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)"begin");
        }
        this.updateService.shutdownNow();
        this.logCounters("final");
        this.eventStore.shutdownNow();
        super.shutdownNow();
        if (log.isInfoEnabled()) {
            log.info((Object)"done");
        }
    }

    @Override
    public synchronized void destroy() {
        super.destroy();
        if (!this.isTransient) {
            this.eventStore.destroy();
            File[] logFiles = this.logDir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.getName().startsWith("counters") && pathname.getName().endsWith(".xml");
                }
            });
            if (logFiles != null) {
                for (File file : logFiles) {
                    if (file.delete()) continue;
                    log.warn((Object)("Could not delete: " + file));
                }
            }
            this.logDir.delete();
        }
    }

    @Override
    public final Class getServiceIface() {
        return ILoadBalancerService.class;
    }

    protected void setHostScores(HostScore[] a) {
        Arrays.sort(a);
        double totalRawScore = 0.0;
        for (HostScore s : a) {
            totalRawScore += s.rawScore;
        }
        for (int i = 0; i < a.length; ++i) {
            HostScore score = a[i];
            score.rank = i;
            score.drank = (double)i / (double)a.length;
            score.score = HostScore.normalize(score.rawScore, totalRawScore);
            this.activeHosts.put(score.hostname, score);
            if (!log.isInfoEnabled()) continue;
            log.info((Object)score.toString());
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("The most active host was: " + a[a.length - 1]));
            log.info((Object)("The least active host was: " + a[0]));
        }
        this.hostScores.set(a);
    }

    protected void setServiceScores(ServiceScore[] a) {
        Arrays.sort(a);
        double totalRawScore = 0.0;
        for (ServiceScore s : a) {
            totalRawScore += s.rawScore;
        }
        for (int i = 0; i < a.length; ++i) {
            ServiceScore score = a[i];
            score.rank = i;
            score.drank = (double)i / (double)a.length;
            score.score = HostScore.normalize(score.rawScore, totalRawScore);
            this.activeDataServices.put(score.serviceUUID, score);
            if (!log.isInfoEnabled()) continue;
            log.info((Object)score.toString());
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("The most active service was: " + a[a.length - 1]));
            log.info((Object)("The least active service was: " + a[0]));
        }
        this.serviceScores.set(a);
    }

    protected void logCounters(String basename) {
        if (this.isTransient) {
            log.warn((Object)"LBS is transient - request ignored.");
            return;
        }
        File file = new File(this.logDir, "counters" + basename + ".xml");
        this.logCounters(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void logCounters(File file) {
        if (file == null) {
            throw new IllegalArgumentException();
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Writing counters on " + file));
        }
        OutputStream os = null;
        try {
            os = new BufferedOutputStream(new FileOutputStream(file));
            this.getFederation().getCounters().asXML(os, "UTF-8", null);
        }
        catch (Exception ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void logCounters() throws IOException {
        if (this.isTransient) {
            log.warn((Object)"LBS is transient - request ignored.");
            return;
        }
        File file = File.createTempFile("counters-hup", ".xml", this.logDir);
        this.logCounters(file);
    }

    @Override
    public void sighup() throws IOException {
        this.logCounters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void join(UUID serviceUUID, Class serviceIface, String hostname) {
        String serviceName;
        if (serviceUUID == null) {
            throw new IllegalArgumentException();
        }
        if (serviceIface == null) {
            throw new IllegalArgumentException();
        }
        if (hostname == null) {
            throw new IllegalArgumentException();
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("serviceUUID=" + serviceUUID + ", serviceIface=" + serviceIface + ", hostname=" + hostname));
        }
        if (IDataService.class == serviceIface) {
            AbstractFederation fed;
            try {
                fed = this.getFederation();
            }
            catch (IllegalStateException t) {
                return;
            }
            try {
                serviceName = fed.getDataService(serviceUUID).getServiceName();
            }
            catch (Throwable t) {
                log.warn((Object)t.getMessage(), t);
                serviceName = serviceUUID.toString();
            }
        } else {
            serviceName = serviceUUID.toString();
        }
        this.lock.lock();
        try {
            if (this.activeHosts.putIfAbsent(hostname, new HostScore(hostname)) == null && log.isInfoEnabled()) {
                log.info((Object)("New host joined: hostname=" + hostname));
            }
            if (IDataService.class == serviceIface && this.activeDataServices.putIfAbsent(serviceUUID, new ServiceScore(hostname, serviceUUID, serviceName)) == null && log.isInfoEnabled()) {
                log.info((Object)("Data service join: hostname=" + hostname + ", serviceUUID=" + serviceUUID));
            }
            if (this.getServiceUUID() != null) {
                this.getFederation().getCounters().makePath(AbstractFederation.getServiceCounterPathPrefix(serviceUUID, serviceIface, hostname));
            }
            this.joined.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leave(UUID serviceUUID) {
        if (log.isInfoEnabled()) {
            log.info((Object)("serviceUUID=" + serviceUUID));
        }
        try {
            this.lock.lock();
            ServiceScore info = this.activeDataServices.remove(serviceUUID);
            if (info != null) {
                // empty if block
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void notifyEvent(Event e) throws IOException {
        if (!this.isOpen()) {
            throw new IllegalStateException();
        }
        this.eventReceiver.notifyEvent(e);
    }

    @Override
    public Iterator<Event> rangeIterator(long fromTime, long toTime) {
        if (!this.isOpen()) {
            throw new IllegalStateException();
        }
        return this.eventReceiver.rangeIterator(fromTime, toTime);
    }

    @Override
    public long rangeCount(long fromTime, long toTime) {
        if (!this.isOpen()) {
            throw new IllegalStateException();
        }
        return this.eventReceiver.rangeCount(fromTime, toTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notify(UUID serviceUUID, byte[] data) {
        block6: {
            this.setupLoggingContext();
            try {
                if (log.isInfoEnabled()) {
                    log.info((Object)("serviceUUID=" + serviceUUID));
                }
                if (serviceUUID.equals(this.getServiceUUID())) break block6;
                try {
                    this.getFederation().getCounters().readXML(new ByteArrayInputStream(data), this.instrumentFactory, null);
                }
                catch (Exception e) {
                    log.warn((Object)e.getMessage(), (Throwable)e);
                    throw new RuntimeException(e);
                }
            }
            finally {
                this.clearLoggingContext();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void warn(String msg, UUID serviceUUID) {
        this.setupLoggingContext();
        try {
            log.warn((Object)(msg + " : serviceUUID=" + serviceUUID));
        }
        finally {
            this.clearLoggingContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void urgent(String msg, UUID serviceUUID) {
        this.setupLoggingContext();
        try {
            log.error((Object)(msg + " : serviceUUID=" + serviceUUID));
        }
        finally {
            this.clearLoggingContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isHighlyUtilizedDataService(UUID serviceUUID) throws IOException {
        this.setupLoggingContext();
        try {
            ServiceScore[] scores = this.serviceScores.get();
            if (scores == null) {
                if (log.isInfoEnabled()) {
                    log.info((Object)"No scores yet");
                }
                boolean bl = false;
                return bl;
            }
            ServiceScore score = this.activeDataServices.get(serviceUUID);
            if (score == null) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Service is not scored: " + serviceUUID));
                }
                boolean bl = false;
                return bl;
            }
            boolean bl = this.isHighlyUtilizedDataService(score, scores);
            return bl;
        }
        finally {
            this.clearLoggingContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isUnderUtilizedDataService(UUID serviceUUID) throws IOException {
        this.setupLoggingContext();
        try {
            ServiceScore[] scores = this.serviceScores.get();
            if (scores == null) {
                if (log.isInfoEnabled()) {
                    log.info((Object)"No scores yet");
                }
                boolean bl = false;
                return bl;
            }
            ServiceScore score = this.activeDataServices.get(serviceUUID);
            if (score == null) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Service is not scored: " + serviceUUID));
                }
                boolean bl = false;
                return bl;
            }
            boolean bl = this.isUnderUtilizedDataService(score, scores);
            return bl;
        }
        finally {
            this.clearLoggingContext();
        }
    }

    protected boolean isHighlyUtilizedDataService(ServiceScore score, ServiceScore[] scores) {
        if (score == null) {
            throw new IllegalArgumentException();
        }
        if (scores == null) {
            throw new IllegalArgumentException();
        }
        boolean highlyUtilized = false;
        if (score.drank > 0.8) {
            highlyUtilized = true;
        } else if (score.rank == scores.length - 1) {
            highlyUtilized = true;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("highlyUtilized=" + highlyUtilized + " : " + score));
        }
        return highlyUtilized;
    }

    protected boolean isUnderUtilizedDataService(ServiceScore score, ServiceScore[] scores) {
        if (score == null) {
            throw new IllegalArgumentException();
        }
        if (scores == null) {
            throw new IllegalArgumentException();
        }
        boolean underUtilized = false;
        if (score.drank < 0.2) {
            underUtilized = true;
        } else if (score.rank == 0) {
            underUtilized = true;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("underUtilized=" + underUtilized + " : " + score));
        }
        return underUtilized;
    }

    @Override
    public UUID getUnderUtilizedDataService() throws IOException, TimeoutException, InterruptedException {
        return this.getUnderUtilizedDataServices(1, 1, null)[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UUID[] getUnderUtilizedDataServices(int minCount, int maxCount, UUID exclude) throws IOException, TimeoutException, InterruptedException {
        this.setupLoggingContext();
        try {
            Object[] uuids;
            if (minCount < 0) {
                throw new IllegalArgumentException();
            }
            if (maxCount < 0) {
                throw new IllegalArgumentException();
            }
            this.lock.lock();
            try {
                uuids = this.getUnderUtilizedDataServicesWithLock(minCount, maxCount, exclude);
            }
            finally {
                this.lock.unlock();
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("minCount=" + minCount + ", maxCount=" + maxCount + ", exclude=" + exclude + " : reporting " + uuids.length + " under-utilized and non-excluded services: " + Arrays.toString(uuids)));
            }
            Object[] objectArray = uuids;
            return objectArray;
        }
        finally {
            this.clearLoggingContext();
        }
    }

    private UUID[] getUnderUtilizedDataServicesWithLock(int minCount, int maxCount, UUID exclude) throws TimeoutException, InterruptedException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("minCount=" + minCount + ", maxCount=" + maxCount + ", exclude=" + exclude));
        }
        if (this.nupdates < this.initialRoundRobinUpdateCount) {
            return this.roundRobinServiceLoadHelper.getUnderUtilizedDataServices(minCount, maxCount, exclude);
        }
        ServiceScore[] scores = this.serviceScores.get();
        if (scores == null || scores.length == 0) {
            if (minCount == 0) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"No scores, minCount is zero - will return null.");
                }
                return null;
            }
            return new ServiceLoadHelperWithoutScores().getUnderUtilizedDataServices(minCount, maxCount, exclude);
        }
        int nok = 0;
        UUID knownGood = null;
        for (int i = 0; i < scores.length && nok < 1; ++i) {
            UUID serviceUUID = scores[i].serviceUUID;
            if (exclude != null && exclude.equals(serviceUUID) || !this.activeDataServices.containsKey(serviceUUID)) continue;
            if (knownGood == null) {
                knownGood = serviceUUID;
            }
            ++nok;
        }
        if (nok == 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No non-excluded services.");
            }
            if (minCount == 0) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"No non-excluded services, minCount is zero - will return null.");
                }
                return null;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Will await a service join.");
            }
            return new ServiceLoadHelperWithoutScores().getUnderUtilizedDataServices(minCount, maxCount, exclude);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will recommend services based on scores: #scored=" + scores.length + ", nok=" + nok + ", knownGood=" + knownGood + ", exclude=" + exclude));
        }
        assert (nok > 0);
        assert (knownGood != null);
        assert (scores != null);
        assert (scores.length != 0);
        return new ServiceLoadHelperWithScores(knownGood, scores).getUnderUtilizedDataServices(minCount, maxCount, exclude);
    }

    protected class ServiceLoadHelperWithScores
    extends AbstractServiceLoadHelperWithScores {
        public ServiceLoadHelperWithScores(UUID knownGood, ServiceScore[] scores) {
            super(LoadBalancerService.this.serviceJoinTimeout, knownGood, scores);
        }

        @Override
        protected void awaitJoin(long timeout, TimeUnit unit) throws InterruptedException {
            LoadBalancerService.this.joined.await(timeout, unit);
        }

        @Override
        protected UUID[] getActiveServices() {
            return LoadBalancerService.this.activeDataServices.keySet().toArray(new UUID[0]);
        }

        @Override
        protected boolean isActiveDataService(UUID serviceUUID) {
            return LoadBalancerService.this.activeDataServices.containsKey(serviceUUID);
        }

        @Override
        protected boolean isUnderUtilizedDataService(ServiceScore score, ServiceScore[] scores) {
            return LoadBalancerService.this.isUnderUtilizedDataService(score, scores);
        }
    }

    protected class ServiceLoadHelperWithoutScores
    extends AbstractServiceLoadHelperWithoutScores {
        public ServiceLoadHelperWithoutScores() {
            super(LoadBalancerService.this.serviceJoinTimeout);
        }

        @Override
        protected void awaitJoin(long timeout, TimeUnit unit) throws InterruptedException {
            LoadBalancerService.this.joined.await(timeout, unit);
        }

        @Override
        protected UUID[] getActiveServices() {
            return LoadBalancerService.this.activeDataServices.keySet().toArray(new UUID[0]);
        }

        @Override
        protected boolean isActiveDataService(UUID serviceUUID) {
            return LoadBalancerService.this.activeDataServices.containsKey(serviceUUID);
        }

        @Override
        protected boolean isUnderUtilizedDataService(ServiceScore score, ServiceScore[] scores) {
            return LoadBalancerService.this.isUnderUtilizedDataService(score, scores);
        }
    }

    protected class RoundRobinServiceLoadHelper
    extends AbstractRoundRobinServiceLoadHelper {
        protected RoundRobinServiceLoadHelper() {
        }

        @Override
        protected UUID[] awaitServices(int minCount, long timeout) throws InterruptedException, TimeoutException {
            return ((AbstractScaleOutFederation)LoadBalancerService.this.getFederation()).awaitServices(minCount, timeout);
        }
    }

    protected class UpdateTask
    implements Runnable {
        protected final transient Logger log = Logger.getLogger(UpdateTask.class);
        final NumberFormat scoreFormat = NumberFormat.getInstance();
        final NumberFormat percentFormat;
        final NumberFormat millisFormat;
        final NumberFormat bytesFormat;

        public UpdateTask() {
            this.scoreFormat.setMaximumFractionDigits(2);
            this.scoreFormat.setMinimumIntegerDigits(1);
            this.percentFormat = NumberFormat.getInstance();
            this.percentFormat.setMaximumFractionDigits(2);
            this.percentFormat.setMinimumIntegerDigits(1);
            this.millisFormat = NumberFormat.getIntegerInstance();
            this.bytesFormat = NumberFormat.getIntegerInstance();
            this.bytesFormat.setGroupingUsed(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.updateHostScores();
                this.updateServiceScores();
                this.setupCounters();
                this.logCounters();
            }
            catch (Throwable t) {
                this.log.error((Object)"Problem in update task?", t);
            }
            finally {
                ++LoadBalancerService.this.nupdates;
            }
        }

        protected void updateHostScores() {
            if (LoadBalancerService.this.activeHosts.isEmpty()) {
                if (this.log.isInfoEnabled()) {
                    this.log.info((Object)"No active hosts");
                }
                return;
            }
            Vector<HostScore> scores = new Vector<HostScore>();
            Iterator<ICounterSet> itrh = LoadBalancerService.this.getFederation().getCounters().counterSetIterator();
            while (itrh.hasNext()) {
                HostScore score;
                block7: {
                    CounterSet hostCounterSet = (CounterSet)itrh.next();
                    String hostname = hostCounterSet.getName();
                    if (!LoadBalancerService.this.activeHosts.containsKey(hostname)) {
                        if (!this.log.isDebugEnabled()) continue;
                        this.log.debug((Object)("Host is not active: " + hostname));
                        continue;
                    }
                    try {
                        score = this.computeScore(hostname, hostCounterSet);
                    }
                    catch (Exception ex) {
                        this.log.error((Object)("Problem computing host score: " + hostname), (Throwable)ex);
                        score = LoadBalancerService.this.activeHosts.get(hostname);
                        if (score != null) break block7;
                        this.log.warn((Object)("Host gone during update task: " + hostname));
                        continue;
                    }
                }
                scores.add(score);
            }
            if (scores.isEmpty()) {
                this.log.warn((Object)("No performance counters for hosts, but " + LoadBalancerService.this.activeHosts.size() + " active hosts"));
                LoadBalancerService.this.hostScores.set(null);
                return;
            }
            HostScore[] a = scores.toArray(new HostScore[0]);
            LoadBalancerService.this.setHostScores(a);
        }

        protected void updateServiceScores() {
            if (LoadBalancerService.this.activeDataServices.isEmpty()) {
                if (this.log.isInfoEnabled()) {
                    this.log.info((Object)"No active services");
                }
                LoadBalancerService.this.serviceScores.set(null);
                return;
            }
            Vector<ServiceScore> scores = new Vector<ServiceScore>();
            Iterator<ICounterSet> itrh = LoadBalancerService.this.getFederation().getCounters().counterSetIterator();
            while (itrh.hasNext()) {
                CounterSet hostCounterSet = (CounterSet)itrh.next();
                String hostname = hostCounterSet.getName();
                HostScore hostScore = LoadBalancerService.this.activeHosts.get(hostname);
                if (hostScore == null) {
                    if (!this.log.isInfoEnabled()) continue;
                    this.log.info((Object)("Host is not active: " + hostname));
                    continue;
                }
                CounterSet serviceIfacesCounterSet = (CounterSet)hostCounterSet.getPath("service");
                if (serviceIfacesCounterSet == null) {
                    this.log.warn((Object)("No services interfaces? hostname=" + hostname));
                    continue;
                }
                Iterator<ICounterSet> itrx = serviceIfacesCounterSet.counterSetIterator();
                while (itrx.hasNext()) {
                    CounterSet servicesCounterSet = (CounterSet)itrx.next();
                    Iterator<ICounterSet> itrs = servicesCounterSet.counterSetIterator();
                    while (itrs.hasNext()) {
                        ServiceScore score;
                        block12: {
                            UUID serviceUUID;
                            CounterSet serviceCounterSet = (CounterSet)itrs.next();
                            String serviceName = serviceCounterSet.getName();
                            try {
                                serviceUUID = UUID.fromString(serviceName);
                            }
                            catch (Exception ex) {
                                this.log.error((Object)("Could not parse service name as UUID?\nhostname=" + hostname + ", serviceCounterSet.path=" + serviceCounterSet.getPath() + ", serviceCounterSet.name=" + serviceCounterSet.getName()), (Throwable)ex);
                                continue;
                            }
                            if (!LoadBalancerService.this.activeDataServices.containsKey(serviceUUID)) continue;
                            try {
                                score = this.computeScore(hostScore, serviceUUID, hostCounterSet, serviceCounterSet);
                            }
                            catch (Exception ex) {
                                this.log.error((Object)("Problem computing service score: " + serviceCounterSet.getPath()), (Throwable)ex);
                                score = LoadBalancerService.this.activeDataServices.get(serviceUUID);
                                if (score != null) break block12;
                                if (!this.log.isInfoEnabled()) continue;
                                this.log.info((Object)("Service leave during update task: " + serviceCounterSet.getPath()));
                                continue;
                            }
                        }
                        scores.add(score);
                    }
                }
            }
            if (scores.isEmpty()) {
                this.log.warn((Object)("No performance counters for services, but " + LoadBalancerService.this.activeDataServices.size() + " active services"));
                LoadBalancerService.this.serviceScores.set(null);
                return;
            }
            ServiceScore[] a = scores.toArray(new ServiceScore[0]);
            LoadBalancerService.this.setServiceScores(a);
        }

        protected HostScore computeScore(String hostname, ICounterSet hostCounterSet) {
            double adjustedRawScore;
            int majorFaultsPerSec = (int)this.getCurrentValue(hostCounterSet, "Memory/Major Page Faults Per Second", 0.0);
            double percentDiskFreeSpace = this.getCurrentValue(hostCounterSet, "LogicalDisk/% Free Space", 0.5);
            double percentProcessorIdle = 1.0 - this.getAverageValueForMinutes(hostCounterSet, "CPU/% Processor Time", 0.5, LoadBalancerService.this.historyMinutes);
            double percentIOWait = this.getAverageValueForMinutes(hostCounterSet, "CPU/% IO Wait", 0.01, LoadBalancerService.this.historyMinutes);
            double baseRawScore = adjustedRawScore = (1.0 + percentIOWait * 100.0) / (1.0 + percentProcessorIdle);
            if (majorFaultsPerSec > 50) {
                adjustedRawScore *= 10.0;
                this.log.warn((Object)("hostname=" + hostname + " : swapping heavily: pages/sec=" + majorFaultsPerSec));
            } else if (majorFaultsPerSec > 10) {
                adjustedRawScore *= 2.0;
                this.log.warn((Object)("hostname=" + hostname + " : swapping: pages/sec=" + majorFaultsPerSec));
            }
            if (percentDiskFreeSpace < 0.05) {
                adjustedRawScore *= 10.0;
                this.log.warn((Object)("hostname=" + hostname + " : very short on disk: freeSpace=" + percentDiskFreeSpace * 100.0 + "%"));
            } else if (percentDiskFreeSpace < 0.1) {
                adjustedRawScore *= 2.0;
                this.log.warn((Object)("hostname=" + hostname + " : is short on disk: freeSpace=" + percentDiskFreeSpace * 100.0 + "%"));
            }
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("hostname=" + hostname + " : adjustedRawScore(" + this.scoreFormat.format(adjustedRawScore) + "), baseRawScore(" + this.scoreFormat.format(baseRawScore) + ") = (1d + percentIOWait(" + this.percentFormat.format(percentIOWait) + ") * 100d) / (1d + percentProcessorIdle(" + this.percentFormat.format(percentProcessorIdle) + "), majorFaultsPerSec=" + majorFaultsPerSec + ", percentDiskSpaceFree=" + this.percentFormat.format(percentDiskFreeSpace)));
            }
            HostScore hostScore = new HostScore(hostname, adjustedRawScore);
            return hostScore;
        }

        protected ServiceScore computeScore(HostScore hostScore, UUID serviceUUID, ICounterSet hostCounterSet, ICounterSet serviceCounterSet) {
            double rawScore;
            assert (hostScore != null);
            assert (serviceUUID != null);
            assert (hostCounterSet != null);
            assert (serviceCounterSet != null);
            assert (hostScore.rank != -1) : hostScore.toString();
            String serviceName = "N/A";
            try {
                serviceName = LoadBalancerService.this.getFederation().getDataService(serviceUUID).getServiceName();
            }
            catch (Throwable t) {
                this.log.warn((Object)t.getMessage(), t);
            }
            double averageQueueingTime = this.getAverageValueForMinutes(serviceCounterSet, "Concurrency Manager/Unisolated Write Service/Average Queuing Time", 10.0, LoadBalancerService.this.historyMinutes);
            double dataDirBytesAvailable = this.getAverageValueForMinutes(serviceCounterSet, "Resource Manager/Store Manager/Data Volume Bytes Available", 2.147483648E10, LoadBalancerService.this.historyMinutes);
            double tmpDirBytesAvailable = this.getAverageValueForMinutes(serviceCounterSet, "Resource Manager/Store Manager/Temp Volume Bytes Available", 1.073741824E10, LoadBalancerService.this.historyMinutes);
            double adjustedRawScore = rawScore = (averageQueueingTime + 1.0) * (hostScore.score + 1.0);
            if (dataDirBytesAvailable < 1.073741824E9) {
                adjustedRawScore *= 10.0;
                this.log.warn((Object)("service=" + serviceName + " : very short on disk: " + "Data Volume Bytes Available" + "=" + this.bytesFormat.format(dataDirBytesAvailable)));
            } else if (dataDirBytesAvailable < 1.073741824E10) {
                adjustedRawScore *= 2.0;
                this.log.warn((Object)("service=" + serviceName + " : is short on disk: " + "Data Volume Bytes Available" + "=" + this.bytesFormat.format(dataDirBytesAvailable)));
            }
            if (tmpDirBytesAvailable < 1.073741824E9) {
                adjustedRawScore *= 10.0;
                this.log.warn((Object)("service=" + serviceName + " : very short on disk: " + "Temp Volume Bytes Available" + "=" + this.bytesFormat.format(tmpDirBytesAvailable)));
            } else if (tmpDirBytesAvailable < 1.073741824E10) {
                adjustedRawScore *= 2.0;
                this.log.warn((Object)("service=" + serviceName + " : is short on disk: " + "Temp Volume Bytes Available" + "=" + this.bytesFormat.format(tmpDirBytesAvailable)));
            }
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("serviceName=" + serviceName + ", serviceUUID=" + serviceUUID + ", averageQueueingTime=" + this.millisFormat.format(averageQueueingTime) + ", dataDirBytesAvail=" + this.bytesFormat.format(dataDirBytesAvailable) + ", tmpDirBytesAvail=" + this.bytesFormat.format(tmpDirBytesAvailable) + ", adjustedRawStore=" + adjustedRawScore + ", rawScore(" + this.scoreFormat.format(rawScore) + ") " + "= (averageQueueingTime(" + averageQueueingTime + ") + 1) " + "* (hostScore(" + this.scoreFormat.format(hostScore.score) + ") + 1)"));
            }
            ServiceScore score = new ServiceScore(hostScore.hostname, serviceUUID, serviceName, adjustedRawScore);
            return score;
        }

        protected double getCurrentValue(ICounterSet counterSet, String path, double defaultValue) {
            assert (counterSet != null);
            assert (path != null);
            ICounter c = (ICounter)counterSet.getPath(path);
            if (c == null) {
                return defaultValue;
            }
            try {
                double val = (Double)c.getValue();
                return val;
            }
            catch (Exception ex) {
                this.log.warn((Object)("Could not read double value: counterSet=" + counterSet.getPath() + ", counter=" + path));
                return defaultValue;
            }
        }

        protected double getAverageValueForMinutes(ICounterSet counterSet, String path, double defaultValue, int minutes) {
            assert (counterSet != null);
            assert (path != null);
            ICounter c = (ICounter)counterSet.getPath(path);
            if (c == null) {
                return defaultValue;
            }
            try {
                if (c.getInstrument() instanceof HistoryInstrument) {
                    HistoryInstrument inst = (HistoryInstrument)c.getInstrument();
                    double val = ((Number)inst.getHistory().getAverage(minutes)).doubleValue();
                    return val;
                }
                this.log.warn((Object)("Not a history: " + c));
                return ((Number)c.getValue()).doubleValue();
            }
            catch (Exception ex) {
                this.log.warn((Object)("Could not read: counterSet=" + counterSet.getPath() + ", counter=" + path), (Throwable)ex);
                return defaultValue;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void setupCounters() {
            String idStr;
            Comparable<HostScore> score;
            HistoryInstrument inst;
            ICounter counter;
            String hn;
            CounterSet serviceRoot = LoadBalancerService.this.getFederation().getServiceCounterSet();
            long now = System.currentTimeMillis();
            CounterSet hosts = serviceRoot.makePath("hosts");
            CounterSet tmpScores = hosts.makePath("scores");
            CounterSet tmpFormula = hosts.makePath("formula");
            CounterSet counterSet = tmpScores;
            synchronized (counterSet) {
                for (HostScore hs : LoadBalancerService.this.activeHosts.values()) {
                    hn = hs.hostname;
                    if (tmpScores.getChild(hn) == null) {
                        tmpScores.addCounter(hn, new HistoryInstrument<Double>(new History<Double>(new Double[60], PeriodEnum.Minutes.getPeriodMillis(), true)));
                    }
                    counter = (ICounter)tmpScores.getChild(hn);
                    inst = (HistoryInstrument)counter.getInstrument();
                    score = LoadBalancerService.this.activeHosts.get(hn);
                    if (score == null) continue;
                    inst.add(now, ((HostScore)score).drank);
                }
            }
            counterSet = tmpFormula;
            synchronized (counterSet) {
                for (HostScore hs : LoadBalancerService.this.activeHosts.values()) {
                    hn = hs.hostname;
                    if (tmpFormula.getChild(hn) == null) {
                        tmpFormula.addCounter(hn, new HistoryInstrument<String>(new History<String>(new String[60], PeriodEnum.Minutes.getPeriodMillis(), true)));
                    }
                    counter = (ICounter)tmpFormula.getChild(hn);
                    inst = (HistoryInstrument)counter.getInstrument();
                    score = LoadBalancerService.this.activeHosts.get(hn);
                    if (score == null) continue;
                    inst.add(now, ((HostScore)score).toString());
                }
            }
            CounterSet services = serviceRoot.makePath("services");
            tmpScores = services.makePath("scores");
            tmpFormula = services.makePath("formula");
            counterSet = tmpScores;
            synchronized (counterSet) {
                for (ServiceScore ss : LoadBalancerService.this.activeDataServices.values()) {
                    idStr = ss.serviceUUID.toString();
                    if (tmpScores.getChild(idStr) == null) {
                        tmpScores.addCounter(idStr, new HistoryInstrument<Double>(new History<Double>(new Double[60], PeriodEnum.Minutes.getPeriodMillis(), true)));
                    }
                    counter = (ICounter)tmpScores.getChild(idStr);
                    inst = (HistoryInstrument)counter.getInstrument();
                    score = LoadBalancerService.this.activeDataServices.get(ss.serviceUUID);
                    if (score == null) continue;
                    inst.add(now, ((ServiceScore)score).drank);
                }
            }
            counterSet = tmpFormula;
            synchronized (counterSet) {
                for (ServiceScore ss : LoadBalancerService.this.activeDataServices.values()) {
                    idStr = ss.serviceUUID.toString();
                    if (tmpFormula.getChild(idStr) == null) {
                        tmpFormula.addCounter(idStr, new HistoryInstrument<String>(new History<String>(new String[60], PeriodEnum.Minutes.getPeriodMillis(), true)));
                    }
                    counter = (ICounter)tmpFormula.getChild(idStr);
                    inst = (HistoryInstrument)counter.getInstrument();
                    score = LoadBalancerService.this.activeDataServices.get(ss.serviceUUID);
                    if (score == null) continue;
                    inst.add(now, ((ServiceScore)score).toString());
                }
            }
        }

        protected void logCounters() {
            long now = System.currentTimeMillis();
            long elapsed = now - LoadBalancerService.this.logLastMillis;
            if (elapsed > LoadBalancerService.this.logDelayMillis) {
                String basename = "" + (long)LoadBalancerService.this.logFileCount % LoadBalancerService.this.logMaxFiles;
                LoadBalancerService.this.logCounters(basename);
                LoadBalancerService.this.logFileCount++;
                LoadBalancerService.this.logLastMillis = now;
            }
        }
    }

    public static interface Options {
        public static final String INITIAL_ROUND_ROBIN_UPDATE_COUNT = LoadBalancerService.class.getName() + ".initialRoundRobinUpdateCount";
        public static final String DEFAULT_INITIAL_ROUND_ROBIN_UPDATE_COUNT = "5";
        public static final String UPDATE_DELAY = LoadBalancerService.class.getName() + ".updateDelay";
        public static final String DEFAULT_UPDATE_DELAY = "60000";
        public static final String HISTORY_MINUTES = LoadBalancerService.class.getName() + ".historyMinutes";
        public static final String DEFAULT_HISTORY_MINUTES = "5";
        public static final String TRANSIENT = LoadBalancerService.class.getName() + ".transient";
        public static final String DEFAULT_TRANSIENT = "false";
        public static final String LOG_DIR = LoadBalancerService.class.getName() + ".log.dir";
        public static final String DEFAULT_LOG_DIR = ".";
        public static final String LOG_DELAY = LoadBalancerService.class.getName() + ".log.delay";
        public static final String DEFAULT_LOG_DELAY = "3600000";
        public static final String LOG_MAX_FILES = LoadBalancerService.class.getName() + ".log.maxFiles";
        public static final String DEFAULT_LOG_MAX_FILES = "168";
        public static final String SERVICE_JOIN_TIMEOUT = LoadBalancerService.class.getName() + ".serviceJoinTimeout";
        public static final String DEFAULT_SERVICE_JOIN_TIMEOUT = "3000";
        public static final String EVENT_HISTORY_MILLIS = LoadBalancerService.class.getName() + ".eventHistoryMillis";
        public static final String DEFAULT_EVENT_HISTORY_MILLIS = "3600000";
    }
}

