/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.service;

import com.bigdata.btree.BytesUtil;
import com.bigdata.btree.ITuple;
import com.bigdata.btree.ITupleIterator;
import com.bigdata.btree.IndexMetadata;
import com.bigdata.io.SerializerUtil;
import com.bigdata.journal.AbstractTask;
import com.bigdata.journal.ConcurrencyManager;
import com.bigdata.journal.IConcurrencyManager;
import com.bigdata.journal.IResourceManager;
import com.bigdata.journal.IndexExistsException;
import com.bigdata.journal.NoSuchIndexException;
import com.bigdata.mdi.LocalPartitionMetadata;
import com.bigdata.mdi.MetadataIndex;
import com.bigdata.mdi.PartitionLocator;
import com.bigdata.service.DataService;
import com.bigdata.service.IBigdataFederation;
import com.bigdata.service.IDataService;
import com.bigdata.service.IMetadataService;
import java.io.IOException;
import java.util.Arrays;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public abstract class MetadataService
extends DataService
implements IMetadataService {
    protected static final String ERR_DELETE_MARKERS = "Delete markers not enabled";
    public static final String METADATA_INDEX_NAMESPACE = "metadata-";

    public static String getMetadataIndexName(String name) {
        return METADATA_INDEX_NAMESPACE + name;
    }

    protected MetadataService(Properties properties) {
        super(properties);
    }

    @Override
    public MetadataService start() {
        return (MetadataService)super.start();
    }

    @Override
    public Future<? extends Object> submit(Callable<? extends Object> task) {
        return super.submit(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int nextPartitionId(String name) throws IOException, InterruptedException, ExecutionException {
        this.setupLoggingContext();
        try {
            NextPartitionIdTask task = new NextPartitionIdTask(this.getConcurrencyManager(), MetadataService.getMetadataIndexName(name));
            Integer partitionId = (Integer)this.getConcurrencyManager().submit(task).get();
            if (log.isInfoEnabled()) {
                log.info((Object)("Assigned partitionId=" + partitionId + ", name=" + name));
            }
            int n = partitionId;
            return n;
        }
        finally {
            this.clearLoggingContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PartitionLocator get(String name, long timestamp, byte[] key) throws InterruptedException, ExecutionException, IOException {
        this.setupLoggingContext();
        try {
            if (timestamp == 0L) {
                timestamp = -1L;
            }
            GetTask task = new GetTask(this.getConcurrencyManager(), timestamp, MetadataService.getMetadataIndexName(name), key);
            PartitionLocator partitionLocator = (PartitionLocator)this.getConcurrencyManager().submit(task).get();
            return partitionLocator;
        }
        finally {
            this.clearLoggingContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PartitionLocator find(String name, long timestamp, byte[] key) throws InterruptedException, ExecutionException, IOException {
        this.setupLoggingContext();
        try {
            if (timestamp == 0L) {
                timestamp = -1L;
            }
            FindTask task = new FindTask(this.getConcurrencyManager(), timestamp, MetadataService.getMetadataIndexName(name), key);
            PartitionLocator partitionLocator = (PartitionLocator)this.getConcurrencyManager().submit(task).get();
            return partitionLocator;
        }
        finally {
            this.clearLoggingContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void splitIndexPartition(String name, PartitionLocator oldLocator, PartitionLocator[] newLocators) throws IOException, InterruptedException, ExecutionException {
        this.setupLoggingContext();
        try {
            SplitIndexPartitionTask task = new SplitIndexPartitionTask(this.getConcurrencyManager(), MetadataService.getMetadataIndexName(name), oldLocator, newLocators);
            this.getConcurrencyManager().submit(task).get();
        }
        finally {
            this.clearLoggingContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void joinIndexPartition(String name, PartitionLocator[] oldLocators, PartitionLocator newLocator) throws IOException, InterruptedException, ExecutionException {
        this.setupLoggingContext();
        try {
            JoinIndexPartitionTask task = new JoinIndexPartitionTask(this.getConcurrencyManager(), MetadataService.getMetadataIndexName(name), oldLocators, newLocator);
            this.getConcurrencyManager().submit(task).get();
        }
        finally {
            this.clearLoggingContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveIndexPartition(String name, PartitionLocator oldLocator, PartitionLocator newLocator) throws IOException, InterruptedException, ExecutionException {
        this.setupLoggingContext();
        try {
            MoveIndexPartitionTask task = new MoveIndexPartitionTask(this.getConcurrencyManager(), MetadataService.getMetadataIndexName(name), oldLocator, newLocator);
            this.getConcurrencyManager().submit(task).get();
        }
        finally {
            this.clearLoggingContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UUID registerScaleOutIndex(IndexMetadata metadata, byte[][] separatorKeys, UUID[] dataServices) throws IOException, InterruptedException, ExecutionException {
        this.setupLoggingContext();
        try {
            UUID managedIndexUUID;
            if (metadata.getName() == null) {
                throw new IllegalArgumentException("No name assigned to index in metadata template.");
            }
            if (!metadata.getDeleteMarkers()) {
                metadata.setDeleteMarkers(true);
                if (log.isInfoEnabled()) {
                    log.info((Object)("Enabling delete markers: " + metadata.getName()));
                }
            }
            String scaleOutIndexName = metadata.getName();
            String metadataIndexName = MetadataService.getMetadataIndexName(scaleOutIndexName);
            RegisterScaleOutIndexTask task = new RegisterScaleOutIndexTask(this.getFederation(), this.getConcurrencyManager(), this.getResourceManager(), metadataIndexName, metadata, separatorKeys, dataServices);
            UUID uUID = managedIndexUUID = (UUID)this.getConcurrencyManager().submit(task).get();
            return uUID;
        }
        finally {
            this.clearLoggingContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropScaleOutIndex(String name) throws IOException, InterruptedException, ExecutionException {
        this.setupLoggingContext();
        try {
            DropScaleOutIndexTask task = new DropScaleOutIndexTask(this.getFederation(), this.getConcurrencyManager(), MetadataService.getMetadataIndexName(name));
            this.getConcurrencyManager().submit(task).get();
        }
        finally {
            this.clearLoggingContext();
        }
    }

    public static class DropScaleOutIndexTask
    extends AbstractTask {
        private final IBigdataFederation fed;

        protected DropScaleOutIndexTask(IBigdataFederation fed, ConcurrencyManager concurrencyManager, String name) {
            super((IConcurrencyManager)concurrencyManager, 0L, name);
            if (fed == null) {
                throw new IllegalArgumentException();
            }
            this.fed = fed;
        }

        protected Object doTask() throws Exception {
            MetadataIndex ndx;
            try {
                ndx = (MetadataIndex)this.getIndex(this.getOnlyResource());
            }
            catch (ClassCastException ex) {
                throw new UnsupportedOperationException("Not a scale-out index?", ex);
            }
            String name = ndx.getScaleOutIndexMetadata().getName();
            if (log.isInfoEnabled()) {
                log.info((Object)("Will drop index partitions for " + name));
            }
            ITupleIterator itr = ndx.rangeIterator(null, null, 0, 2, null);
            int ndropped = 0;
            while (itr.hasNext()) {
                ITuple tuple = itr.next();
                PartitionLocator pmd = (PartitionLocator)SerializerUtil.deserialize(tuple.getValue());
                int partitionId = pmd.getPartitionId();
                UUID serviceUUID = pmd.getDataServiceUUID();
                IDataService dataService = this.fed.getDataService(serviceUUID);
                if (log.isInfoEnabled()) {
                    log.info((Object)("Dropping index partition: partitionId=" + partitionId + ", dataService=" + dataService));
                }
                dataService.dropIndex(DataService.getIndexPartitionName(name, partitionId));
                ++ndropped;
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("Dropped " + ndropped + " index partitions for " + name));
            }
            this.getJournal().dropIndex(this.getOnlyResource());
            return ndropped;
        }
    }

    protected static class RegisterScaleOutIndexTask
    extends AbstractTask {
        private final IBigdataFederation fed;
        private final String scaleOutIndexName;
        private final IndexMetadata metadata;
        private final int npartitions;
        private final byte[][] separatorKeys;
        private final UUID[] dataServiceUUIDs;
        private final IDataService[] dataServices;

        public RegisterScaleOutIndexTask(IBigdataFederation fed, ConcurrencyManager concurrencyManager, IResourceManager resourceManager, String metadataIndexName, IndexMetadata metadata, byte[][] separatorKeys, UUID[] dataServiceUUIDs) {
            super((IConcurrencyManager)concurrencyManager, 0L, metadataIndexName);
            if (fed == null) {
                throw new IllegalArgumentException();
            }
            if (metadata == null) {
                throw new IllegalArgumentException();
            }
            if (separatorKeys == null) {
                throw new IllegalArgumentException();
            }
            if (separatorKeys.length == 0) {
                throw new IllegalArgumentException();
            }
            if (dataServiceUUIDs != null) {
                if (dataServiceUUIDs.length == 0) {
                    throw new IllegalArgumentException();
                }
                if (separatorKeys.length != dataServiceUUIDs.length) {
                    throw new IllegalArgumentException();
                }
            } else {
                try {
                    dataServiceUUIDs = fed.getLoadBalancerService().getUnderUtilizedDataServices(separatorKeys.length, separatorKeys.length, null);
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
            this.fed = fed;
            this.scaleOutIndexName = metadata.getName();
            this.metadata = metadata;
            this.npartitions = separatorKeys.length;
            this.separatorKeys = separatorKeys;
            this.dataServiceUUIDs = dataServiceUUIDs;
            this.dataServices = new IDataService[dataServiceUUIDs.length];
            if (separatorKeys[0] == null) {
                throw new IllegalArgumentException();
            }
            if (separatorKeys[0].length != 0) {
                throw new IllegalArgumentException("The first separatorKey must be an empty byte[].");
            }
            for (int i = 0; i < this.npartitions; ++i) {
                byte[] separatorKey = separatorKeys[i];
                if (separatorKey == null) {
                    throw new IllegalArgumentException();
                }
                if (i > 0 && BytesUtil.compareBytes(separatorKey, separatorKeys[i - 1]) < 0) {
                    throw new IllegalArgumentException("Separator keys out of order at index=" + i);
                }
                UUID uuid = dataServiceUUIDs[i];
                if (uuid == null) {
                    throw new IllegalArgumentException();
                }
                IDataService dataService = fed.getDataService(uuid);
                if (dataService == null) {
                    throw new IllegalArgumentException("Unknown data service: uuid=" + uuid);
                }
                this.dataServices[i] = dataService;
            }
        }

        protected Object doTask() throws Exception {
            String metadataName = this.getOnlyResource();
            try {
                this.getIndex(metadataName);
                throw new IndexExistsException(metadataName);
            }
            catch (NoSuchIndexException ex) {
                int i;
                UUID metadataIndexUUID = UUID.randomUUID();
                MetadataIndex mdi = MetadataIndex.create(this.getJournal(), metadataIndexUUID, this.metadata);
                PartitionLocator[] partitions = new PartitionLocator[this.npartitions];
                for (i = 0; i < this.npartitions; ++i) {
                    byte[] leftSeparator = this.separatorKeys[i];
                    byte[] rightSeparator = i + 1 < this.npartitions ? this.separatorKeys[i + 1] : null;
                    PartitionLocator pmd = new PartitionLocator(mdi.incrementAndGetNextPartitionId(), this.dataServiceUUIDs[i], leftSeparator, rightSeparator);
                    if (log.isInfoEnabled()) {
                        log.info((Object)("name=" + this.scaleOutIndexName + ", pmd=" + pmd));
                    }
                    IndexMetadata md = this.metadata.clone();
                    md.setPartitionMetadata(new LocalPartitionMetadata(pmd.getPartitionId(), -1, leftSeparator, rightSeparator, null, null));
                    this.dataServices[i].registerIndex(DataService.getIndexPartitionName(this.scaleOutIndexName, pmd.getPartitionId()), md);
                    partitions[i] = pmd;
                }
                for (i = 0; i < this.npartitions; ++i) {
                    mdi.insert(this.separatorKeys[i], SerializerUtil.serialize(partitions[i]));
                }
                this.getJournal().registerIndex(metadataName, mdi);
                return mdi.getScaleOutIndexMetadata().getIndexUUID();
            }
        }
    }

    protected static class MoveIndexPartitionTask
    extends AbstractTask {
        protected final PartitionLocator oldLocator;
        protected final PartitionLocator newLocator;

        protected MoveIndexPartitionTask(IConcurrencyManager concurrencyManager, String resource, PartitionLocator oldLocator, PartitionLocator newLocator) {
            super(concurrencyManager, 0L, resource);
            if (oldLocator == null) {
                throw new IllegalArgumentException();
            }
            if (newLocator == null) {
                throw new IllegalArgumentException();
            }
            this.oldLocator = oldLocator;
            this.newLocator = newLocator;
        }

        protected Object doTask() throws Exception {
            MetadataIndex mdi;
            PartitionLocator pmd;
            if (log.isInfoEnabled()) {
                log.info((Object)("name=" + this.getOnlyResource() + ", oldLocator=" + this.oldLocator + ", newLocator=" + this.newLocator));
            }
            if ((pmd = (PartitionLocator)SerializerUtil.deserialize((mdi = (MetadataIndex)this.getIndex(this.getOnlyResource())).remove(this.oldLocator.getLeftSeparatorKey()))) == null) {
                throw new RuntimeException("No such locator: name=" + this.getOnlyResource() + ", locator=" + this.oldLocator);
            }
            if (!this.oldLocator.equals(pmd)) {
                throw new RuntimeException("Expected oldLocator=" + this.oldLocator + ", but actual=" + pmd);
            }
            mdi.insert(this.newLocator.getLeftSeparatorKey(), SerializerUtil.serialize(this.newLocator));
            return null;
        }
    }

    protected static class JoinIndexPartitionTask
    extends AbstractTask {
        protected final PartitionLocator[] oldLocators;
        protected final PartitionLocator newLocator;

        protected JoinIndexPartitionTask(IConcurrencyManager concurrencyManager, String resource, PartitionLocator[] oldLocators, PartitionLocator newLocator) {
            super(concurrencyManager, 0L, resource);
            if (oldLocators == null) {
                throw new IllegalArgumentException();
            }
            if (newLocator == null) {
                throw new IllegalArgumentException();
            }
            this.oldLocators = oldLocators;
            this.newLocator = newLocator;
        }

        protected Object doTask() throws Exception {
            int i;
            if (log.isInfoEnabled()) {
                log.info((Object)("name=" + this.getOnlyResource() + ", oldLocators=" + Arrays.toString(this.oldLocators) + ", newLocator=" + this.newLocator));
            }
            MetadataIndex mdi = (MetadataIndex)this.getIndex(this.getOnlyResource());
            for (i = 0; i < this.oldLocators.length; ++i) {
                PartitionLocator tmp = this.oldLocators[i];
                if (tmp.getPartitionId() == this.newLocator.getPartitionId()) {
                    throw new RuntimeException("Same partition identifier: " + tmp + ", " + this.newLocator);
                }
                for (int j = i + 1; j < this.oldLocators.length; ++j) {
                    if (tmp.getPartitionId() != this.oldLocators[j].getPartitionId()) continue;
                    throw new RuntimeException("Same partition identifier: " + tmp + ", " + this.oldLocators[j]);
                }
            }
            for (i = 0; i < this.oldLocators.length; ++i) {
                PartitionLocator locator = this.oldLocators[i];
                PartitionLocator pmd = (PartitionLocator)SerializerUtil.deserialize(mdi.remove(locator.getLeftSeparatorKey()));
                if (locator.equals(pmd)) continue;
                throw new RuntimeException("Expected oldLocator=" + locator + ", but actual=" + pmd);
            }
            mdi.insert(this.newLocator.getLeftSeparatorKey(), SerializerUtil.serialize(this.newLocator));
            return null;
        }
    }

    protected static class SplitIndexPartitionTask
    extends AbstractTask {
        protected final PartitionLocator oldLocator;
        protected final PartitionLocator[] newLocators;

        protected SplitIndexPartitionTask(IConcurrencyManager concurrencyManager, String resource, PartitionLocator oldLocator, PartitionLocator[] newLocators) {
            super(concurrencyManager, 0L, resource);
            if (oldLocator == null) {
                throw new IllegalArgumentException();
            }
            if (newLocators == null) {
                throw new IllegalArgumentException();
            }
            this.oldLocator = oldLocator;
            this.newLocators = newLocators;
        }

        protected Object doTask() throws Exception {
            int i;
            byte[] rightSeparator;
            MetadataIndex mdi;
            PartitionLocator pmd;
            if (log.isInfoEnabled()) {
                log.info((Object)("name=" + this.getOnlyResource() + ", oldLocator=" + this.oldLocator + ", locators=" + Arrays.toString(this.newLocators)));
            }
            if ((pmd = (PartitionLocator)SerializerUtil.deserialize((mdi = (MetadataIndex)this.getIndex(this.getOnlyResource())).remove(this.oldLocator.getLeftSeparatorKey()))) == null) {
                throw new RuntimeException("No such locator: name=" + this.getOnlyResource() + ", locator=" + this.oldLocator);
            }
            if (!this.oldLocator.equals(pmd)) {
                throw new RuntimeException("Expected different locator: name=" + this.getOnlyResource() + ", oldLocator=" + this.oldLocator + ", but actual=" + pmd);
            }
            byte[] leftSeparator = this.oldLocator.getLeftSeparatorKey();
            if (!BytesUtil.bytesEqual(leftSeparator, this.newLocators[0].getLeftSeparatorKey())) {
                throw new RuntimeException("locators[0].leftSeparator does not agree.");
            }
            long indexOf = mdi.indexOf(leftSeparator);
            try {
                rightSeparator = mdi.keyAt(indexOf + 1L);
            }
            catch (IndexOutOfBoundsException ex) {
                rightSeparator = null;
            }
            PartitionLocator locator = this.newLocators[this.newLocators.length - 1];
            if (rightSeparator == null) {
                if (locator.getRightSeparatorKey() != null) {
                    throw new RuntimeException("locators[" + this.newLocators.length + "].rightSeparator should be null.");
                }
            } else if (!BytesUtil.bytesEqual(rightSeparator, locator.getRightSeparatorKey())) {
                throw new RuntimeException("locators[" + this.newLocators.length + "].rightSeparator does not agree.");
            }
            for (i = 0; i < this.newLocators.length; ++i) {
                PartitionLocator tmp = this.newLocators[i];
                if (tmp.getPartitionId() == this.oldLocator.getPartitionId()) {
                    throw new RuntimeException("Same partition identifier: " + tmp + ", " + this.oldLocator);
                }
                for (int j = i + 1; j < this.newLocators.length; ++j) {
                    if (tmp.getPartitionId() != this.newLocators[j].getPartitionId()) continue;
                    throw new RuntimeException("Same partition identifier: " + tmp + ", " + this.newLocators[j]);
                }
            }
            for (i = 0; i < this.newLocators.length; ++i) {
                PartitionLocator locator2 = this.newLocators[i];
                mdi.insert(locator2.getLeftSeparatorKey(), SerializerUtil.serialize(locator2));
            }
            return null;
        }
    }

    protected static class NextPartitionIdTask
    extends AbstractTask {
        protected NextPartitionIdTask(IConcurrencyManager concurrencyManager, String resource) {
            super(concurrencyManager, 0L, resource);
        }

        protected Object doTask() throws Exception {
            MetadataIndex ndx = (MetadataIndex)this.getIndex(this.getOnlyResource());
            int partitionId = ndx.incrementAndGetNextPartitionId();
            assert (ndx.needsCheckpoint());
            return partitionId;
        }
    }

    private static final class FindTask
    extends AbstractTask {
        private final byte[] key;

        public FindTask(IConcurrencyManager concurrencyManager, long timestamp, String resource, byte[] key) {
            super(concurrencyManager, timestamp, resource);
            this.key = key;
        }

        protected Object doTask() throws Exception {
            MetadataIndex ndx = (MetadataIndex)this.getIndex(this.getOnlyResource());
            return ndx.find(this.key);
        }
    }

    private static final class GetTask
    extends AbstractTask {
        private final byte[] key;

        public GetTask(IConcurrencyManager concurrencyManager, long timestamp, String resource, byte[] key) {
            super(concurrencyManager, timestamp, resource);
            this.key = key;
        }

        protected Object doTask() throws Exception {
            MetadataIndex ndx = (MetadataIndex)this.getIndex(this.getOnlyResource());
            return ndx.get(this.key);
        }
    }

    public static interface Options
    extends DataService.Options {
    }
}

