/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.service.jini;

import com.bigdata.Banner;
import com.bigdata.counters.AbstractStatisticsCollector;
import com.bigdata.counters.PIDUtil;
import com.bigdata.io.SerializerUtil;
import com.bigdata.jini.lookup.entry.Hostname;
import com.bigdata.jini.lookup.entry.ServiceUUID;
import com.bigdata.jini.util.JiniUtil;
import com.bigdata.service.AbstractService;
import com.bigdata.service.IBigdataFederation;
import com.bigdata.service.IService;
import com.bigdata.service.IServiceShutdown;
import com.bigdata.service.jini.JiniClient;
import com.bigdata.service.jini.JiniClientConfig;
import com.bigdata.service.jini.JiniFederation;
import com.bigdata.zookeeper.ZLock;
import com.bigdata.zookeeper.ZLockImpl;
import com.sun.jini.start.LifeCycle;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.rmi.Remote;
import java.rmi.server.ExportException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.config.ConfigurationProvider;
import net.jini.core.entry.Entry;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceRegistrar;
import net.jini.discovery.DiscoveryManagement;
import net.jini.export.Exporter;
import net.jini.jeri.BasicILFactory;
import net.jini.jeri.BasicJeriExporter;
import net.jini.jeri.InvocationLayerFactory;
import net.jini.jeri.ServerEndpoint;
import net.jini.jeri.tcp.TcpServerEndpoint;
import net.jini.lease.LeaseListener;
import net.jini.lease.LeaseRenewalEvent;
import net.jini.lease.LeaseRenewalManager;
import net.jini.lookup.JoinManager;
import net.jini.lookup.ServiceIDListener;
import net.jini.lookup.entry.Name;
import org.apache.log4j.Logger;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;

public abstract class AbstractServer
implements Runnable,
LeaseListener,
ServiceIDListener {
    private static final Logger log = Logger.getLogger(AbstractServer.class);
    private ServiceID serviceID;
    private File serviceDir;
    private File serviceIdFile;
    private File pidFile;
    private RandomAccessFile lockFileRAF;
    private FileLock fileLock;
    private File lockFile;
    protected String logicalServiceZPath;
    protected String physicalServiceZPath;
    private JiniClient<?> client;
    private JoinManager joinManager;
    protected Configuration config;
    private String serviceName;
    private Exporter exporter;
    protected Remote impl;
    protected Remote proxy;
    private String hostname;
    private LifeCycle lifeCycle;
    private Future masterElectionFuture;
    private volatile boolean shuttingDown;
    private Object keepAlive;

    public final String getServiceName() {
        return this.serviceName;
    }

    protected String getHostName() {
        return this.hostname;
    }

    public Remote getProxy() {
        return this.proxy;
    }

    public ServiceID getServiceID() {
        return this.serviceID;
    }

    protected boolean isPersistent() {
        return true;
    }

    protected JoinManager getJoinManager() {
        return this.joinManager;
    }

    public JiniClient getClient() {
        return this.client;
    }

    public static final void setSecurityManager() {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            System.setSecurityManager(new SecurityManager());
            if (log.isInfoEnabled()) {
                log.info((Object)"Set security manager");
            }
        } else if (log.isInfoEnabled()) {
            log.info((Object)("Security manager already in place: " + sm.getClass()));
        }
    }

    protected void fatal(String msg, Throwable t) {
        log.fatal((Object)msg, t);
        try {
            this.shutdownNow(false);
        }
        catch (Throwable t2) {
            log.error((Object)this, t2);
        }
        throw new RuntimeException(msg, t);
    }

    private AbstractServer(String[] args) {
        this.lockFileRAF = null;
        this.masterElectionFuture = null;
        this.shuttingDown = false;
        this.keepAlive = new Object();
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractServer(String[] args, LifeCycle lifeCycle) {
        LinkedList<Entry> entries;
        block37: {
            this.lockFileRAF = null;
            this.masterElectionFuture = null;
            this.shuttingDown = false;
            this.keepAlive = new Object();
            Banner.banner();
            if (lifeCycle == null) {
                throw new IllegalArgumentException();
            }
            this.lifeCycle = lifeCycle;
            AbstractServer.setSecurityManager();
            Banner.banner();
            entries = null;
            try {
                this.config = ConfigurationProvider.getInstance((String[])args);
                JiniClientConfig jiniClientConfig = new JiniClientConfig(this.getClass().getName(), this.config);
                this.logicalServiceZPath = (String)this.config.getEntry(this.getClass().getName(), "logicalServiceZPath", String.class, null);
                this.serviceDir = (File)this.config.getEntry(this.getClass().getName(), "serviceDir", File.class);
                if (this.serviceDir != null && !this.serviceDir.exists()) {
                    log.warn((Object)("Creating: " + this.serviceDir));
                    this.serviceDir.mkdirs();
                }
                this.serviceIdFile = new File(this.serviceDir, "service.id");
                this.lockFile = new File(this.serviceDir, ".lock");
                this.acquireFileLock();
                this.pidFile = new File(this.serviceDir, "pid");
                this.writePIDFile(this.pidFile);
                entries = new LinkedList<Entry>(Arrays.asList(jiniClientConfig.entries));
                String serviceName = null;
                String hostname = null;
                UUID serviceUUID = null;
                for (Entry e : entries) {
                    if (e instanceof Name && serviceName == null) {
                        serviceName = ((Name)e).name;
                    }
                    if (e instanceof Hostname && hostname == null) {
                        hostname = ((Hostname)e).hostname;
                    }
                    if (!(e instanceof ServiceUUID) || serviceUUID != null) continue;
                    serviceUUID = ((ServiceUUID)e).serviceUUID;
                }
                if (serviceName == null) {
                    String defaultName;
                    serviceName = defaultName = this.getClass().getName() + "@" + AbstractStatisticsCollector.fullyQualifiedHostName + "#" + this.hashCode();
                    entries.add((Entry)new Name(serviceName));
                }
                this.serviceName = serviceName;
                if (hostname == null) {
                    hostname = AbstractStatisticsCollector.fullyQualifiedHostName;
                    entries.add((Entry)new Hostname(hostname));
                }
                this.hostname = hostname;
                if (serviceUUID != null) {
                    this.serviceID = JiniUtil.uuid2ServiceID(serviceUUID);
                    if (!this.serviceIdFile.exists()) {
                        this.writeServiceIDOnFile(this.serviceID);
                    }
                } else if (!this.serviceIdFile.exists()) {
                    this.serviceID = JiniUtil.uuid2ServiceID(UUID.randomUUID());
                    this.writeServiceIDOnFile(this.serviceID);
                }
                this.exporter = (Exporter)this.config.getEntry(this.getClass().getName(), "exporter", Exporter.class, (Object)new BasicJeriExporter((ServerEndpoint)TcpServerEndpoint.getInstance((int)0), (InvocationLayerFactory)new BasicILFactory()));
                if (this.serviceIdFile.exists()) {
                    try {
                        ServiceID serviceIDFromFile = AbstractServer.readServiceId(this.serviceIdFile);
                        if (this.serviceID == null) {
                            this.serviceID = serviceIDFromFile;
                        } else if (!this.serviceID.equals((Object)serviceIDFromFile)) {
                            throw new ConfigurationException("ServiceID in Configuration does not agree with the value in " + this.serviceIdFile + " : Configuration=" + this.serviceID + ", serviceIdFile=" + serviceIDFromFile);
                        }
                        break block37;
                    }
                    catch (IOException ex) {
                        this.fatal("Could not read serviceID from existing file: " + this.serviceIdFile + ": " + this, ex);
                    }
                    break block37;
                }
                if (log.isInfoEnabled()) {
                    log.info((Object)"New service instance.");
                }
            }
            catch (ConfigurationException ex) {
                this.fatal("Configuration error: " + this, ex);
            }
        }
        Runtime.getRuntime().addShutdownHook(new ShutdownThread(this));
        try {
            this.client = new JiniClient(this.getClass(), this.config);
        }
        catch (Throwable t) {
            this.fatal("Could not create JiniClient: " + this, t);
        }
        IBigdataFederation fed = null;
        try {
            if (log.isInfoEnabled()) {
                log.info((Object)"Creating service impl...");
            }
            this.impl = this.newService(this.client.getProperties());
            if (log.isInfoEnabled()) {
                log.info((Object)("Service impl is " + this.impl));
            }
            IBigdataFederation f = fed = this.client.connect();
            ((JiniFederation)fed).getZookeeperAccessor().addWatcher(new Watcher((JiniFederation)f){
                boolean sessionValid = false;
                final /* synthetic */ JiniFederation val$f;
                {
                    this.val$f = jiniFederation;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void process(WatchedEvent event) {
                    switch (event.getState()) {
                        case Expired: {
                            this.sessionValid = false;
                            AbstractServer abstractServer = AbstractServer.this;
                            synchronized (abstractServer) {
                                if (AbstractServer.this.masterElectionFuture != null) {
                                    AbstractServer.this.masterElectionFuture.cancel(true);
                                    AbstractServer.this.masterElectionFuture = null;
                                    log.warn((Object)("Zookeeper session expired: cancelled master election task: " + this));
                                }
                                break;
                            }
                        }
                        case NoSyncConnected: 
                        case SyncConnected: {
                            if (this.sessionValid) break;
                            this.sessionValid = true;
                            if (AbstractServer.this.serviceID == null) break;
                            try {
                                AbstractServer.this.notifyZookeeper(this.val$f, JiniUtil.serviceID2UUID(AbstractServer.this.serviceID));
                                break;
                            }
                            catch (Throwable t) {
                                log.error((Object)AbstractServer.this, t);
                            }
                        }
                    }
                }
            });
            if (this.impl instanceof AbstractService) {
                ((AbstractService)this.impl).start();
            }
        }
        catch (Exception ex) {
            this.fatal("Could not start service: " + this, ex);
        }
        try {
            this.proxy = this.exporter.export(this.impl);
            if (log.isInfoEnabled()) {
                log.info((Object)("Proxy is " + this.proxy + "(" + this.proxy.getClass() + ")"));
            }
        }
        catch (ExportException ex) {
            this.fatal("Export error: " + this, ex);
        }
        try {
            assert (this.proxy != null) : "No proxy?";
            Entry[] attributes = entries.toArray(new Entry[0]);
            this.joinManager = this.serviceID != null ? new JoinManager((Object)this.proxy, attributes, this.serviceID, (DiscoveryManagement)((JiniFederation)fed).getDiscoveryManagement(), new LeaseRenewalManager(), this.config) : new JoinManager((Object)this.proxy, attributes, (ServiceIDListener)this, (DiscoveryManagement)((JiniFederation)fed).getDiscoveryManagement(), new LeaseRenewalManager(), this.config);
        }
        catch (Exception ex) {
            this.fatal("JoinManager: " + this, ex);
        }
        AbstractServer abstractServer = this;
        synchronized (abstractServer) {
            if (this.serviceID != null) {
                this.notifyServiceUUID(this.serviceID);
            }
        }
    }

    public String toString() {
        ServiceID serviceID = this.serviceID;
        return this.getClass().getName() + "{serviceName=" + this.serviceName + ", hostname=" + this.hostname + ", serviceUUID=" + (serviceID == null ? "null" : "" + JiniUtil.serviceID2UUID(serviceID)) + "}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acquireFileLock() {
        block9: {
            try {
                this.lockFileRAF = new RandomAccessFile(this.lockFile, "rw");
            }
            catch (IOException ex) {
                throw new RuntimeException("Could not open: file=" + this.lockFile, ex);
            }
            try {
                this.fileLock = this.lockFileRAF.getChannel().tryLock();
                if (this.fileLock != null) break block9;
                try {
                    this.lockFileRAF.close();
                }
                catch (Throwable t) {
                }
                finally {
                    this.lockFileRAF = null;
                }
                throw new RuntimeException("Service already running: file=" + this.lockFile);
            }
            catch (IOException ex) {
                log.warn((Object)("FileLock not supported: file=" + this.lockFile), (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePIDFile(File file) {
        try {
            String pid = Integer.toString(PIDUtil.getPID());
            try (FileOutputStream os = new FileOutputStream(file);){
                os.getChannel().truncate(0L);
                os.write(pid.getBytes("ASCII"));
                os.flush();
            }
        }
        catch (IOException ex) {
            log.warn((Object)("Could not write pid: file=" + file), (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized boolean unexport(boolean force) {
        if (log.isInfoEnabled()) {
            log.info((Object)("force=" + force + ", proxy=" + this.proxy));
        }
        try {
            if (this.proxy != null) {
                if (this.exporter.unexport(force)) {
                    boolean bl = true;
                    return bl;
                }
                log.warn((Object)("Proxy was not unexported? : " + this));
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.proxy = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServiceID readServiceId(File file) throws IOException {
        try (FileInputStream is = new FileInputStream(file);){
            ServiceID serviceID = new ServiceID((DataInput)new DataInputStream(is));
            if (log.isInfoEnabled()) {
                log.info((Object)("Read ServiceID=" + serviceID + " from " + file));
            }
            ServiceID serviceID2 = serviceID;
            return serviceID2;
        }
    }

    public synchronized void serviceIDNotify(ServiceID serviceID) {
        if (serviceID == null) {
            throw new IllegalArgumentException();
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("serviceID=" + serviceID));
        }
        if (this.serviceID != null && !this.serviceID.equals((Object)serviceID)) {
            throw new IllegalStateException("ServiceID may not be changed: ServiceID=" + this.serviceID + ", proposed=" + serviceID);
        }
        this.serviceID = serviceID;
        assert (this.serviceIdFile != null) : "serviceIdFile not defined?";
        this.writeServiceIDOnFile(serviceID);
        this.notifyServiceUUID(serviceID);
        LinkedList<Entry> attributes = new LinkedList<Entry>(Arrays.asList(this.joinManager.getAttributes()));
        Iterator itr = attributes.iterator();
        while (itr.hasNext()) {
            Entry e = (Entry)itr.next();
            if (!(e instanceof ServiceUUID)) continue;
            itr.remove();
        }
        attributes.add((Entry)new ServiceUUID(JiniUtil.serviceID2UUID(serviceID)));
        this.joinManager.setAttributes(attributes.toArray(new Entry[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void writeServiceIDOnFile(ServiceID serviceID) {
        try (DataOutputStream dout = new DataOutputStream(new FileOutputStream(this.serviceIdFile));){
            serviceID.writeBytes((DataOutput)dout);
            dout.flush();
            if (log.isInfoEnabled()) {
                log.info((Object)("ServiceID saved: file=" + this.serviceIdFile + ", serviceID=" + serviceID));
            }
        }
        catch (Exception ex) {
            log.error((Object)("Could not save ServiceID : " + this), (Throwable)ex);
        }
    }

    protected synchronized void notifyServiceUUID(ServiceID serviceID) {
        if (serviceID == null) {
            throw new IllegalArgumentException();
        }
        if (this.serviceID != null && !this.serviceID.equals((Object)serviceID)) {
            throw new IllegalStateException("ServiceID may not be changed: ServiceID=" + this.serviceID + ", proposed=" + serviceID);
        }
        if (this.impl != null && this.impl instanceof AbstractService) {
            UUID serviceUUID = JiniUtil.serviceID2UUID(serviceID);
            AbstractService service = (AbstractService)this.impl;
            service.setServiceUUID(serviceUUID);
            try {
                JiniFederation fed = (JiniFederation)service.getFederation();
                this.notifyZookeeper(fed, serviceUUID);
            }
            catch (Throwable t) {
                log.error((Object)("Could not register service with zookeeper: " + this), t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyZookeeper(JiniFederation fed, UUID serviceUUID) throws KeeperException, InterruptedException {
        if (fed == null) {
            throw new IllegalArgumentException();
        }
        if (serviceUUID == null) {
            throw new IllegalArgumentException();
        }
        ZooKeeper zookeeper = fed.getZookeeper();
        if (zookeeper == null) {
            log.warn((Object)("No zookeeper: will not create service znode: " + this));
            return;
        }
        if (this.logicalServiceZPath == null) {
            log.warn((Object)("No logicalServiceZPath in config file: will not create service znode: cls=" + this.getClass().getName()));
            return;
        }
        this.physicalServiceZPath = this.logicalServiceZPath + "/" + "physicalServices" + "/" + serviceUUID;
        byte[] data = SerializerUtil.serialize(this.joinManager.getAttributes());
        try {
            List<ACL> acl = fed.getZooConfig().acl;
            zookeeper.create(this.physicalServiceZPath, data, acl, this.isPersistent() ? CreateMode.PERSISTENT : CreateMode.EPHEMERAL);
        }
        catch (KeeperException.NodeExistsException ex) {
            zookeeper.setData(this.physicalServiceZPath, data, -1);
        }
        AbstractServer abstractServer = this;
        synchronized (abstractServer) {
            if (this.masterElectionFuture == null) {
                this.masterElectionFuture = fed.submitMonitoredTask(new MasterElectionTask());
            }
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("(Re)-registered with zookeeper: zpath=" + this.physicalServiceZPath));
        }
    }

    public void notify(LeaseRenewalEvent event) {
        log.warn((Object)("Lease could not be renewed: " + this + " : " + event));
        try {
            JoinManager joinManager = this.joinManager;
            if (joinManager != null) {
                ServiceRegistrar[] a = joinManager.getJoinSet();
                if (a.length == 0) {
                    log.error((Object)"Service not registered with any service registrars");
                } else if (log.isInfoEnabled()) {
                    log.info((Object)("Service remains registered with " + a.length + " service registrars"));
                }
            }
        }
        catch (Exception ex) {
            log.error((Object)("Problem obtaining joinSet? : " + this), (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void shutdownNow(boolean destroy) {
        Object tmp;
        if (this.shuttingDown) {
            return;
        }
        this.shuttingDown = true;
        try {
            if (log.isInfoEnabled()) {
                log.info((Object)"Unexporting the service proxy.");
            }
            this.unexport(true);
        }
        catch (Throwable ex) {
            log.error((Object)("Problem unexporting service: " + this), ex);
        }
        if (destroy && this.impl != null && this.impl instanceof IService) {
            tmp = (IService)this.impl;
            try {
                tmp.destroy();
            }
            catch (Throwable ex) {
                log.error((Object)("Problem with service destroy: " + this), ex);
            }
        }
        if (this.impl != null && this.impl instanceof IServiceShutdown) {
            try {
                tmp = (IServiceShutdown)((Object)this.impl);
                if (tmp != null && tmp.isOpen()) {
                    tmp.shutdownNow();
                }
            }
            catch (Throwable ex) {
                log.error((Object)("Problem with service shutdown: " + this), ex);
            }
        }
        this.impl = null;
        try {
            this.terminate();
        }
        catch (Throwable ex) {
            log.error((Object)("Could not terminate async threads (jini, zookeeper): " + this), ex);
        }
        if (this.lifeCycle != null) {
            try {
                this.lifeCycle.unregister((Object)this);
            }
            catch (Throwable ex) {
                log.error((Object)("Could not unregister lifeCycle: " + this), ex);
            }
            finally {
                this.lifeCycle = null;
            }
        }
        if (destroy) {
            this.recursiveDelete(this.serviceDir);
            if (this.serviceIdFile.exists() && !this.serviceIdFile.delete()) {
                log.warn((Object)("Could not delete: " + this.serviceIdFile));
            }
            if (this.pidFile.exists() && !this.pidFile.delete()) {
                log.warn((Object)("Could not delete: " + this.pidFile));
            }
        }
        if (this.lockFileRAF != null && this.lockFileRAF.getChannel().isOpen()) {
            try {
                this.lockFileRAF.close();
            }
            catch (IOException ex) {
                log.warn((Object)this, (Throwable)ex);
            }
        }
        if (destroy && this.lockFile.exists() && !this.lockFile.delete()) {
            log.warn((Object)("Could not delete: " + this.serviceDir));
        }
        if (destroy && this.serviceDir.exists() && !this.serviceDir.delete()) {
            log.warn((Object)("Could not delete: " + this.serviceDir));
        }
        Object object = this.keepAlive;
        synchronized (object) {
            this.keepAlive.notify();
        }
    }

    public boolean isShuttingDown() {
        return this.shuttingDown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void terminate() {
        if (log.isInfoEnabled()) {
            log.info((Object)"Terminating service management threads.");
        }
        if (this.joinManager != null) {
            try {
                this.joinManager.terminate();
            }
            catch (Throwable ex) {
                log.error((Object)("Could not terminate the join manager: " + this), ex);
            }
            finally {
                this.joinManager = null;
            }
        }
        if (this.client != null) {
            if (this.client.isConnected()) {
                this.client.disconnect(true);
            }
            this.client = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (log.isInfoEnabled()) {
            log.info((Object)"Started server.");
        }
        try {
            Thread.currentThread().setName(this.getClass().getName());
        }
        catch (SecurityException ex) {
            log.warn((Object)("Could not set thread name: " + ex));
        }
        Object object = this.keepAlive;
        synchronized (object) {
            try {
                this.keepAlive.wait();
            }
            catch (InterruptedException ex) {
                if (log.isInfoEnabled()) {
                    log.info((Object)ex.getLocalizedMessage());
                }
            }
            finally {
                this.shutdownNow(false);
            }
        }
        System.out.println("Service is down: class=" + this.getClass().getName() + ", name=" + this.serviceName);
    }

    public final synchronized void destroy() {
        this.shutdownNow(true);
    }

    private void recursiveDelete(File f) {
        if (f.isDirectory()) {
            File[] children = f.listFiles(this.getFileFilter());
            for (int i = 0; i < children.length; ++i) {
                this.recursiveDelete(children[i]);
            }
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Removing: " + f));
        }
        if (f.exists() && !f.delete()) {
            log.warn((Object)("Could not remove: " + f));
        }
    }

    protected FileFilter getFileFilter() {
        return new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return false;
            }
        };
    }

    public void runDestroy() {
        Thread t = new Thread("destroyService"){

            @Override
            public void run() {
                String msg = AbstractServer.this.toString();
                log.warn((Object)("Will destroy service: " + msg));
                try {
                    AbstractServer.this.destroy();
                    log.warn((Object)("Service destroyed: " + msg));
                }
                catch (Throwable t) {
                    log.error((Object)("Problem destroying service: " + msg), t);
                }
            }
        };
        t.setDaemon(true);
        t.start();
    }

    protected abstract Remote newService(Properties var1);

    static class ShutdownThread
    extends Thread {
        final AbstractServer server;

        public ShutdownThread(AbstractServer server) {
            super("shutdownThread");
            if (server == null) {
                throw new IllegalArgumentException();
            }
            this.server = server;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                if (log.isInfoEnabled()) {
                    log.info((Object)"Running shutdown.");
                }
                this.server.shutdownNow(false);
            }
            catch (Exception ex) {
                log.error((Object)("While shutting down service: " + this), (Throwable)ex);
            }
        }
    }

    protected class MasterElectionTask
    implements Callable {
        public Object call() throws Exception {
            while (!AbstractServer.this.shuttingDown && AbstractServer.this.impl != null) {
                try {
                    this.runOnce();
                }
                catch (InterruptedException t) {
                    if (!log.isInfoEnabled()) continue;
                    log.info((Object)"Interrupted.");
                }
                catch (KeeperException.SessionExpiredException t) {
                    log.error((Object)"Zookeeper session expired!");
                    return null;
                }
                catch (Throwable t) {
                    log.error((Object)AbstractServer.this, t);
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void runOnce() throws Exception, InterruptedException {
            AbstractService service = (AbstractService)AbstractServer.this.impl;
            JiniFederation fed = (JiniFederation)service.getFederation();
            ZooKeeper zookeeper = fed.getZookeeperAccessor().getZookeeper();
            List<ACL> acl = fed.getZooConfig().acl;
            ZLockImpl zlock = ZLockImpl.getLock(zookeeper, AbstractServer.this.logicalServiceZPath + "/" + "masterElection", acl);
            zlock.lock();
            try {
                this.runAsMaster(service, zlock);
            }
            finally {
                zlock.unlock();
            }
        }

        protected void runAsMaster(AbstractService service, ZLock zlock) throws InterruptedException, Exception {
            log.warn((Object)("Service is now the master: " + AbstractServer.this));
            Thread.sleep(Long.MAX_VALUE);
        }
    }

    public static interface ConfigurationOptions {
        public static final String SERVICE_DIR = "serviceDir";
        public static final String LOGICAL_SERVICE_ZPATH = "logicalServiceZPath";
        public static final String EXPORTER = "exporter";
    }
}

